/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.WidgetEffectRendererKt;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00046789B\u001d\b\u0007\u0012\u0012\b\u0002\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u0018J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\b\u0010!\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014JJ\u0010$\u001a\u00070\u0005\u00a2\u0006\u0002\b\t2\u000b\u0010%\u001a\u00070\u0005\u00a2\u0006\u0002\b\t2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010'2\b\u0010+\u001a\u0004\u0018\u00010'2\u0006\u0010,\u001a\u00020\rH\u0014J\u000e\u0010-\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0012J\b\u00101\u001a\u00020\u0010H\u0016J\u0012\u00102\u001a\u00020\u00102\b\u0010%\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u00103\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\b\u00104\u001a\u000205H\u0016R\u0018\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R2\u0010%\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t2\r\u0010\u0011\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u000b\"\u0004\b/\u00100\u00a8\u0006:"}, d2={"Lcom/intellij/openapi/wm/impl/status/TextPanel;", "Ljavax/swing/JPanel;", "Ljavax/accessibility/Accessible;", "toolTipTextSupplier", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "textForPreferredSize", "Lorg/jetbrains/annotations/Nls;", "getTextForPreferredSize", "()Ljava/lang/String;", "preferredHeight", "", "Ljava/lang/Integer;", "explicitSize", "Ljava/awt/Dimension;", "value", "", "alignment", "getAlignment", "()F", "getToolTipText", "updateUI", "", "getFont", "Ljava/awt/Font;", "recomputeSize", "paintComponent", "g", "Ljava/awt/Graphics;", "getWidgetEffect", "Lcom/intellij/openapi/wm/impl/status/IdeStatusBarImpl$WidgetEffect;", "isHoverEffect", "", "getTextX", "truncateText", "text", "bounds", "Ljava/awt/Rectangle;", "fm", "Ljava/awt/FontMetrics;", "textR", "iconR", "maxWidth", "setTextAlignment", "getText", "setText", "(Ljava/lang/String;)V", "getPreferredSize", "getPanelDimensionFromFontMetrics", "setExplicitSize", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "Companion", "WithIconAndArrows", "ExtraSize", "AccessibleTextPanel", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nTextPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextPanel.kt\ncom/intellij/openapi/wm/impl/status/TextPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n1#2:264\n*E\n"})
public class TextPanel
extends JPanel
implements Accessible {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Function0<String> toolTipTextSupplier;
    @Nullable
    private Integer preferredHeight;
    @Nullable
    private Dimension explicitSize;
    private float alignment;
    @Nullable
    private String text;
    @NotNull
    public static final String PROPERTY_TEXT = "TextPanel.text";
    @NotNull
    public static final String PROPERTY_ICON = "TextPanel.icon";

    @JvmOverloads
    public TextPanel(@Nullable Function0<String> toolTipTextSupplier2) {
        this.toolTipTextSupplier = toolTipTextSupplier2;
        this.setOpaque(false);
        this.updateUI();
    }

    public /* synthetic */ TextPanel(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        this((Function0<String>)function0);
    }

    @Nullable
    protected String getTextForPreferredSize() {
        return this.text;
    }

    protected final float getAlignment() {
        return this.alignment;
    }

    @Override
    @Nullable
    public String getToolTipText() {
        Object object = this.toolTipTextSupplier;
        if (object == null || (object = (String)object.invoke()) == null) {
            object = super.getToolTipText();
        }
        return object;
    }

    @Override
    public void updateUI() {
        GraphicsUtil.setAntialiasingType((JComponent)this, (Object)AntialiasingType.getAATextInfoForSwingComponent());
        UISettings.Companion.setupFractionalMetrics((JComponent)this);
        this.recomputeSize();
    }

    @Override
    @NotNull
    public Font getFont() {
        return Companion.getFont();
    }

    public final void recomputeSize() {
        this.preferredHeight = Companion.computeTextHeight();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        String string = this.text;
        if (string == null) {
            return;
        }
        String s = string;
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        ((Graphics2D)g).setFont(this.getFont());
        UISettings.Companion.setupAntialiasing(g);
        Rectangle bounds = new Rectangle(panelWidth, panelHeight);
        FontMetrics fontMetrics = g.getFontMetrics();
        int textWidth = fontMetrics.stringWidth(s);
        Insets insets = this.getInsets();
        int x = textWidth > panelWidth ? insets.left : this.getTextX(g);
        int maxWidth = panelWidth - x - insets.right;
        if (textWidth > maxWidth) {
            s = this.truncateText(s, bounds, fontMetrics, new Rectangle(), new Rectangle(), maxWidth);
        }
        int y = UIUtil.getStringY((String)s, (Rectangle)bounds, (Graphics2D)((Graphics2D)g));
        if (SystemInfo.isJetBrainsJvm && ExperimentalUI.Companion.isNewUI()) {
            y += fontMetrics.getLeading();
        }
        IdeStatusBarImpl.WidgetEffect effect = this.getWidgetEffect();
        if (this.isEnabled()) {
            IdeStatusBarImpl.WidgetEffect widgetEffect = effect;
            var14_13 = switch (widgetEffect == null ? -1 : WhenMappings.$EnumSwitchMapping$0[widgetEffect.ordinal()]) {
                case 1 -> JBUI.CurrentTheme.StatusBar.Widget.PRESSED_FOREGROUND;
                case 2 -> JBUI.CurrentTheme.StatusBar.Widget.HOVER_FOREGROUND;
                default -> JBUI.CurrentTheme.StatusBar.Widget.FOREGROUND;
            };
            Intrinsics.checkNotNull((Object)var14_13);
            color = var14_13;
        } else {
            var14_13 = NamedColorUtil.getInactiveTextColor();
            Intrinsics.checkNotNull((Object)var14_13);
            color = var14_13;
        }
        Color foreground = color;
        ((Graphics2D)g).setColor(foreground);
        ((Graphics2D)g).drawString(s, x, y);
    }

    private final IdeStatusBarImpl.WidgetEffect getWidgetEffect() {
        return (IdeStatusBarImpl.WidgetEffect)((Object)ClientProperty.get((Component)this, WidgetEffectRendererKt.getWIDGET_EFFECT_KEY()));
    }

    @TestOnly
    public final boolean isHoverEffect() {
        return this.isEnabled() && this.getWidgetEffect() == IdeStatusBarImpl.WidgetEffect.HOVER;
    }

    protected int getTextX(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        String text2 = this.text;
        Insets insets = this.getInsets();
        return text2 == null || this.alignment == 0.0f ? insets.left : (this.alignment == 1.0f ? this.getWidth() - insets.right - g.getFontMetrics().stringWidth(text2) : (this.alignment == 0.5f ? (this.getWidth() - insets.left - insets.right - g.getFontMetrics().stringWidth(text2)) / 2 + insets.left : insets.left));
    }

    @NotNull
    protected String truncateText(@NotNull String text2, @Nullable Rectangle bounds, @Nullable FontMetrics fm, @Nullable Rectangle textR, @Nullable Rectangle iconR, int maxWidth) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String string = SwingUtilities.layoutCompoundLabel(this, fm, text2, null, 0, 0, 0, 11, bounds, iconR, textR, 0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"layoutCompoundLabel(...)");
        return string;
    }

    public final void setTextAlignment(float alignment) {
        this.alignment = alignment;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String value) {
        AccessibleContext accessibleContext;
        String text2;
        String string = value;
        if (string != null) {
            String string2;
            String p0 = string2 = string;
            boolean bl = false;
            v1 = ((CharSequence)p0).length() > 0 ? string2 : null;
        } else {
            v1 = text2 = null;
        }
        if (Intrinsics.areEqual(text2, (Object)this.text)) {
            return;
        }
        AccessibleContext accessibleContext2 = accessibleContext = this.accessibleContext;
        String oldAccessibleName = accessibleContext2 != null ? accessibleContext2.getAccessibleName() : null;
        String oldText = this.text;
        this.text = text2;
        this.firePropertyChange(PROPERTY_TEXT, oldText, text2);
        if (accessibleContext != null && !Intrinsics.areEqual((Object)accessibleContext.getAccessibleName(), (Object)oldAccessibleName)) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", oldAccessibleName, accessibleContext.getAccessibleName());
        }
        this.setPreferredSize(this.getPanelDimensionFromFontMetrics(text2));
        this.revalidate();
        this.repaint();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = this.explicitSize;
        if (dimension == null) {
            dimension = this.getPanelDimensionFromFontMetrics(this.getTextForPreferredSize());
        }
        return dimension;
    }

    private final Dimension getPanelDimensionFromFontMetrics(String text2) {
        Insets insets = this.getInsets();
        int width = insets.left + insets.right + (text2 == null ? 0 : this.getFontMetrics(this.getFont()).stringWidth(text2));
        Integer n = this.preferredHeight;
        return new Dimension(width, n != null ? n : this.getMinimumSize().height);
    }

    public final void setExplicitSize(@Nullable Dimension explicitSize) {
        this.explicitSize = explicitSize;
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTextPanel();
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    @JvmOverloads
    public TextPanel() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/wm/impl/status/TextPanel$AccessibleTextPanel;", "Ljavax/swing/JComponent$AccessibleJComponent;", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/openapi/wm/impl/status/TextPanel;)V", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleName", "", "intellij.platform.ide.impl"})
    private final class AccessibleTextPanel
    extends JComponent.AccessibleJComponent {
        public AccessibleTextPanel() {
            super(TextPanel.this);
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole = AccessibleRole.LABEL;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"LABEL");
            return accessibleRole;
        }

        @Override
        @Nullable
        public String getAccessibleName() {
            return TextPanel.this.getText();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/wm/impl/status/TextPanel$Companion;", "", "<init>", "()V", "PROPERTY_TEXT", "", "PROPERTY_ICON", "getFont", "Ljava/awt/Font;", "computeTextHeight", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Font getFont() {
            Font font;
            if (SystemInfoRt.isMac && !ExperimentalUI.Companion.isNewUI()) {
                JBFont jBFont = JBFont.small();
                Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"small(...)");
                font = (Font)jBFont;
            } else {
                Font font2 = JBUI.CurrentTheme.StatusBar.font();
                font = font2;
                Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"font(...)");
            }
            return font;
        }

        public final int computeTextHeight() {
            JLabel label2 = new JLabel("XXX");
            label2.setFont(this.getFont());
            return label2.getPreferredSize().height;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/wm/impl/status/TextPanel$ExtraSize;", "Lcom/intellij/openapi/wm/impl/status/TextPanel;", "<init>", "()V", "getPreferredSize", "Ljava/awt/Dimension;", "intellij.platform.ide.impl"})
    public static class ExtraSize
    extends TextPanel {
        public ExtraSize() {
            super((Function0<String>)null);
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Dimension size2 = super.getPreferredSize();
            return new Dimension(size2.width + 3, size2.height);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IdeStatusBarImpl.WidgetEffect.values().length];
            try {
                nArray[IdeStatusBarImpl.WidgetEffect.PRESSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeStatusBarImpl.WidgetEffect.HOVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001b\b\u0016\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019R(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/wm/impl/status/TextPanel$WithIconAndArrows;", "Lcom/intellij/openapi/wm/impl/status/TextPanel;", "<init>", "()V", "toolTipTextSupplier", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "value", "Ljavax/swing/Icon;", "icon", "getIcon", "()Ljavax/swing/Icon;", "setIcon", "(Ljavax/swing/Icon;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "getPreferredSize", "Ljava/awt/Dimension;", "getTextX", "", "getIconX", "hasIcon", "", "Companion", "intellij.platform.ide.impl"})
    public static class WithIconAndArrows
    extends TextPanel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private Icon icon;
        private static final int GAP = JBUIScale.scale((int)2);

        @Nullable
        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(@Nullable Icon value) {
            if (Intrinsics.areEqual((Object)value, (Object)this.icon)) {
                return;
            }
            Icon oldValue = this.icon;
            this.icon = value;
            this.firePropertyChange(TextPanel.PROPERTY_ICON, oldValue, value);
            this.revalidate();
            this.repaint();
        }

        public WithIconAndArrows() {
            super((Function0<String>)null);
        }

        public WithIconAndArrows(@Nullable Function0<String> toolTipTextSupplier2) {
            super(toolTipTextSupplier2);
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            block2: {
                Icon icon2;
                Icon icon3;
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paintComponent(g);
                if (this.getIcon() == null || this.isEnabled()) {
                    icon3 = this.getIcon();
                } else {
                    Icon icon4 = this.getIcon();
                    Intrinsics.checkNotNull((Object)icon4);
                    icon3 = IconLoader.getDisabledIcon((Icon)icon4);
                }
                Icon icon5 = icon2 = icon3;
                if (icon5 == null) break block2;
                icon5.paintIcon(this, g, this.getIconX(g), this.getHeight() / 2 - icon2.getIconHeight() / 2);
            }
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            if (this.getIcon() == null) {
                return preferredSize;
            }
            int n = preferredSize.width;
            Icon icon2 = this.getIcon();
            Intrinsics.checkNotNull((Object)icon2);
            return new Dimension(RangesKt.coerceAtLeast((int)(n + icon2.getIconWidth()), (int)this.getHeight()), preferredSize.height);
        }

        @Override
        protected int getTextX(@NotNull Graphics g) {
            int n;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            int x = super.getTextX(g);
            if (this.getIcon() == null || this.getAlignment() == 1.0f) {
                n = x;
            } else if (this.getAlignment() == 0.5f) {
                Icon icon2 = this.getIcon();
                Intrinsics.checkNotNull((Object)icon2);
                n = x + (icon2.getIconWidth() + GAP) / 2;
            } else if (this.getAlignment() == 0.0f) {
                Icon icon3 = this.getIcon();
                Intrinsics.checkNotNull((Object)icon3);
                n = x + icon3.getIconWidth() + GAP;
            } else {
                n = x;
            }
            return n;
        }

        private final int getIconX(Graphics g) {
            int n;
            int x = super.getTextX(g);
            if (this.getIcon() == null || this.getText() == null || this.getAlignment() == 0.0f) {
                n = x;
            } else if (this.getAlignment() == 0.5f) {
                Icon icon2 = this.getIcon();
                Intrinsics.checkNotNull((Object)icon2);
                n = x - (icon2.getIconWidth() + GAP) / 2;
            } else if (this.getAlignment() == 1.0f) {
                Icon icon3 = this.getIcon();
                Intrinsics.checkNotNull((Object)icon3);
                n = x - icon3.getIconWidth() - GAP;
            } else {
                n = x;
            }
            return n;
        }

        public final boolean hasIcon() {
            return this.getIcon() != null;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/wm/impl/status/TextPanel$WithIconAndArrows$Companion;", "", "<init>", "()V", "GAP", "", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

