/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.codeStyle.CodeFormattingDataPreparer;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CodeFormattingData {
    private static final Key<CodeFormattingData> CODE_FORMATTING_DATA_KEY = Key.create((String)"code.formatting.data");
    @NotNull
    private final Map<Integer, Set<TextRange>> injectedFileRangesMap;
    @NotNull
    private final PsiFile myPsiFile;

    private CodeFormattingData(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeFormattingData.$$$reportNull$$$0(0);
        }
        this.injectedFileRangesMap = new HashMap<Integer, Set<TextRange>>();
        this.myPsiFile = file2;
    }

    @NotNull
    public static CodeFormattingData getOrCreate(@NotNull PsiFile psiFile) {
        CodeFormattingData formattingData;
        if (psiFile == null) {
            CodeFormattingData.$$$reportNull$$$0(1);
        }
        if ((formattingData = (CodeFormattingData)psiFile.getUserData(CODE_FORMATTING_DATA_KEY)) == null) {
            formattingData = new CodeFormattingData(psiFile);
            psiFile.putUserData(CODE_FORMATTING_DATA_KEY, (Object)formattingData);
        }
        CodeFormattingData codeFormattingData = formattingData;
        if (codeFormattingData == null) {
            CodeFormattingData.$$$reportNull$$$0(2);
        }
        return codeFormattingData;
    }

    public static void copy(@NotNull PsiFile source, @NotNull PsiFile target) {
        if (source == null) {
            CodeFormattingData.$$$reportNull$$$0(3);
        }
        if (target == null) {
            CodeFormattingData.$$$reportNull$$$0(4);
        }
        target.putUserData(CODE_FORMATTING_DATA_KEY, (Object)((CodeFormattingData)source.getUserData(CODE_FORMATTING_DATA_KEY)));
    }

    @NotNull
    public static CodeFormattingData prepare(@NotNull PsiFile file2, @NotNull List<TextRange> ranges) {
        if (file2 == null) {
            CodeFormattingData.$$$reportNull$$$0(5);
        }
        if (ranges == null) {
            CodeFormattingData.$$$reportNull$$$0(6);
        }
        CodeFormattingData formattingData = CodeFormattingData.getOrCreate(file2);
        for (TextRange range : ranges) {
            formattingData.getInjectedRanges(range);
        }
        for (CodeFormattingDataPreparer preparer : CodeFormattingDataPreparer.EP_NAME.getExtensionList()) {
            preparer.prepareFormattingData(file2, ranges, formattingData);
        }
        CodeFormattingData codeFormattingData = formattingData;
        if (codeFormattingData == null) {
            CodeFormattingData.$$$reportNull$$$0(7);
        }
        return codeFormattingData;
    }

    public void dispose() {
        this.myPsiFile.putUserData(CODE_FORMATTING_DATA_KEY, null);
    }

    @NotNull
    Set<TextRange> getInjectedRanges(@NotNull TextRange range) {
        if (range == null) {
            CodeFormattingData.$$$reportNull$$$0(8);
        }
        if (this.myPsiFile.getProject().isDefault() || range.isEmpty()) {
            Set<TextRange> set = Collections.emptySet();
            if (set == null) {
                CodeFormattingData.$$$reportNull$$$0(9);
            }
            return set;
        }
        if ("Rust".equals(this.myPsiFile.getLanguage().getID())) {
            Set<TextRange> set = Collections.emptySet();
            if (set == null) {
                CodeFormattingData.$$$reportNull$$$0(10);
            }
            return set;
        }
        Set<TextRange> injectedRanges = this.injectedFileRangesMap.get(range.getStartOffset());
        if (injectedRanges == null) {
            injectedRanges = this.collectInjectedRanges(range);
            this.injectedFileRangesMap.put(range.getStartOffset(), injectedRanges);
        }
        Set<TextRange> set = injectedRanges;
        if (set == null) {
            CodeFormattingData.$$$reportNull$$$0(11);
        }
        return set;
    }

    private LinkedHashSet<TextRange> collectInjectedRanges(@NotNull TextRange range) {
        if (range == null) {
            CodeFormattingData.$$$reportNull$$$0(12);
        }
        LinkedHashSet<TextRange> injectedFileRangesSet = new LinkedHashSet<TextRange>();
        if (this.myPsiFile.getProject().isDefault()) {
            return injectedFileRangesSet;
        }
        List injectedDocuments = InjectedLanguageManager.getInstance((Project)this.myPsiFile.getProject()).getCachedInjectedDocumentsInRange(this.myPsiFile, this.myPsiFile.getTextRange());
        if (!injectedDocuments.isEmpty()) {
            for (DocumentWindow injectedDocument : injectedDocuments) {
                injectedFileRangesSet.add(TextRange.from((int)injectedDocument.injectedToHost(0), (int)injectedDocument.getTextLength()));
            }
        } else {
            Collection<PsiLanguageInjectionHost> injectionHosts = CodeFormattingData.collectInjectionHosts(this.myPsiFile, range);
            PsiLanguageInjectionHost.InjectedPsiVisitor visitor = (injectedPsi, places) -> {
                for (PsiLanguageInjectionHost.Shred place : places) {
                    Segment rangeMarker = place.getHostRangeMarker();
                    if (rangeMarker == null) continue;
                    injectedFileRangesSet.add(TextRange.create((Segment)rangeMarker));
                }
            };
            for (PsiLanguageInjectionHost host : injectionHosts) {
                ProgressManager.checkCanceled();
                InjectedLanguageManager.getInstance((Project)this.myPsiFile.getProject()).enumerate((PsiElement)host, visitor);
            }
        }
        return injectedFileRangesSet;
    }

    @NotNull
    private static Collection<PsiLanguageInjectionHost> collectInjectionHosts(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            CodeFormattingData.$$$reportNull$$$0(13);
        }
        if (range == null) {
            CodeFormattingData.$$$reportNull$$$0(14);
        }
        Stack toProcess = new Stack();
        for (PsiElement e = file2.findElementAt(range.getStartOffset()); e != null && e.getTextRange().getStartOffset() < range.getEndOffset(); e = e.getNextSibling()) {
            toProcess.push((Object)e);
        }
        if (toProcess.isEmpty()) {
            Set<PsiLanguageInjectionHost> set = Collections.emptySet();
            if (set == null) {
                CodeFormattingData.$$$reportNull$$$0(15);
            }
            return set;
        }
        HashSet<PsiLanguageInjectionHost> result2 = null;
        while (!toProcess.isEmpty()) {
            PsiElement e = (PsiElement)toProcess.pop();
            if (e instanceof PsiLanguageInjectionHost) {
                if (result2 == null) {
                    result2 = new HashSet<PsiLanguageInjectionHost>();
                }
                result2.add((PsiLanguageInjectionHost)e);
                continue;
            }
            for (PsiElement child = e.getFirstChild(); child != null && e.getTextRange().getStartOffset() < range.getEndOffset(); child = child.getNextSibling()) {
                toProcess.push((Object)child);
            }
        }
        Set<PsiLanguageInjectionHost> set = result2 == null ? Collections.emptySet() : result2;
        if (set == null) {
            CodeFormattingData.$$$reportNull$$$0(16);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 9, 10, 11, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeFormattingData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeFormattingData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prepare";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedRanges";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInjectionHosts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedRanges";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectInjectedRanges";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectInjectionHosts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 9, 10, 11, 15, 16 -> new IllegalStateException(string);
        };
    }
}

