/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.NSWorkspace;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ui/MacCustomAppIcon;", "", "<init>", "()V", "Companion", "intellij.platform.ide.impl"})
public final class MacCustomAppIcon {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ui/MacCustomAppIcon$Companion;", "", "<init>", "()V", "available", "", "isCustom", "setCustom", "", "value", "showDialog", "getApplicationPath", "", "getImagePath", "appPath", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean available() {
            if (!SystemInfo.isMac || PluginManagerCore.isRunningFromSources()) {
                return false;
            }
            String appPath = this.getApplicationPath();
            return appPath != null && new File(this.getImagePath(appPath)).exists();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isCustom() {
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                String appPath = this.getApplicationPath();
                if (appPath == null) {
                    boolean bl = false;
                    return bl;
                }
                ID iD = NSWorkspace.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"getInstance(...)");
                ID workspace = iD;
                Object[] objectArray = new Object[]{Foundation.nsString((String)appPath)};
                ID iD2 = Foundation.invoke((ID)workspace, (String)"iconForFile:", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)iD2, (String)"invoke(...)");
                ID image2 = iD2;
                ID iD3 = Foundation.invoke((ID)image2, (String)"description", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)iD3, (String)"invoke(...)");
                ID description = iD3;
                String string = Foundation.toStringViaUTF8((ID)description);
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"ISCustomIcon", (boolean)false, (int)2, null) : false;
                return bl;
            }
            finally {
                pool.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setCustom(boolean value, boolean showDialog) {
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                String appPath = this.getApplicationPath();
                if (appPath == null) {
                    return;
                }
                ID image2 = ID.NIL;
                if (value) {
                    ID iD = Foundation.nsString((String)this.getImagePath(appPath));
                    Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"nsString(...)");
                    ID name2 = iD;
                    Object[] objectArray = new Object[]{name2};
                    image2 = Foundation.invoke((ID)Foundation.invoke((String)"NSImage", (String)"alloc", (Object[])new Object[0]), (String)"initWithContentsOfFile:", (Object[])objectArray);
                }
                ID iD = NSWorkspace.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"getInstance(...)");
                ID workspace = iD;
                Object[] objectArray = new Object[]{image2, Foundation.nsString((String)appPath), 2};
                boolean result2 = Foundation.invoke((ID)workspace, (String)"setIcon:forFile:options:", (Object[])objectArray).booleanValue();
                if (result2) {
                    PropertiesComponent.getInstance().setValue("ide.mac.custom.app.icon", value, true);
                    Process process2 = Runtime.getRuntime().exec("killall Finder && killall Dock");
                    if (showDialog && PluginManagerConfigurable.showRestartDialog(IdeBundle.message((String)"dialog.title.restart.required", (Object[])new Object[0]), Companion::setCustom$lambda$0) == 0) {
                        process2.waitFor(20L, TimeUnit.SECONDS);
                        ApplicationManagerEx.getApplicationEx().restart(true);
                    }
                } else if (showDialog) {
                    objectArray = new Object[]{value ? 0 : 1};
                    Messages.showErrorDialog((String)IdeBundle.message((String)"checkbox.ide.mac.app.icon", (Object[])new Object[0]), (String)IdeBundle.message((String)"ide.mac.app.icon.error.message", (Object[])objectArray));
                } else {
                    objectArray = new Object[]{value ? 0 : 1};
                    Logger.getInstance(MacCustomAppIcon.class).error(IdeBundle.message((String)"ide.mac.app.icon.error.message", (Object[])objectArray));
                }
            }
            finally {
                pool.drain();
            }
        }

        private final String getApplicationPath() {
            String string = PathManager.getHomePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHomePath(...)");
            String appPath = string;
            int index = StringsKt.lastIndexOf$default((CharSequence)appPath, (String)".app", (int)0, (boolean)false, (int)6, null);
            if (index > 0) {
                String string2 = appPath.substring(0, index + 4);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return string2;
            }
            return null;
        }

        private final String getImagePath(String appPath) {
            String customIcon = "custom.icns";
            return appPath + "/Contents/Resources/" + customIcon;
        }

        private static final String setCustom$lambda$0(String it) {
            Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
            return IdeBundle.message((String)"dialog.message.must.be.restarted.for.changes.to.take.effect", (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

