/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ui.colorpicker.AlphaSliderComponent;
import com.intellij.ui.colorpicker.ColorAdjustPanelKt;
import com.intellij.ui.colorpicker.ColorIndicator;
import com.intellij.ui.colorpicker.ColorPickerBuilderKt;
import com.intellij.ui.colorpicker.ColorPickerModel;
import com.intellij.ui.colorpicker.ColorPipetteButton;
import com.intellij.ui.colorpicker.ColorPipetteProvider;
import com.intellij.ui.colorpicker.HueSliderComponent;
import com.intellij.ui.colorpicker.SliderComponent;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonUI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u001a8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/intellij/ui/colorpicker/ColorAdjustPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/ui/picker/ColorListener;", "model", "Lcom/intellij/ui/colorpicker/ColorPickerModel;", "pipetteProvider", "Lcom/intellij/ui/colorpicker/ColorPipetteProvider;", "showAlpha", "", "<init>", "(Lcom/intellij/ui/colorpicker/ColorPickerModel;Lcom/intellij/ui/colorpicker/ColorPipetteProvider;Z)V", "pipetteButton", "Lcom/intellij/ui/colorpicker/ColorPipetteButton;", "getPipetteButton", "()Lcom/intellij/ui/colorpicker/ColorPipetteButton;", "pipetteButton$delegate", "Lkotlin/Lazy;", "colorIndicator", "Lcom/intellij/ui/colorpicker/ColorIndicator;", "getColorIndicator", "()Lcom/intellij/ui/colorpicker/ColorIndicator;", "hueSlider", "Lcom/intellij/ui/colorpicker/HueSliderComponent;", "getHueSlider", "()Lcom/intellij/ui/colorpicker/HueSliderComponent;", "alphaSlider", "Lcom/intellij/ui/colorpicker/AlphaSliderComponent;", "getAlphaSlider", "()Lcom/intellij/ui/colorpicker/AlphaSliderComponent;", "colorChanged", "", "color", "Ljava/awt/Color;", "source", "", "intellij.platform.ide.impl"})
public final class ColorAdjustPanel
extends JPanel
implements ColorListener {
    @NotNull
    private final ColorPickerModel model;
    @NotNull
    private final ColorPipetteProvider pipetteProvider;
    @NotNull
    private final Lazy pipetteButton$delegate;
    @VisibleForTesting
    @NotNull
    private final ColorIndicator colorIndicator;
    @VisibleForTesting
    @NotNull
    private final HueSliderComponent hueSlider;
    @VisibleForTesting
    @NotNull
    private final AlphaSliderComponent alphaSlider;

    /*
     * WARNING - void declaration
     */
    public ColorAdjustPanel(@NotNull ColorPickerModel model2, @NotNull ColorPipetteProvider pipetteProvider, boolean showAlpha) {
        void $this$alphaSlider_u24lambda_u240;
        JComponent $this$hueSlider_u24lambda_u240;
        JComponent $this$colorIndicator_u24lambda_u240;
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)pipetteProvider, (String)"pipetteProvider");
        super(new GridBagLayout());
        this.model = model2;
        this.pipetteProvider = pipetteProvider;
        this.pipetteButton$delegate = LazyKt.lazy(() -> ColorAdjustPanel.pipetteButton_delegate$lambda$0(this));
        ColorIndicator colorIndicator = jComponent = new ColorIndicator(null, 1, null);
        ColorAdjustPanel colorAdjustPanel = this;
        boolean bl = false;
        $this$colorIndicator_u24lambda_u240.setBorder(ColorAdjustPanelKt.access$getCOLOR_INDICATOR_BORDER$p());
        $this$colorIndicator_u24lambda_u240.setPreferredSize((Dimension)ColorAdjustPanelKt.access$getCOLOR_INDICATOR_SIZE$p());
        colorAdjustPanel.colorIndicator = jComponent;
        $this$colorIndicator_u24lambda_u240 = jComponent = new HueSliderComponent();
        colorAdjustPanel = this;
        boolean bl2 = false;
        $this$hueSlider_u24lambda_u240.setBorder((Border)ColorAdjustPanelKt.access$getHUE_SLIDER_BORDER$p());
        $this$hueSlider_u24lambda_u240.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        ((SliderComponent)$this$hueSlider_u24lambda_u240).addListener(arg_0 -> ColorAdjustPanel.hueSlider$lambda$0$0(this, showAlpha, arg_0));
        colorAdjustPanel.hueSlider = jComponent;
        $this$hueSlider_u24lambda_u240 = jComponent = new AlphaSliderComponent();
        colorAdjustPanel = this;
        boolean bl3 = false;
        $this$alphaSlider_u24lambda_u240.setBorder((Border)ColorAdjustPanelKt.access$getALPHA_SLIDER_BORDER$p());
        $this$alphaSlider_u24lambda_u240.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        $this$alphaSlider_u24lambda_u240.addListener(arg_0 -> ColorAdjustPanel.alphaSlider$lambda$0$0(this, arg_0));
        colorAdjustPanel.alphaSlider = jComponent;
        this.setBorder((Border)ColorAdjustPanelKt.access$getPANEL_BORDER$p());
        this.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        this.setPreferredSize((Dimension)ColorAdjustPanelKt.access$getPANEL_PREFERRED_SIZE$p());
        GridBagConstraints c = new GridBagConstraints();
        if (ColorAdjustPanelKt.access$canPickupColorFromDisplay()) {
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.12;
            this.add((Component)this.getPipetteButton(), c);
        }
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.12;
        this.add((Component)this.colorIndicator, c);
        c.fill = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.76;
        JPanel sliderPanel = new JPanel();
        sliderPanel.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        if (showAlpha) {
            sliderPanel.setBorder((Border)JBUI.Borders.empty());
            sliderPanel.setLayout(new BoxLayout(sliderPanel, 1));
            sliderPanel.add(this.hueSlider);
            v0 = sliderPanel.add(this.alphaSlider);
        } else {
            sliderPanel.setBorder((Border)JBUI.Borders.empty((int)9, (int)0));
            sliderPanel.setLayout(new BorderLayout());
            v0 = sliderPanel.add(this.hueSlider);
        }
        this.add((Component)sliderPanel, c);
        this.model.addListener(this);
    }

    public /* synthetic */ ColorAdjustPanel(ColorPickerModel colorPickerModel, ColorPipetteProvider colorPipetteProvider, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(colorPickerModel, colorPipetteProvider, bl);
    }

    private final ColorPipetteButton getPipetteButton() {
        Lazy lazy = this.pipetteButton$delegate;
        return (ColorPipetteButton)lazy.getValue();
    }

    @NotNull
    public final ColorIndicator getColorIndicator() {
        return this.colorIndicator;
    }

    @NotNull
    public final HueSliderComponent getHueSlider() {
        return this.hueSlider;
    }

    @NotNull
    public final AlphaSliderComponent getAlphaSlider() {
        return this.alphaSlider;
    }

    public void colorChanged(@NotNull Color color, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (!Intrinsics.areEqual((Object)this.colorIndicator.getColor(), (Object)color)) {
            this.colorIndicator.setColor(color);
        }
        float hue = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null)[0];
        int hueDegree = MathKt.roundToInt((float)(hue * (float)360));
        if (Math.abs(((Number)this.hueSlider.getValue()).intValue() - hueDegree) != 360) {
            this.hueSlider.setValue(hueDegree);
        }
        this.alphaSlider.setSliderBackgroundColor(color);
        if (((Number)this.alphaSlider.getValue()).intValue() != color.getAlpha()) {
            this.alphaSlider.setValue(color.getAlpha());
        }
        this.repaint();
    }

    private static final ColorPipetteButton pipetteButton_delegate$lambda$0(ColorAdjustPanel this$0) {
        ColorPipetteButton colorPipetteButton;
        ColorPipetteButton $this$pipetteButton_delegate_u24lambda_u240_u240 = colorPipetteButton = new ColorPipetteButton(this$0.model, this$0.pipetteProvider.createPipette(this$0));
        boolean bl = false;
        $this$pipetteButton_delegate_u24lambda_u240_u240.setBorder((Border)ColorAdjustPanelKt.access$getPIPETTE_BUTTON_BORDER$p());
        $this$pipetteButton_delegate_u24lambda_u240_u240.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        $this$pipetteButton_delegate_u24lambda_u240_u240.setUI(new BasicButtonUI());
        $this$pipetteButton_delegate_u24lambda_u240_u240.setFocusable(false);
        $this$pipetteButton_delegate_u24lambda_u240_u240.setPreferredSize((Dimension)ColorAdjustPanelKt.access$getCOLOR_INDICATOR_SIZE$p());
        return colorPipetteButton;
    }

    private static final Unit hueSlider$lambda$0$0(ColorAdjustPanel this$0, boolean $showAlpha, int it) {
        if (this$0.model.getColor().getRed() == this$0.model.getColor().getGreen() && this$0.model.getColor().getGreen() == this$0.model.getColor().getBlue()) {
            return Unit.INSTANCE;
        }
        float hue = (float)it / 360.0f;
        float[] hsbValues = Color.RGBtoHSB(this$0.model.getColor().getRed(), this$0.model.getColor().getGreen(), this$0.model.getColor().getBlue(), null);
        int rgb = Color.HSBtoRGB(hue, hsbValues[1], hsbValues[2]);
        int argb = this$0.model.getColor().getAlpha() << 24 | rgb & 0xFFFFFF;
        Color newColor = $showAlpha ? new Color(argb, true) : new Color(rgb);
        this$0.model.setColor(newColor, this$0);
        return Unit.INSTANCE;
    }

    private static final Unit alphaSlider$lambda$0$0(ColorAdjustPanel this$0, int it) {
        this$0.model.setColor(new Color(this$0.model.getColor().getRed(), this$0.model.getColor().getGreen(), this$0.model.getColor().getBlue(), it), this$0);
        return Unit.INSTANCE;
    }
}

