/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupShowOptionsBuilder;
import com.intellij.openapi.ui.popup.PopupShowOptionsImpl;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.UiInterceptors;
import com.intellij.ui.awt.AnchoredPoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupDispatcher;
import com.intellij.ui.popup.list.ComboBoxPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.tree.TreePopupImpl;
import com.intellij.ui.popup.util.MnemonicsSearch;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.wayland.WaylandUtilKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.TimerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WizardPopup
extends AbstractPopup
implements ActionListener,
ElementFilter {
    private static final Logger LOG = Logger.getInstance(WizardPopup.class);
    private static final Dimension MAX_SIZE = new Dimension(Integer.MAX_VALUE, 600);
    protected static final int STEP_X_PADDING = 2;
    private final WizardPopup myParent;
    private boolean alignByParentBounds;
    protected final PopupStep<Object> myStep;
    protected WizardPopup myChild;
    private boolean myIsActiveRoot;
    private final Timer myAutoSelectionTimer;
    private final MnemonicsSearch myMnemonicsSearch;
    private Object myParentValue;
    private Point myLastOwnerPoint;
    private Window myOwnerWindow;
    private MyComponentAdapter myOwnerListener;
    private final ActionMap myActionMap;
    private final InputMap myInputMap;
    private boolean myKeyPressedReceived;

    public WizardPopup(@Nullable Project project2, @Nullable JBPopup aParent, @NotNull PopupStep<Object> aStep) {
        if (aStep == null) {
            WizardPopup.$$$reportNull$$$0(0);
        }
        this.alignByParentBounds = true;
        this.myIsActiveRoot = true;
        this.myAutoSelectionTimer = TimerUtil.createNamedTimer((String)"Wizard auto-selection", (int)Registry.intValue((String)"ide.popup.auto.delay", (int)500), (ActionListener)this);
        this.myActionMap = new ActionMap();
        this.myInputMap = new InputMap();
        this.myParent = (WizardPopup)aParent;
        this.myStep = aStep;
        this.mySpeedSearch.setEnabled(this.myStep.isSpeedSearchEnabled());
        JComponent content2 = this.createContent();
        content2.putClientProperty("JBPopup", this);
        JComponent popupComponent = this.createPopupComponent(content2);
        this.init(project2, popupComponent, this.getPreferredFocusableComponent(), true, true, true, null, this.isResizable(), aStep.getTitle(), null, true, Collections.emptySet(), false, null, null, null, false, null, true, false, true, null, 0.0f, null, true, false, new Component[0], null, 2, true, Collections.emptyList(), null, null, false, true, true, null, true, null);
        this.registerAction("disposeAll", 27, 1, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WizardPopup.this.mySpeedSearch.isHoldingFilter()) {
                    WizardPopup.this.mySpeedSearch.reset();
                } else {
                    WizardPopup.this.disposeAll();
                }
            }
        });
        AbstractAction goBackAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardPopup.this.goBack();
            }
        };
        this.registerAction("goBack3", 27, 0, goBackAction);
        this.myMnemonicsSearch = new MnemonicsSearch(this){

            protected void select(Object value) {
                WizardPopup.this.onSelectByMnemonic(value);
            }
        };
        this.initActionShortcutDelegates(aStep, popupComponent);
    }

    private void initActionShortcutDelegates(@NotNull PopupStep<?> step2, @NotNull JComponent component2) {
        MnemonicNavigationFilter itemsSource;
        if (step2 == null) {
            WizardPopup.$$$reportNull$$$0(1);
        }
        if (component2 == null) {
            WizardPopup.$$$reportNull$$$0(2);
        }
        if ((itemsSource = step2.getMnemonicNavigationFilter()) == null) {
            return;
        }
        for (Object item : itemsSource.getValues()) {
            ShortcutProvider itemShortcut;
            ShortcutSet shortcut;
            if (!(item instanceof ShortcutProvider) || (shortcut = (itemShortcut = (ShortcutProvider)item).getShortcut()) == null || !shortcut.hasShortcuts()) continue;
            ActionShortcutDelegate action2 = new ActionShortcutDelegate(item, shortcut);
            action2.registerCustomShortcutSet(component2, this);
        }
    }

    @NotNull
    protected JComponent createPopupComponent(JComponent content2) {
        JScrollPane scrollPane = this.createScrollPane(content2);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getHorizontalScrollBar().setBorder(null);
        scrollPane.getActionMap().get("unitScrollLeft").setEnabled(false);
        scrollPane.getActionMap().get("unitScrollRight").setEnabled(false);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            WizardPopup.$$$reportNull$$$0(3);
        }
        return jScrollPane;
    }

    @NotNull
    protected JScrollPane createScrollPane(JComponent content2) {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)content2);
        if (jScrollPane == null) {
            WizardPopup.$$$reportNull$$$0(4);
        }
        return jScrollPane;
    }

    private void disposeAll() {
        WizardPopup root = PopupDispatcher.getActiveRoot();
        this.disposeAllParents(null);
        root.getStep().canceled();
    }

    public void goBack() {
        if (this.mySpeedSearch.isHoldingFilter()) {
            this.mySpeedSearch.reset();
            return;
        }
        if (this.myParent != null) {
            this.myParent.disposeChildren();
        } else {
            this.disposeAll();
        }
    }

    protected abstract JComponent createContent();

    @Override
    public void dispose() {
        this.myAutoSelectionTimer.stop();
        super.dispose();
        PopupDispatcher.unsetShowing(this);
        PopupDispatcher.clearRootIfNeeded(this);
        if (this.myOwnerWindow != null && this.myOwnerListener != null) {
            this.myOwnerWindow.removeComponentListener(this.myOwnerListener);
        }
    }

    public void disposeChildren() {
        if (this.myChild != null) {
            this.myChild.disposeChildren();
            Disposer.dispose((Disposable)this.myChild);
            this.myChild = null;
        }
    }

    @Override
    @ApiStatus.Internal
    protected void showImpl(@NotNull PopupShowOptionsBuilder showOptions) {
        PopupShowOptionsBuilder newOptions;
        if (showOptions == null) {
            WizardPopup.$$$reportNull$$$0(5);
        }
        if (UiInterceptors.tryIntercept((Object)this)) {
            return;
        }
        LOG.assertTrue(!this.isDisposed());
        PopupShowOptionsImpl options2 = showOptions.build();
        if (options2.getPopupAnchor() == AnchoredPoint.Anchor.TOP_LEFT) {
            Component owner = options2.getOwner();
            int aScreenX = options2.getScreenX();
            int aScreenY = options2.getScreenY();
            Dimension size2 = this.getContent().getPreferredSize();
            Dimension minimumSize = this.getMinimumSize();
            size2.width = Math.max(size2.width, minimumSize.width);
            size2.height = Math.max(size2.height, minimumSize.height);
            Rectangle targetBounds = new Rectangle(new Point(aScreenX, aScreenY), size2);
            if (this.getParent() != null && this.alignByParentBounds) {
                Rectangle parentBounds = this.getParent().getBounds();
                parentBounds.x += 2;
                parentBounds.width -= 4;
                ScreenUtil.moveToFit((Rectangle)targetBounds, (Rectangle)ScreenUtil.getScreenRectangle((int)(parentBounds.x + parentBounds.width / 2), (int)(parentBounds.y + parentBounds.height / 2)), null);
                if (parentBounds.intersects(targetBounds)) {
                    targetBounds.x = this.getParent().getBounds().x - targetBounds.width - 2;
                }
            } else {
                ScreenUtil.moveToFit((Rectangle)targetBounds, (Rectangle)ScreenUtil.getScreenRectangle((int)(aScreenX + 1), (int)(aScreenY + 1)), null);
            }
            newOptions = new PopupShowOptionsBuilder().withOwner(owner).withScreenXY(targetBounds.x, targetBounds.y).withForcedXY(true);
        } else {
            newOptions = showOptions;
        }
        if (this.getParent() == null && this.myIsActiveRoot) {
            PopupDispatcher.setActiveRoot(this);
        } else {
            PopupDispatcher.setShowing(this);
        }
        LOG.assertTrue(!this.isDisposed(), (Object)("Disposed popup, parent=" + String.valueOf(this.getParent())));
        super.showImpl(newOptions);
    }

    @Override
    protected void afterShow() {
        super.afterShow();
        this.registerAutoMove();
    }

    private void registerAutoMove() {
        if (this.myOwner != null) {
            this.myOwnerWindow = SwingUtilities.getWindowAncestor(this.myOwner);
            if (this.myOwnerWindow != null) {
                this.myLastOwnerPoint = this.myOwnerWindow.getLocationOnScreen();
                this.myOwnerListener = new MyComponentAdapter();
                this.myOwnerWindow.addComponentListener(this.myOwnerListener);
            }
        }
    }

    private void processParentWindowMoved() {
        if (this.isDisposed()) {
            return;
        }
        Point newOwnerPoint = this.myOwnerWindow.getLocationOnScreen();
        int deltaX = this.myLastOwnerPoint.x - newOwnerPoint.x;
        int deltaY = this.myLastOwnerPoint.y - newOwnerPoint.y;
        this.myLastOwnerPoint = newOwnerPoint;
        Window wnd = SwingUtilities.getWindowAncestor(this.getContent());
        if (!wnd.isShowing()) {
            return;
        }
        Point current = wnd.getLocationOnScreen();
        this.setLocation(new Point(current.x - deltaX, current.y - deltaY));
    }

    protected abstract JComponent getPreferredFocusableComponent();

    @Override
    public void cancel(InputEvent e) {
        super.cancel(e);
        this.disposeChildren();
        Disposer.dispose((Disposable)this);
        this.getStep().canceled();
    }

    @Override
    public boolean isCancelKeyEnabled() {
        return super.isCancelKeyEnabled() && !this.mySpeedSearch.isHoldingFilter();
    }

    protected void disposeAllParents(InputEvent e) {
        this.myDisposeEvent = e;
        Disposer.dispose((Disposable)this);
        if (this.myParent != null) {
            this.myParent.disposeAllParents(null);
        }
    }

    public final void registerAction(@NonNls String aActionName, int aKeyCode, @JdkConstants.InputEventMask int aModifier, Action aAction) {
        this.myInputMap.put(KeyStroke.getKeyStroke(aKeyCode, aModifier), aActionName);
        this.myActionMap.put(aActionName, aAction);
    }

    protected String getActionForKeyStroke(KeyStroke keyStroke) {
        return (String)this.myInputMap.get(keyStroke);
    }

    public final void registerAction(@NonNls String aActionName, KeyStroke keyStroke, Action aAction) {
        this.myInputMap.put(keyStroke, aActionName);
        this.myActionMap.put(aActionName, aAction);
    }

    protected abstract InputMap getInputMap();

    protected abstract ActionMap getActionMap();

    protected final void setParentValue(Object parentValue) {
        this.myParentValue = parentValue;
    }

    @Override
    @NotNull
    protected AbstractPopup.MyContentPanel createContentPanel(boolean resizable, @NotNull PopupBorder border, boolean isToDrawMacCorner) {
        if (border == null) {
            WizardPopup.$$$reportNull$$$0(6);
        }
        return new MyContainer(border);
    }

    protected boolean isResizable() {
        return false;
    }

    public WizardPopup getParent() {
        return this.myParent;
    }

    public void setAlignByParentBounds(boolean alignByParentBounds) {
        this.alignByParentBounds = alignByParentBounds;
    }

    public boolean isAlignByParentBounds() {
        return this.alignByParentBounds;
    }

    public PopupStep getStep() {
        return this.myStep;
    }

    public final boolean dispatch(KeyEvent event) {
        KeyStroke stroke;
        if (this.anyModalWindowsAbovePopup()) {
            return false;
        }
        if (event.getID() == 401) {
            this.myKeyPressedReceived = true;
            stroke = KeyStroke.getKeyStroke(event.getKeyCode(), event.getModifiers(), false);
            if (this.proceedKeyEvent(event, stroke)) {
                return true;
            }
        } else if (!this.myKeyPressedReceived && !(this instanceof ComboBoxPopup)) {
            return false;
        }
        if (event.getID() == 402) {
            stroke = KeyStroke.getKeyStroke(event.getKeyCode(), event.getModifiers(), true);
            return this.proceedKeyEvent(event, stroke);
        }
        this.myMnemonicsSearch.processKeyEvent(event);
        this.processKeyEvent(event);
        if (event.isConsumed()) {
            return true;
        }
        this.process(event);
        return event.isConsumed();
    }

    protected void processKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            WizardPopup.$$$reportNull$$$0(7);
        }
        this.mySpeedSearch.processKeyEvent(e);
    }

    private boolean proceedKeyEvent(KeyEvent event, KeyStroke stroke) {
        Action action2;
        if (this.myInputMap.get(stroke) != null && (action2 = this.myActionMap.get(this.myInputMap.get(stroke))) != null && action2.isEnabled()) {
            WriteIntentReadAction.run(() -> action2.actionPerformed(new ActionEvent(this.getContent(), event.getID(), "", event.getWhen(), event.getModifiers())));
            event.consume();
            return true;
        }
        return false;
    }

    protected void process(KeyEvent aEvent) {
    }

    public Rectangle getBounds() {
        JComponent content2 = this.isDisposed() ? null : this.getContent();
        return content2 == null ? null : new Rectangle(content2.getLocationOnScreen(), content2.getSize());
    }

    protected WizardPopup createPopup(WizardPopup parent, PopupStep step2, Object parentValue) {
        if (step2 instanceof ListPopupStep) {
            return new ListPopupImpl(this.getProject(), parent, (ListPopupStep)step2, parentValue);
        }
        if (step2 instanceof TreePopupStep) {
            return new TreePopupImpl(this.getProject(), parent, (TreePopupStep<Object>)((TreePopupStep)step2), parentValue);
        }
        throw new IllegalArgumentException(step2.getClass().toString());
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this.myAutoSelectionTimer.stop();
        if (this.getStep().isAutoSelectionEnabled()) {
            this.onAutoSelectionTimer();
        }
    }

    protected final void restartTimer() {
        if (!this.myAutoSelectionTimer.isRunning()) {
            this.myAutoSelectionTimer.start();
        } else {
            this.myAutoSelectionTimer.restart();
        }
    }

    protected final void stopTimer() {
        this.myAutoSelectionTimer.stop();
    }

    protected void onAutoSelectionTimer() {
    }

    public boolean shouldBeShowing(Object value) {
        if (!this.myStep.isSpeedSearchEnabled()) {
            return true;
        }
        SpeedSearchFilter filter2 = this.myStep.getSpeedSearchFilter();
        if (filter2 == null) {
            return true;
        }
        if (!filter2.canBeHidden(value)) {
            return true;
        }
        if (!this.mySpeedSearch.isHoldingFilter()) {
            return true;
        }
        String text2 = filter2.getIndexedString(value);
        return this.mySpeedSearch.shouldBeShowing(text2);
    }

    public SpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    protected void onSelectByMnemonic(Object value) {
    }

    protected abstract void onChildSelectedFor(Object var1);

    protected final void notifyParentOnChildSelection() {
        if (this.myParent == null || this.myParentValue == null) {
            return;
        }
        this.myParent.onChildSelectedFor(this.myParentValue);
    }

    public void setActiveRoot(boolean activeRoot) {
        this.myIsActiveRoot = activeRoot;
    }

    @Override
    public final void setFinalRunnable(@Nullable Runnable runnable2) {
        if (this.getParent() == null) {
            super.setFinalRunnable(runnable2);
        } else {
            this.getParent().setFinalRunnable(runnable2);
        }
    }

    @Override
    public void setOk(boolean ok) {
        if (this.getParent() == null) {
            super.setOk(ok);
        } else {
            this.getParent().setOk(ok);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public ActionMap getOwnActionMap() {
        ActionMap actionMap = this.myActionMap;
        if (actionMap == null) {
            WizardPopup.$$$reportNull$$$0(8);
        }
        return actionMap;
    }

    @ApiStatus.Internal
    @NotNull
    public InputMap getOwnInputMap() {
        InputMap inputMap = this.myInputMap;
        if (inputMap == null) {
            WizardPopup.$$$reportNull$$$0(9);
        }
        return inputMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aStep";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/WizardPopup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showOptions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "border";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/WizardPopup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnActionMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnInputMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initActionShortcutDelegates";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createContentPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processKeyEvent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 9 -> new IllegalStateException(string);
        };
    }

    private class ActionShortcutDelegate
    extends DumbAwareAction {
        private final Object myItem;

        ActionShortcutDelegate(@NotNull Object item, ShortcutSet shortcut) {
            if (item == null) {
                ActionShortcutDelegate.$$$reportNull$$$0(0);
            }
            if (shortcut == null) {
                ActionShortcutDelegate.$$$reportNull$$$0(1);
            }
            this.myItem = item;
            this.setShortcutSet(shortcut);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ActionShortcutDelegate.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ActionShortcutDelegate.$$$reportNull$$$0(3);
            }
            WizardPopup.this.onSelectByMnemonic(this.myItem);
        }

        public String toString() {
            return "ActionShortcutDelegate{myItem=" + String.valueOf(this.myItem) + "} " + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shortcut";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/WizardPopup$ActionShortcutDelegate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/WizardPopup$ActionShortcutDelegate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class MyComponentAdapter
    extends ComponentAdapter {
        private MyComponentAdapter() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            WizardPopup.this.processParentWindowMoved();
        }
    }

    private static final class MyContainer
    extends AbstractPopup.MyContentPanel {
        private MyContainer(@NotNull PopupBorder border) {
            if (border == null) {
                MyContainer.$$$reportNull$$$0(0);
            }
            super(border);
            this.setOpaque(true);
            this.setFocusCycleRoot(true);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                return super.getPreferredSize();
            }
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            return MyContainer.computeNotBiggerDimension(super.getPreferredSize().getSize(), focusOwner);
        }

        private static Dimension computeNotBiggerDimension(@NotNull Dimension ofContent, @Nullable Component focusOwner) {
            if (ofContent == null) {
                MyContainer.$$$reportNull$$$0(1);
            }
            int defaultHeight = ofContent.height > WizardPopup.MAX_SIZE.height + 50 ? WizardPopup.MAX_SIZE.height : ofContent.height;
            @Nullable Integer computedHeight = MyContainer.computeNotBiggerHeight(ofContent, focusOwner);
            int resultHeight = computedHeight != null ? computedHeight : defaultHeight;
            int resultWidth = Math.min(ofContent.width, WizardPopup.MAX_SIZE.width);
            if (ofContent.height > resultHeight) {
                resultWidth = (int)((double)resultWidth + ScrollPaneFactory.createScrollPane().getVerticalScrollBar().getPreferredSize().getWidth());
            }
            return new Dimension(resultWidth, resultHeight);
        }

        @Nullable
        private static Integer computeNotBiggerHeight(@NotNull Dimension ofContent, @Nullable Component focusOwner) {
            if (ofContent == null) {
                MyContainer.$$$reportNull$$$0(2);
            }
            @Nullable Integer screenHeight = null;
            if (StartupUiUtil.isWaylandToolkit()) {
                screenHeight = WaylandUtilKt.getFakeScreenHeight((Component)focusOwner);
            } else {
                Point locationOnScreen = null;
                if (focusOwner != null && focusOwner.isShowing()) {
                    locationOnScreen = focusOwner.getLocationOnScreen();
                }
                if (locationOnScreen != null) {
                    Rectangle r = ScreenUtil.getScreenRectangle(locationOnScreen);
                    screenHeight = r.height;
                }
            }
            return screenHeight == null ? null : Integer.valueOf(Math.min(ofContent.height, screenHeight - screenHeight / 4));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "border";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ofContent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/popup/WizardPopup$MyContainer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeNotBiggerDimension";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeNotBiggerHeight";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

