/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.Easing;
import com.intellij.util.animation.JBAnimator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.DoubleConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\bJ.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J#\u0010+\u001a\u00070,\u00a2\u0006\u0002\b-2\u0006\u0010.\u001a\u00020/2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J&\u00100\u001a\n \u000f*\u0004\u0018\u00010,0,2\u0006\u0010.\u001a\u00020/2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001a\u0010%\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001a\u0010(\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010!\u00a8\u00061"}, d2={"Lcom/intellij/util/animation/ShowHideAnimator;", "", "easing", "Lcom/intellij/util/animation/Easing;", "consumer", "Ljava/util/function/DoubleConsumer;", "<init>", "(Lcom/intellij/util/animation/Easing;Ljava/util/function/DoubleConsumer;)V", "(Ljava/util/function/DoubleConsumer;)V", "animator", "Lcom/intellij/util/animation/JBAnimator;", "atomicVisible", "Ljava/util/concurrent/atomic/AtomicBoolean;", "statefulEasing", "Lcom/intellij/util/animation/Easing$Stateful;", "kotlin.jvm.PlatformType", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "setVisible", "", "visible", "", "onCompletion", "Lkotlin/Function0;", "updateVisibility", "setVisibleImmediately", "showingDelay", "", "getShowingDelay", "()I", "setShowingDelay", "(I)V", "showingDuration", "getShowingDuration", "setShowingDuration", "hidingDelay", "getHidingDelay", "setHidingDelay", "hidingDuration", "getHidingDuration", "setHidingDuration", "createShowingAnimation", "Lcom/intellij/util/animation/Animation;", "Lorg/jetbrains/annotations/NotNull;", "value", "", "createHidingAnimation", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class ShowHideAnimator {
    @NotNull
    private final DoubleConsumer consumer;
    @NotNull
    private final JBAnimator animator;
    @NotNull
    private final AtomicBoolean atomicVisible;
    private final Easing.Stateful statefulEasing;
    private int showingDelay;
    private int showingDuration;
    private int hidingDelay;
    private int hidingDuration;

    public ShowHideAnimator(@NotNull Easing easing, @NotNull DoubleConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.consumer = consumer;
        this.animator = new JBAnimator();
        this.atomicVisible = new AtomicBoolean();
        this.statefulEasing = easing.stateful();
        this.showingDelay = Registry.Companion.intValue("ide.animation.showing.delay", 0);
        this.showingDuration = Registry.Companion.intValue("ide.animation.showing.duration", 130);
        this.hidingDelay = Registry.Companion.intValue("ide.animation.hiding.delay", 140);
        this.hidingDuration = Registry.Companion.intValue("ide.animation.hiding.duration", 150);
    }

    @NotNull
    public final Disposable getDisposable() {
        return (Disposable)this.animator;
    }

    public ShowHideAnimator(@NotNull DoubleConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Easing easing = Easing.LINEAR;
        Intrinsics.checkNotNullExpressionValue((Object)easing, (String)"LINEAR");
        this(easing, consumer);
    }

    public final void setVisible(boolean visible, @Nullable Function0<Unit> onCompletion2, @NotNull Function0<Unit> updateVisibility) {
        block4: {
            block2: {
                block5: {
                    double value;
                    block3: {
                        Intrinsics.checkNotNullParameter(updateVisibility, (String)"updateVisibility");
                        if (visible == this.atomicVisible.getAndSet(visible)) break block2;
                        value = this.statefulEasing.value;
                        if (visible || !(value > 0.0)) break block3;
                        Animation animation = this.createHidingAnimation(value, updateVisibility);
                        if (onCompletion2 != null) {
                            animation.runWhenExpired(() -> ShowHideAnimator.setVisible$lambda$0(onCompletion2));
                        }
                        Animation[] animationArray = new Animation[]{animation};
                        this.animator.animate(animationArray);
                        break block4;
                    }
                    if (!visible || !(value < 1.0)) break block5;
                    Animation animation = this.createShowingAnimation(value, updateVisibility);
                    if (onCompletion2 != null) {
                        animation.runWhenExpired(() -> ShowHideAnimator.setVisible$lambda$1(onCompletion2));
                    }
                    Animation[] animationArray = new Animation[]{animation};
                    this.animator.animate(animationArray);
                    break block4;
                }
                this.animator.stop();
                updateVisibility.invoke();
                Function0<Unit> function0 = onCompletion2;
                if (function0 == null) break block4;
                function0.invoke();
                break block4;
            }
            Function0<Unit> function0 = onCompletion2;
            if (function0 == null) break block4;
            function0.invoke();
        }
    }

    public static /* synthetic */ void setVisible$default(ShowHideAnimator showHideAnimator, boolean bl, Function0 function0, Function0 function02, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setVisible");
        }
        if ((n & 2) != 0) {
            function0 = null;
        }
        showHideAnimator.setVisible(bl, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    public final void setVisibleImmediately(boolean visible) {
        this.animator.stop();
        if (visible != this.atomicVisible.getAndSet(visible)) {
            this.consumer.accept(this.statefulEasing.calc(visible ? 1.0 : 0.0));
        }
    }

    public final int getShowingDelay() {
        return this.showingDelay;
    }

    public final void setShowingDelay(int n) {
        this.showingDelay = n;
    }

    public final int getShowingDuration() {
        return this.showingDuration;
    }

    public final void setShowingDuration(int n) {
        this.showingDuration = n;
    }

    public final int getHidingDelay() {
        return this.hidingDelay;
    }

    public final void setHidingDelay(int n) {
        this.hidingDelay = n;
    }

    public final int getHidingDuration() {
        return this.hidingDuration;
    }

    public final void setHidingDuration(int n) {
        this.hidingDuration = n;
    }

    private final Animation createShowingAnimation(double value, Function0<Unit> updateVisibility) {
        Animation animation;
        Animation $this$createShowingAnimation_u24lambda_u240 = animation = new Animation(this.consumer);
        boolean bl = false;
        if (value > 0.0) {
            $this$createShowingAnimation_u24lambda_u240.setDuration(MathKt.roundToInt((double)((double)this.showingDuration * (1.0 - value))));
            $this$createShowingAnimation_u24lambda_u240.setEasing(this.statefulEasing.coerceIn(value, 1.0));
        } else {
            $this$createShowingAnimation_u24lambda_u240.setDelay(this.showingDelay);
            $this$createShowingAnimation_u24lambda_u240.setDuration(this.showingDuration);
            $this$createShowingAnimation_u24lambda_u240.setEasing((Easing)this.statefulEasing);
        }
        Animation animation2 = animation.runWhenScheduled(() -> ShowHideAnimator.createShowingAnimation$lambda$1(this, updateVisibility));
        Intrinsics.checkNotNullExpressionValue((Object)animation2, (String)"runWhenScheduled(...)");
        return animation2;
    }

    private final Animation createHidingAnimation(double value, Function0<Unit> updateVisibility) {
        Animation animation;
        Animation $this$createHidingAnimation_u24lambda_u240 = animation = new Animation(this.consumer);
        boolean bl = false;
        if (value < 1.0) {
            $this$createHidingAnimation_u24lambda_u240.setDuration(MathKt.roundToInt((double)((double)this.hidingDuration * value)));
            $this$createHidingAnimation_u24lambda_u240.setEasing(this.statefulEasing.coerceIn(0.0, value).reverse());
        } else {
            $this$createHidingAnimation_u24lambda_u240.setDelay(this.hidingDelay);
            $this$createHidingAnimation_u24lambda_u240.setDuration(this.hidingDuration);
            $this$createHidingAnimation_u24lambda_u240.setEasing(this.statefulEasing.reverse());
        }
        return animation.runWhenExpiredOrCancelled(() -> ShowHideAnimator.createHidingAnimation$lambda$1(this, updateVisibility));
    }

    private static final void setVisible$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void setVisible$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void createShowingAnimation$lambda$1(ShowHideAnimator this$0, Function0 $updateVisibility) {
        if (this$0.atomicVisible.get()) {
            $updateVisibility.invoke();
        }
    }

    private static final void createHidingAnimation$lambda$1(ShowHideAnimator this$0, Function0 $updateVisibility) {
        if (!this$0.atomicVisible.get()) {
            $updateVisibility.invoke();
        }
    }
}

