/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.JavaXmlDocumentKt;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.xml.parsers.DocumentBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class ComboBoxWithHistory
extends JComboBox {
    private final String myHistoryId;
    private Project myProject;
    private final HashMap<Object, Long> myWeights;
    private boolean myAutoSave;

    public ComboBoxWithHistory(@Nullable Project project2, String historyId, Object[] items2) {
        this.myWeights = new HashMap();
        this.myAutoSave = true;
        this.myHistoryId = historyId;
        this.myProject = project2;
        this.setModelFrom(items2);
    }

    public ComboBoxWithHistory(@NotNull String historyId, Object[] items2) {
        if (historyId == null) {
            ComboBoxWithHistory.$$$reportNull$$$0(0);
        }
        this(null, historyId, items2);
    }

    public ComboBoxWithHistory(String historyId) {
        this(null, historyId, ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    public void setModelFrom(Object ... items2) {
        this.setModel(new MyModel(items2));
    }

    public boolean isAutoSave() {
        return this.myAutoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.myAutoSave = autoSave;
    }

    public void save() {
        @NonNls StringBuilder buf = new StringBuilder("<map>");
        for (Object key : this.myWeights.keySet()) {
            Long value;
            if (key == null || (value = this.myWeights.get(key)) == null) continue;
            buf.append("<element>").append("<key>").append(key).append("</key>").append("<value>").append(value).append("</value>").append("</element>");
        }
        String xml = buf.append("</map>").toString();
        if (this.myProject == null) {
            PropertiesComponent.getInstance().setValue(this.myHistoryId, xml);
        } else {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(this.myHistoryId, xml);
        }
    }

    public void load() {
        String xml = this.myProject == null ? PropertiesComponent.getInstance().getValue(this.myHistoryId) : PropertiesComponent.getInstance((Project)this.myProject).getValue(this.myHistoryId);
        this.myWeights.clear();
        if (xml == null) {
            return;
        }
        try {
            DocumentBuilder db = JavaXmlDocumentKt.createDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document doc = db.parse(is);
            NodeList nodes = doc.getElementsByTagName("map");
            if (nodes.getLength() == 1) {
                NodeList map2 = nodes.item(0).getChildNodes();
                for (int i2 = 0; i2 < map2.getLength(); ++i2) {
                    Node item = map2.item(i2);
                    NodeList list2 = item.getChildNodes();
                    Element key = (Element)list2.item(0);
                    Element value = (Element)list2.item(1);
                    this.myWeights.put(key.getTextContent(), Long.valueOf(value.getTextContent()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setProject(Project project2) {
        this.myProject = project2;
        this.load();
    }

    private static Object[] sort(Object[] items2, HashMap<Object, Long> weights) {
        Arrays.sort(items2, new LastUsedComparator(weights, Arrays.asList(items2)));
        return items2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyId", "com/intellij/util/ui/ComboBoxWithHistory", "<init>"));
    }

    private final class MyModel
    extends DefaultComboBoxModel {
        private MyModel(Object[] items2) {
            super(ComboBoxWithHistory.sort(items2, ComboBoxWithHistory.this.myWeights));
        }

        @Override
        public void setSelectedItem(Object o) {
            super.setSelectedItem(o);
            if (o != null && ComboBoxWithHistory.this.isAutoSave()) {
                ComboBoxWithHistory.this.myWeights.put(o.toString(), System.currentTimeMillis());
                ComboBoxWithHistory.this.save();
            }
        }
    }

    private static final class LastUsedComparator
    implements Comparator<Object> {
        private final HashMap<Object, Long> myWeights;
        private final List<Object> myInitialPositions;

        private LastUsedComparator(HashMap<Object, Long> weights, List<Object> initialPositions) {
            this.myWeights = weights;
            this.myInitialPositions = initialPositions;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Long w1 = this.myWeights.get(o1);
            Long w2 = this.myWeights.get(o2);
            if (w1 != null || w2 != null) {
                return w1 != null && w2 != null ? LastUsedComparator.sign(w2 - w1) : (w1 != null ? -1 : 1);
            }
            return this.myInitialPositions.indexOf(o1) - this.myInitialPositions.indexOf(o2);
        }

        private static int sign(Long l) {
            return l == 0L ? 0 : (l < 0L ? -1 : 1);
        }
    }
}

