/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.components.breadcrumbs.StickyLineInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.breadcrumbs.BreadcrumbsPresentationProvider;
import com.intellij.xml.breadcrumbs.BreadcrumbsUtilEx;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.PsiCrumb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiFileBreadcrumbsCollector
extends FileBreadcrumbsCollector {
    private static final Logger LOG = Logger.getInstance(PsiFileBreadcrumbsCollector.class);
    private final Project myProject;

    public PsiFileBreadcrumbsCollector(Project project2) {
        this.myProject = project2;
    }

    public boolean handlesFile(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(0);
        }
        return BreadcrumbsUtilEx.findProvider(virtualFile2, this.myProject, true) != null;
    }

    public void watchForChanges(@NotNull VirtualFile file2, @NotNull Editor editor2, @NotNull Disposable disposable, @NotNull Runnable changesHandler) {
        if (file2 == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(3);
        }
        if (changesHandler == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(4);
        }
        PsiFileBreadcrumbsCollector.watchForChanges(this.myProject, file2, disposable, changesHandler);
    }

    @ApiStatus.Internal
    public static void watchForChanges(@NotNull Project myProject, final @NotNull VirtualFile file2, @NotNull Disposable disposable, final @NotNull Runnable changesHandler) {
        if (myProject == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(6);
        }
        if (disposable == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(7);
        }
        if (changesHandler == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(8);
        }
        PomManager.getModel((Project)myProject).addModelListener(new PomModelListener(){

            public void modelChanged(@NotNull PomModelEvent event) {
                VirtualFile changedFile;
                TreeAspect aspect;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((aspect = (TreeAspect)ContainerUtil.findInstance((Iterable)event.getChangedAspects(), TreeAspect.class)) == null) {
                    return;
                }
                TreeChangeEvent change = (TreeChangeEvent)ObjectUtils.tryCast((Object)event.getChangeSet((PomModelAspect)aspect), TreeChangeEvent.class);
                if (change == null) {
                    return;
                }
                PsiFile psiFile = change.getRootElement().getPsi().getContainingFile();
                VirtualFile virtualFile2 = changedFile = psiFile == null ? null : psiFile.getVirtualFile();
                if (!Comparing.equal((Object)changedFile, (Object)file2)) {
                    return;
                }
                changesHandler.run();
            }

            public boolean isAspectChangeInteresting(@NotNull PomModelAspect aspect) {
                if (aspect == null) {
                    1.$$$reportNull$$$0(1);
                }
                return aspect instanceof TreeAspect;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aspect";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xml/breadcrumbs/PsiFileBreadcrumbsCollector$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modelChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isAspectChangeInteresting";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
    }

    @NotNull
    public Iterable<Crumb> computeCrumbs(@NotNull VirtualFile file2, @NotNull Document document2, int offset, Boolean forcedShown) {
        BreadcrumbsProvider defaultInfoProvider;
        Collection<Pair<PsiElement, BreadcrumbsProvider>> pairs;
        if (file2 == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(9);
        }
        if (document2 == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(10);
        }
        if ((pairs = PsiFileBreadcrumbsCollector.getLineElements(document2, offset, file2, this.myProject, defaultInfoProvider = BreadcrumbsUtilEx.findProvider(file2, this.myProject, forcedShown), true)) == null) {
            List<Crumb> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiFileBreadcrumbsCollector.$$$reportNull$$$0(11);
            }
            return list2;
        }
        ArrayList<Crumb> result2 = new ArrayList<Crumb>(pairs.size());
        CrumbPresentation[] presentations = PsiFileBreadcrumbsCollector.getCrumbPresentations(PsiFileBreadcrumbsCollector.toPsiElementArray(pairs));
        int index = 0;
        for (Pair<PsiElement, BreadcrumbsProvider> pair : pairs) {
            CrumbPresentation presentation2 = null;
            if (presentations != null && 0 <= index && index < presentations.length) {
                presentation2 = presentations[index++];
            }
            result2.add((Crumb)new PsiCrumb((PsiElement)pair.first, (BreadcrumbsProvider)pair.second, presentation2));
        }
        ArrayList<Crumb> arrayList = result2;
        if (arrayList == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    @NotNull
    public List<StickyLineInfo> computeStickyLineInfos(@NotNull VirtualFile file2, @NotNull Document document2, int offset) {
        if (file2 == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(13);
        }
        if (document2 == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(14);
        }
        boolean checkSettings = false;
        BreadcrumbsProvider defaultInfoProvider = BreadcrumbsUtilEx.findProvider(file2, this.myProject, true);
        PsiElement element = PsiFileBreadcrumbsCollector.findStartElement(document2, offset, file2, this.myProject, defaultInfoProvider, checkSettings, true);
        if (element == null) {
            List<StickyLineInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiFileBreadcrumbsCollector.$$$reportNull$$$0(15);
            }
            return list2;
        }
        ArrayList<StickyLineInfo> result2 = new ArrayList<StickyLineInfo>();
        while (element != null) {
            BreadcrumbsProvider provider = PsiFileBreadcrumbsCollector.findProviderForElement(element, defaultInfoProvider, checkSettings);
            if (provider != null && provider.acceptStickyElement(element)) {
                result2.add(new StickyLineInfo(element));
            }
            if (!((element = PsiFileBreadcrumbsCollector.getParent(element, provider)) instanceof PsiDirectory)) continue;
            break;
        }
        ArrayList<StickyLineInfo> arrayList = result2;
        if (arrayList == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private static CrumbPresentation @Nullable [] getCrumbPresentations(PsiElement[] elements) {
        for (BreadcrumbsPresentationProvider provider : BreadcrumbsPresentationProvider.EP_NAME.getExtensionList()) {
            CrumbPresentation[] presentations = provider.getCrumbPresentations(elements);
            if (presentations == null) continue;
            return presentations;
        }
        return null;
    }

    @Nullable
    private static Collection<Pair<PsiElement, BreadcrumbsProvider>> getLineElements(Document document2, int offset, VirtualFile file2, Project project2, BreadcrumbsProvider defaultInfoProvider, boolean checkSettings) {
        PsiElement element = PsiFileBreadcrumbsCollector.findStartElement(document2, offset, file2, project2, defaultInfoProvider, checkSettings, false);
        if (element == null) {
            return null;
        }
        LinkedList<Pair<PsiElement, BreadcrumbsProvider>> result2 = new LinkedList<Pair<PsiElement, BreadcrumbsProvider>>();
        while (element != null) {
            BreadcrumbsProvider provider = PsiFileBreadcrumbsCollector.findProviderForElement(element, defaultInfoProvider, checkSettings);
            if (provider != null && provider.acceptElement(element)) {
                result2.addFirst((Pair<PsiElement, BreadcrumbsProvider>)Pair.create((Object)element, (Object)provider));
            }
            if (!((element = PsiFileBreadcrumbsCollector.getParent(element, provider)) instanceof PsiDirectory)) continue;
            break;
        }
        return result2;
    }

    @Nullable
    private static PsiElement findStartElement(Document document2, int offset, VirtualFile file2, Project project2, BreadcrumbsProvider defaultInfoProvider, boolean checkSettings, boolean isSticky) {
        PsiElement middleElement = PsiFileBreadcrumbsCollector.findFirstBreadcrumbedElement(offset, file2, project2, defaultInfoProvider, checkSettings, isSticky);
        CharSequence chars = document2.getCharsSequence();
        int leftOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)"\t ");
        leftOffset = leftOffset >= 0 ? leftOffset : offset - 1;
        PsiElement leftElement = PsiFileBreadcrumbsCollector.findFirstBreadcrumbedElement(leftOffset, file2, project2, defaultInfoProvider, checkSettings, isSticky);
        if (leftElement != null && (middleElement == null || PsiTreeUtil.isAncestor((PsiElement)middleElement, (PsiElement)leftElement, (boolean)true))) {
            return leftElement;
        }
        return middleElement;
    }

    @Nullable
    private static PsiElement findFirstBreadcrumbedElement(int offset, VirtualFile file2, Project project2, BreadcrumbsProvider defaultInfoProvider, boolean checkSettings, boolean isSticky) {
        if (file2 == null || !file2.isValid() || file2.isDirectory()) {
            return null;
        }
        PriorityQueue leafs = new PriorityQueue(3, (o1, o2) -> {
            TextRange range1 = o1.getTextRange();
            if (range1 == null) {
                LOG.error(String.valueOf(o1) + " returned null range");
                return 1;
            }
            TextRange range2 = o2.getTextRange();
            if (range2 == null) {
                LOG.error(String.valueOf(o2) + " returned null range");
                return -1;
            }
            return range2.getStartOffset() - range1.getStartOffset();
        });
        FileViewProvider viewProvider = BreadcrumbsUtilEx.findViewProvider(file2, project2);
        if (viewProvider == null) {
            return null;
        }
        for (Language language : viewProvider.getLanguages()) {
            ContainerUtil.addIfNotNull(leafs, (Object)viewProvider.findElementAt(offset, language));
        }
        while (!leafs.isEmpty()) {
            PsiElement element = (PsiElement)leafs.remove();
            BreadcrumbsProvider provider = PsiFileBreadcrumbsCollector.findProviderForElement(element, defaultInfoProvider, checkSettings);
            if (provider != null) {
                boolean accept2;
                boolean bl = accept2 = isSticky ? provider.acceptStickyElement(element) : provider.acceptElement(element);
                if (accept2) {
                    return element;
                }
            }
            if (element instanceof PsiFile) continue;
            ContainerUtil.addIfNotNull(leafs, (Object)PsiFileBreadcrumbsCollector.getParent(element, provider));
        }
        return null;
    }

    @Nullable
    private static PsiElement getParent(@NotNull PsiElement element, @Nullable BreadcrumbsProvider provider) {
        if (element == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(17);
        }
        return provider != null ? provider.getParent(element) : element.getParent();
    }

    @Nullable
    private static BreadcrumbsProvider findProviderForElement(@NotNull PsiElement element, BreadcrumbsProvider defaultProvider, boolean checkSettings) {
        if (element == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(18);
        }
        Language language = element.getLanguage();
        if (checkSettings && !BreadcrumbsUtilEx.isBreadcrumbsShownFor(language)) {
            return defaultProvider;
        }
        BreadcrumbsProvider provider = BreadcrumbsUtil.getInfoProvider((Language)language);
        return provider == null ? defaultProvider : provider;
    }

    private static PsiElement[] toPsiElementArray(Collection<? extends Pair<PsiElement, BreadcrumbsProvider>> pairs) {
        PsiElement[] elements = new PsiElement[pairs.size()];
        int index = 0;
        for (Pair<PsiElement, BreadcrumbsProvider> pair : pairs) {
            elements[index++] = (PsiElement)pair.first;
        }
        return elements;
    }

    public static PsiElement @Nullable [] getLinePsiElements(Document document2, int offset, VirtualFile file2, Project project2, BreadcrumbsProvider infoProvider) {
        Collection<Pair<PsiElement, BreadcrumbsProvider>> pairs = PsiFileBreadcrumbsCollector.getLineElements(document2, offset, file2, project2, infoProvider, false);
        return pairs == null ? null : PsiFileBreadcrumbsCollector.toPsiElementArray(pairs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myProject";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/breadcrumbs/PsiFileBreadcrumbsCollector";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/breadcrumbs/PsiFileBreadcrumbsCollector";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCrumbs";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeStickyLineInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handlesFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "watchForChanges";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeCrumbs";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeStickyLineInfos";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findProviderForElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 15, 16 -> new IllegalStateException(string);
        };
    }
}

