/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PathsList {
    private final List<String> myPath = new ArrayList<String>();
    private final List<String> myPathTail = new ArrayList<String>();
    private final Set<String> myPathSet = new HashSet<String>();
    private static final Function<String, VirtualFile> PATH_TO_LOCAL_VFILE = path -> StandardFileSystems.local().findFileByPath(path.replace(File.separatorChar, '/'));
    private static final Function<VirtualFile, String> LOCAL_PATH = file -> PathUtil.getLocalPath(file);
    private static final Function<String, VirtualFile> PATH_TO_DIR = s -> {
        VirtualFile file = (VirtualFile)((Object)((Object)PATH_TO_LOCAL_VFILE.fun(s)));
        if (file == null) {
            return null;
        }
        if (!file.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence()) == ArchiveFileType.INSTANCE) {
            return StandardFileSystems.jar().findFileByPath(file.getPath() + "!/");
        }
        return file;
    };

    public boolean isEmpty() {
        return this.myPathSet.isEmpty();
    }

    public void add(@Nullable String path) {
        this.addAllLast(this.chooseFirstTimeItems(path), this.myPath);
    }

    public void remove(@NotNull VirtualFile file) {
        if (file == null) {
            PathsList.$$$reportNull$$$0(0);
        }
        String path = (String)LOCAL_PATH.fun((Object)file);
        this.remove(path);
    }

    public void remove(@NotNull String path) {
        if (path == null) {
            PathsList.$$$reportNull$$$0(1);
        }
        this.myPath.remove(path);
        this.myPathTail.remove(path);
        this.myPathSet.remove(path);
    }

    public void clear() {
        this.myPath.clear();
        this.myPathTail.clear();
        this.myPathSet.clear();
    }

    public void add(VirtualFile file) {
        String trimmed;
        String path = (String)LOCAL_PATH.fun((Object)file);
        String string = trimmed = path != null ? path.trim() : "";
        if (!trimmed.isEmpty() && this.myPathSet.add(trimmed)) {
            this.myPath.add(trimmed);
        }
    }

    public void addFirst(String path) {
        int index = 0;
        for (String element : this.chooseFirstTimeItems(path)) {
            this.myPath.add(index, element);
            this.myPathSet.add(element);
            ++index;
        }
    }

    public void addTail(String path) {
        this.addAllLast(this.chooseFirstTimeItems(path), this.myPathTail);
    }

    @NotNull
    private Iterable<String> chooseFirstTimeItems(@Nullable String path) {
        if (path == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PathsList.$$$reportNull$$$0(2);
            }
            return list;
        }
        JBIterable jBIterable = JBIterable.from((Iterable)StringUtil.tokenize((String)path, (String)File.pathSeparator)).filter(element -> !(element = element.trim()).isEmpty() && !this.myPathSet.contains(element));
        if (jBIterable == null) {
            PathsList.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    private void addAllLast(Iterable<String> elements, List<? super String> toArray) {
        for (String element : elements) {
            toArray.add(element);
            this.myPathSet.add(element);
        }
    }

    @NotNull
    public String getPathsString() {
        String string = StringUtil.join(this.getPathList(), (String)File.pathSeparator);
        if (string == null) {
            PathsList.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public @Unmodifiable List<String> getPathList() {
        List list = ContainerUtil.concat(this.myPath, this.myPathTail);
        if (list == null) {
            PathsList.$$$reportNull$$$0(5);
        }
        return list;
    }

    public @Unmodifiable List<VirtualFile> getVirtualFiles() {
        return JBIterable.from(this.getPathList()).filterMap(PATH_TO_LOCAL_VFILE).toList();
    }

    public @Unmodifiable List<VirtualFile> getRootDirs() {
        return JBIterable.from(this.getPathList()).filterMap(PATH_TO_DIR).toList();
    }

    public void addAll(List<String> allClasspath) {
        for (String path : allClasspath) {
            this.add(path);
        }
    }

    public void addAllFiles(File[] files) {
        this.addAllFiles(Arrays.asList(files));
    }

    public void addAllFiles(List<? extends File> files) {
        for (File file : files) {
            this.add(file);
        }
    }

    public void add(File file) {
        this.add(FileUtil.toCanonicalPath((String)file.getAbsolutePath()).replace('/', File.separatorChar));
    }

    public void addFirst(File file) {
        this.addFirst(FileUtil.toCanonicalPath((String)file.getAbsolutePath()).replace('/', File.separatorChar));
    }

    public void addVirtualFiles(Collection<? extends VirtualFile> files) {
        for (VirtualFile virtualFile : files) {
            this.add(virtualFile);
        }
    }

    public void addVirtualFiles(VirtualFile[] files) {
        this.addVirtualFiles(Arrays.asList(files));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PathsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PathsList";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseFirstTimeItems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

