/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.RuntimeFlagsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.BusState;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.LazyListenerKt;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageBusEx;
import com.intellij.util.messages.impl.MessageBusImplKt;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import com.intellij.util.messages.impl.MessagePublisher;
import com.intellij.util.messages.impl.MessageQueue;
import com.intellij.util.messages.impl.PluginListenerDescriptor;
import com.intellij.util.messages.impl.RootBus;
import com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl;
import com.intellij.util.messages.impl.ToParentMessagePublisher;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 o2\u00020\u00012\u00020\u0002:\u0002noB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\tJ\n\u0010$\u001a\u00020\fH\u0096\u0080\u0004J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0017J \u0010*\u001a\u00020(2\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0010J\u001c\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100J\u0010\u0010%\u001a\u00020&2\u0006\u00102\u001a\u00020\u001dH\u0016J\b\u00103\u001a\u000204H\u0016J\u0010\u0010%\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J%\u00107\u001a\u0002H8\"\b\b\u0000\u00108*\u00020\u00122\f\u00109\u001a\b\u0012\u0004\u0012\u0002H80\u0011H\u0016\u00a2\u0006\u0002\u0010:J%\u0010;\u001a\u0002H8\"\b\b\u0000\u00108*\u00020\u00122\f\u00109\u001a\b\u0012\u0004\u0012\u0002H80\u0011H\u0016\u00a2\u0006\u0002\u0010:J/\u0010<\u001a\b\u0012\u0004\u0012\u0002H80=\"\u0004\b\u0000\u001082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H80\u00112\u0006\u0010>\u001a\u00020?H\u0010\u00a2\u0006\u0002\b@J\u0006\u0010A\u001a\u00020(J\u0006\u0010B\u001a\u00020(J\b\u0010C\u001a\u00020(H\u0016J\r\u0010D\u001a\u00020(H\u0010\u00a2\u0006\u0002\bEJ\u0014\u0010I\u001a\u00020G2\n\u00109\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\r\u0010J\u001a\u00020(H\u0000\u00a2\u0006\u0002\bKJ\b\u0010L\u001a\u00020(H\u0002J\b\u0010M\u001a\u00020(H\u0002J1\u0010N\u001a\u00020(2\n\u00109\u001a\u0006\u0012\u0002\b\u00030\u00112\u000e\u0010O\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00120\r2\u0006\u0010P\u001a\u00020GH\u0010\u00a2\u0006\u0002\bQJ#\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00172\n\u00109\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0010\u00a2\u0006\u0004\bS\u0010TJ\r\u0010U\u001a\u00020GH\u0010\u00a2\u0006\u0002\bVJ\u0019\u0010W\u001a\u00020(2\n\u00109\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0000\u00a2\u0006\u0002\bXJ\u0019\u0010Y\u001a\u00020(2\n\u00109\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0010\u00a2\u0006\u0002\bZJ\b\u0010[\u001a\u00020(H\u0016J\u001d\u0010\\\u001a\u00020G2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0010\u00a2\u0006\u0004\b^\u0010_J\u001d\u0010`\u001a\u00020(2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0010\u00a2\u0006\u0004\ba\u0010bJ\u0015\u0010c\u001a\u00020(2\u0006\u0010d\u001a\u00020eH\u0000\u00a2\u0006\u0002\bfJ\u000e\u0010g\u001a\u00020(2\u0006\u0010h\u001a\u00020 J\u000e\u0010i\u001a\u00020(2\u0006\u0010h\u001a\u00020 J\u001a\u0010j\u001a\u00020(2\u0010\u0010k\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030m0lH\u0016R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u00108\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0016\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00170\u00108\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00198\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010F\u001a\u00020G8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010H\u00a8\u0006p"}, d2={"Lcom/intellij/util/messages/impl/MessageBusImpl;", "Lcom/intellij/util/messages/MessageBus;", "Lcom/intellij/util/messages/impl/MessageBusEx;", "owner", "Lcom/intellij/util/messages/MessageBusOwner;", "parentBus", "Lcom/intellij/util/messages/impl/CompositeMessageBus;", "<init>", "(Lcom/intellij/util/messages/MessageBusOwner;Lcom/intellij/util/messages/impl/CompositeMessageBus;)V", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "topicClassToListenerDescriptor", "", "", "", "Lcom/intellij/util/messages/impl/PluginListenerDescriptor;", "publisherCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/util/messages/Topic;", "", "subscribers", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/util/messages/impl/MessageBusImpl$MessageHandlerHolder;", "subscriberCache", "", "rootBus", "Lcom/intellij/util/messages/impl/RootBus;", "disposeState", "Lcom/intellij/util/messages/impl/BusState;", "connectionDisposable", "Lcom/intellij/openapi/Disposable;", "messageDeliveryListeners", "", "Lcom/intellij/util/messages/impl/MessageDeliveryListener;", "parent", "getParent", "()Lcom/intellij/util/messages/MessageBus;", "toString", "connect", "Lcom/intellij/util/messages/MessageBusConnection;", "clearPublisherCache", "", "clearAllSubscriberCache", "setLazyListeners", "map", "unsubscribeLazyListeners", "module", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "listenerDescriptors", "", "Lcom/intellij/util/messages/ListenerDescriptor;", "parentDisposable", "simpleConnect", "Lcom/intellij/util/messages/SimpleMessageBusConnection;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "syncPublisher", "L", "topic", "(Lcom/intellij/util/messages/Topic;)Ljava/lang/Object;", "syncAndPreloadPublisher", "createPublisher", "Lcom/intellij/util/messages/impl/MessagePublisher;", "direction", "Lcom/intellij/util/messages/Topic$BroadcastDirection;", "createPublisher$intellij_platform_core", "disposeConnectionChildren", "disposeConnection", "dispose", "disposeChildren", "disposeChildren$intellij_platform_core", "isDisposed", "", "()Z", "hasUndeliveredEvents", "checkDisposed", "checkDisposed$intellij_platform_core", "checkBusDisposed", "checkOwnerDisposed", "doComputeSubscribers", "result", "subscribeLazyListeners", "doComputeSubscribers$intellij_platform_core", "computeSubscribers", "computeSubscribers$intellij_platform_core", "(Lcom/intellij/util/messages/Topic;)[Ljava/lang/Object;", "hasChildren", "hasChildren$intellij_platform_core", "notifyOnSubscription", "notifyOnSubscription$intellij_platform_core", "notifyOnSubscriptionToTopicToChildren", "notifyOnSubscriptionToTopicToChildren$intellij_platform_core", "removeEmptyConnectionsRecursively", "notifyConnectionTerminated", "topicAndHandlerPairs", "notifyConnectionTerminated$intellij_platform_core", "([Ljava/lang/Object;)Z", "clearSubscriberCache", "clearSubscriberCache$intellij_platform_core", "([Ljava/lang/Object;)V", "deliverImmediately", "connection", "Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;", "deliverImmediately$intellij_platform_core", "addMessageDeliveryListener", "listener", "removeMessageDeliveryListener", "disconnectPluginConnections", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "MessageHandlerHolder", "Companion", "intellij.platform.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMessageBusImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageBusImpl.kt\ncom/intellij/util/messages/impl/MessageBusImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,853:1\n1807#2,3:854\n37#3,2:857\n1#4:859\n13#5:860\n*S KotlinDebug\n*F\n+ 1 MessageBusImpl.kt\ncom/intellij/util/messages/impl/MessageBusImpl\n*L\n256#1:854,3\n309#1:857,2\n108#1:860\n*E\n"})
public class MessageBusImpl
implements MessageBus,
MessageBusEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile Map<String, List<PluginListenerDescriptor>> topicClassToListenerDescriptor;
    @JvmField
    @NotNull
    public final ConcurrentMap<Topic<?>, Object> publisherCache;
    @JvmField
    @NotNull
    public final ConcurrentLinkedQueue<MessageHandlerHolder> subscribers;
    @JvmField
    @NotNull
    public final ConcurrentMap<Topic<?>, Object[]> subscriberCache;
    @JvmField
    @Nullable
    public final CompositeMessageBus parentBus;
    @JvmField
    @NotNull
    public final RootBus rootBus;
    @JvmField
    @NotNull
    public final MessageBusOwner owner;
    @NotNull
    private BusState disposeState;
    @Nullable
    private Disposable connectionDisposable;
    @JvmField
    @NotNull
    public Set<MessageDeliveryListener> messageDeliveryListeners;
    @JvmField
    @NotNull
    public static final Logger LOG;

    public MessageBusImpl(@NotNull MessageBusOwner owner, @NotNull CompositeMessageBus parentBus) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)parentBus, (String)"parentBus");
        this.topicClassToListenerDescriptor = MessageBusImplKt.access$getEMPTY_MAP$p();
        this.publisherCache = new ConcurrentHashMap();
        this.subscribers = new ConcurrentLinkedQueue();
        this.subscriberCache = new ConcurrentHashMap();
        this.disposeState = BusState.Alive.INSTANCE;
        this.connectionDisposable = Disposer.newDisposable();
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.messageDeliveryListeners = keySetView;
        this.owner = owner;
        this.parentBus = parentBus;
        this.rootBus = parentBus.rootBus;
        parentBus.addChild(this);
    }

    public MessageBusImpl(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.topicClassToListenerDescriptor = MessageBusImplKt.access$getEMPTY_MAP$p();
        this.publisherCache = new ConcurrentHashMap();
        this.subscribers = new ConcurrentLinkedQueue();
        this.subscriberCache = new ConcurrentHashMap();
        this.disposeState = BusState.Alive.INSTANCE;
        this.connectionDisposable = Disposer.newDisposable();
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.messageDeliveryListeners = keySetView;
        this.owner = owner;
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.intellij.util.messages.impl.RootBus");
        this.rootBus = (RootBus)this;
        this.parentBus = null;
    }

    @Nullable
    public MessageBus getParent() {
        return this.parentBus;
    }

    @NotNull
    public String toString() {
        return "MessageBus(owner=" + this.owner + ", disposeState= " + this.disposeState + ')';
    }

    @NotNull
    public MessageBusConnection connect() {
        Disposable disposable = this.connectionDisposable;
        Intrinsics.checkNotNull((Object)disposable);
        return this.connect(disposable);
    }

    @Override
    public void clearPublisherCache() {
        this.publisherCache.clear();
    }

    @Override
    @TestOnly
    public void clearAllSubscriberCache() {
        LOG.assertTrue(this.rootBus != this);
        this.rootBus.subscriberCache.clear();
        this.subscriberCache.clear();
    }

    @Override
    public final void setLazyListeners(@NotNull ConcurrentMap<String, List<PluginListenerDescriptor>> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Map<String, List<PluginListenerDescriptor>> topicClassToListenerDescriptor = this.topicClassToListenerDescriptor;
        if (topicClassToListenerDescriptor == MessageBusImplKt.access$getEMPTY_MAP$p()) {
            this.topicClassToListenerDescriptor = map2;
        } else {
            for (Map.Entry entry : ((Map)map2).entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                Intrinsics.checkNotNull((Object)value);
                topicClassToListenerDescriptor.computeIfAbsent(key, arg_0 -> MessageBusImpl.setLazyListeners$lambda$1(MessageBusImpl::setLazyListeners$lambda$0, arg_0)).addAll(value);
            }
            if (this.rootBus != this) {
                this.rootBus.subscriberCache.clear();
            }
            this.subscriberCache.clear();
        }
    }

    @Override
    public final void unsubscribeLazyListeners(@NotNull IdeaPluginDescriptor module, @NotNull List<ListenerDescriptor> listenerDescriptors) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(listenerDescriptors, (String)"listenerDescriptors");
        boolean isChanged = LazyListenerKt.unsubscribeLazyListeners(module, listenerDescriptors, this.topicClassToListenerDescriptor, this.subscribers);
        if (isChanged) {
            if (this.rootBus != this) {
                this.rootBus.subscriberCache.clear();
            }
            this.subscriberCache.clear();
        }
    }

    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.checkDisposed$intellij_platform_core();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)connection));
        return connection;
    }

    @NotNull
    public SimpleMessageBusConnection simpleConnect() {
        this.checkDisposed$intellij_platform_core();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SimpleMessageBusConnection connect(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Job scopeJob = JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext());
        JobKt.ensureActive((Job)scopeJob);
        this.checkDisposed$intellij_platform_core();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        try {
            this.subscribers.add(connection);
        }
        finally {
            scopeJob.invokeOnCompletion(arg_0 -> MessageBusImpl.connect$lambda$0(connection, arg_0));
        }
        return connection;
    }

    @NotNull
    public <L> L syncPublisher(@NotNull Topic<L> topic) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        this.checkDisposed$intellij_platform_core();
        Object object = this.publisherCache.computeIfAbsent(topic, arg_0 -> MessageBusImpl.syncPublisher$lambda$1(arg_0 -> MessageBusImpl.syncPublisher$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type L of com.intellij.util.messages.impl.MessageBusImpl.syncPublisher");
        return (L)object;
    }

    @NotNull
    public <L> L syncAndPreloadPublisher(@NotNull Topic<L> topic) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        L publisher = this.syncPublisher(topic);
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(publisher);
        Intrinsics.checkNotNull((Object)invocationHandler, (String)"null cannot be cast to non-null type com.intellij.util.messages.impl.MessagePublisher<*>");
        ((MessagePublisher)invocationHandler).preload();
        return publisher;
    }

    @NotNull
    public <L> MessagePublisher<L> createPublisher$intellij_platform_core(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return direction == Topic.BroadcastDirection.TO_PARENT ? (MessagePublisher)new ToParentMessagePublisher<L>(topic, this) : new MessagePublisher(topic, this);
    }

    public final void disposeConnectionChildren() {
        this.disposeState = BusState.Disposing.INSTANCE;
        Disposable disposable = this.connectionDisposable;
        Intrinsics.checkNotNull((Object)disposable);
        Disposer.disposeChildren((Disposable)disposable, arg_0 -> MessageBusImpl.disposeConnectionChildren$lambda$1(MessageBusImpl::disposeConnectionChildren$lambda$0, arg_0));
    }

    public final void disposeConnection() {
        Disposable disposable = this.connectionDisposable;
        Intrinsics.checkNotNull((Object)disposable);
        Disposer.dispose((Disposable)disposable);
        this.connectionDisposable = null;
    }

    public void dispose() {
        block1: {
            this.checkBusDisposed();
            this.disposeState = new BusState.Disposed(new Throwable());
            this.disposeChildren$intellij_platform_core();
            Disposable disposable = this.connectionDisposable;
            if (disposable != null) {
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this.rootBus.getQueue$intellij_platform_core().queue.removeIf(arg_0 -> MessageBusImpl.dispose$lambda$2(arg_0 -> MessageBusImpl.dispose$lambda$1(this, arg_0), arg_0));
            CompositeMessageBus compositeMessageBus = this.parentBus;
            if (compositeMessageBus == null) break block1;
            compositeMessageBus.onChildBusDisposed$intellij_platform_core(this);
        }
    }

    public void disposeChildren$intellij_platform_core() {
    }

    public boolean isDisposed() {
        return this.disposeState instanceof BusState.Disposed || this.owner.isDisposed();
    }

    public boolean hasUndeliveredEvents(@NotNull Topic<?> topic) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(topic, (String)"topic");
            if (this.isDisposed()) {
                return false;
            }
            MessageQueue queue = this.rootBus.getQueue$intellij_platform_core();
            Message current = queue.current;
            if (current != null && current.topic == topic && current.bus == this) {
                return true;
            }
            Iterable $this$any$iv = queue.queue;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Message it = (Message)element$iv;
                    boolean bl2 = false;
                    if (!(it.topic == topic && it.bus == this)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void checkDisposed$intellij_platform_core() {
        this.checkBusDisposed();
        this.checkOwnerDisposed();
    }

    private final void checkBusDisposed() {
        BusState state = this.disposeState;
        if (state instanceof BusState.Disposed) {
            if (RuntimeFlagsKt.isMessageBusThrowsWhenDisposed()) {
                Throwable throwable = new AlreadyDisposedException(this.toString()).initCause(((BusState.Disposed)state).where);
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"initCause(...)");
                throw throwable;
            }
            LOG.error("Already disposed: " + this, ((BusState.Disposed)state).where);
        }
    }

    private final void checkOwnerDisposed() {
        if (this.owner.isDisposed()) {
            if (RuntimeFlagsKt.isMessageBusThrowsWhenDisposed()) {
                throw new AlreadyDisposedException(this.toString());
            }
            LOG.error("Already disposed: " + this);
        }
    }

    public void doComputeSubscribers$intellij_platform_core(@NotNull Topic<?> topic, @NotNull List<? super Object> result, boolean subscribeLazyListeners) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        if (subscribeLazyListeners && this.topicClassToListenerDescriptor != MessageBusImplKt.access$getEMPTY_MAP$p() && topic.getListenerClass() != Runnable.class) {
            LazyListenerKt.subscribeLazyListeners(topic, this.topicClassToListenerDescriptor, this.subscribers, this.owner);
        }
        Iterator<MessageHandlerHolder> iterator = this.subscribers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<MessageHandlerHolder> iterator2 = iterator;
        while (iterator2.hasNext()) {
            MessageHandlerHolder subscriber = iterator2.next();
            if (subscriber.isDisposed()) continue;
            subscriber.collectHandlers(topic, result);
        }
    }

    @NotNull
    public Object[] computeSubscribers$intellij_platform_core(@NotNull Topic<?> topic) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        List result = new ArrayList();
        this.doComputeSubscribers$intellij_platform_core(topic, result, true);
        if (result.isEmpty()) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        } else {
            Collection $this$toTypedArray$iv = result;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Object[0]);
        }
        return objectArray;
    }

    public boolean hasChildren$intellij_platform_core() {
        return false;
    }

    public final void notifyOnSubscription$intellij_platform_core(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        this.subscriberCache.remove(topic);
        if (topic.getBroadcastDirection() != Topic.BroadcastDirection.TO_CHILDREN) {
            return;
        }
        MessageBusImpl parentBus = this;
        while (true) {
            CompositeMessageBus compositeMessageBus = parentBus.parentBus;
            if (compositeMessageBus == null) {
                break;
            }
            parentBus = compositeMessageBus;
            parentBus.subscriberCache.remove(topic);
        }
        if (this.hasChildren$intellij_platform_core()) {
            this.notifyOnSubscriptionToTopicToChildren$intellij_platform_core(topic);
        }
    }

    public void notifyOnSubscriptionToTopicToChildren$intellij_platform_core(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
    }

    public void removeEmptyConnectionsRecursively() {
        this.subscribers.removeIf(arg_0 -> MessageBusImpl.removeEmptyConnectionsRecursively$lambda$1(MessageBusImpl::removeEmptyConnectionsRecursively$lambda$0, arg_0));
    }

    public boolean notifyConnectionTerminated$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter((Object)topicAndHandlerPairs, (String)"topicAndHandlerPairs");
        if (!Intrinsics.areEqual((Object)this.disposeState, (Object)BusState.Alive.INSTANCE)) {
            return false;
        }
        this.rootBus.scheduleEmptyConnectionRemoving();
        return MessageBusImplKt.access$clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, this);
    }

    public void clearSubscriberCache$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter((Object)topicAndHandlerPairs, (String)"topicAndHandlerPairs");
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            Map map2 = this.subscriberCache;
            Object object = topicAndHandlerPairs[i];
            TypeIntrinsics.asMutableMap((Object)map2).remove(object);
        }
    }

    public final void deliverImmediately$intellij_platform_core(@NotNull MessageBusConnectionImpl connection) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            this.checkBusDisposed();
            if (this.owner.isDisposed()) {
                return;
            }
            MessageQueue queue = this.rootBus.getQueue$intellij_platform_core();
            ArrayDeque<Message> jobs = queue.queue;
            if (jobs.isEmpty()) {
                return;
            }
            List list = MessageBusImplKt.access$deliverImmediately(connection, jobs);
            if (list == null) {
                return;
            }
            List newJobs = list;
            int n = ((Collection)newJobs).size() + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    jobs.addFirst((Message)newJobs.get(i));
                } while (0 <= n);
            }
            Throwable error = null;
            for (Message job : newJobs) {
                jobs.removeFirstOccurrence(job);
                error = MessageBusImplKt.access$deliverMessage(job, queue, error);
            }
            Throwable throwable = error;
            if (throwable == null) break block6;
            Throwable p0 = throwable;
            boolean bl = false;
            MessageBusImplKt.throwError(p0);
        }
    }

    public final void addMessageDeliveryListener(@NotNull MessageDeliveryListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.messageDeliveryListeners.add(listener);
    }

    public final void removeMessageDeliveryListener(@NotNull MessageDeliveryListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.messageDeliveryListeners.remove(listener);
    }

    @Override
    public void disconnectPluginConnections(@NotNull Predicate<Class<?>> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Iterator<MessageHandlerHolder> iterator = this.subscribers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<MessageHandlerHolder> iterator2 = iterator;
        while (iterator2.hasNext()) {
            MessageHandlerHolder holder = iterator2.next();
            holder.disconnectIfNeeded(predicate);
        }
        this.subscriberCache.clear();
    }

    private static final List setLazyListeners$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List setLazyListeners$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Unit connect$lambda$0(SimpleMessageBusConnectionImpl $connection, Throwable it) {
        $connection.disconnect();
        return Unit.INSTANCE;
    }

    private static final Object syncPublisher$lambda$0(MessageBusImpl this$0, Topic topic1) {
        Class clazz = topic1.getListenerClass();
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getListenerClass(...)");
        Class aClass = clazz;
        Intrinsics.checkNotNull((Object)topic1);
        Topic.BroadcastDirection broadcastDirection = topic1.getBroadcastDirection();
        Intrinsics.checkNotNullExpressionValue((Object)broadcastDirection, (String)"getBroadcastDirection(...)");
        MessagePublisher publisher = this$0.createPublisher$intellij_platform_core(topic1, broadcastDirection);
        Class[] classArray = new Class[]{aClass};
        return Proxy.newProxyInstance(aClass.getClassLoader(), classArray, (InvocationHandler)publisher);
    }

    private static final Object syncPublisher$lambda$1(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final boolean disposeConnectionChildren$lambda$0(Disposable it) {
        return true;
    }

    private static final boolean disposeConnectionChildren$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean dispose$lambda$1(MessageBusImpl this$0, Message it) {
        return it.bus == this$0;
    }

    private static final boolean dispose$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeEmptyConnectionsRecursively$lambda$0(MessageHandlerHolder it) {
        return it.isDisposed();
    }

    private static final boolean removeEmptyConnectionsRecursively$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MessageBusImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/messages/impl/MessageBusImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00010\nH&J\u001a\u0010\u000b\u001a\u00020\u00062\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/messages/impl/MessageBusImpl$MessageHandlerHolder;", "", "isDisposed", "", "()Z", "collectHandlers", "", "topic", "Lcom/intellij/util/messages/Topic;", "result", "", "disconnectIfNeeded", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "intellij.platform.core"})
    public static interface MessageHandlerHolder {
        public boolean isDisposed();

        public void collectHandlers(@NotNull Topic<?> var1, @NotNull List<? super Object> var2);

        public void disconnectIfNeeded(@NotNull Predicate<Class<?>> var1);
    }
}

