/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.execution.filters.ExceptionLineRefiner;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;

public class ArithmeticExceptionInfo
extends ExceptionInfo {
    ArithmeticExceptionInfo(int offset, String message) {
        super(offset, "java.lang.ArithmeticException", message);
    }

    @Override
    ExceptionLineRefiner.RefinerMatchResult matchSpecificExceptionElement(@NotNull PsiElement current) {
        PsiElement nextElement;
        if (current == null) {
            ArithmeticExceptionInfo.$$$reportNull$$$0(0);
        }
        if ((nextElement = PsiTreeUtil.nextVisibleLeaf((PsiElement)current)) == null) {
            return null;
        }
        if (nextElement instanceof PsiJavaToken && (nextElement.textMatches((CharSequence)"%") || nextElement.textMatches((CharSequence)"/")) && nextElement.getParent() instanceof PsiPolyadicExpression) {
            PsiExpression prevOperand = (PsiExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)nextElement, PsiExpression.class);
            PsiExpression nextOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextElement, PsiExpression.class)));
            if (prevOperand != null && TypeConversionUtil.isIntegralNumberType((PsiType)prevOperand.getType()) && nextOperand != null && TypeConversionUtil.isIntegralNumberType((PsiType)nextOperand.getType())) {
                Object value;
                if (!PsiTreeUtil.isAncestor((PsiElement)prevOperand, (PsiElement)current, (boolean)false)) {
                    return null;
                }
                while (nextOperand instanceof PsiUnaryExpression && ((PsiUnaryExpression)nextOperand).getOperationTokenType().equals(JavaTokenType.MINUS)) {
                    nextOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiUnaryExpression)nextOperand).getOperand());
                }
                if (nextOperand instanceof PsiLiteral && (value = ((PsiLiteral)nextOperand).getValue()) instanceof Number && ((Number)value).longValue() != 0L) {
                    return null;
                }
                if (nextOperand == null) {
                    return null;
                }
                return ArithmeticExceptionInfo.onTheSameLineFor(current, (PsiElement)nextOperand, true);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/execution/filters/ArithmeticExceptionInfo", "matchSpecificExceptionElement"));
    }
}

