/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionLineParser;
import com.intellij.execution.filters.ExceptionLineParserFactory;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionWorker {
    @NonNls
    private static final String AT = "at";
    private static final String AT_PREFIX = "at ";
    private static final String STANDALONE_AT = " at ";
    private final ExceptionLineParser myParser;

    public ExceptionWorker(@NotNull ExceptionInfoCache cache) {
        if (cache == null) {
            ExceptionWorker.$$$reportNull$$$0(0);
        }
        this.myParser = ExceptionLineParserFactory.getInstance().create(cache);
    }

    public Filter.Result execute(@NotNull String line, int textEndOffset) {
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(1);
        }
        return this.myParser.execute(line, textEndOffset);
    }

    private static int getLineNumber(@NotNull String lineString) {
        if (lineString == null) {
            ExceptionWorker.$$$reportNull$$$0(2);
        }
        if (lineString.isEmpty() || lineString.length() > 9 || !Character.isDigit(lineString.charAt(0))) {
            return -1;
        }
        try {
            return Integer.parseInt(lineString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public Filter.Result getResult() {
        return this.myParser.getResult();
    }

    public String getMethod() {
        return this.myParser.getMethod();
    }

    public PsiFile getFile() {
        return this.myParser.getFile();
    }

    public ParsedLine getInfo() {
        return this.myParser.getInfo();
    }

    private static int findAtPrefix(@NotNull String line) {
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(3);
        }
        if (line.startsWith(AT_PREFIX)) {
            return 0;
        }
        int startIdx = line.indexOf(STANDALONE_AT);
        return startIdx < 0 ? line.indexOf(AT_PREFIX) : startIdx;
    }

    private static int findRParenAfterLocation(@NotNull String line, int startIdx) {
        int singleRParen;
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(4);
        }
        int next = singleRParen = line.indexOf(41, startIdx);
        while (next > -1) {
            if (next >= 1 && Character.isDigit(line.charAt(next - 1))) {
                return next;
            }
            if ((next = line.indexOf(41, next + 1)) == -1) continue;
            singleRParen = -1;
        }
        return singleRParen;
    }

    @Nullable
    public static ParsedLine parseExceptionLine(@NotNull String line) {
        ParsedLine result;
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(5);
        }
        if ((result = ExceptionWorker.parseNormalStackTraceLine(line)) == null) {
            result = ExceptionWorker.parseYourKitLine(line);
        }
        if (result == null) {
            result = ExceptionWorker.parseForcedLine(line);
        }
        if (result == null) {
            result = ExceptionWorker.parseLinchekLine(line);
        }
        return result;
    }

    @Nullable
    private static ParsedLine parseNormalStackTraceLine(@NotNull String line) {
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(6);
        }
        return ExceptionWorker.parseStackTraceLine(line, false);
    }

    @Nullable
    private static ParsedLine parseLinchekLine(@NotNull String line) {
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(7);
        }
        if (line.startsWith("|")) {
            return ExceptionWorker.parseStackTraceLine(line, true);
        }
        return null;
    }

    @Nullable
    private static ParsedLine parseStackTraceLine(@NotNull String line, boolean searchForRParenOnlyAfterAt) {
        int classNameIdx;
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(8);
        }
        int startIdx = ExceptionWorker.findAtPrefix(line);
        int rParenIdx = ExceptionWorker.findRParenAfterLocation(line, searchForRParenOnlyAfterAt ? startIdx : 0);
        if (rParenIdx < 0) {
            return null;
        }
        TextRange methodName = ExceptionWorker.findMethodNameCandidateBefore(line, startIdx, rParenIdx);
        if (methodName == null) {
            return null;
        }
        int lParenIdx = methodName.getEndOffset();
        int dotIdx = methodName.getStartOffset() - 1;
        int moduleIdx = line.indexOf(47);
        if (moduleIdx > -1 && moduleIdx < dotIdx && !line.startsWith("0x", moduleIdx + 1)) {
            classNameIdx = moduleIdx + 1;
            if (line.charAt(classNameIdx) == '/') {
                ++classNameIdx;
            }
        } else if (startIdx >= 0) {
            classNameIdx = startIdx + 1 + AT.length() + (line.charAt(startIdx) == 'a' ? 0 : 1);
        } else {
            classNameIdx = StringUtil.findFirst((CharSequence)line, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
            if (classNameIdx < 0) {
                classNameIdx = 0;
            }
        }
        return ParsedLine.createFromFileAndLine(new TextRange(classNameIdx, ExceptionWorker.handleSpaces(line, dotIdx, -1)), ExceptionWorker.trimRange(line, methodName), lParenIdx + 1, rParenIdx, line);
    }

    @NotNull
    private static TextRange trimRange(@NotNull String line, @NotNull TextRange range) {
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(9);
        }
        if (range == null) {
            ExceptionWorker.$$$reportNull$$$0(10);
        }
        int start = ExceptionWorker.handleSpaces(line, range.getStartOffset(), 1);
        int end = ExceptionWorker.handleSpaces(line, range.getEndOffset(), -1);
        if (start != range.getStartOffset() || end != range.getEndOffset()) {
            TextRange textRange = TextRange.create((int)start, (int)end);
            if (textRange == null) {
                ExceptionWorker.$$$reportNull$$$0(11);
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            ExceptionWorker.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    @Nullable
    private static ParsedLine parseYourKitLine(@NotNull String line) {
        int lineEnd;
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(13);
        }
        if ((lineEnd = line.length() - 1) > 0 && line.charAt(lineEnd) == '\n') {
            --lineEnd;
        }
        if (lineEnd > 0 && Character.isDigit(line.charAt(lineEnd))) {
            TextRange methodName;
            int spaceIndex = line.lastIndexOf(32);
            int rParenIdx = line.lastIndexOf(41);
            if (rParenIdx > 0 && spaceIndex == rParenIdx + 1 && (methodName = ExceptionWorker.findMethodNameCandidateBefore(line, 0, rParenIdx)) != null) {
                return ParsedLine.createFromFileAndLine(new TextRange(0, methodName.getStartOffset() - 1), methodName, spaceIndex + 1, lineEnd + 1, line);
            }
        }
        return null;
    }

    @Nullable
    private static ParsedLine parseForcedLine(@NotNull String line) {
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(14);
        }
        String dash = "- ";
        if (!line.trim().startsWith(dash)) {
            return null;
        }
        String linePrefix = "line=";
        int lineNumberStart = line.indexOf(linePrefix);
        if (lineNumberStart < 0) {
            return null;
        }
        int lineNumberEnd = line.indexOf(32, lineNumberStart);
        if (lineNumberEnd < 0) {
            return null;
        }
        TextRange methodName = ExceptionWorker.findMethodNameCandidateBefore(line, 0, lineNumberStart);
        if (methodName == null) {
            return null;
        }
        int lineNumber = ExceptionWorker.getLineNumber(line.substring(lineNumberStart + linePrefix.length(), lineNumberEnd));
        if (lineNumber < 0) {
            return null;
        }
        return new ParsedLine(ExceptionWorker.trimRange(line, TextRange.create((int)(line.indexOf(dash) + dash.length()), (int)(methodName.getStartOffset() - 1))), methodName, TextRange.create((int)lineNumberStart, (int)lineNumberEnd), null, lineNumber);
    }

    private static TextRange findMethodNameCandidateBefore(@NotNull String line, int start, int end) {
        int lParenIdx;
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(15);
        }
        if ((lParenIdx = line.lastIndexOf(40, end)) < 0) {
            return null;
        }
        int dotIdx = line.lastIndexOf(46, lParenIdx);
        if (dotIdx < 0 || dotIdx < start) {
            return null;
        }
        return TextRange.create((int)(dotIdx + 1), (int)lParenIdx);
    }

    private static int handleSpaces(@NotNull String line, int pos, int delta) {
        char c;
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(16);
        }
        int len = line.length();
        while (pos >= 0 && pos < len && Character.isSpaceChar(c = line.charAt(pos))) {
            pos += delta;
        }
        return pos;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineString";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/ExceptionWorker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/ExceptionWorker";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "trimRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumber";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAtPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRParenAfterLocation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseExceptionLine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseNormalStackTraceLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseLinchekLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseStackTraceLine";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "trimRange";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseYourKitLine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseForcedLine";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMethodNameCandidateBefore";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleSpaces";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12 -> new IllegalStateException(string);
        };
    }

    public static class ParsedLine {
        @NotNull
        public final TextRange classFqnRange;
        @NotNull
        public final TextRange methodNameRange;
        @NotNull
        public final TextRange fileLineRange;
        @Nullable
        public final String fileName;
        public final int lineNumber;

        ParsedLine(@NotNull TextRange classFqnRange, @NotNull TextRange methodNameRange, @NotNull TextRange fileLineRange, @Nullable String fileName, int lineNumber) {
            if (classFqnRange == null) {
                ParsedLine.$$$reportNull$$$0(0);
            }
            if (methodNameRange == null) {
                ParsedLine.$$$reportNull$$$0(1);
            }
            if (fileLineRange == null) {
                ParsedLine.$$$reportNull$$$0(2);
            }
            this.classFqnRange = classFqnRange;
            this.methodNameRange = methodNameRange;
            this.fileLineRange = fileLineRange;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        @Nullable
        private static ParsedLine createFromFileAndLine(@NotNull TextRange classFqnRange, @NotNull TextRange methodNameRange, int fileLineStart, int fileLineEnd, @NotNull String line) {
            TextRange fileLineRange;
            String fileAndLine;
            if (classFqnRange == null) {
                ParsedLine.$$$reportNull$$$0(3);
            }
            if (methodNameRange == null) {
                ParsedLine.$$$reportNull$$$0(4);
            }
            if (line == null) {
                ParsedLine.$$$reportNull$$$0(5);
            }
            if ("Native Method".equals(fileAndLine = (fileLineRange = TextRange.create((int)fileLineStart, (int)fileLineEnd)).substring(line)) || "Unknown Source".equals(fileAndLine)) {
                return new ParsedLine(classFqnRange, methodNameRange, fileLineRange, null, -1);
            }
            int colonIndex = fileAndLine.lastIndexOf(58);
            if (colonIndex < 0) {
                return null;
            }
            int lineNumber = ExceptionWorker.getLineNumber(fileAndLine.substring(colonIndex + 1));
            if (lineNumber < 0) {
                return null;
            }
            return new ParsedLine(classFqnRange, methodNameRange, fileLineRange, fileAndLine.substring(0, colonIndex).trim(), lineNumber);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFqnRange";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNameRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileLineRange";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/filters/ExceptionWorker$ParsedLine";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromFileAndLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

