/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ClassLoaderConfigurator;
import com.intellij.ide.plugins.ContentModuleDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleLoadingRule;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.ResolveScopeManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.UrlClassLoader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a$\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f0\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001e\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\u0006\u0010\t\u001a\u00020\u001cH\u0002\u001a\u001d\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0 H\u0007\u00a2\u0006\u0002\u0010!\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0012\u001a\u00020\u00138@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\"\u001a\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"DEFAULT_CLASSLOADER_CONFIGURATION", "Lcom/intellij/util/lang/UrlClassLoader$Builder;", "Lorg/jetbrains/annotations/NotNull;", "createModuleResolveScopeManager", "Lcom/intellij/ide/plugins/cl/ResolveScopeManager;", "createScopeWithExtraPackage", "customPackage", "", "createPluginDependencyAndContentBasedScope", "descriptor", "Lcom/intellij/ide/plugins/PluginMainDescriptor;", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "getPackagePrefixesLoadedBySeparateClassLoaders", "", "Lkotlin/Pair;", "Lcom/intellij/ide/plugins/PluginModuleId;", "getDependencyPackagePrefixes", "canExtendIdeaClassLoader", "", "getCanExtendIdeaClassLoader", "()Z", "canExtendIdeaClassLoader$delegate", "Lkotlin/Lazy;", "configureUsingIdeaClassloader", "Ljava/lang/ClassLoader;", "classPath", "Ljava/nio/file/Path;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "sortDependenciesInPlace", "", "dependencies", "", "([Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "()V", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.core.impl"})
public final class ClassLoaderConfiguratorKt {
    @NotNull
    private static final UrlClassLoader.Builder DEFAULT_CLASSLOADER_CONFIGURATION;
    @NotNull
    private static final Lazy canExtendIdeaClassLoader$delegate;

    private static final ResolveScopeManager createModuleResolveScopeManager() {
        return new ResolveScopeManager(){

            public String isDefinitelyAlienClass(String name, String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                return !StringsKt.startsWith$default((String)name, (String)packagePrefix, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null) ? "" : null;
            }
        };
    }

    private static final ResolveScopeManager createScopeWithExtraPackage(String customPackage) {
        return new ResolveScopeManager(customPackage){
            final /* synthetic */ String $customPackage;
            {
                this.$customPackage = $customPackage;
            }

            public String isDefinitelyAlienClass(String name, String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                if (!(force || StringsKt.startsWith$default((String)name, (String)packagePrefix, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)this.$customPackage, (boolean)false, (int)2, null))) {
                    return "";
                }
                return null;
            }
        };
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @Nullable
    public static final ResolveScopeManager createPluginDependencyAndContentBasedScope(@NotNull PluginMainDescriptor descriptor, @NotNull PluginSet pluginSet) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)pluginSet, (String)"pluginSet");
        List<Pair<String, PluginModuleId>> contentPackagePrefixes = ClassLoaderConfiguratorKt.getPackagePrefixesLoadedBySeparateClassLoaders(descriptor);
        List<String> dependencyPackagePrefixes = ClassLoaderConfiguratorKt.getDependencyPackagePrefixes(descriptor, pluginSet);
        if (contentPackagePrefixes.isEmpty() && dependencyPackagePrefixes.isEmpty()) {
            return null;
        }
        String pluginId = descriptor.getPluginId().getIdString();
        return new ResolveScopeManager(contentPackagePrefixes, pluginId, dependencyPackagePrefixes){
            final /* synthetic */ List<Pair<String, PluginModuleId>> $contentPackagePrefixes;
            final /* synthetic */ String $pluginId;
            final /* synthetic */ List<String> $dependencyPackagePrefixes;
            {
                this.$contentPackagePrefixes = $contentPackagePrefixes;
                this.$pluginId = $pluginId;
                this.$dependencyPackagePrefixes = $dependencyPackagePrefixes;
            }

            public String isDefinitelyAlienClass(String name, String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                if (force) {
                    return null;
                }
                for (Pair<String, PluginModuleId> pair : this.$contentPackagePrefixes) {
                    String prefix = (String)pair.component1();
                    PluginModuleId moduleId = (PluginModuleId)pair.component2();
                    if (!StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return "Class " + name + " must not be requested from main classloader of " + this.$pluginId + " plugin. Matches content module (packagePrefix=" + prefix + ", moduleId=" + moduleId + ").";
                }
                for (String prefix : this.$dependencyPackagePrefixes) {
                    if (!StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return "";
                }
                return null;
            }
        };
    }

    private static final List<Pair<String, PluginModuleId>> getPackagePrefixesLoadedBySeparateClassLoaders(PluginMainDescriptor descriptor) {
        List<ContentModuleDescriptor> modules = descriptor.getContentModules();
        if (modules.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Pair> result = new ArrayList<Pair>(modules.size());
        for (ContentModuleDescriptor module : modules) {
            Collection collection = module.getJarFiles();
            if (!(collection == null || collection.isEmpty()) || module.moduleLoadingRule == ModuleLoadingRule.EMBEDDED) continue;
            String packagePrefix = module.getPackagePrefix();
            if (packagePrefix == null) {
                if (module.getPluginClassLoader() == null) continue;
                throw new PluginException("Package is not specified (module=" + module + ')', module.getPluginId());
            }
            result.add(TuplesKt.to((Object)(packagePrefix + '.'), (Object)module.moduleId));
        }
        return result;
    }

    private static final List<String> getDependencyPackagePrefixes(PluginMainDescriptor descriptor, PluginSet pluginSet) {
        List<PluginModuleId> dependencies = descriptor.getModuleDependencies().getModules();
        if (dependencies.isEmpty()) {
            List<String> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            return list;
        }
        ArrayList<String> result = new ArrayList<String>(dependencies.size());
        for (PluginModuleId item : dependencies) {
            String packagePrefix;
            ContentModuleDescriptor contentModuleDescriptor = pluginSet.findEnabledModule(item);
            if (contentModuleDescriptor == null || (packagePrefix = contentModuleDescriptor.getPackagePrefix()) == null || Intrinsics.areEqual((Object)item.getName(), (Object)"intellij.platform.commercial.verifier")) continue;
            result.add(packagePrefix + '.');
        }
        return result;
    }

    public static final boolean getCanExtendIdeaClassLoader() {
        Lazy lazy = canExtendIdeaClassLoader$delegate;
        return (Boolean)lazy.getValue();
    }

    private static final ClassLoader configureUsingIdeaClassloader(List<? extends Path> classPath, IdeaPluginDescriptorImpl descriptor) {
        ClassLoaderConfiguratorKt.getLOG().warn("deprecated `use-idea-classloader` attribute used by " + descriptor);
        ClassLoader loader = ClassLoaderConfigurator.class.getClassLoader();
        try {
            MethodHandle addFiles = MethodHandles.lookup().findVirtual(loader.getClass(), "addFiles", MethodType.methodType(Void.TYPE, List.class));
            addFiles.invoke(loader, classPath);
            Intrinsics.checkNotNull((Object)loader);
            return loader;
        }
        catch (Throwable e) {
            throw new IllegalStateException("An unexpected core classloader: " + loader, e);
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static final void sortDependenciesInPlace(@NotNull IdeaPluginDescriptorImpl[] dependencies) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        if (dependencies.length <= 1) {
            return;
        }
        ArraysKt.sortWith((Object[])dependencies, (arg_0, arg_1) -> ClassLoaderConfiguratorKt.sortDependenciesInPlace$lambda$1(ClassLoaderConfiguratorKt::sortDependenciesInPlace$lambda$0, arg_0, arg_1));
    }

    private static final Logger getLOG() {
        Logger logger = Logger.getInstance((String)"#com.intellij.ide.plugins.ClassLoaderConfigurator");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static /* synthetic */ void getLOG$annotations() {
    }

    private static final boolean canExtendIdeaClassLoader_delegate$lambda$0() {
        Object object;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)MethodHandles.lookup().findVirtual(ClassLoaderConfigurator.class.getClassLoader().getClass(), "addFiles", MethodType.methodType(Void.TYPE, List.class)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return Result.isSuccess-impl((Object)object);
    }

    private static final int sortDependenciesInPlace$getWeight(IdeaPluginDescriptorImpl module) {
        return module instanceof ContentModuleDescriptor ? 0 : 1;
    }

    private static final int sortDependenciesInPlace$lambda$0(IdeaPluginDescriptorImpl o1, IdeaPluginDescriptorImpl o2) {
        int n;
        Intrinsics.checkNotNull((Object)o1);
        int n2 = ClassLoaderConfiguratorKt.sortDependenciesInPlace$getWeight(o1);
        Intrinsics.checkNotNull((Object)o2);
        int diff = n2 - ClassLoaderConfiguratorKt.sortDependenciesInPlace$getWeight(o2);
        if (diff == 0) {
            String string;
            String string2 = o2.getPackagePrefix();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = o1.getPackagePrefix()) == null) {
                string = "";
            }
            n = string2.compareTo(string);
        } else {
            n = diff;
        }
        return n;
    }

    private static final int sortDependenciesInPlace$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return ClassLoaderConfiguratorKt.getLOG();
    }

    public static final /* synthetic */ ResolveScopeManager access$createModuleResolveScopeManager() {
        return ClassLoaderConfiguratorKt.createModuleResolveScopeManager();
    }

    public static final /* synthetic */ UrlClassLoader.Builder access$getDEFAULT_CLASSLOADER_CONFIGURATION$p() {
        return DEFAULT_CLASSLOADER_CONFIGURATION;
    }

    public static final /* synthetic */ ClassLoader access$configureUsingIdeaClassloader(List classPath, IdeaPluginDescriptorImpl descriptor) {
        return ClassLoaderConfiguratorKt.configureUsingIdeaClassloader(classPath, descriptor);
    }

    public static final /* synthetic */ ResolveScopeManager access$createScopeWithExtraPackage(String customPackage) {
        return ClassLoaderConfiguratorKt.createScopeWithExtraPackage(customPackage);
    }

    static {
        UrlClassLoader.Builder builder = UrlClassLoader.build().useCache();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"useCache(...)");
        DEFAULT_CLASSLOADER_CONFIGURATION = builder;
        canExtendIdeaClassLoader$delegate = LazyKt.lazy(ClassLoaderConfiguratorKt::canExtendIdeaClassLoader_delegate$lambda$0);
    }
}

