/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.ThreadingSupport;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ModalContextProjectLocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.application.impl.NonBlockingFlushQueue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.EDT;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFrame;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class LaterInvocator {
    private static final Logger LOG = Logger.getInstance(LaterInvocator.class);
    private static final List<Object> ourModalEntities = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Map<Project, List<Dialog>> projectToModalEntities = new WeakHashMap<Project, List<Dialog>>();
    private static final Map<Project, Stack<ModalityState>> projectToModalEntitiesStack = new WeakHashMap<Project, Stack<ModalityState>>();
    private static final Stack<ModalityStateEx> ourModalityStack = new Stack((Object[])new ModalityStateEx[]{(ModalityStateEx)ModalityState.nonModal()});
    private static final EventDispatcher<ModalityStateListener> ourModalityStateMulticaster = EventDispatcher.create(ModalityStateListener.class);
    private static NonBlockingFlushQueue ourNonBlockingEdtQueue = null;
    private static final ConcurrentMap<Window, ModalityStateEx> ourWindowModalities = CollectionFactory.createConcurrentWeakMap();

    private LaterInvocator() {
    }

    public static void initializeNonBlockingFlushQueue(@NotNull ThreadingSupport threadingSupport) {
        if (threadingSupport == null) {
            LaterInvocator.$$$reportNull$$$0(0);
        }
        ourNonBlockingEdtQueue = new NonBlockingFlushQueue(threadingSupport);
    }

    public static void addModalityStateListener(@NotNull ModalityStateListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            LaterInvocator.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            LaterInvocator.$$$reportNull$$$0(2);
        }
        if (!ourModalityStateMulticaster.getListeners().contains(listener)) {
            ourModalityStateMulticaster.addListener((EventListener)listener, parentDisposable);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static ModalityStateEx modalityStateForWindow(@NotNull Window window) {
        if (window == null) {
            LaterInvocator.$$$reportNull$$$0(3);
        }
        ModalityStateEx modalityStateEx = ourWindowModalities.computeIfAbsent(window, __ -> {
            Stack<ModalityStateEx> stack = ourModalityStack;
            synchronized (stack) {
                for (ModalityStateEx state2 : ourModalityStack) {
                    if (!state2.contains(window)) continue;
                    return state2;
                }
            }
            Window owner = window.getOwner();
            ModalityStateEx ownerState = owner == null ? (ModalityStateEx)ModalityState.nonModal() : LaterInvocator.modalityStateForWindow(owner);
            return LaterInvocator.isModalDialog(window) ? ownerState.appendEntity(window) : ownerState;
        });
        if (modalityStateEx == null) {
            LaterInvocator.$$$reportNull$$$0(4);
        }
        return modalityStateEx;
    }

    private static boolean isModalDialog(@NotNull Object window) {
        if (window == null) {
            LaterInvocator.$$$reportNull$$$0(5);
        }
        return window instanceof Dialog && ((Dialog)window).isModal();
    }

    @ApiStatus.Internal
    public static void invokeLater(@NotNull ModalityState modalityState, @NotNull Condition<?> expired, @NotNull Runnable runnable) {
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(6);
        }
        if (expired == null) {
            LaterInvocator.$$$reportNull$$$0(7);
        }
        if (runnable == null) {
            LaterInvocator.$$$reportNull$$$0(8);
        }
        LaterInvocator.invokeLater(modalityState, expired, true, runnable);
    }

    @ApiStatus.Internal
    public static void invokeLater(@NotNull ModalityState modalityState, @NotNull Condition<?> expired, boolean needsWriteIntentLock, @NotNull Runnable runnable) {
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(9);
        }
        if (expired == null) {
            LaterInvocator.$$$reportNull$$$0(10);
        }
        if (runnable == null) {
            LaterInvocator.$$$reportNull$$$0(11);
        }
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.INVOKE_LATER);
        if (expired.value(null)) {
            return;
        }
        ourNonBlockingEdtQueue.push(modalityState, runnable, needsWriteIntentLock, expired);
    }

    @RequiresBackgroundThread
    @ApiStatus.Internal
    public static void invokeAndWait(@NotNull ModalityState modalityState, boolean wrapWithLocks, @NotNull Runnable runnable) {
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(12);
        }
        if (runnable == null) {
            LaterInvocator.$$$reportNull$$$0(13);
        }
        ThreadingAssertions.assertBackgroundThread();
        final AtomicReference<Runnable> runnableRef = new AtomicReference<Runnable>(runnable);
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref exception = Ref.create();
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
                Runnable runnable = runnableRef.getAndSet(null);
                if (runnable == null) {
                    return;
                }
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    exception.set((Object)e);
                }
                finally {
                    semaphore.up();
                }
            }

            @NonNls
            public String toString() {
                Runnable runnable = (Runnable)runnableRef.get();
                return "InvokeAndWait[" + (runnable == null ? "(cancelled)" : runnable.toString()) + "]";
            }
        };
        LaterInvocator.invokeLater(modalityState, Conditions.alwaysFalse(), wrapWithLocks, runnable1);
        try {
            while (!semaphore.waitFor(10L)) {
                ProgressManager.checkCanceled();
            }
        }
        catch (Throwable e) {
            runnableRef.set(null);
            throw e;
        }
        if (!exception.isNull()) {
            Throwable cause = (Throwable)exception.get();
            if (SystemProperties.getBooleanProperty((String)"invoke.later.wrap.error", (boolean)true)) {
                throw new RuntimeException(cause);
            }
            ExceptionUtil.rethrow((Throwable)cause);
        }
    }

    @RequiresEdt
    public static void enterModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ModalityStateEx state2 = LaterInvocator.getCurrentModalityState().appendEntity(modalEntity);
        if (LaterInvocator.isModalDialog(modalEntity)) {
            ModalityStateEx current = state2;
            state2 = LaterInvocator.modalityStateForWindow((Window)modalEntity);
            state2.forceModalEntities(current);
        }
        LaterInvocator.enterModal(modalEntity, state2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public static void enterModal(@NotNull Object modalEntity, @NotNull ModalityStateEx appendedState) {
        TransactionGuardImpl guard;
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(15);
        }
        if (appendedState == null) {
            LaterInvocator.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true, modalEntity);
        ourModalEntities.add(modalEntity);
        Stack<ModalityStateEx> stack = ourModalityStack;
        synchronized (stack) {
            ourModalityStack.push((Object)appendedState);
        }
        TransactionGuardImpl transactionGuardImpl = guard = LoadingState.COMPONENTS_LOADED.isOccurred() ? (TransactionGuardImpl)TransactionGuard.getInstance() : null;
        if (guard != null) {
            guard.enteredModality(appendedState);
        }
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    @RequiresEdt
    public static void enterModal(@NotNull Project project, @NotNull Dialog dialog) {
        if (project == null) {
            LaterInvocator.$$$reportNull$$$0(17);
        }
        if (dialog == null) {
            LaterInvocator.$$$reportNull$$$0(18);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + dialog.getName() + " ; for project: " + project.getName());
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true, (Object)dialog);
        List modalEntitiesList = projectToModalEntities.computeIfAbsent(project, __ -> ContainerUtil.createLockFreeCopyOnWriteList());
        modalEntitiesList.add(dialog);
        Stack modalEntitiesStack = projectToModalEntitiesStack.computeIfAbsent(project, __ -> new Stack((Object[])new ModalityState[]{ModalityState.nonModal()}));
        modalEntitiesStack.push((Object)new ModalityStateEx(ourModalEntities));
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @RequiresEdt
    public static void markTransparent(@NotNull ModalityState state2) {
        if (state2 == null) {
            LaterInvocator.$$$reportNull$$$0(19);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ((ModalityStateEx)state2).markTransparent();
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    @RequiresEdt
    public static void leaveModal(Project project, @NotNull Dialog dialog) {
        if (dialog == null) {
            LaterInvocator.$$$reportNull$$$0(20);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + dialog.getName() + " ; for project: " + project.getName());
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false, (Object)dialog);
        int index = ourModalEntities.indexOf(dialog);
        if (index != -1) {
            LaterInvocator.removeModality(dialog, index);
        } else if (project != null) {
            List<Dialog> dialogs = projectToModalEntities.get(project);
            int perProjectIndex = dialogs.indexOf(dialog);
            LOG.assertTrue(perProjectIndex >= 0);
            dialogs.remove(perProjectIndex);
            Stack<ModalityState> states = projectToModalEntitiesStack.get(project);
            states.remove(perProjectIndex + 1);
            for (int i = 1; i < states.size(); ++i) {
                ((ModalityStateEx)((Object)states.get(i))).removeModality(dialog);
            }
        }
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeModality(@NotNull Object modalEntity, int index) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(21);
        }
        ourModalEntities.remove(index);
        Stack<ModalityStateEx> stack = ourModalityStack;
        synchronized (stack) {
            ourModalityStack.remove(index + 1);
            for (int i = 1; i < ourModalityStack.size(); ++i) {
                ((ModalityStateEx)((Object)ourModalityStack.get(i))).removeModality(modalEntity);
            }
        }
        ModalityStateEx.unmarkTransparent(modalEntity);
    }

    @RequiresEdt
    public static void leaveModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(22);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + modalEntity);
        }
        Cancellation.executeInNonCancelableSection(() -> {
            ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false, modalEntity);
            int index = ourModalEntities.indexOf(modalEntity);
            LOG.assertTrue(index >= 0);
            LaterInvocator.removeModality(modalEntity, index);
            LaterInvocator.reincludeSkippedItemsAndRequestFlush();
        });
    }

    @TestOnly
    @RequiresEdt
    public static void leaveAllModals() {
        ThreadingAssertions.assertEventDispatchThread();
        while (!ourModalEntities.isEmpty()) {
            LaterInvocator.leaveModal(ourModalEntities.get(ourModalEntities.size() - 1));
        }
        LOG.assertTrue(LaterInvocator.getCurrentModalityState() == ModalityState.nonModal(), (Object)LaterInvocator.getCurrentModalityState());
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    @RequiresEdt
    @ApiStatus.Internal
    public static void forceLeaveAllModals(@NonNls String string) {
        ThreadingAssertions.assertEventDispatchThread();
        ModalityStateEx currentState = LaterInvocator.getCurrentModalityState();
        if (currentState != ModalityState.nonModal()) {
            String reason;
            currentState.cancelAllEntities(reason);
            LaterInvocator.invokeLater(ModalityState.any(), Conditions.alwaysFalse(), () -> LaterInvocator.forceLeaveAllModals(reason));
        }
    }

    @RequiresEdt
    public static Object @NotNull [] getCurrentModalEntities() {
        ThreadingAssertions.assertEventDispatchThread();
        Object[] objectArray = ArrayUtil.toObjectArray(ourModalEntities);
        if (objectArray == null) {
            LaterInvocator.$$$reportNull$$$0(23);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @RequiresEdt
    @NotNull
    public static ModalityStateEx getCurrentModalityState() {
        ThreadingAssertions.assertEventDispatchThread();
        Stack<ModalityStateEx> stack = ourModalityStack;
        // MONITORENTER : stack
        ModalityStateEx modalityStateEx = (ModalityStateEx)((Object)ourModalityStack.peek());
        // MONITOREXIT : stack
        if (modalityStateEx != null) return modalityStateEx;
        LaterInvocator.$$$reportNull$$$0(24);
        return modalityStateEx;
    }

    @RequiresEdt
    public static boolean isInModalContextForProject(@Nullable Project project) {
        Project project2;
        ThreadingAssertions.assertEventDispatchThread();
        if (ourModalEntities.isEmpty()) {
            return false;
        }
        if (project2 == null) {
            return true;
        }
        List<Dialog> modalEntitiesForProject = projectToModalEntities.get(project2);
        return modalEntitiesForProject == null || modalEntitiesForProject.isEmpty();
    }

    @RequiresEdt
    public static boolean isInModalContext() {
        ThreadingAssertions.assertEventDispatchThread();
        return LaterInvocator.isInModalContextForProject(null);
    }

    @RequiresEdt
    public static boolean isInModalContext(@NotNull JFrame frame, @Nullable Project project) {
        if (frame == null) {
            LaterInvocator.$$$reportNull$$$0(25);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Object[] entities = LaterInvocator.getCurrentModalEntities();
        int forOtherProjects = 0;
        for (Object entity : entities) {
            if (entity instanceof ModalContextProjectLocator && !((ModalContextProjectLocator)entity).isPartOf(frame, project)) {
                ++forOtherProjects;
                continue;
            }
            if (!(entity instanceof Component) || LaterInvocator.isAncestor(frame, (Component)entity)) continue;
            ++forOtherProjects;
        }
        return forOtherProjects != entities.length;
    }

    private static boolean isAncestor(@NotNull Component ancestor, @Nullable Component descendant) {
        if (ancestor == null) {
            LaterInvocator.$$$reportNull$$$0(26);
        }
        while (descendant != null) {
            if (descendant == ancestor) {
                return true;
            }
            descendant = descendant.getParent();
        }
        return false;
    }

    static boolean isFlushNow(@NotNull Runnable runnable) {
        if (runnable == null) {
            LaterInvocator.$$$reportNull$$$0(27);
        }
        return ourNonBlockingEdtQueue.isFlushNow(runnable);
    }

    public static void pollWriteThreadEventsOnce() {
        LOG.assertTrue(!EDT.isCurrentThreadEdt());
        LOG.assertTrue(ApplicationManager.getApplication().isWriteIntentLockAcquired());
    }

    @TestOnly
    @NotNull
    public static Object getLaterInvocatorEdtQueue() {
        NonBlockingFlushQueue nonBlockingFlushQueue = ourNonBlockingEdtQueue;
        if (nonBlockingFlushQueue == null) {
            LaterInvocator.$$$reportNull$$$0(28);
        }
        return nonBlockingFlushQueue;
    }

    @RequiresEdt
    private static void reincludeSkippedItemsAndRequestFlush() {
        ThreadingAssertions.assertEventDispatchThread();
        ourNonBlockingEdtQueue.onModalityChanged();
    }

    @RequiresEdt
    public static void purgeExpiredItems() {
        ThreadingAssertions.assertEventDispatchThread();
        if (ourNonBlockingEdtQueue != null) {
            ourNonBlockingEdtQueue.purgeExpiredItems();
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @TestOnly
    @RequiresEdt
    public static void dispatchPendingFlushes() {
        ThreadingAssertions.assertEventDispatchThread();
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        LaterInvocator.invokeLater(ModalityState.any(), Conditions.alwaysFalse(), () -> ((Semaphore)semaphore).up());
        while (!semaphore.isUp()) {
            EDT.dispatchAllInvocationEvents();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 23: 
            case 24: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 23: 
            case 24: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadingSupport";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 4: 
            case 23: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/LaterInvocator";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalEntity";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendedState";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/LaterInvocator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "modalityStateForWindow";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalEntities";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalityState";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaterInvocatorEdtQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initializeNonBlockingFlushQueue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addModalityStateListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "modalityStateForWindow";
                break;
            }
            case 4: 
            case 23: 
            case 24: 
            case 28: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isModalDialog";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "enterModal";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "markTransparent";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "leaveModal";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeModality";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isInModalContext";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isFlushNow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 23: 
            case 24: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

