/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandIdentity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CommandDescriptor
implements CommandToken {
    @NotNull
    private final CommandIdentity identity;
    @NotNull
    private final Runnable command;
    @Nullable
    private final Project project;
    private final @NlsContexts.Command @Nullable String name;
    @Nullable
    private final Object groupId;
    @Nullable
    private final Document document;
    @NotNull
    private final UndoConfirmationPolicy undoConfirmationPolicy;
    private final boolean shouldRecordActionForActiveDocument;

    CommandDescriptor(@NotNull Runnable command, @Nullable Project project, @NlsContexts.Command @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordActionForActiveDocument, @Nullable Document document) {
        if (command == null) {
            CommandDescriptor.$$$reportNull$$$0(0);
        }
        if (undoConfirmationPolicy == null) {
            CommandDescriptor.$$$reportNull$$$0(1);
        }
        this(new CommandIdentity(), command, project, name, groupId, undoConfirmationPolicy, shouldRecordActionForActiveDocument, document);
    }

    private CommandDescriptor(@NotNull CommandIdentity identity, @NotNull Runnable command, @Nullable Project project, @NlsContexts.Command @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordActionForActiveDocument, @Nullable Document document) {
        if (identity == null) {
            CommandDescriptor.$$$reportNull$$$0(2);
        }
        if (command == null) {
            CommandDescriptor.$$$reportNull$$$0(3);
        }
        if (undoConfirmationPolicy == null) {
            CommandDescriptor.$$$reportNull$$$0(4);
        }
        this.identity = identity;
        this.command = command;
        this.project = project;
        this.name = name;
        this.groupId = groupId;
        this.undoConfirmationPolicy = undoConfirmationPolicy;
        this.shouldRecordActionForActiveDocument = shouldRecordActionForActiveDocument;
        this.document = document;
    }

    @NotNull
    CommandEvent toCommandEvent(@NotNull CommandProcessor processor) {
        if (processor == null) {
            CommandDescriptor.$$$reportNull$$$0(5);
        }
        return new CommandEvent(processor, this.command, this.name, this.groupId, this.project, this.undoConfirmationPolicy, this.shouldRecordActionForActiveDocument, this.document);
    }

    @NotNull
    CommandDescriptor withName(@NlsContexts.Command @Nullable String name) {
        return new CommandDescriptor(this.identity, this.command, this.project, name, this.groupId, this.undoConfirmationPolicy, this.shouldRecordActionForActiveDocument, this.document);
    }

    @NotNull
    CommandDescriptor withGroupId(@Nullable Object groupId) {
        return new CommandDescriptor(this.identity, this.command, this.project, this.name, groupId, this.undoConfirmationPolicy, this.shouldRecordActionForActiveDocument, this.document);
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.project;
    }

    @NotNull
    Runnable getCommand() {
        Runnable runnable = this.command;
        if (runnable == null) {
            CommandDescriptor.$$$reportNull$$$0(6);
        }
        return runnable;
    }

    @NlsContexts.Command
    @Nullable
    String getName() {
        return this.name;
    }

    @Nullable
    Object getGroupId() {
        return this.groupId;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CommandDescriptor)) {
            return false;
        }
        CommandDescriptor that = (CommandDescriptor)object;
        return Objects.equals(this.identity, that.identity);
    }

    public int hashCode() {
        return Objects.hashCode(this.identity);
    }

    public String toString() {
        return "'" + this.name + "', group: '" + this.groupId + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoConfirmationPolicy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/CommandDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/CommandDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toCommandEvent";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

