/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.local;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.platform.eel.fs.EelFiles;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreLocalVirtualFile
extends VirtualFile {
    private final CoreLocalFileSystem myFileSystem;
    private final Path myFile;
    private BasicFileAttributes myAttributes;
    private VirtualFile[] myChildren;

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull Path file) {
        if (fileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(1);
        }
        this.myFileSystem = fileSystem;
        this.myFile = file;
    }

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull Path file, boolean isDirectory) {
        if (fileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(2);
        }
        if (file == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(3);
        }
        this.myFileSystem = fileSystem;
        this.myFile = file;
        this.myAttributes = isDirectory ? new IncompleteDirectoryAttributes() : null;
    }

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull Path file, @NotNull BasicFileAttributes attributes) {
        if (fileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(4);
        }
        if (file == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(5);
        }
        if (attributes == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(6);
        }
        this.myFileSystem = fileSystem;
        this.myFile = file;
        this.myAttributes = attributes;
    }

    @NotNull
    protected Path getFile() {
        Path path = this.myFile;
        if (path == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(7);
        }
        return path;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        CoreLocalFileSystem coreLocalFileSystem = this.myFileSystem;
        if (coreLocalFileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(8);
        }
        return coreLocalFileSystem;
    }

    @NotNull
    public String getName() {
        String string = NioFiles.getFileName((Path)this.myFile);
        if (string == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = FileUtil.toSystemIndependentName((String)this.myFile.toString());
        if (string == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDirectory() {
        BasicFileAttributes attrs2 = this.getAttributes(false);
        return attrs2 != null && attrs2.isDirectory();
    }

    public boolean is(@NotNull VFileProperty property) {
        if (property == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(11);
        }
        BasicFileAttributes attrs2 = this.getAttributes(true);
        if (property == VFileProperty.HIDDEN) {
            return attrs2 instanceof DosFileAttributes && ((DosFileAttributes)attrs2).isHidden() && this.myFile.getParent() != null || NioFiles.getFileName((Path)this.myFile).startsWith(".");
        }
        if (property == VFileProperty.SYMLINK) {
            return attrs2 != null && attrs2.isSymbolicLink();
        }
        if (property == VFileProperty.SPECIAL) {
            return attrs2 != null && attrs2.isOther();
        }
        return super.is(property);
    }

    public long getTimeStamp() {
        BasicFileAttributes attrs2 = this.getAttributes(true);
        return attrs2 != null ? attrs2.lastModifiedTime().toMillis() : -1L;
    }

    public long getLength() {
        BasicFileAttributes attrs2 = this.getAttributes(false);
        return attrs2 != null ? attrs2.size() : -1L;
    }

    @Nullable
    protected BasicFileAttributes getAttributes(boolean full) {
        if (this.myAttributes == null || full && this.myAttributes instanceof IncompleteDirectoryAttributes) {
            try {
                this.myAttributes = Files.readAttributes(this.myFile, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.myAttributes;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        Path parentFile = this.myFile.getParent();
        return parentFile != null ? new CoreLocalVirtualFile(this.myFileSystem, parentFile, new IncompleteDirectoryAttributes()) : null;
    }

    public VirtualFile[] getChildren() {
        if (this.myChildren == null) {
            List files = NioFiles.list((Path)this.myFile);
            if (files.isEmpty()) {
                this.myChildren = EMPTY_ARRAY;
            } else {
                VirtualFile[] result = new VirtualFile[files.size()];
                for (int i = 0; i < files.size(); ++i) {
                    result[i] = new CoreLocalVirtualFile(this.myFileSystem, (Path)files.get(i));
                }
                this.myChildren = result;
            }
        }
        return this.myChildren;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        byte[] byArray = EelFiles.readAllBytes((Path)this.myFile);
        if (byArray == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(12);
        }
        return byArray;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM((InputStream)new BufferedInputStream(Files.newInputStream(this.myFile, new OpenOption[0])), (VirtualFile)this);
        if (inputStream == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(13);
        }
        return inputStream;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public boolean isInLocalFileSystem() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CoreLocalVirtualFile that = (CoreLocalVirtualFile)((Object)o);
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/local/CoreLocalVirtualFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/local/CoreLocalVirtualFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class IncompleteDirectoryAttributes
    implements BasicFileAttributes {
        private IncompleteDirectoryAttributes() {
        }

        @Override
        public FileTime lastModifiedTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileTime lastAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileTime creationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean isSymbolicLink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOther() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public Object fileKey() {
            throw new UnsupportedOperationException();
        }
    }
}

