/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.impl.builder;

import com.intellij.platform.syntax.impl.builder.CompositeMarker;
import com.intellij.platform.syntax.impl.builder.ErrorMarker;
import com.intellij.platform.syntax.impl.builder.MarkerPoolKt;
import com.intellij.platform.syntax.impl.builder.ProductionMarker;
import com.intellij.platform.syntax.impl.builder.SyntaxTreeBuilderImpl;
import com.intellij.util.fastutil.ints.IntArrayList;
import com.intellij.util.fastutil.ints.IntList;
import com.intellij.util.fastutil.ints.IntListExtensionsKt;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bJ\u0011\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000eH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/syntax/impl/builder/MarkerPool;", "", "builder", "Lcom/intellij/platform/syntax/impl/builder/SyntaxTreeBuilderImpl;", "<init>", "(Lcom/intellij/platform/syntax/impl/builder/SyntaxTreeBuilderImpl;)V", "freeStartMarkers", "Lcom/intellij/util/fastutil/ints/IntArrayList;", "freeErrorItems", "list", "Ljava/util/ArrayList;", "Lcom/intellij/platform/syntax/impl/builder/ProductionMarker;", "Lkotlin/collections/ArrayList;", "size", "", "getSize", "()I", "allocateCompositeMarker", "Lcom/intellij/platform/syntax/impl/builder/CompositeMarker;", "allocateErrorNode", "Lcom/intellij/platform/syntax/impl/builder/ErrorMarker;", "freeMarker", "", "marker", "get", "index", "intellij.platform.syntax"})
public class MarkerPool {
    @NotNull
    private final SyntaxTreeBuilderImpl builder;
    @NotNull
    private final IntArrayList freeStartMarkers;
    @NotNull
    private final IntArrayList freeErrorItems;
    @NotNull
    private final ArrayList<ProductionMarker> list;

    public MarkerPool(@NotNull SyntaxTreeBuilderImpl builder) {
        this.builder = builder;
        this.freeStartMarkers = new IntArrayList();
        this.freeErrorItems = new IntArrayList();
        this.list = new ArrayList();
        this.list.add(new CompositeMarker(-1, this.builder));
    }

    public final int getSize() {
        return this.list.size();
    }

    @NotNull
    public final CompositeMarker allocateCompositeMarker() {
        if (!IntListExtensionsKt.isEmpty((IntList)((IntList)this.freeStartMarkers))) {
            ProductionMarker productionMarker = this.list.get(MarkerPoolKt.access$pop(this.freeStartMarkers));
            Intrinsics.checkNotNull((Object)productionMarker, (String)"null cannot be cast to non-null type com.intellij.platform.syntax.impl.builder.CompositeMarker");
            return (CompositeMarker)productionMarker;
        }
        CompositeMarker marker = new CompositeMarker(this.list.size(), this.builder);
        this.list.add(marker);
        return marker;
    }

    @NotNull
    public final ErrorMarker allocateErrorNode() {
        if (!IntListExtensionsKt.isEmpty((IntList)((IntList)this.freeErrorItems))) {
            ProductionMarker productionMarker = this.list.get(MarkerPoolKt.access$pop(this.freeErrorItems));
            Intrinsics.checkNotNull((Object)productionMarker, (String)"null cannot be cast to non-null type com.intellij.platform.syntax.impl.builder.ErrorMarker");
            return (ErrorMarker)productionMarker;
        }
        ErrorMarker item = new ErrorMarker(this.list.size(), this.builder);
        this.list.add(item);
        return item;
    }

    public final void freeMarker(@NotNull ProductionMarker marker) {
        marker.dispose();
        IntArrayList freeMarkerStack = marker instanceof CompositeMarker ? this.freeStartMarkers : this.freeErrorItems;
        MarkerPoolKt.access$push(freeMarkerStack, marker.getMarkerId());
    }

    @NotNull
    public final ProductionMarker get(int index) {
        return this.list.get(index);
    }
}

