/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.lexer;

import com.intellij.platform.syntax.CancellationProvider;
import com.intellij.platform.syntax.Logger;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.lexer.Builder;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.lexer.TokenList;
import com.intellij.platform.syntax.lexer.TokenListImplKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ*\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0012\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\"\u001a\u00020\bH\u0016J\u0018\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0016J\u0010\u0010&\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0016J\u0018\u0010'\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u0006H\u0016J\u0010\u0010)\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006*"}, d2={"Lcom/intellij/platform/syntax/lexer/TokenListImpl;", "Lcom/intellij/platform/syntax/lexer/TokenList;", "lexStarts", "", "lexTypes", "", "Lcom/intellij/platform/syntax/SyntaxElementType;", "tokenCount", "", "tokenizedText", "", "startIndex", "<init>", "([I[Lcom/intellij/platform/syntax/SyntaxElementType;ILjava/lang/CharSequence;I)V", "getLexStarts", "()[I", "getLexTypes", "()[Lcom/intellij/platform/syntax/SyntaxElementType;", "[Lcom/intellij/platform/syntax/SyntaxElementType;", "getTokenCount", "()I", "getTokenizedText", "()Ljava/lang/CharSequence;", "getStartIndex", "assertMatches", "", "text", "lexer", "Lcom/intellij/platform/syntax/lexer/Lexer;", "cancellationProvider", "Lcom/intellij/platform/syntax/CancellationProvider;", "logger", "Lcom/intellij/platform/syntax/Logger;", "getTokenType", "index", "slice", "start", "end", "getTokenStart", "remap", "newValue", "getTokenEnd", "intellij.platform.syntax"})
public final class TokenListImpl
implements TokenList {
    @NotNull
    private final int[] lexStarts;
    @NotNull
    private final SyntaxElementType[] lexTypes;
    private final int tokenCount;
    @NotNull
    private final CharSequence tokenizedText;
    private final int startIndex;

    public TokenListImpl(@NotNull int[] lexStarts, @NotNull SyntaxElementType[] lexTypes, int tokenCount, @NotNull CharSequence tokenizedText, int startIndex) {
        this.lexStarts = lexStarts;
        this.lexTypes = lexTypes;
        this.tokenCount = tokenCount;
        this.tokenizedText = tokenizedText;
        this.startIndex = startIndex;
        if (!(this.startIndex + this.getTokenCount() < this.lexStarts.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.startIndex + this.getTokenCount() <= this.lexTypes.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ TokenListImpl(int[] nArray, SyntaxElementType[] syntaxElementTypeArray, int n, CharSequence charSequence, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        this(nArray, syntaxElementTypeArray, n, charSequence, n2);
    }

    @NotNull
    public final int[] getLexStarts() {
        return this.lexStarts;
    }

    @NotNull
    public final SyntaxElementType[] getLexTypes() {
        return this.lexTypes;
    }

    @Override
    public int getTokenCount() {
        return this.tokenCount;
    }

    @Override
    @NotNull
    public CharSequence getTokenizedText() {
        return this.tokenizedText;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    public final void assertMatches(@NotNull CharSequence text, @NotNull Lexer lexer, @Nullable CancellationProvider cancellationProvider, @Nullable Logger logger) {
        TokenListImpl sequence = new Builder(text, lexer, cancellationProvider, logger).performLexing();
        if (!(this.getTokenCount() == sequence.getTokenCount())) {
            throw new IllegalStateException("Check failed.");
        }
        int n = this.getTokenCount();
        for (int j = 0; j < n; ++j) {
            if (sequence.lexStarts[j] == this.lexStarts[this.startIndex + j] && sequence.lexTypes[j] == this.lexTypes[this.startIndex + j]) continue;
            throw new IllegalStateException("Check failed.");
        }
        if (sequence.lexStarts[this.getTokenCount()] != this.lexStarts[this.startIndex + this.getTokenCount()]) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Override
    @Nullable
    public SyntaxElementType getTokenType(int index) {
        if (!(0 <= index ? index < this.getTokenCount() : false)) {
            return null;
        }
        return this.lexTypes[this.startIndex + index];
    }

    @Override
    @NotNull
    public TokenList slice(int start, int end) {
        if (!(start >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(end <= this.getTokenCount())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(start <= end)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (start == 0 && end == this.getTokenCount()) {
            return this;
        }
        if (start == end) {
            return TokenListImplKt.access$emptyTokenList();
        }
        return new TokenListImpl(this.lexStarts, this.lexTypes, end - start, this.getTokenizedText(), this.startIndex + start);
    }

    @Override
    public int getTokenStart(int index) {
        if (!(0 <= index ? index < this.getTokenCount() : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.lexStarts[this.startIndex + index];
    }

    @Override
    public void remap(int index, @NotNull SyntaxElementType newValue) {
        if (!(0 <= index ? index < this.getTokenCount() : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.lexTypes[this.startIndex + index] = newValue;
    }

    @Override
    public int getTokenEnd(int index) {
        return this.lexStarts[this.startIndex + index + 1];
    }
}

