/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.core.CoreBundle;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.CodeInsightContextAwareSearchScopes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDirectoryImpl
extends PsiElementBase
implements PsiDirectory,
Queryable {
    private static final Key<Boolean> UPDATE_ADDED_FILE_KEY = Key.create((String)"UPDATE_ADDED_FILE_KEY");
    private static final Logger LOG = Logger.getInstance(PsiDirectoryImpl.class);
    private final PsiManagerEx myManager;
    private final VirtualFile myFile;

    public PsiDirectoryImpl(@NotNull PsiManagerEx manager, @NotNull VirtualFile file) {
        if (manager == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(1);
        }
        this.myManager = manager;
        this.myFile = file;
    }

    public PsiDirectoryImpl(@NotNull PsiManagerImpl manager, @NotNull VirtualFile file) {
        if (manager == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(3);
        }
        this.myManager = manager;
        this.myFile = file;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && !this.getProject().isDisposed();
    }

    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(5);
        }
        return language;
    }

    @Override
    @NotNull
    public PsiManager getManager() {
        PsiManagerEx psiManagerEx = this.myManager;
        if (psiManagerEx == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(6);
        }
        return psiManagerEx;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(8);
        }
        this.checkSetName(name);
        try {
            this.myFile.rename((Object)this.myManager, name);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        PsiDirectoryImpl psiDirectoryImpl = this;
        if (psiDirectoryImpl == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(9);
        }
        return psiDirectoryImpl;
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        VirtualFile parentFile = this.myFile.getParent();
        if (parentFile == null) {
            throw new IncorrectOperationException(CoreBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{this.myFile.getPath()}));
        }
        VirtualFile child = parentFile.findChild(name);
        if (child != null && !child.equals(this.myFile)) {
            throw new IncorrectOperationException(CoreBundle.message((String)"dir.already.exists.error", (Object[])new Object[]{child.getPresentableUrl()}));
        }
    }

    public PsiDirectory getParentDirectory() {
        VirtualFile parentFile = this.myFile.getParent();
        if (parentFile == null) {
            return null;
        }
        if (!parentFile.isValid()) {
            LOG.error("Invalid parent: " + parentFile + " of dir " + this.myFile + ", dir.valid=" + this.myFile.isValid());
            return null;
        }
        return this.myManager.findDirectory(parentFile);
    }

    public PsiDirectory @NotNull [] getSubdirectories() {
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile file : files) {
            PsiDirectory dir = this.myManager.findDirectory(file);
            if (dir == null) continue;
            dirs.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = dirs.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(10);
        }
        return psiDirectoryArray;
    }

    public PsiFile @NotNull [] getFiles() {
        return this.getFilesImpl(null);
    }

    public PsiFile @NotNull [] getFiles(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(11);
        }
        return this.getFilesImpl(scope);
    }

    private PsiFile @NotNull [] getFilesImpl(@Nullable GlobalSearchScope scope) {
        if (!this.myFile.isValid()) {
            throw new InvalidVirtualFileAccessException(this.myFile);
        }
        VirtualFile[] files = this.myFile.getChildren();
        if (files.length == 0) {
            if (PsiFile.EMPTY_ARRAY == null) {
                PsiDirectoryImpl.$$$reportNull$$$0(12);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        boolean sharedSourceSupportEnabled = CodeInsightContexts.isSharedSourceSupportEnabled((Project)this.getProject());
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (VirtualFile file : files) {
            PsiFile psiFile;
            if (sharedSourceSupportEnabled && scope != null) {
                Collection contexts = CodeInsightContextAwareSearchScopes.getCorrespondingContexts((SearchScope)scope, (VirtualFile)file);
                for (CodeInsightContext context : contexts) {
                    PsiFile psiFile2 = this.myManager.findFile(file, context);
                    if (psiFile2 == null) continue;
                    psiFiles.add(psiFile2);
                }
                continue;
            }
            if (scope != null && !scope.contains(file) || (psiFile = this.myManager.findFile(file)) == null) continue;
            psiFiles.add(psiFile);
        }
        PsiFile[] psiFileArray = PsiUtilCore.toPsiFileArray(psiFiles);
        if (psiFileArray == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(13);
        }
        return psiFileArray;
    }

    public PsiDirectory findSubdirectory(@NotNull String name) {
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(14);
        }
        ProgressManager.checkCanceled();
        VirtualFile childVFile = this.myFile.findChild(name);
        if (childVFile == null) {
            return null;
        }
        return this.myManager.findDirectory(childVFile);
    }

    public PsiFile findFile(@NotNull String name) {
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(15);
        }
        ProgressManager.checkCanceled();
        VirtualFile childVFile = this.myFile.findChild(name);
        if (childVFile == null) {
            return null;
        }
        if (!childVFile.isValid()) {
            LOG.error("Invalid file: " + childVFile + " in dir " + this.myFile + ", dir.valid=" + this.myFile.isValid(), (Throwable)new InvalidVirtualFileAccessException(childVFile));
            return null;
        }
        return this.myManager.findFile(childVFile);
    }

    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (processor == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(16);
        }
        this.checkValid();
        for (VirtualFile vFile : this.myFile.getChildren()) {
            PsiDirectory item;
            ProgressManager.checkCanceled();
            if (!vFile.isValid()) continue;
            boolean isDir = vFile.isDirectory();
            if (processor instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor).acceptItem(vFile.getName(), isDir)) continue;
            Object object = item = isDir ? this.myManager.findDirectory(vFile) : this.myManager.findFile(vFile);
            if (item == null || processor.execute((PsiElement)item)) continue;
            return false;
        }
        return true;
    }

    public PsiElement @NotNull [] getChildren() {
        this.checkValid();
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList children = new ArrayList(files.length);
        this.processChildren((PsiElementProcessor<? super PsiFileSystemItem>)((PsiElementProcessor)element -> {
            children.add(element);
            return true;
        }));
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(children);
        if (psiElementArray == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(17);
        }
        return psiElementArray;
    }

    private void checkValid() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
    }

    public PsiDirectory getParent() {
        return this.getParentDirectory();
    }

    @Override
    public PsiFile getContainingFile() {
        return null;
    }

    @Override
    @Nullable
    protected Icon getBaseIcon() {
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.Folder);
    }

    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return -1;
    }

    public int getTextLength() {
        return -1;
    }

    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return -1;
    }

    public String getText() {
        return "";
    }

    public char @NotNull [] textToCharArray() {
        if (ArrayUtilRt.EMPTY_CHAR_ARRAY == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(18);
        }
        return ArrayUtilRt.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(19);
        }
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(20);
        }
        return false;
    }

    @Override
    public final boolean isWritable() {
        return this.myFile.isWritable();
    }

    @Override
    public boolean isPhysical() {
        return !(this.myFile.getFileSystem() instanceof NonPhysicalFileSystem) && !this.myFile.getFileSystem().getProtocol().equals("temp");
    }

    @Override
    public PsiElement copy() {
        throw new IncorrectOperationException();
    }

    @NotNull
    public PsiDirectory createSubdirectory(@NotNull String name) throws IncorrectOperationException {
        PsiDirectory psiDirectory;
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(21);
        }
        this.checkCreateSubdirectory(name);
        try {
            VirtualFile file = this.getVirtualFile().createChildDirectory((Object)this.myManager, name);
            PsiDirectory directory = this.myManager.findDirectory(file);
            if (directory == null) {
                throw new IncorrectOperationException("Cannot find directory in '" + file.getPresentableUrl() + "'");
            }
            psiDirectory = directory;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        if (psiDirectory == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(22);
        }
        return psiDirectory;
    }

    public void checkCreateSubdirectory(@NotNull String name) throws IncorrectOperationException {
        VirtualFile existingFile;
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(23);
        }
        if ((existingFile = this.getVirtualFile().findChild(name)) != null) {
            throw new IncorrectOperationException(CoreBundle.message((String)"file.already.exists.error", (Object[])new Object[]{existingFile.getPresentableUrl()}));
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @NotNull
    public PsiFile createFile(@NotNull String name) throws IncorrectOperationException {
        PsiFile psiFile;
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(24);
        }
        this.checkCreateFile(name);
        try {
            VirtualFile vFile = this.getVirtualFile().createChildData((Object)this.myManager, name);
            PsiFile psiFile2 = this.myManager.findFile(vFile);
            assert (psiFile2 != null) : vFile.getPath();
            psiFile = psiFile2;
        }
        catch (IOException e) {
            throw new IncorrectOperationException((Throwable)e);
        }
        if (psiFile == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(25);
        }
        return psiFile;
    }

    @NotNull
    public PsiFile copyFileFrom(@NotNull String newName, @NotNull PsiFile originalFile) throws IncorrectOperationException {
        VirtualFile copyVFile;
        VirtualFile vFile;
        block12: {
            PsiFile psiFile;
            if (newName == null) {
                PsiDirectoryImpl.$$$reportNull$$$0(26);
            }
            if (originalFile == null) {
                PsiDirectoryImpl.$$$reportNull$$$0(27);
            }
            this.checkCreateFile(newName);
            Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(originalFile);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            VirtualFile parent = this.getVirtualFile();
            try {
                vFile = originalFile.getVirtualFile();
                if (vFile == null) {
                    throw new IncorrectOperationException("Cannot copy non-physical file: " + originalFile);
                }
                if (parent.getFileSystem() == vFile.getFileSystem()) {
                    copyVFile = vFile.copy((Object)this, parent, newName);
                } else if (vFile instanceof LightVirtualFile) {
                    copyVFile = parent.createChildData((Object)this, newName);
                    copyVFile.setBinaryContent(vFile.contentsToByteArray());
                } else {
                    copyVFile = VfsUtilCore.copyFile((Object)this, (VirtualFile)vFile, (VirtualFile)parent, (String)newName);
                }
                if (!((Boolean)UPDATE_ADDED_FILE_KEY.get((UserDataHolder)this, (Object)true)).booleanValue()) break block12;
                DumbService.getInstance((Project)this.getProject()).completeJustSubmittedTasks();
                PsiFile copyPsi = this.findCopy(copyVFile, vFile);
                UpdateAddedFileProcessor.updateAddedFiles(Collections.singletonList(copyPsi), Collections.singletonList(originalFile));
                psiFile = copyPsi;
            }
            catch (IOException e) {
                throw new IncorrectOperationException((Throwable)e);
            }
            if (psiFile == null) {
                PsiDirectoryImpl.$$$reportNull$$$0(28);
            }
            return psiFile;
        }
        return this.findCopy(copyVFile, vFile);
    }

    @NotNull
    private PsiFile findCopy(VirtualFile copyVFile, VirtualFile vFile) {
        PsiFile copyPsi = this.myManager.findFile(copyVFile);
        if (copyPsi == null) {
            throw new IncorrectOperationException("Could not find file " + copyVFile + " after copying " + vFile);
        }
        PsiFile psiFile = copyPsi;
        if (psiFile == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(29);
        }
        return psiFile;
    }

    public <T extends Throwable> void executeWithUpdatingAddedFilesDisabled(ThrowableRunnable<T> runnable) throws T {
        try {
            this.putUserData(UPDATE_ADDED_FILE_KEY, false);
            runnable.run();
        }
        finally {
            this.putUserData(UPDATE_ADDED_FILE_KEY, null);
        }
    }

    public void checkCreateFile(@NotNull String name) throws IncorrectOperationException {
        VirtualFile existingFile;
        if (name == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(30);
        }
        if ((existingFile = this.getVirtualFile().findChild(name)) != null) {
            throw new IncorrectOperationException(CoreBundle.message((String)"file.already.exists.error", (Object[])new Object[]{existingFile.getPresentableUrl()}));
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(31);
        }
        this.checkAdd(element);
        if (element instanceof PsiFile) {
            PsiFile originalFile = (PsiFile)element;
            try {
                VirtualFile newVFile;
                if (originalFile instanceof PsiFileImpl) {
                    newVFile = this.myFile.createChildData((Object)this.myManager, originalFile.getName());
                    String text = originalFile.getText();
                    PsiFile psiFile = this.getManager().findFile(newVFile);
                    Document document = psiFile == null ? null : psiFile.getViewProvider().getDocument();
                    FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                    if (document != null) {
                        document.setText((CharSequence)text);
                        if (psiFile.isPhysical()) {
                            fileDocumentManager.saveDocument(document);
                        }
                        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document);
                    } else {
                        String lineSeparator = fileDocumentManager.getLineSeparator(newVFile, this.getProject());
                        if (!lineSeparator.equals("\n")) {
                            text = StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
                        }
                        LoadTextUtil.write(this.getProject(), newVFile, (Object)this.myManager, text, -1L);
                    }
                } else {
                    byte[] storedContents = ((PsiBinaryFileImpl)originalFile).getStoredContents();
                    if (storedContents != null) {
                        newVFile = this.myFile.createChildData((Object)this.myManager, originalFile.getName());
                        newVFile.setBinaryContent(storedContents);
                    } else {
                        newVFile = VfsUtilCore.copyFile(null, (VirtualFile)originalFile.getVirtualFile(), (VirtualFile)this.myFile);
                    }
                }
                PsiFile newFile = this.myManager.findFile(newVFile);
                if (newFile == null) {
                    throw new IncorrectOperationException("Could not find file " + newVFile);
                }
                UpdateAddedFileProcessor.updateAddedFiles(Collections.singletonList(newFile), Collections.singletonList(originalFile));
                return newFile;
            }
            catch (IOException e) {
                throw new IncorrectOperationException((Throwable)e);
            }
        }
        throw new IncorrectOperationException(element + " (" + element.getClass() + ")");
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(32);
        }
        CheckUtil.checkWritable((PsiElement)this);
        if (element instanceof PsiDirectory || element instanceof PsiFile) {
            String name = ((PsiFileSystemItem)element).getName();
            boolean caseSensitive = this.getVirtualFile().isCaseSensitive();
            VirtualFile existing = (VirtualFile)ContainerUtil.find((Object[])this.getVirtualFile().getChildren(), item -> Comparing.strEqual((String)item.getName(), (String)name, (boolean)caseSensitive));
            if (existing != null) {
                throw new IncorrectOperationException(CoreBundle.message((String)(existing.isDirectory() ? "dir.already.exists.error" : "file.already.exists.error"), (Object[])new Object[]{existing.getPresentableUrl()}));
            }
        } else {
            throw new IncorrectOperationException(element.getClass().getName());
        }
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(33);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(34);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        try {
            this.myFile.delete((Object)this.myManager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException((Throwable)e);
        }
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkDelete(this.myFile);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(35);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(36);
        }
        visitor.visitDirectory((PsiDirectory)this);
    }

    public String toString() {
        return "PsiDirectory:" + this.myFile.getPresentableUrl();
    }

    public ASTNode getNode() {
        return null;
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    @Nullable
    public NavigationRequest navigationRequest() {
        return NavigationRequest.directoryNavigationRequest((PsiDirectory)this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().navigateToDirectory((PsiDirectory)this, requestFocus);
    }

    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            PsiDirectoryImpl.$$$reportNull$$$0(37);
        }
        info.put("fileName", this.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiDirectoryImpl directory = (PsiDirectoryImpl)o;
        if (!((Object)((Object)this.myManager)).equals((Object)directory.myManager)) {
            return false;
        }
        return this.myFile.equals(directory.myFile);
    }

    public int hashCode() {
        int result = ((Object)((Object)this.myManager)).hashCode();
        result = 31 * result + this.myFile.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/PsiDirectoryImpl";
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/PsiDirectoryImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubdirectories";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesImpl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubdirectory";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFileFrom";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 29: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSubdirectory";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createSubdirectory";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkCreateSubdirectory";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "copyFileFrom";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkCreateFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

