/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.configurations.meta.key.parser;

import com.intellij.ktor.configurations.meta.key.KtorMetaConfigKey;
import com.intellij.ktor.configurations.meta.key.KtorMetaConfigKeyKt;
import com.intellij.ktor.configurations.meta.key.hint.KtorHintWrapper;
import com.intellij.ktor.configurations.meta.key.parser.KtorMetaConfigKeyParserKt;
import com.intellij.ktor.configurations.meta.key.parser.model.Deprecation;
import com.intellij.ktor.configurations.meta.key.parser.model.Hint;
import com.intellij.ktor.configurations.meta.key.parser.model.HintKt;
import com.intellij.ktor.configurations.meta.key.parser.model.MetadataFormat;
import com.intellij.ktor.configurations.meta.key.parser.model.Property;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\t\u0010\u0017\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c2\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u00c2\u0003J3\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0014\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001f\u001a\u00020 H\u00d6\u0081\u0004J\n\u0010!\u001a\u00020\u0007H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ktor/configurations/meta/key/parser/MetaConfigKeyParser;", "", "module", "Lcom/intellij/openapi/module/Module;", "stream", "Ljava/io/InputStream;", "libraryName", "", "psiParent", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/openapi/module/Module;Ljava/io/InputStream;Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "jsonFormat", "Lkotlinx/serialization/json/Json;", "getKtorMetaConfigKeys", "", "Lcom/intellij/ktor/configurations/meta/key/KtorMetaConfigKey;", "getKtorMetaConfigKey", "property", "Lcom/intellij/ktor/configurations/meta/key/parser/model/Property;", "hints", "", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$ItemHint;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ktor"})
final class MetaConfigKeyParser {
    @NotNull
    private final Module module;
    @NotNull
    private final InputStream stream;
    @NotNull
    private final String libraryName;
    @Nullable
    private final PsiElement psiParent;
    @NotNull
    private final Json jsonFormat;

    public MetaConfigKeyParser(@NotNull Module module, @NotNull InputStream stream, @NotNull String libraryName, @Nullable PsiElement psiParent) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        this.module = module;
        this.stream = stream;
        this.libraryName = libraryName;
        this.psiParent = psiParent;
        this.jsonFormat = JsonKt.Json$default(null, MetaConfigKeyParser::jsonFormat$lambda$0, (int)1, null);
    }

    public /* synthetic */ MetaConfigKeyParser(Module module, InputStream inputStream, String string, PsiElement psiElement, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            psiElement = null;
        }
        this(module, inputStream, string, psiElement);
    }

    @NotNull
    public final List<KtorMetaConfigKey> getKtorMetaConfigKeys() {
        return (List)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends KtorMetaConfigKey>>, Object>(this, null){
            int label;
            final /* synthetic */ MetaConfigKeyParser this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        void $this$decodeFromStream$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Json json = MetaConfigKeyParser.access$getJsonFormat$p(this.this$0);
                        InputStream stream$iv = MetaConfigKeyParser.access$getStream$p(this.this$0);
                        boolean $i$f$decodeFromStream = false;
                        $this$decodeFromStream$iv.getSerializersModule();
                        MetadataFormat metadataFormat = (MetadataFormat)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)MetadataFormat.Companion.serializer()), (InputStream)stream$iv);
                        List<Property> properties = metadataFormat.component2();
                        List<Hint> hints = metadataFormat.component3();
                        Map<String, MetaConfigKey.ItemHint> keyHints = HintKt.toMetaConfigKeyHints((Collection<Hint>)hints);
                        Iterable iterable = properties;
                        MetaConfigKeyParser metaConfigKeyParser = this.this$0;
                        boolean $i$f$map = false;
                        void var9_10 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Property property2 = (Property)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(MetaConfigKeyParser.access$getKtorMetaConfigKey(metaConfigKeyParser, (Property)it, keyHints));
                        }
                        return (List)destination$iv$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<KtorMetaConfigKey>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final KtorMetaConfigKey getKtorMetaConfigKey(Property property2, Map<String, ? extends MetaConfigKey.ItemHint> hints) {
        String configKeyName = property2.getName();
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Pair<PsiType, MetaConfigKey.AccessType> pair = property2.getPsiTypeToAccessType(project);
        PsiType psiType = (PsiType)pair.component1();
        MetaConfigKey.AccessType accessType = (MetaConfigKey.AccessType)pair.component2();
        PsiNamedElement keyElement = KtorMetaConfigKeyParserKt.access$getConfigKeyPsiElement(this.module, this.libraryName, this.psiParent, configKeyName, psiType);
        KtorHintWrapper ktorHint = KtorHintWrapper.Companion.getKtorHintWrapper(hints, configKeyName, accessType);
        PsiElement psiElement = (PsiElement)keyElement;
        MetaConfigKey.DescriptionText descriptionText = KtorMetaConfigKeyKt.getDescription(property2.getDescription());
        String string = property2.getDefaultValue();
        Deprecation deprecation = property2.getDeprecation();
        if (deprecation == null || (deprecation = deprecation.toMetaConfigKeyDeprecation()) == null) {
            deprecation = MetaConfigKey.Deprecation.NOT_DEPRECATED;
        }
        Deprecation deprecation2 = deprecation;
        Intrinsics.checkNotNull((Object)deprecation2);
        return new KtorMetaConfigKey(configKeyName, psiElement, psiType, accessType, descriptionText, string, (MetaConfigKey.Deprecation)deprecation2, ktorHint);
    }

    private final Module component1() {
        return this.module;
    }

    private final InputStream component2() {
        return this.stream;
    }

    private final String component3() {
        return this.libraryName;
    }

    private final PsiElement component4() {
        return this.psiParent;
    }

    @NotNull
    public final MetaConfigKeyParser copy(@NotNull Module module, @NotNull InputStream stream, @NotNull String libraryName, @Nullable PsiElement psiParent) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        return new MetaConfigKeyParser(module, stream, libraryName, psiParent);
    }

    public static /* synthetic */ MetaConfigKeyParser copy$default(MetaConfigKeyParser metaConfigKeyParser, Module module, InputStream inputStream, String string, PsiElement psiElement, int n, Object object) {
        if ((n & 1) != 0) {
            module = metaConfigKeyParser.module;
        }
        if ((n & 2) != 0) {
            inputStream = metaConfigKeyParser.stream;
        }
        if ((n & 4) != 0) {
            string = metaConfigKeyParser.libraryName;
        }
        if ((n & 8) != 0) {
            psiElement = metaConfigKeyParser.psiParent;
        }
        return metaConfigKeyParser.copy(module, inputStream, string, psiElement);
    }

    @NotNull
    public String toString() {
        return "MetaConfigKeyParser(module=" + this.module + ", stream=" + this.stream + ", libraryName=" + this.libraryName + ", psiParent=" + this.psiParent + ")";
    }

    public int hashCode() {
        int result = this.module.hashCode();
        result = result * 31 + this.stream.hashCode();
        result = result * 31 + this.libraryName.hashCode();
        result = result * 31 + (this.psiParent == null ? 0 : this.psiParent.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MetaConfigKeyParser)) {
            return false;
        }
        MetaConfigKeyParser metaConfigKeyParser = (MetaConfigKeyParser)other;
        if (!Intrinsics.areEqual((Object)this.module, (Object)metaConfigKeyParser.module)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stream, (Object)metaConfigKeyParser.stream)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.libraryName, (Object)metaConfigKeyParser.libraryName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.psiParent, (Object)metaConfigKeyParser.psiParent);
    }

    private static final Unit jsonFormat$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Json access$getJsonFormat$p(MetaConfigKeyParser $this) {
        return $this.jsonFormat;
    }

    public static final /* synthetic */ InputStream access$getStream$p(MetaConfigKeyParser $this) {
        return $this.stream;
    }

    public static final /* synthetic */ KtorMetaConfigKey access$getKtorMetaConfigKey(MetaConfigKeyParser $this, Property property2, Map hints) {
        return $this.getKtorMetaConfigKey(property2, hints);
    }
}

