/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions.scheme;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.config.SerializationHelper;
import com.intellij.internal.statistic.devkit.actions.TestParseEventsSchemeDialog;
import com.intellij.internal.statistic.devkit.actions.scheme.EventsSchemeJsonSchemaProviderFactoryKt;
import com.intellij.internal.statistic.devkit.actions.scheme.EventsTestSchemeGroupConfiguration;
import com.intellij.internal.statistic.eventLog.events.scheme.EventDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.FieldDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import com.intellij.internal.statistic.eventLog.validator.storage.GroupValidationTestRule;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.TextFieldCompletionProviderDumbAware;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.JBDimension;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import com.jetbrains.jsonSchema.impl.inspections.JsonSchemaComplianceInspection;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u000245BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\rH\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010+\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010,\u001a\u00020 H\u0002J\u0010\u0010-\u001a\u00020\r2\b\u0010.\u001a\u0004\u0018\u00010\u0007J\b\u0010/\u001a\u00020\rH\u0002J\u0006\u00100\u001a\u00020\u001dJ\b\u00101\u001a\u00020\rH\u0016J\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "productionGroups", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;", "initialGroup", "Lcom/intellij/internal/statistic/eventLog/validator/storage/GroupValidationTestRule;", "generatedScheme", "", "Lcom/intellij/internal/statistic/eventLog/events/scheme/GroupDescriptor;", "groupIdChangeListener", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;Lcom/intellij/internal/statistic/eventLog/validator/storage/GroupValidationTestRule;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "groupIdTextField", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "getGroupIdTextField", "()Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "currentGroup", "allowAllEventsRadioButton", "Lcom/intellij/ui/components/JBRadioButton;", "customRulesRadioButton", "generateSchemeButton", "Ljavax/swing/JComponent;", "validationRulesEditorComponent", "tempFile", "Lcom/intellij/psi/PsiFile;", "validationRulesEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "eventsScheme", "", "", "createCustomRules", "Lcom/intellij/openapi/ui/DialogPanel;", "updateGenerateSchemeButton", "createCompletionProvider", "Lcom/intellij/util/TextFieldCompletionProviderDumbAware;", "createEditor", "file", "updatePanel", "newGroup", "updateRulesOption", "getFocusedComponent", "dispose", "validate", "Lcom/intellij/openapi/ui/ValidationInfo;", "Companion", "ProductionRules", "intellij.platform.statistics.devkit"})
@SourceDebugExtension(value={"SMAP\nEventsTestSchemeGroupConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsTestSchemeGroupConfiguration.kt\ncom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,355:1\n13#2:356\n*S KotlinDebug\n*F\n+ 1 EventsTestSchemeGroupConfiguration.kt\ncom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration\n*L\n250#1:356\n*E\n"})
public final class EventsTestSchemeGroupConfiguration
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final TextFieldWithCompletion groupIdTextField;
    @NotNull
    private GroupValidationTestRule currentGroup;
    private JBRadioButton allowAllEventsRadioButton;
    private JBRadioButton customRulesRadioButton;
    private JComponent generateSchemeButton;
    @NotNull
    private final JComponent validationRulesEditorComponent;
    @NotNull
    private final PsiFile tempFile;
    @NotNull
    private final EditorEx validationRulesEditor;
    @NotNull
    private final Map<String, String> eventsScheme;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<ProductionRules> FUS_TEST_SCHEME_COMMON_RULES_KEY;

    public EventsTestSchemeGroupConfiguration(@NotNull Project project, @NotNull EventGroupRemoteDescriptors productionGroups, @NotNull GroupValidationTestRule initialGroup, @NotNull List<GroupDescriptor> generatedScheme, final @Nullable Function1<? super GroupValidationTestRule, Unit> groupIdChangeListener) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)productionGroups, (String)"productionGroups");
        Intrinsics.checkNotNullParameter((Object)initialGroup, (String)"initialGroup");
        Intrinsics.checkNotNullParameter(generatedScheme, (String)"generatedScheme");
        this.project = project;
        this.currentGroup = initialGroup;
        this.eventsScheme = Companion.createEventsScheme$intellij_platform_statistics_devkit(generatedScheme);
        this.groupIdTextField = new TextFieldWithCompletion(this.project, (TextCompletionProvider)this.createCompletionProvider(productionGroups), initialGroup.getGroupId(), true, true, true);
        this.groupIdTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                GroupValidationTestRule groupValidationTestRule = currentGroup;
                String string = this.getGroupIdTextField().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                groupValidationTestRule.setGroupId(string);
                if (groupIdChangeListener != null) {
                    groupIdChangeListener.invoke((Object)currentGroup);
                }
                this.updateGenerateSchemeButton();
            }
        });
        PsiFile psiFile = TestParseEventsSchemeDialog.createTempFile(this.project, "event-log-validation-rules", this.currentGroup.getCustomRules());
        Intrinsics.checkNotNull((Object)psiFile);
        this.tempFile = psiFile;
        this.tempFile.getVirtualFile().putUserData(EventsSchemeJsonSchemaProviderFactoryKt.getEVENTS_TEST_SCHEME_VALIDATION_RULES_KEY(), (Object)true);
        this.tempFile.putUserData(FUS_TEST_SCHEME_COMMON_RULES_KEY, (Object)new ProductionRules(productionGroups.rules));
        this.validationRulesEditor = this.createEditor(this.project, this.tempFile);
        this.validationRulesEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                GroupValidationTestRule groupValidationTestRule = currentGroup;
                String string = validationRulesEditor.getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                groupValidationTestRule.setCustomRules(string);
            }
        });
        JComponent jComponent = this.validationRulesEditor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        this.validationRulesEditorComponent = jComponent;
        this.panel = (JPanel)BuilderKt.panel(arg_0 -> EventsTestSchemeGroupConfiguration._init_$lambda$0(this, initialGroup, arg_0));
        this.updateRulesOption();
    }

    public /* synthetic */ EventsTestSchemeGroupConfiguration(Project project, EventGroupRemoteDescriptors eventGroupRemoteDescriptors, GroupValidationTestRule groupValidationTestRule, List list, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        this(project, eventGroupRemoteDescriptors, groupValidationTestRule, list, (Function1<? super GroupValidationTestRule, Unit>)function1);
    }

    @NotNull
    public final JPanel getPanel() {
        return this.panel;
    }

    @NotNull
    public final TextFieldWithCompletion getGroupIdTextField() {
        return this.groupIdTextField;
    }

    private final DialogPanel createCustomRules() {
        DialogPanel dialogPanel;
        DialogPanel $this$createCustomRules_u24lambda_u241 = dialogPanel = BuilderKt.panel(arg_0 -> EventsTestSchemeGroupConfiguration.createCustomRules$lambda$0(this, arg_0));
        boolean bl = false;
        $this$createCustomRules_u24lambda_u241.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, (Object)UnscaledGapsKt.UnscaledGaps$default((int)0, (int)2, (int)0, (int)0, (int)13, null));
        return dialogPanel;
    }

    private final void updateGenerateSchemeButton() {
        JBRadioButton jBRadioButton = this.customRulesRadioButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customRulesRadioButton");
            jBRadioButton = null;
        }
        boolean useCustomRules = jBRadioButton.isSelected();
        JComponent jComponent = this.generateSchemeButton;
        if (jComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generateSchemeButton");
            jComponent = null;
        }
        jComponent.setEnabled(useCustomRules && this.eventsScheme.get(this.groupIdTextField.getText()) != null);
        JComponent jComponent2 = this.generateSchemeButton;
        if (jComponent2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generateSchemeButton");
            jComponent2 = null;
        }
        if (!jComponent2.isEnabled()) {
            JComponent jComponent3 = this.generateSchemeButton;
            if (jComponent3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"generateSchemeButton");
                jComponent3 = null;
            }
            jComponent3.setToolTipText(StatisticsBundle.message((String)"stats.scheme.generation.available.only.for.new.api", (Object[])new Object[0]));
        } else {
            JComponent jComponent4 = this.generateSchemeButton;
            if (jComponent4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"generateSchemeButton");
                jComponent4 = null;
            }
            jComponent4.setToolTipText(null);
        }
    }

    private final TextFieldCompletionProviderDumbAware createCompletionProvider(EventGroupRemoteDescriptors productionGroups) {
        return new TextFieldCompletionProviderDumbAware(this, productionGroups){
            final /* synthetic */ EventsTestSchemeGroupConfiguration this$0;
            final /* synthetic */ EventGroupRemoteDescriptors $productionGroups;
            {
                this.this$0 = $receiver;
                this.$productionGroups = $productionGroups;
            }

            /*
             * WARNING - void declaration
             */
            protected void addCompletionVariants(String text, int offset, String prefix, CompletionResultSet result) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                Iterable iterable = EventsTestSchemeGroupConfiguration.access$getEventsScheme$p(this.this$0).keySet();
                EventsTestSchemeGroupConfiguration eventsTestSchemeGroupConfiguration = this.this$0;
                boolean $i$f$map = false;
                void var9_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(LookupElementBuilder.create((String)it).withInsertHandler((arg_0, arg_1) -> createCompletionProvider.1.addCompletionVariants$lambda$0$0(eventsTestSchemeGroupConfiguration, arg_0, arg_1)));
                }
                List generatedSchemeVariants = (List)destination$iv$iv;
                result.addAllElements((Iterable)generatedSchemeVariants);
                List productionGroupsVariants = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.$productionGroups.groups), createCompletionProvider.1::addCompletionVariants$lambda$1), arg_0 -> createCompletionProvider.1.addCompletionVariants$lambda$2(this.this$0, arg_0)), arg_0 -> createCompletionProvider.1.addCompletionVariants$lambda$3(this.this$0, arg_0)));
                result.addAllElements((Iterable)productionGroupsVariants);
            }

            private static final void addCompletionVariants$lambda$0$0$0(EventsTestSchemeGroupConfiguration this$0, String $scheme) {
                EventsTestSchemeGroupConfiguration.access$getValidationRulesEditor$p(this$0).getDocument().setText((CharSequence)$scheme);
            }

            private static final void addCompletionVariants$lambda$0$0(EventsTestSchemeGroupConfiguration this$0, InsertionContext insertionContext, LookupElement item) {
                Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                String scheme = (String)EventsTestSchemeGroupConfiguration.access$getEventsScheme$p(this$0).get(item.getLookupString());
                if (scheme != null) {
                    JBRadioButton jBRadioButton = EventsTestSchemeGroupConfiguration.access$getCustomRulesRadioButton$p(this$0);
                    if (jBRadioButton == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"customRulesRadioButton");
                        jBRadioButton = null;
                    }
                    jBRadioButton.setSelected(true);
                    WriteAction.run(() -> createCompletionProvider.1.addCompletionVariants$lambda$0$0$0(this$0, scheme));
                }
            }

            private static final void addCompletionVariants$lambda$3$0$0(EventsTestSchemeGroupConfiguration this$0) {
                EventsTestSchemeGroupConfiguration.access$getValidationRulesEditor$p(this$0).getDocument().setText((CharSequence)"{\n    \"event_id\": [],\n    \"event_data\": {}\n  }");
            }

            private static final void addCompletionVariants$lambda$3$0(EventsTestSchemeGroupConfiguration this$0, InsertionContext insertionContext, LookupElement lookupElement) {
                Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<unused var>");
                JBRadioButton jBRadioButton = EventsTestSchemeGroupConfiguration.access$getAllowAllEventsRadioButton$p(this$0);
                if (jBRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"allowAllEventsRadioButton");
                    jBRadioButton = null;
                }
                jBRadioButton.setSelected(true);
                WriteAction.run(() -> createCompletionProvider.1.addCompletionVariants$lambda$3$0$0(this$0));
            }

            private static final String addCompletionVariants$lambda$1(EventGroupRemoteDescriptors.EventGroupRemoteDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.id;
            }

            private static final boolean addCompletionVariants$lambda$2(EventsTestSchemeGroupConfiguration this$0, String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return EventsTestSchemeGroupConfiguration.access$getEventsScheme$p(this$0).keySet().contains(it);
            }

            private static final LookupElementBuilder addCompletionVariants$lambda$3(EventsTestSchemeGroupConfiguration this$0, String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LookupElementBuilder.create((String)it).withInsertHandler((arg_0, arg_1) -> createCompletionProvider.1.addCompletionVariants$lambda$3$0(this$0, arg_0, arg_1));
            }
        };
    }

    private final EditorEx createEditor(Project project, PsiFile file) {
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            document = EditorFactory.getInstance().createDocument((CharSequence)this.currentGroup.getCustomRules());
        }
        VirtualFile virtualFile = file.getVirtualFile();
        Editor editor = EditorFactory.getInstance().createEditor(document, project, virtualFile, false);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        editor2.setFile(virtualFile);
        editor2.getSettings().setLineMarkerAreaShown(false);
        editor2.getSettings().setFoldingOutlineShown(false);
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName("JSON");
        LightVirtualFile lightFile = new LightVirtualFile("Dummy.json", fileType, (CharSequence)"");
        EditorHighlighter highlighter = EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter(project, (VirtualFile)lightFile);
        try {
            editor2.setHighlighter(highlighter);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
        return editor2;
    }

    public final void updatePanel(@Nullable GroupValidationTestRule newGroup) {
        if (newGroup == null) {
            return;
        }
        this.currentGroup = newGroup;
        this.groupIdTextField.setText(newGroup.getGroupId());
        this.groupIdTextField.requestFocusInWindow();
        if (newGroup.getUseCustomRules()) {
            JBRadioButton jBRadioButton = this.customRulesRadioButton;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customRulesRadioButton");
                jBRadioButton = null;
            }
            jBRadioButton.setSelected(true);
        } else {
            JBRadioButton jBRadioButton = this.allowAllEventsRadioButton;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"allowAllEventsRadioButton");
                jBRadioButton = null;
            }
            jBRadioButton.setSelected(true);
        }
        WriteAction.run(() -> EventsTestSchemeGroupConfiguration.updatePanel$lambda$0(this, newGroup));
    }

    private final void updateRulesOption() {
        this.updateGenerateSchemeButton();
        JBRadioButton jBRadioButton = this.customRulesRadioButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customRulesRadioButton");
            jBRadioButton = null;
        }
        this.currentGroup.setUseCustomRules(jBRadioButton.isSelected());
    }

    @NotNull
    public final JComponent getFocusedComponent() {
        return (JComponent)this.groupIdTextField;
    }

    public void dispose() {
        WriteCommandAction.writeCommandAction((Project)this.project).run(() -> EventsTestSchemeGroupConfiguration.dispose$lambda$0(this));
        if (!this.validationRulesEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.validationRulesEditor);
        }
    }

    @NotNull
    public final List<ValidationInfo> validate() {
        return EventsTestSchemeGroupConfiguration.Companion.validateTestSchemeGroup(this.project, this.currentGroup, (JComponent)this.groupIdTextField, this.tempFile);
    }

    private static final Unit lambda$0$0$0(TextFieldWithCompletion $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setMinimumSize((Dimension)new JBDimension(200, 1));
        return Unit.INSTANCE;
    }

    private static final void lambda$0$1$0$0$0(EventsTestSchemeGroupConfiguration this$0, ChangeEvent it) {
        this$0.updateRulesOption();
    }

    private static final Unit lambda$0$1$0$0(EventsTestSchemeGroupConfiguration this$0, JBRadioButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addChangeListener(arg_0 -> EventsTestSchemeGroupConfiguration.lambda$0$1$0$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final void lambda$0$1$1$0$0(EventsTestSchemeGroupConfiguration this$0, ChangeEvent it) {
        this$0.updateRulesOption();
    }

    private static final Unit lambda$0$1$1$0(Row $this_row, EventsTestSchemeGroupConfiguration this$0, JBRadioButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        Icon icon = AllIcons.General.BalloonWarning12;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BalloonWarning12");
        $this_row.icon(icon);
        $this$applyToComponent.addChangeListener(arg_0 -> EventsTestSchemeGroupConfiguration.lambda$0$1$1$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1$0(EventsTestSchemeGroupConfiguration this$0, GroupValidationTestRule $initialGroup, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = StatisticsBundle.message((String)"stats.use.custom.validation.rules", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null);
        String string2 = StatisticsBundle.message((String)"stats.test.scheme.custom.rules.help", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this$0.customRulesRadioButton = (JBRadioButton)ButtonKt.selected((Cell)Cell.contextHelp$default((Cell)cell, (String)string2, null, (int)2, null), (boolean)$initialGroup.getUseCustomRules()).applyToComponent(arg_0 -> EventsTestSchemeGroupConfiguration.lambda$0$1$0$0(this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1$1(EventsTestSchemeGroupConfiguration this$0, GroupValidationTestRule $initialGroup, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = StatisticsBundle.message((String)"stats.allow.all.events", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null);
        String string2 = StatisticsBundle.message((String)"stats.allow.all.events.help", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this$0.allowAllEventsRadioButton = (JBRadioButton)ButtonKt.selected((Cell)Cell.contextHelp$default((Cell)cell, (String)string2, null, (int)2, null), (!$initialGroup.getUseCustomRules() ? 1 : 0) != 0).applyToComponent(arg_0 -> EventsTestSchemeGroupConfiguration.lambda$0$1$1$0($this$row, this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(EventsTestSchemeGroupConfiguration this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.groupIdTextField).applyToComponent(EventsTestSchemeGroupConfiguration::lambda$0$0$0).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1(EventsTestSchemeGroupConfiguration this$0, GroupValidationTestRule $initialGroup, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> EventsTestSchemeGroupConfiguration.lambda$0$1$0(this$0, $initialGroup, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> EventsTestSchemeGroupConfiguration.lambda$0$1$1(this$0, $initialGroup, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2(EventsTestSchemeGroupConfiguration this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.createCustomRules()).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(EventsTestSchemeGroupConfiguration this$0, GroupValidationTestRule $initialGroup, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = StatisticsBundle.message((String)"stats.group.id", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> EventsTestSchemeGroupConfiguration.lambda$0$0(this$0, arg_0));
        Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> EventsTestSchemeGroupConfiguration.lambda$0$1(this$0, $initialGroup, arg_0), (int)3, null);
        Row row = Panel.row$default((Panel)$this$panel, null, arg_0 -> EventsTestSchemeGroupConfiguration.lambda$0$2(this$0, arg_0), (int)1, null).resizableRow();
        JBRadioButton jBRadioButton = this$0.customRulesRadioButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customRulesRadioButton");
            jBRadioButton = null;
        }
        row.visibleIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBRadioButton)));
        return Unit.INSTANCE;
    }

    private static final void createCustomRules$lambda$0$1$0$0(EventsTestSchemeGroupConfiguration this$0, String $scheme) {
        this$0.validationRulesEditor.getDocument().setText((CharSequence)$scheme);
    }

    private static final Unit createCustomRules$lambda$0$1$0(EventsTestSchemeGroupConfiguration this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String scheme = this$0.eventsScheme.get(this$0.groupIdTextField.getText());
        if (scheme != null) {
            WriteAction.run(() -> EventsTestSchemeGroupConfiguration.createCustomRules$lambda$0$1$0$0(this$0, scheme));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCustomRules$lambda$0$0(EventsTestSchemeGroupConfiguration this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell(this$0.validationRulesEditorComponent).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createCustomRules$lambda$0$1(EventsTestSchemeGroupConfiguration this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.generateSchemeButton = $this$row.button("Generate Scheme", arg_0 -> EventsTestSchemeGroupConfiguration.createCustomRules$lambda$0$1$0(this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCustomRules$lambda$0$2(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = StatisticsBundle.message((String)"stats.validation.rules.format", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCustomRules$lambda$0(EventsTestSchemeGroupConfiguration this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> EventsTestSchemeGroupConfiguration.createCustomRules$lambda$0$0(this$0, arg_0), (int)1, null).resizableRow();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> EventsTestSchemeGroupConfiguration.createCustomRules$lambda$0$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, EventsTestSchemeGroupConfiguration::createCustomRules$lambda$0$2, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void updatePanel$lambda$0(EventsTestSchemeGroupConfiguration this$0, GroupValidationTestRule $newGroup) {
        this$0.validationRulesEditor.getDocument().setText((CharSequence)$newGroup.getCustomRules());
    }

    private static final void dispose$lambda$0(EventsTestSchemeGroupConfiguration this$0) {
        try {
            this$0.tempFile.delete();
        }
        catch (IncorrectOperationException e) {
            LOG.warn((Throwable)e);
        }
    }

    public static final /* synthetic */ Map access$getEventsScheme$p(EventsTestSchemeGroupConfiguration $this) {
        return $this.eventsScheme;
    }

    public static final /* synthetic */ JBRadioButton access$getCustomRulesRadioButton$p(EventsTestSchemeGroupConfiguration $this) {
        return $this.customRulesRadioButton;
    }

    public static final /* synthetic */ JBRadioButton access$getAllowAllEventsRadioButton$p(EventsTestSchemeGroupConfiguration $this) {
        return $this.allowAllEventsRadioButton;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EventsTestSchemeGroupConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"statistics.test.scheme.validation.rules.file");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        FUS_TEST_SCHEME_COMMON_RULES_KEY = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J0\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J-\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b\u001bJ'\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000eH\u0000\u00a2\u0006\u0002\b J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u001fH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "FUS_TEST_SCHEME_COMMON_RULES_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration$ProductionRules;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getFUS_TEST_SCHEME_COMMON_RULES_KEY$intellij_platform_statistics_devkit", "()Lcom/intellij/openapi/util/Key;", "validateTestSchemeGroup", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "project", "Lcom/intellij/openapi/project/Project;", "testSchemeGroup", "Lcom/intellij/internal/statistic/eventLog/validator/storage/GroupValidationTestRule;", "groupIdTextField", "Ljavax/swing/JComponent;", "customRulesFile", "Lcom/intellij/psi/PsiFile;", "validateCustomValidationRules", "customRules", "", "validateCustomValidationRules$intellij_platform_statistics_devkit", "createEventsScheme", "Ljava/util/HashMap;", "generatedScheme", "Lcom/intellij/internal/statistic/eventLog/events/scheme/GroupDescriptor;", "createEventsScheme$intellij_platform_statistics_devkit", "createValidationRules", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors$GroupRemoteRule;", "group", "isValidJson", "", "intellij.platform.statistics.devkit"})
    @SourceDebugExtension(value={"SMAP\nEventsTestSchemeGroupConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsTestSchemeGroupConfiguration.kt\ncom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n1586#2:356\n1661#2,3:357\n*S KotlinDebug\n*F\n+ 1 EventsTestSchemeGroupConfiguration.kt\ncom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration$Companion\n*L\n295#1:356\n295#1:357,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<ProductionRules> getFUS_TEST_SCHEME_COMMON_RULES_KEY$intellij_platform_statistics_devkit() {
            return FUS_TEST_SCHEME_COMMON_RULES_KEY;
        }

        @NotNull
        public final List<ValidationInfo> validateTestSchemeGroup(@NotNull Project project, @NotNull GroupValidationTestRule testSchemeGroup, @NotNull JComponent groupIdTextField) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)testSchemeGroup, (String)"testSchemeGroup");
            Intrinsics.checkNotNullParameter((Object)groupIdTextField, (String)"groupIdTextField");
            return this.validateTestSchemeGroup(project, testSchemeGroup, groupIdTextField, null);
        }

        private final List<ValidationInfo> validateTestSchemeGroup(Project project, GroupValidationTestRule testSchemeGroup, JComponent groupIdTextField, PsiFile customRulesFile) {
            String groupId = testSchemeGroup.getGroupId();
            List validationInfo = new ArrayList();
            if (((CharSequence)groupId).length() == 0) {
                validationInfo.add(new ValidationInfo(StatisticsBundle.message((String)"stats.specify.group.id", (Object[])new Object[0]), groupIdTextField));
            }
            if (testSchemeGroup.getUseCustomRules()) {
                validationInfo.addAll((Collection)this.validateCustomValidationRules$intellij_platform_statistics_devkit(project, testSchemeGroup.getCustomRules(), customRulesFile));
            }
            return validationInfo;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ValidationInfo> validateCustomValidationRules$intellij_platform_statistics_devkit(@NotNull Project project, @NotNull String customRules, @Nullable PsiFile customRulesFile) {
            void $this$mapTo$iv$iv;
            PsiFile psiFile;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)customRules, (String)"customRules");
            if (StringsKt.isBlank((CharSequence)customRules)) {
                return CollectionsKt.listOf((Object)new ValidationInfo(StatisticsBundle.message((String)"stats.unable.to.parse.validation.rules", (Object[])new Object[0])));
            }
            if (!this.isValidJson(customRules)) {
                return CollectionsKt.listOf((Object)new ValidationInfo(StatisticsBundle.message((String)"stats.unable.to.parse.validation.rules", (Object[])new Object[0])));
            }
            if (project == ProjectManager.getInstance().getDefaultProject()) {
                return CollectionsKt.emptyList();
            }
            if (customRulesFile != null) {
                psiFile = customRulesFile;
            } else {
                PsiFile psiFile2 = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)JsonLanguage.INSTANCE, (CharSequence)customRules);
                psiFile2.getVirtualFile().putUserData(EventsSchemeJsonSchemaProviderFactoryKt.getEVENTS_TEST_SCHEME_VALIDATION_RULES_KEY(), (Object)true);
                psiFile = psiFile2;
            }
            PsiFile file = psiFile;
            Map map2 = InspectionEngine.inspectEx(Collections.singletonList(new LocalInspectionToolWrapper((LocalInspectionTool)new JsonSchemaComplianceInspection())), (PsiFile)file, (TextRange)file.getTextRange(), (TextRange)file.getTextRange(), (boolean)true, (boolean)false, (boolean)true, (ProgressIndicator)((ProgressIndicator)new DaemonProgressIndicator()), (PairProcessor)PairProcessor.alwaysTrue());
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"inspectEx(...)");
            Map map3 = map2;
            Iterable $this$map$iv = CollectionsKt.flatten((Iterable)map3.values());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void descriptor;
                ProblemDescriptor problemDescriptor = (ProblemDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ValidationInfo("Line " + (descriptor.getLineNumber() + 1) + ": " + descriptor.getDescriptionTemplate()));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final HashMap<String, String> createEventsScheme$intellij_platform_statistics_devkit(@NotNull List<GroupDescriptor> generatedScheme) {
            Intrinsics.checkNotNullParameter(generatedScheme, (String)"generatedScheme");
            HashMap<String, String> eventsScheme = new HashMap<String, String>();
            for (GroupDescriptor group : generatedScheme) {
                EventGroupRemoteDescriptors.GroupRemoteRule validationRules = this.createValidationRules(group);
                if (validationRules == null) continue;
                ((Map)eventsScheme).put(group.getId(), SerializationHelper.INSTANCE.serialize((Object)validationRules));
            }
            return eventsScheme;
        }

        private final EventGroupRemoteDescriptors.GroupRemoteRule createValidationRules(GroupDescriptor group) {
            HashSet<String> eventIds = new HashSet<String>();
            HashMap eventData = new HashMap();
            Set events = group.getSchema();
            for (EventDescriptor event : events) {
                eventIds.add(event.getEvent());
                for (FieldDescriptor dataField : event.getFields()) {
                    Set validationRule = dataField.getValue();
                    Set validationRules = (Set)eventData.get(dataField.getPath());
                    if (validationRules == null) {
                        ((Map)eventData).put(dataField.getPath(), CollectionsKt.toHashSet((Iterable)validationRule));
                        continue;
                    }
                    validationRules.addAll(validationRule);
                }
            }
            if (eventIds.isEmpty() && eventData.isEmpty()) {
                return null;
            }
            EventGroupRemoteDescriptors.GroupRemoteRule rules = new EventGroupRemoteDescriptors.GroupRemoteRule(null, null, null, null, null, 31, null);
            rules.event_id = eventIds;
            rules.setEvent_data((Map)eventData);
            return rules;
        }

        private final boolean isValidJson(String customRules) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                mapper.readTree(customRules);
                return true;
            }
            catch (JacksonException e) {
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0013\b\u0016\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0006\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration$ProductionRules;", "", "regexps", "", "", "enums", "<init>", "(Ljava/util/Set;Ljava/util/Set;)V", "rules", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors$GroupRemoteRule;", "(Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors$GroupRemoteRule;)V", "getRegexps", "()Ljava/util/Set;", "getEnums", "intellij.platform.statistics.devkit"})
    public static final class ProductionRules {
        @NotNull
        private final Set<String> regexps;
        @NotNull
        private final Set<String> enums;

        public ProductionRules(@NotNull Set<String> regexps, @NotNull Set<String> enums) {
            Intrinsics.checkNotNullParameter(regexps, (String)"regexps");
            Intrinsics.checkNotNullParameter(enums, (String)"enums");
            this.regexps = regexps;
            this.enums = enums;
        }

        @NotNull
        public final Set<String> getRegexps() {
            return this.regexps;
        }

        @NotNull
        public final Set<String> getEnums() {
            return this.enums;
        }

        public ProductionRules(@Nullable EventGroupRemoteDescriptors.GroupRemoteRule rules) {
            Object object;
            Object object2 = rules;
            if (object2 == null || (object2 = ((EventGroupRemoteDescriptors.GroupRemoteRule)object2).regexps) == null || (object2 = object2.keySet()) == null) {
                object2 = SetsKt.emptySet();
            }
            if ((object = rules) == null || (object = object.getEnums()) == null || (object = object.keySet()) == null) {
                object = SetsKt.emptySet();
            }
            this((Set<String>)object2, (Set<String>)object);
        }
    }
}

