/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.error.ShouldNotBeNull;

public class InstanceOfAssertFactory<T, ASSERT extends AbstractAssert<?, ?>>
implements AssertFactory<Object, ASSERT> {
    private final Type type;
    private final Class<T> rawClass;
    private final AssertFactory<T, ASSERT> delegate;

    public InstanceOfAssertFactory(Class<T> type, AssertFactory<T, ASSERT> delegate) {
        this(type, type, delegate);
    }

    public InstanceOfAssertFactory(Class<T> rawClass, Type[] typeArguments, AssertFactory<T, ASSERT> delegate) {
        this(new SyntheticParameterizedType(rawClass, typeArguments), rawClass, delegate);
    }

    private InstanceOfAssertFactory(Type type, Class<T> rawClass, AssertFactory<T, ASSERT> delegate) {
        this.type = Objects.requireNonNull(type, ShouldNotBeNull.shouldNotBeNull("type")::create);
        this.rawClass = Objects.requireNonNull(rawClass, ShouldNotBeNull.shouldNotBeNull("rawClass")::create);
        this.delegate = Objects.requireNonNull(delegate, ShouldNotBeNull.shouldNotBeNull("delegate")::create);
    }

    Class<T> getRawClass() {
        return this.rawClass;
    }

    @Override
    public ASSERT createAssert(Object actual) {
        return (ASSERT)((AbstractAssert)this.delegate.createAssert(this.rawClass.cast(actual)));
    }

    @Override
    public ASSERT createAssert(AssertFactory.ValueProvider<?> valueProvider) {
        Object actual = valueProvider.apply(this.type);
        return (ASSERT)this.createAssert(actual);
    }

    public String toString() {
        return "InstanceOfAssertFactory for " + this.type.getTypeName();
    }

    private static final class SyntheticParameterizedType
    implements ParameterizedType,
    Serializable {
        private final Class<?> rawClass;
        private final Type[] typeArguments;

        public SyntheticParameterizedType(Class<?> rawClass, Type[] typeArguments) {
            this.rawClass = Objects.requireNonNull(rawClass, ShouldNotBeNull.shouldNotBeNull("rawClass")::create);
            this.typeArguments = Objects.requireNonNull(typeArguments, ShouldNotBeNull.shouldNotBeNull("typeArguments")::create);
        }

        @Override
        public String getTypeName() {
            return this.rawClass.getTypeName() + Arrays.stream(this.typeArguments).map(Type::getTypeName).collect(Collectors.joining(", ", "<", ">"));
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Class<?> getRawType() {
            return this.rawClass;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArguments;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType otherType = (ParameterizedType)other;
            return otherType.getOwnerType() == null && this.rawClass.equals(otherType.getRawType()) && Arrays.equals(this.typeArguments, otherType.getActualTypeArguments());
        }

        public int hashCode() {
            return Objects.hash(this.rawClass, Arrays.hashCode(this.typeArguments));
        }

        public String toString() {
            return this.getTypeName();
        }
    }
}

