/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.database.Dbms;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.impl.SqlFileImpl;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0004H\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\nH\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/dialects/mongo/js/MongoJSFileViewProvider;", "Lcom/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider;", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "mongoJSBaseLanguage", "Lcom/intellij/lang/Language;", "sqlTemplate", "Lcom/intellij/psi/tree/IElementType;", "manager", "Lcom/intellij/psi/PsiManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "eventSystemEnabled", "", "<init>", "(Lcom/intellij/lang/Language;Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "getBaseLanguage", "getLanguages", "", "getTemplateDataLanguage", "cloneInner", "fileCopy", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "intellij.database.dialects.mongo"})
public final class MongoJSFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    @NotNull
    private final Language mongoJSBaseLanguage;
    @NotNull
    private final IElementType sqlTemplate;

    public MongoJSFileViewProvider(@NotNull Language mongoJSBaseLanguage, @NotNull IElementType sqlTemplate, @NotNull PsiManager manager, @NotNull VirtualFile file, boolean eventSystemEnabled) {
        Intrinsics.checkNotNullParameter((Object)mongoJSBaseLanguage, (String)"mongoJSBaseLanguage");
        Intrinsics.checkNotNullParameter((Object)sqlTemplate, (String)"sqlTemplate");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(manager, file, eventSystemEnabled);
        this.mongoJSBaseLanguage = mongoJSBaseLanguage;
        this.sqlTemplate = sqlTemplate;
    }

    @NotNull
    public Language getBaseLanguage() {
        return this.mongoJSBaseLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Object[] objectArray = new Language[]{this.getBaseLanguage(), this.getTemplateDataLanguage()};
        return SetsKt.hashSetOf((Object[])objectArray);
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect((Dbms)Dbms.MONGO);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        return (Language)sqlLanguageDialect;
    }

    @NotNull
    protected MongoJSFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
        return new MongoJSFileViewProvider(this.mongoJSBaseLanguage, this.sqlTemplate, (PsiManager)psiManagerEx, fileCopy, false);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Language language = lang;
        if (Intrinsics.areEqual((Object)language, (Object)this.getBaseLanguage())) {
            psiFile = super.createFile(lang);
        } else if (Intrinsics.areEqual((Object)language, (Object)this.getTemplateDataLanguage())) {
            PsiFileImpl psiFileImpl;
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            PsiFile psiFile2 = parserDefinition.createFile((FileViewProvider)this);
            Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            PsiFileImpl fromParserDefinition = (PsiFileImpl)psiFile2;
            PsiFileImpl $this$createFile_u24lambda_u240 = psiFileImpl = !Intrinsics.areEqual((Object)fromParserDefinition.getLanguage(), (Object)lang) && lang instanceof SqlLanguageDialect ? (PsiFileImpl)new SqlFileImpl((FileViewProvider)this, (SqlLanguageDialect)lang) : fromParserDefinition;
            boolean bl = false;
            $this$createFile_u24lambda_u240.setContentElementType(this.sqlTemplate);
            psiFile = (PsiFile)psiFileImpl;
        } else {
            psiFile = null;
        }
        return psiFile;
    }
}

