/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemModificationType;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0004\"#$%B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u000eJ\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001e\u001a\u00020\b*\u00020\u00192\u0006\u0010\u0006\u001a\u00020\b2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0 H\u0002J(\u0010!\u001a\u00020\b*\u00020\u00192\u0006\u0010\u0006\u001a\u00020\b2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0 H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus;", "", "debugName", "", "<init>", "(Ljava/lang/String;)V", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "kotlin.jvm.PlatformType", "isDirty", "", "isUpToDate", "getModificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "markBroken", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "markDirty", "type", "markModified", "markReverted", "markSynchronized", "update", "event", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "debug", "", "newState", "oldState", "withFuture", "action", "Lkotlin/Function1;", "ifFuture", "Companion", "ProjectEvent", "ProjectState", "Stamp", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class ProjectStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String debugName;
    @NotNull
    private AtomicReference<ProjectState> state;
    @NotNull
    private static final Logger LOG;

    public ProjectStatus(@Nullable String debugName) {
        this.debugName = debugName;
        this.state = new AtomicReference<ProjectState>(new ProjectState.Synchronized(Stamp.Companion.getNONE()));
    }

    public /* synthetic */ ProjectStatus(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public final boolean isDirty() {
        return this.state.get() instanceof ProjectState.Dirty;
    }

    public final boolean isUpToDate() {
        boolean bl;
        ProjectState projectState = this.state.get();
        if (projectState instanceof ProjectState.Modified || projectState instanceof ProjectState.Dirty || projectState instanceof ProjectState.Broken) {
            bl = false;
        } else if (projectState instanceof ProjectState.Synchronized || projectState instanceof ProjectState.Reverted) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final ExternalSystemModificationType getModificationType() {
        ProjectState state = this.state.get();
        return state instanceof ProjectState.Dirty ? ((ProjectState.Dirty)state).getType() : (state instanceof ProjectState.Modified ? ((ProjectState.Modified)state).getType() : ExternalSystemModificationType.UNKNOWN);
    }

    @NotNull
    public final ProjectState markBroken(@NotNull Stamp stamp) {
        Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
        return this.update(new ProjectEvent.Break(stamp));
    }

    @NotNull
    public final ProjectState markDirty(@NotNull Stamp stamp, @NotNull ExternalSystemModificationType type) {
        Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.update(new ProjectEvent.Invalidate(stamp, type));
    }

    public static /* synthetic */ ProjectState markDirty$default(ProjectStatus projectStatus, Stamp stamp, ExternalSystemModificationType externalSystemModificationType, int n, Object object) {
        if ((n & 2) != 0) {
            externalSystemModificationType = ExternalSystemModificationType.INTERNAL;
        }
        return projectStatus.markDirty(stamp, externalSystemModificationType);
    }

    @NotNull
    public final ProjectState markModified(@NotNull Stamp stamp, @NotNull ExternalSystemModificationType type) {
        Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.update(new ProjectEvent.Modify(stamp, type));
    }

    public static /* synthetic */ ProjectState markModified$default(ProjectStatus projectStatus, Stamp stamp, ExternalSystemModificationType externalSystemModificationType, int n, Object object) {
        if ((n & 2) != 0) {
            externalSystemModificationType = ExternalSystemModificationType.INTERNAL;
        }
        return projectStatus.markModified(stamp, externalSystemModificationType);
    }

    @NotNull
    public final ProjectState markReverted(@NotNull Stamp stamp) {
        Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
        return this.update(new ProjectEvent.Revert(stamp));
    }

    @NotNull
    public final ProjectState markSynchronized(@NotNull Stamp stamp) {
        Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
        return this.update(new ProjectEvent.Synchronize(stamp));
    }

    @NotNull
    public final ProjectState update(@NotNull ProjectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AtomicReference oldState = new AtomicReference();
        ProjectState newState2 = this.state.updateAndGet(arg_0 -> ProjectStatus.update$lambda$0(oldState, event, this, arg_0));
        Intrinsics.checkNotNull((Object)newState2);
        Object v = oldState.get();
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        this.debug(newState2, (ProjectState)v, event);
        return newState2;
    }

    private final void debug(ProjectState newState2, ProjectState oldState, ProjectEvent event) {
        if (LOG.isDebugEnabled()) {
            String debugPrefix = this.debugName == null ? "" : this.debugName + ": ";
            LOG.debug(debugPrefix + oldState + " -> " + newState2 + " by " + event);
        }
    }

    private final ProjectState withFuture(ProjectEvent $this$withFuture, ProjectState state, Function1<? super Stamp, ? extends ProjectState> action2) {
        return (ProjectState)action2.invoke((Object)ComparisonsKt.maxOf((Comparable)$this$withFuture.getStamp(), (Comparable)state.getStamp()));
    }

    private final ProjectState ifFuture(ProjectEvent $this$ifFuture, ProjectState state, Function1<? super Stamp, ? extends ProjectState> action2) {
        return $this$ifFuture.getStamp().compareTo(state.getStamp()) > 0 ? (ProjectState)action2.invoke((Object)$this$ifFuture.getStamp()) : state;
    }

    private static final ProjectState update$lambda$0$0(ProjectEvent $event, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Dirty(it, ((ProjectEvent.Invalidate)$event).getType());
    }

    private static final ProjectState update$lambda$0$1(ProjectEvent $event, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Modified(it, ((ProjectEvent.Modify)$event).getType());
    }

    private static final ProjectState update$lambda$0$2(ProjectState $currentState, ProjectEvent $event, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Dirty(it, Companion.merge(((ProjectState.Dirty)$currentState).getType(), ((ProjectEvent.Invalidate)$event).getType()));
    }

    private static final ProjectState update$lambda$0$3(ProjectState $currentState, ProjectEvent $event, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Dirty(it, Companion.merge(((ProjectState.Dirty)$currentState).getType(), ((ProjectEvent.Modify)$event).getType()));
    }

    private static final ProjectState update$lambda$0$4(ProjectState $currentState, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Dirty(it, ((ProjectState.Dirty)$currentState).getType());
    }

    private static final ProjectState update$lambda$0$5(ProjectState $currentState, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Dirty(it, ((ProjectState.Dirty)$currentState).getType());
    }

    private static final ProjectState update$lambda$0$6(ProjectState $currentState, ProjectEvent $event, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Dirty(it, Companion.merge(((ProjectState.Modified)$currentState).getType(), ((ProjectEvent.Invalidate)$event).getType()));
    }

    private static final ProjectState update$lambda$0$7(ProjectState $currentState, ProjectEvent $event, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Modified(it, Companion.merge(((ProjectState.Modified)$currentState).getType(), ((ProjectEvent.Modify)$event).getType()));
    }

    private static final ProjectState update$lambda$0$8(ProjectState $currentState, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Dirty(it, ((ProjectState.Modified)$currentState).getType());
    }

    private static final ProjectState update$lambda$0$9(ProjectEvent $event, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Dirty(it, ((ProjectEvent.Invalidate)$event).getType());
    }

    private static final ProjectState update$lambda$0$10(ProjectEvent $event, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Modified(it, ((ProjectEvent.Modify)$event).getType());
    }

    private static final ProjectState update$lambda$0$11(ProjectEvent $event, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Dirty(it, ((ProjectEvent.Invalidate)$event).getType());
    }

    private static final ProjectState update$lambda$0$12(ProjectEvent $event, Stamp it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ProjectState.Dirty(it, ((ProjectEvent.Modify)$event).getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ProjectState update$lambda$0(AtomicReference $oldState, ProjectEvent $event, ProjectStatus this$0, ProjectState currentState) {
        ProjectState projectState;
        $oldState.set(currentState);
        ProjectState projectState2 = currentState;
        if (projectState2 instanceof ProjectState.Synchronized) {
            ProjectEvent projectEvent = $event;
            if (projectEvent instanceof ProjectEvent.Synchronize) {
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)update.newState.1.1.INSTANCE));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                projectState = this$0.ifFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$0($event, arg_0)));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Modify) {
                projectState = this$0.ifFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$1($event, arg_0)));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Revert) {
                projectState = this$0.ifFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)update.newState.1.4.INSTANCE));
                return projectState;
            } else {
                if (!(projectEvent instanceof ProjectEvent.Break)) throw new NoWhenBranchMatchedException();
                projectState = this$0.ifFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)update.newState.1.5.INSTANCE));
            }
            return projectState;
        } else if (projectState2 instanceof ProjectState.Dirty) {
            ProjectEvent projectEvent = $event;
            if (projectEvent instanceof ProjectEvent.Synchronize) {
                projectState = this$0.ifFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)update.newState.1.6.INSTANCE));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$2(currentState, $event, arg_0)));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Modify) {
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$3(currentState, $event, arg_0)));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Revert) {
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$4(currentState, arg_0)));
                return projectState;
            } else {
                if (!(projectEvent instanceof ProjectEvent.Break)) throw new NoWhenBranchMatchedException();
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$5(currentState, arg_0)));
            }
            return projectState;
        } else if (projectState2 instanceof ProjectState.Modified) {
            ProjectEvent projectEvent = $event;
            if (projectEvent instanceof ProjectEvent.Synchronize) {
                projectState = this$0.ifFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)update.newState.1.11.INSTANCE));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$6(currentState, $event, arg_0)));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Modify) {
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$7(currentState, $event, arg_0)));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Revert) {
                projectState = this$0.ifFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)update.newState.1.14.INSTANCE));
                return projectState;
            } else {
                if (!(projectEvent instanceof ProjectEvent.Break)) throw new NoWhenBranchMatchedException();
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$8(currentState, arg_0)));
            }
            return projectState;
        } else if (projectState2 instanceof ProjectState.Reverted) {
            ProjectEvent projectEvent = $event;
            if (projectEvent instanceof ProjectEvent.Synchronize) {
                projectState = this$0.ifFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)update.newState.1.16.INSTANCE));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$9($event, arg_0)));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Modify) {
                projectState = this$0.ifFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$10($event, arg_0)));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Revert) {
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)update.newState.1.19.INSTANCE));
                return projectState;
            } else {
                if (!(projectEvent instanceof ProjectEvent.Break)) throw new NoWhenBranchMatchedException();
                projectState = this$0.ifFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)update.newState.1.20.INSTANCE));
            }
            return projectState;
        } else {
            if (!(projectState2 instanceof ProjectState.Broken)) throw new NoWhenBranchMatchedException();
            ProjectEvent projectEvent = $event;
            if (projectEvent instanceof ProjectEvent.Synchronize) {
                projectState = this$0.ifFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)update.newState.1.21.INSTANCE));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Invalidate) {
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$11($event, arg_0)));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Modify) {
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)arg_0 -> ProjectStatus.update$lambda$0$12($event, arg_0)));
                return projectState;
            } else if (projectEvent instanceof ProjectEvent.Revert) {
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)update.newState.1.24.INSTANCE));
                return projectState;
            } else {
                if (!(projectEvent instanceof ProjectEvent.Break)) throw new NoWhenBranchMatchedException();
                projectState = this$0.withFuture($event, currentState, (Function1<? super Stamp, ? extends ProjectState>)((Function1)update.newState.1.25.INSTANCE));
            }
        }
        return projectState;
    }

    public ProjectStatus() {
        this(null, 1, null);
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.externalSystem.autoimport");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "merge", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "type1", "type2", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExternalSystemModificationType merge(@NotNull ExternalSystemModificationType type1, @NotNull ExternalSystemModificationType type2) {
            Intrinsics.checkNotNullParameter((Object)type1, (String)"type1");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type2");
            return switch (WhenMappings.$EnumSwitchMapping$0[type1.ordinal()]) {
                case 1 -> ExternalSystemModificationType.INTERNAL;
                case 2 -> {
                    switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                        case 1: {
                            yield ExternalSystemModificationType.INTERNAL;
                        }
                        case 2: {
                            yield ExternalSystemModificationType.EXTERNAL;
                        }
                        case 3: {
                            yield ExternalSystemModificationType.EXTERNAL;
                        }
                        case 4: {
                            yield ExternalSystemModificationType.EXTERNAL;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                case 3 -> {
                    switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                        case 1: {
                            yield ExternalSystemModificationType.INTERNAL;
                        }
                        case 2: {
                            yield ExternalSystemModificationType.EXTERNAL;
                        }
                        case 3: {
                            yield ExternalSystemModificationType.HIDDEN;
                        }
                        case 4: {
                            yield ExternalSystemModificationType.HIDDEN;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                case 4 -> type2;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExternalSystemModificationType.values().length];
                try {
                    nArray[ExternalSystemModificationType.INTERNAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExternalSystemModificationType.EXTERNAL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExternalSystemModificationType.HIDDEN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExternalSystemModificationType.UNKNOWN.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \r2\u00020\u0001:\u0006\b\t\n\u000b\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0005\u000e\u000f\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "", "<init>", "()V", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "getStamp", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "Synchronize", "Invalidate", "Modify", "Revert", "Break", "Companion", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Break;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Invalidate;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Modify;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Revert;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Synchronize;", "intellij.platform.externalSystem.impl"})
    public static abstract sealed class ProjectEvent {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private ProjectEvent() {
        }

        @NotNull
        public abstract Stamp getStamp();

        public /* synthetic */ ProjectEvent(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Break;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;)V", "getStamp", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
        public static final class Break
        extends ProjectEvent {
            @NotNull
            private final Stamp stamp;

            public Break(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                super(null);
                this.stamp = stamp;
            }

            @Override
            @NotNull
            public Stamp getStamp() {
                return this.stamp;
            }

            @NotNull
            public final Stamp component1() {
                return this.stamp;
            }

            @NotNull
            public final Break copy(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                return new Break(stamp);
            }

            public static /* synthetic */ Break copy$default(Break break_, Stamp stamp, int n, Object object) {
                if ((n & 1) != 0) {
                    stamp = break_.stamp;
                }
                return break_.copy(stamp);
            }

            @NotNull
            public String toString() {
                return "Break(stamp=" + this.stamp + ")";
            }

            public int hashCode() {
                return this.stamp.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Break)) {
                    return false;
                }
                Break break_ = (Break)other;
                return Intrinsics.areEqual((Object)this.stamp, (Object)break_.stamp);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Companion;", "", "<init>", "()V", "externalModify", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Modify;", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "externalInvalidate", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Invalidate;", "intellij.platform.externalSystem.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Modify externalModify(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                return new Modify(stamp, ExternalSystemModificationType.EXTERNAL);
            }

            @NotNull
            public final Invalidate externalInvalidate(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                return new Invalidate(stamp, ExternalSystemModificationType.EXTERNAL);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Invalidate;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "type", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;)V", "getStamp", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "getType", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
        public static final class Invalidate
        extends ProjectEvent {
            @NotNull
            private final Stamp stamp;
            @NotNull
            private final ExternalSystemModificationType type;

            public Invalidate(@NotNull Stamp stamp, @NotNull ExternalSystemModificationType type) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                super(null);
                this.stamp = stamp;
                this.type = type;
            }

            @Override
            @NotNull
            public Stamp getStamp() {
                return this.stamp;
            }

            @NotNull
            public final ExternalSystemModificationType getType() {
                return this.type;
            }

            @NotNull
            public final Stamp component1() {
                return this.stamp;
            }

            @NotNull
            public final ExternalSystemModificationType component2() {
                return this.type;
            }

            @NotNull
            public final Invalidate copy(@NotNull Stamp stamp, @NotNull ExternalSystemModificationType type) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                return new Invalidate(stamp, type);
            }

            public static /* synthetic */ Invalidate copy$default(Invalidate invalidate, Stamp stamp, ExternalSystemModificationType externalSystemModificationType, int n, Object object) {
                if ((n & 1) != 0) {
                    stamp = invalidate.stamp;
                }
                if ((n & 2) != 0) {
                    externalSystemModificationType = invalidate.type;
                }
                return invalidate.copy(stamp, externalSystemModificationType);
            }

            @NotNull
            public String toString() {
                return "Invalidate(stamp=" + this.stamp + ", type=" + this.type + ")";
            }

            public int hashCode() {
                int result = this.stamp.hashCode();
                result = result * 31 + this.type.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Invalidate)) {
                    return false;
                }
                Invalidate invalidate = (Invalidate)other;
                if (!Intrinsics.areEqual((Object)this.stamp, (Object)invalidate.stamp)) {
                    return false;
                }
                return this.type == invalidate.type;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Modify;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "type", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;)V", "getStamp", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "getType", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
        public static final class Modify
        extends ProjectEvent {
            @NotNull
            private final Stamp stamp;
            @NotNull
            private final ExternalSystemModificationType type;

            public Modify(@NotNull Stamp stamp, @NotNull ExternalSystemModificationType type) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                super(null);
                this.stamp = stamp;
                this.type = type;
            }

            @Override
            @NotNull
            public Stamp getStamp() {
                return this.stamp;
            }

            @NotNull
            public final ExternalSystemModificationType getType() {
                return this.type;
            }

            @NotNull
            public final Stamp component1() {
                return this.stamp;
            }

            @NotNull
            public final ExternalSystemModificationType component2() {
                return this.type;
            }

            @NotNull
            public final Modify copy(@NotNull Stamp stamp, @NotNull ExternalSystemModificationType type) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                return new Modify(stamp, type);
            }

            public static /* synthetic */ Modify copy$default(Modify modify, Stamp stamp, ExternalSystemModificationType externalSystemModificationType, int n, Object object) {
                if ((n & 1) != 0) {
                    stamp = modify.stamp;
                }
                if ((n & 2) != 0) {
                    externalSystemModificationType = modify.type;
                }
                return modify.copy(stamp, externalSystemModificationType);
            }

            @NotNull
            public String toString() {
                return "Modify(stamp=" + this.stamp + ", type=" + this.type + ")";
            }

            public int hashCode() {
                int result = this.stamp.hashCode();
                result = result * 31 + this.type.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Modify)) {
                    return false;
                }
                Modify modify = (Modify)other;
                if (!Intrinsics.areEqual((Object)this.stamp, (Object)modify.stamp)) {
                    return false;
                }
                return this.type == modify.type;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Revert;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;)V", "getStamp", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
        public static final class Revert
        extends ProjectEvent {
            @NotNull
            private final Stamp stamp;

            public Revert(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                super(null);
                this.stamp = stamp;
            }

            @Override
            @NotNull
            public Stamp getStamp() {
                return this.stamp;
            }

            @NotNull
            public final Stamp component1() {
                return this.stamp;
            }

            @NotNull
            public final Revert copy(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                return new Revert(stamp);
            }

            public static /* synthetic */ Revert copy$default(Revert revert, Stamp stamp, int n, Object object) {
                if ((n & 1) != 0) {
                    stamp = revert.stamp;
                }
                return revert.copy(stamp);
            }

            @NotNull
            public String toString() {
                return "Revert(stamp=" + this.stamp + ")";
            }

            public int hashCode() {
                return this.stamp.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Revert)) {
                    return false;
                }
                Revert revert = (Revert)other;
                return Intrinsics.areEqual((Object)this.stamp, (Object)revert.stamp);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent$Synchronize;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;)V", "getStamp", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
        public static final class Synchronize
        extends ProjectEvent {
            @NotNull
            private final Stamp stamp;

            public Synchronize(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                super(null);
                this.stamp = stamp;
            }

            @Override
            @NotNull
            public Stamp getStamp() {
                return this.stamp;
            }

            @NotNull
            public final Stamp component1() {
                return this.stamp;
            }

            @NotNull
            public final Synchronize copy(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                return new Synchronize(stamp);
            }

            public static /* synthetic */ Synchronize copy$default(Synchronize synchronize, Stamp stamp, int n, Object object) {
                if ((n & 1) != 0) {
                    stamp = synchronize.stamp;
                }
                return synchronize.copy(stamp);
            }

            @NotNull
            public String toString() {
                return "Synchronize(stamp=" + this.stamp + ")";
            }

            public int hashCode() {
                return this.stamp.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Synchronize)) {
                    return false;
                }
                Synchronize synchronize = (Synchronize)other;
                return Intrinsics.areEqual((Object)this.stamp, (Object)synchronize.stamp);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\b\t\n\u000b\fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0005\r\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "", "<init>", "()V", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "getStamp", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "Synchronized", "Dirty", "Modified", "Reverted", "Broken", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Broken;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Dirty;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Modified;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Reverted;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Synchronized;", "intellij.platform.externalSystem.impl"})
    public static abstract sealed class ProjectState {
        private ProjectState() {
        }

        @NotNull
        public abstract Stamp getStamp();

        public /* synthetic */ ProjectState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Broken;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;)V", "getStamp", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
        public static final class Broken
        extends ProjectState {
            @NotNull
            private final Stamp stamp;

            public Broken(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                super(null);
                this.stamp = stamp;
            }

            @Override
            @NotNull
            public Stamp getStamp() {
                return this.stamp;
            }

            @NotNull
            public final Stamp component1() {
                return this.stamp;
            }

            @NotNull
            public final Broken copy(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                return new Broken(stamp);
            }

            public static /* synthetic */ Broken copy$default(Broken broken, Stamp stamp, int n, Object object) {
                if ((n & 1) != 0) {
                    stamp = broken.stamp;
                }
                return broken.copy(stamp);
            }

            @NotNull
            public String toString() {
                return "Broken(stamp=" + this.stamp + ")";
            }

            public int hashCode() {
                return this.stamp.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Broken)) {
                    return false;
                }
                Broken broken = (Broken)other;
                return Intrinsics.areEqual((Object)this.stamp, (Object)broken.stamp);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Dirty;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "type", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;)V", "getStamp", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "getType", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
        public static final class Dirty
        extends ProjectState {
            @NotNull
            private final Stamp stamp;
            @NotNull
            private final ExternalSystemModificationType type;

            public Dirty(@NotNull Stamp stamp, @NotNull ExternalSystemModificationType type) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                super(null);
                this.stamp = stamp;
                this.type = type;
            }

            @Override
            @NotNull
            public Stamp getStamp() {
                return this.stamp;
            }

            @NotNull
            public final ExternalSystemModificationType getType() {
                return this.type;
            }

            @NotNull
            public final Stamp component1() {
                return this.stamp;
            }

            @NotNull
            public final ExternalSystemModificationType component2() {
                return this.type;
            }

            @NotNull
            public final Dirty copy(@NotNull Stamp stamp, @NotNull ExternalSystemModificationType type) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                return new Dirty(stamp, type);
            }

            public static /* synthetic */ Dirty copy$default(Dirty dirty, Stamp stamp, ExternalSystemModificationType externalSystemModificationType, int n, Object object) {
                if ((n & 1) != 0) {
                    stamp = dirty.stamp;
                }
                if ((n & 2) != 0) {
                    externalSystemModificationType = dirty.type;
                }
                return dirty.copy(stamp, externalSystemModificationType);
            }

            @NotNull
            public String toString() {
                return "Dirty(stamp=" + this.stamp + ", type=" + this.type + ")";
            }

            public int hashCode() {
                int result = this.stamp.hashCode();
                result = result * 31 + this.type.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Dirty)) {
                    return false;
                }
                Dirty dirty = (Dirty)other;
                if (!Intrinsics.areEqual((Object)this.stamp, (Object)dirty.stamp)) {
                    return false;
                }
                return this.type == dirty.type;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Modified;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "type", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;)V", "getStamp", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "getType", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
        public static final class Modified
        extends ProjectState {
            @NotNull
            private final Stamp stamp;
            @NotNull
            private final ExternalSystemModificationType type;

            public Modified(@NotNull Stamp stamp, @NotNull ExternalSystemModificationType type) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                super(null);
                this.stamp = stamp;
                this.type = type;
            }

            @Override
            @NotNull
            public Stamp getStamp() {
                return this.stamp;
            }

            @NotNull
            public final ExternalSystemModificationType getType() {
                return this.type;
            }

            @NotNull
            public final Stamp component1() {
                return this.stamp;
            }

            @NotNull
            public final ExternalSystemModificationType component2() {
                return this.type;
            }

            @NotNull
            public final Modified copy(@NotNull Stamp stamp, @NotNull ExternalSystemModificationType type) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                return new Modified(stamp, type);
            }

            public static /* synthetic */ Modified copy$default(Modified modified, Stamp stamp, ExternalSystemModificationType externalSystemModificationType, int n, Object object) {
                if ((n & 1) != 0) {
                    stamp = modified.stamp;
                }
                if ((n & 2) != 0) {
                    externalSystemModificationType = modified.type;
                }
                return modified.copy(stamp, externalSystemModificationType);
            }

            @NotNull
            public String toString() {
                return "Modified(stamp=" + this.stamp + ", type=" + this.type + ")";
            }

            public int hashCode() {
                int result = this.stamp.hashCode();
                result = result * 31 + this.type.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Modified)) {
                    return false;
                }
                Modified modified = (Modified)other;
                if (!Intrinsics.areEqual((Object)this.stamp, (Object)modified.stamp)) {
                    return false;
                }
                return this.type == modified.type;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Reverted;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;)V", "getStamp", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
        public static final class Reverted
        extends ProjectState {
            @NotNull
            private final Stamp stamp;

            public Reverted(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                super(null);
                this.stamp = stamp;
            }

            @Override
            @NotNull
            public Stamp getStamp() {
                return this.stamp;
            }

            @NotNull
            public final Stamp component1() {
                return this.stamp;
            }

            @NotNull
            public final Reverted copy(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                return new Reverted(stamp);
            }

            public static /* synthetic */ Reverted copy$default(Reverted reverted, Stamp stamp, int n, Object object) {
                if ((n & 1) != 0) {
                    stamp = reverted.stamp;
                }
                return reverted.copy(stamp);
            }

            @NotNull
            public String toString() {
                return "Reverted(stamp=" + this.stamp + ")";
            }

            public int hashCode() {
                return this.stamp.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Reverted)) {
                    return false;
                }
                Reverted reverted = (Reverted)other;
                return Intrinsics.areEqual((Object)this.stamp, (Object)reverted.stamp);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState$Synchronized;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectState;", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;)V", "getStamp", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
        public static final class Synchronized
        extends ProjectState {
            @NotNull
            private final Stamp stamp;

            public Synchronized(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                super(null);
                this.stamp = stamp;
            }

            @Override
            @NotNull
            public Stamp getStamp() {
                return this.stamp;
            }

            @NotNull
            public final Stamp component1() {
                return this.stamp;
            }

            @NotNull
            public final Synchronized copy(@NotNull Stamp stamp) {
                Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
                return new Synchronized(stamp);
            }

            public static /* synthetic */ Synchronized copy$default(Synchronized synchronized_, Stamp stamp, int n, Object object) {
                if ((n & 1) != 0) {
                    stamp = synchronized_.stamp;
                }
                return synchronized_.copy(stamp);
            }

            @NotNull
            public String toString() {
                return "Synchronized(stamp=" + this.stamp + ")";
            }

            public int hashCode() {
                return this.stamp.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Synchronized)) {
                    return false;
                }
                Synchronized synchronized_ = (Synchronized)other;
                return Intrinsics.areEqual((Object)this.stamp, (Object)synchronized_.stamp);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\bB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0000H\u0096\u0082\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "", "stamp", "", "<init>", "(I)V", "compareTo", "other", "Companion", "intellij.platform.externalSystem.impl"})
    public static final class Stamp
    implements Comparable<Stamp> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int stamp;
        @NotNull
        private static final Stamp NONE = new Stamp(-1);
        @NotNull
        private static final AtomicInteger counter = new AtomicInteger(0);

        private Stamp(int stamp) {
            this.stamp = stamp;
        }

        @Override
        public int compareTo(@NotNull Stamp other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.compare((int)this.stamp, (int)other.stamp);
        }

        public /* synthetic */ Stamp(int stamp, DefaultConstructorMarker $constructor_marker) {
            this(stamp);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp$Companion;", "", "<init>", "()V", "NONE", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "getNONE", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "nextStamp", "intellij.platform.externalSystem.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Stamp getNONE() {
                return NONE;
            }

            @NotNull
            public final Stamp nextStamp() {
                return new Stamp(counter.incrementAndGet(), null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

