/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.ProgressBuildEvent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J1\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u00110\u000fH\u0016JA\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00102\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u00110\u000fH\u0017J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0010H\u0003\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/externalSystem/service/ExternalSystemTaskProgressIndicatorUpdater;", "", "<init>", "()V", "canUpdate", "", "externalSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "updateIndicator", "", "event", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationEvent;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "textWrapper", "Ljava/util/function/Function;", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "getText", "description", "progress", "", "total", "unit", "onTaskEnd", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "getSizeInfo", "Companion", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nExternalSystemTaskProgressIndicatorUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalSystemTaskProgressIndicatorUpdater.kt\ncom/intellij/openapi/externalSystem/service/ExternalSystemTaskProgressIndicatorUpdater\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public abstract class ExternalSystemTaskProgressIndicatorUpdater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ExtensionPointName<ExternalSystemTaskProgressIndicatorUpdater> EP_NAME = ExtensionPointName.Companion.create("com.intellij.externalSystemTaskProgressIndicatorUpdater");

    public abstract boolean canUpdate(@NotNull ProjectSystemId var1);

    public void updateIndicator(@NotNull ExternalSystemTaskNotificationEvent event, @NotNull ProgressIndicator indicator, @NotNull Function<String, String> textWrapper) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(textWrapper, (String)"textWrapper");
        long total = 0L;
        long progress = 0L;
        String unit = null;
        if (event instanceof ExternalSystemBuildEvent && ((ExternalSystemBuildEvent)event).getBuildEvent() instanceof ProgressBuildEvent) {
            BuildEvent buildEvent = ((ExternalSystemBuildEvent)event).getBuildEvent();
            Intrinsics.checkNotNull((Object)buildEvent, (String)"null cannot be cast to non-null type com.intellij.build.events.ProgressBuildEvent");
            progressEvent = (ProgressBuildEvent)buildEvent;
            total = progressEvent.getTotal();
            progress = progressEvent.getProgress();
            String string = progressEvent.getUnit();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUnit(...)");
            unit = string;
        } else if (event instanceof ExternalSystemTaskExecutionEvent && ((ExternalSystemTaskExecutionEvent)event).getProgressEvent() instanceof ExternalSystemStatusEvent) {
            ExternalSystemProgressEvent externalSystemProgressEvent = ((ExternalSystemTaskExecutionEvent)event).getProgressEvent();
            Intrinsics.checkNotNull((Object)externalSystemProgressEvent, (String)"null cannot be cast to non-null type com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent<*>");
            progressEvent = (ExternalSystemStatusEvent)externalSystemProgressEvent;
            total = progressEvent.getTotal();
            progress = progressEvent.getProgress();
            unit = progressEvent.getUnit();
        } else {
            return;
        }
        if (total <= 0L) {
            indicator.setIndeterminate(true);
        } else {
            indicator.setIndeterminate(false);
            indicator.setFraction((double)progress / (double)total);
        }
        String string = event.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
        String description = string;
        indicator.setText(this.getText(description, progress, total, unit, textWrapper));
    }

    @NlsSafe
    @NotNull
    public String getText(@NotNull String description, long progress, long total, @NotNull String unit, @NotNull Function<String, String> textWrapper) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter(textWrapper, (String)"textWrapper");
        String string = textWrapper.apply(description);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apply(...)");
        String body = string;
        String it = this.getSizeInfo(progress, total, unit);
        boolean bl = false;
        Object tail = StringUtil.isNotEmpty((String)it) ? "(" + it + ")" : "";
        return body + " " + (String)tail;
    }

    public void onTaskEnd(@NotNull ExternalSystemTaskId taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
    }

    @NlsSafe
    private final String getSizeInfo(long progress, long total, String unit) {
        String string = unit;
        return Intrinsics.areEqual((Object)string, (Object)"bytes") ? (total <= 0L ? StringUtil.formatFileSize((long)progress) + " / ?" : StringUtil.formatFileSize((long)progress) + " / " + StringUtil.formatFileSize((long)total)) : (Intrinsics.areEqual((Object)string, (Object)"items") ? (total <= 0L ? progress + " / ?" : progress + " / " + total) : "");
    }

    @JvmStatic
    @Nullable
    public static final ExternalSystemTaskProgressIndicatorUpdater getInstance(@NotNull ProjectSystemId systemId) {
        return Companion.getInstance(systemId);
    }

    @JvmStatic
    @NotNull
    public static final ExternalSystemTaskProgressIndicatorUpdater getInstanceOrDefault(@NotNull ProjectSystemId systemId) {
        return Companion.getInstanceOrDefault(systemId);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/externalSystem/service/ExternalSystemTaskProgressIndicatorUpdater$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/externalSystem/service/ExternalSystemTaskProgressIndicatorUpdater;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "getInstance", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getInstanceOrDefault", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<ExternalSystemTaskProgressIndicatorUpdater> getEP_NAME() {
            return EP_NAME;
        }

        @JvmStatic
        @Nullable
        public final ExternalSystemTaskProgressIndicatorUpdater getInstance(@NotNull ProjectSystemId systemId) {
            Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
            return (ExternalSystemTaskProgressIndicatorUpdater)this.getEP_NAME().findFirstSafe(arg_0 -> Companion.getInstance$lambda$1(arg_0 -> Companion.getInstance$lambda$0(systemId, arg_0), arg_0));
        }

        @JvmStatic
        @NotNull
        public final ExternalSystemTaskProgressIndicatorUpdater getInstanceOrDefault(@NotNull ProjectSystemId systemId) {
            Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
            ExternalSystemTaskProgressIndicatorUpdater externalSystemTaskProgressIndicatorUpdater = this.getInstance(systemId);
            if (externalSystemTaskProgressIndicatorUpdater == null) {
                externalSystemTaskProgressIndicatorUpdater = new ExternalSystemTaskProgressIndicatorUpdater(){

                    public boolean canUpdate(ProjectSystemId externalSystemId) {
                        Intrinsics.checkNotNullParameter((Object)externalSystemId, (String)"externalSystemId");
                        return true;
                    }
                };
            }
            return externalSystemTaskProgressIndicatorUpdater;
        }

        private static final boolean getInstance$lambda$0(ProjectSystemId $systemId, ExternalSystemTaskProgressIndicatorUpdater it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.canUpdate($systemId);
        }

        private static final boolean getInstance$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

