/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.SoftlyKillableProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.DiscardingInputStream;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.ObjectUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProcessHandler
extends BuildProcessHandler
implements SoftlyKillableProcessHandler,
Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalSystemProcessHandler.class);
    static final Key<Boolean> SOFT_PROCESS_KILL_ENABLED_KEY = Key.create((String)"SOFT_PROCESS_KILL_ENABLED_KEY");
    @NotNull
    private final String myExecutionName;
    @Nullable
    private ExternalSystemTask myTask;
    @Nullable
    private UserDataHolder myDataHolder;
    @Nullable
    private OutputStream myProcessInputWriter;
    @Nullable
    private InputStream myProcessInputReader;
    @NotNull
    private final AnsiEscapeDecoder myAnsiEscapeDecoder;
    private boolean escapeAnsiText;

    public ExternalSystemProcessHandler(@NotNull ExternalSystemTask task, @NotNull String executionName) {
        if (task == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(0);
        }
        if (executionName == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(1);
        }
        this(task, executionName, (UserDataHolder)ObjectUtils.tryCast((Object)task, UserDataHolder.class));
    }

    private ExternalSystemProcessHandler(@NotNull ExternalSystemTask task, @NotNull String executionName, @Nullable UserDataHolder dataHolder) {
        if (task == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(2);
        }
        if (executionName == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(3);
        }
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.escapeAnsiText = true;
        this.myTask = task;
        this.myDataHolder = dataHolder;
        this.myExecutionName = executionName;
        try {
            Pipe pipe = Pipe.open();
            this.myProcessInputReader = new DiscardingInputStream(new BufferedInputStream(Channels.newInputStream(pipe.source())));
            this.myProcessInputWriter = new BufferedOutputStream(Channels.newOutputStream(pipe.sink()));
        }
        catch (IOException e) {
            LOG.warn("Unable to setup process input", (Throwable)e);
        }
        if (this.myDataHolder != null) {
            ExternalSystemProcessHandler.closeLeakedStream(this.myDataHolder);
            this.myDataHolder.putUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY, (Object)this.myProcessInputReader);
        }
    }

    @NotNull
    public String getExecutionName() {
        String string = this.myExecutionName;
        if (string == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public ExternalSystemTask getTask() {
        return this.myTask;
    }

    @ApiStatus.Experimental
    public void disableAnsiTextEscaping() {
        this.escapeAnsiText = false;
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
        if (text == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(5);
        }
        if (outputType == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(6);
        }
        if (this.escapeAnsiText) {
            this.myAnsiEscapeDecoder.escapeText(text, outputType, (decodedText, attributes) -> super.notifyTextAvailable(decodedText, attributes));
        } else {
            super.notifyTextAvailable(text, outputType);
        }
    }

    @ApiStatus.Experimental
    public boolean shouldKillProcessSoftly() {
        return this.myDataHolder != null && this.myDataHolder.getUserData(SOFT_PROCESS_KILL_ENABLED_KEY) == Boolean.TRUE;
    }

    protected void destroyProcessImpl() {
        try {
            ExternalSystemTask task = this.myTask;
            if (task != null) {
                task.cancel(new ExternalSystemTaskNotificationListener[0]);
            }
        }
        finally {
            this.closeInput();
        }
    }

    protected void detachProcessImpl() {
        try {
            this.notifyProcessDetached();
        }
        finally {
            this.closeInput();
        }
    }

    public boolean detachIsDefault() {
        return false;
    }

    @Nullable
    public OutputStream getProcessInput() {
        return this.myProcessInputWriter;
    }

    public void notifyProcessTerminated(int exitCode) {
        try {
            super.notifyProcessTerminated(exitCode);
        }
        finally {
            this.closeInput();
        }
    }

    protected void closeInput() {
        OutputStream processInputWriter = this.myProcessInputWriter;
        InputStream processInputReader = this.myProcessInputReader;
        UserDataHolder dataHolder = this.myDataHolder;
        this.myProcessInputWriter = null;
        this.myProcessInputReader = null;
        if (dataHolder != null) {
            dataHolder.putUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY, null);
        }
        StreamUtil.closeStream((Closeable)processInputWriter);
        StreamUtil.closeStream((Closeable)processInputReader);
    }

    private static void closeLeakedStream(@NotNull UserDataHolder dataHolder) {
        if (dataHolder == null) {
            ExternalSystemProcessHandler.$$$reportNull$$$0(7);
        }
        InputStream leakedStream = (InputStream)dataHolder.getUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY);
        dataHolder.putUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY, null);
        if (leakedStream != null) {
            LOG.warn("Unexpected stream found, closing it...");
        }
        StreamUtil.closeStream((Closeable)leakedStream);
    }

    public void dispose() {
        try {
            this.detachProcessImpl();
        }
        finally {
            this.myTask = null;
            this.myDataHolder = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemProcessHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemProcessHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyTextAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "closeLeakedStream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

