/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcherImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsState;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemProjectSetupExtension;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemRunManagerListener;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalProjectsManager", storages={@Storage(value="$WORKSPACE_FILE$")}, getStateRequiresEdt=true)
public final class ExternalProjectsManagerImpl
implements ExternalProjectsManager,
PersistentStateComponent<ExternalProjectsState>,
Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalProjectsManagerImpl.class);
    private static final ExtensionPointName<ExternalSystemProjectSetupExtension> PROJECT_SETUP_EXTENSION_EP = new ExtensionPointName("com.intellij.openapi.externalSystem.projectSetupExtension");
    private final AtomicBoolean isInitializationFinished;
    private final AtomicBoolean isInitializationStarted;
    private final AtomicBoolean isDisposed;
    private final CompositeRunnable myPostInitializationActivities;
    private final CompositeRunnable myPostInitializationBGActivities;
    @NotNull
    private ExternalProjectsState myState;
    @NotNull
    private final Project myProject;
    private final ExternalSystemRunManagerListener myRunManagerListener;
    private final ExternalSystemTaskActivator myTaskActivator;
    private final ExternalSystemShortcutsManager myShortcutsManager;
    private final CoroutineScope coroutineScope;
    private final List<ExternalProjectsView> myProjectsViews;
    private final ExternalSystemProjectsWatcherImpl myWatcher;

    public ExternalProjectsManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(1);
        }
        this.isInitializationFinished = new AtomicBoolean();
        this.isInitializationStarted = new AtomicBoolean();
        this.isDisposed = new AtomicBoolean();
        this.myPostInitializationActivities = new CompositeRunnable();
        this.myPostInitializationBGActivities = new CompositeRunnable();
        this.myState = new ExternalProjectsState();
        this.myProjectsViews = new SmartList();
        this.myProject = project;
        this.myShortcutsManager = new ExternalSystemShortcutsManager(project);
        this.coroutineScope = coroutineScope;
        Disposer.register((Disposable)this, (Disposable)this.myShortcutsManager);
        this.myTaskActivator = new ExternalSystemTaskActivator(project);
        this.myRunManagerListener = new ExternalSystemRunManagerListener(this);
        this.myWatcher = new ExternalSystemProjectsWatcherImpl(this.myProject);
        ApplicationManager.getApplication().getMessageBus().connect(coroutineScope).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashSet<ProjectSystemId> availableES = new HashSet<ProjectSystemId>();
                for (ExternalSystemManager manager : ExternalSystemManager.EP_NAME.getExtensionList()) {
                    ProjectSystemId id = manager.getSystemId();
                    availableES.add(id);
                }
                Iterator<ExternalProjectsView> iterator = ExternalProjectsManagerImpl.this.myProjectsViews.iterator();
                while (iterator.hasNext()) {
                    ExternalProjectsView view = iterator.next();
                    if (!availableES.contains(view.getSystemId())) {
                        iterator.remove();
                    }
                    if (!(view instanceof Disposable)) continue;
                    Disposer.dispose((Disposable)((Disposable)view));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl$1", "pluginUnloaded"));
            }
        });
    }

    public static ExternalProjectsManagerImpl getInstance(@NotNull Project project) {
        if (project == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(2);
        }
        return (ExternalProjectsManagerImpl)ExternalProjectsManager.getInstance((Project)project);
    }

    @Nullable
    public static Project setupCreatedProject(@Nullable Project project) {
        if (project != null) {
            ExternalProjectsManagerImpl.getInstance(project).setStoreExternally(true);
            for (ExternalSystemProjectSetupExtension each : PROJECT_SETUP_EXTENSION_EP.getExtensionList()) {
                each.setupCreatedProject(project);
            }
        }
        return project;
    }

    public void setStoreExternally(boolean value) {
        ExternalStorageConfigurationManager externalStorageConfigurationManager = ExternalStorageConfigurationManager.getInstance((Project)this.myProject);
        if (externalStorageConfigurationManager.isEnabled() == value) {
            return;
        }
        externalStorageConfigurationManager.setEnabled(value);
        try {
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (module.isDisposed()) continue;
                ExternalSystemModulePropertyManager.getInstance((Module)module).swapStore();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(3);
        }
        return project;
    }

    @ApiStatus.Internal
    public ExternalSystemShortcutsManager getShortcutsManager() {
        return this.myShortcutsManager;
    }

    public ExternalSystemTaskActivator getTaskActivator() {
        return this.myTaskActivator;
    }

    public ExternalSystemProjectsWatcher getExternalProjectsWatcher() {
        return this.myWatcher;
    }

    public void registerView(@NotNull ExternalProjectsView externalProjectsView) {
        if (externalProjectsView == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(4);
        }
        assert (this.getExternalProjectsView(externalProjectsView.getSystemId()) == null);
        this.myProjectsViews.add(externalProjectsView);
        if (externalProjectsView instanceof ExternalProjectsViewImpl) {
            ExternalProjectsViewImpl view = (ExternalProjectsViewImpl)externalProjectsView;
            view.loadState(this.myState.getExternalSystemsState().get(externalProjectsView.getSystemId().getId()).getProjectsViewState());
            view.init();
        }
    }

    @Nullable
    public ExternalProjectsView getExternalProjectsView(@NotNull ProjectSystemId systemId) {
        if (systemId == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(5);
        }
        for (ExternalProjectsView projectsView : this.myProjectsViews) {
            if (!projectsView.getSystemId().equals((Object)systemId)) continue;
            return projectsView;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        ProgressManager.checkCanceled();
        if (this.isInitializationStarted.getAndSet(true)) {
            return;
        }
        ExternalProjectsDataStorage.getInstance(this.myProject).load();
        this.myRunManagerListener.attach();
        this.myShortcutsManager.init();
        for (ExternalSystemManager systemManager : ExternalSystemManager.EP_NAME.getIterable()) {
            Collection<ExternalProjectInfo> externalProjects = ExternalProjectsDataStorage.getInstance(this.myProject).list(systemManager.getSystemId());
            for (ExternalProjectInfo externalProject : externalProjects) {
                if (externalProject.getExternalProjectStructure() == null) continue;
                Collection taskData = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProject.getExternalProjectStructure(), (Key)ProjectKeys.TASK);
                this.myShortcutsManager.scheduleKeymapUpdate(taskData);
            }
            if (externalProjects.isEmpty()) continue;
            this.myShortcutsManager.scheduleRunConfigurationKeymapUpdate(systemManager.getSystemId());
        }
        this.myTaskActivator.init();
        AtomicBoolean atomicBoolean = this.isInitializationFinished;
        synchronized (atomicBoolean) {
            this.isInitializationFinished.set(true);
            this.invokeLater(() -> {
                this.myPostInitializationActivities.run();
                this.myPostInitializationActivities.clear();
            });
            AppJavaExecutorUtil.executeOnPooledCpuThread((CoroutineScope)this.coroutineScope, () -> {
                this.myPostInitializationBGActivities.run();
                this.myPostInitializationBGActivities.clear();
            });
        }
    }

    public void refreshProject(@NotNull String externalProjectPath, @NotNull ImportSpec importSpec) {
        if (externalProjectPath == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(6);
        }
        if (importSpec == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(7);
        }
        ExternalSystemUtil.refreshProject(externalProjectPath, importSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenInitialized(@NotNull Runnable runnable) {
        if (runnable == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(8);
        }
        if (this.isDisposed.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = this.isInitializationFinished;
        synchronized (atomicBoolean) {
            if (this.isInitializationFinished.get()) {
                this.invokeLater(runnable);
            } else {
                this.myPostInitializationActivities.add(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenInitializedInBackground(@NotNull Runnable runnable) {
        if (runnable == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(9);
        }
        if (this.isDisposed.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = this.isInitializationFinished;
        synchronized (atomicBoolean) {
            if (this.isInitializationFinished.get()) {
                ApplicationManager.getApplication().executeOnPooledThread(runnable);
            } else {
                this.myPostInitializationBGActivities.add(runnable);
            }
        }
    }

    private void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().invokeLater(runnable, o -> this.myProject.isDisposed() || this.isDisposed.get());
    }

    public void updateExternalProjectData(ExternalProjectInfo externalProject) {
        ExternalProjectsDataStorage.getInstance(this.myProject).update(externalProject);
        if (externalProject.getExternalProjectStructure() != null) {
            ProjectData projectData = (ProjectData)externalProject.getExternalProjectStructure().getData();
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(this.myProject, projectData.getOwner());
            Collection taskData = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProject.getExternalProjectStructure(), (Key)ProjectKeys.TASK);
            this.myShortcutsManager.scheduleKeymapUpdate(taskData);
            this.myShortcutsManager.scheduleRunConfigurationKeymapUpdate(projectData.getOwner());
        }
    }

    public void forgetExternalProjectData(@NotNull ProjectSystemId projectSystemId, @NotNull String linkedProjectPath) {
        if (projectSystemId == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(11);
        }
        if (linkedProjectPath == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(12);
        }
        ExternalProjectsDataStorage.getInstance(this.myProject).remove(projectSystemId, linkedProjectPath);
        ExternalSystemUtil.scheduleExternalViewStructureUpdate(this.myProject, projectSystemId);
    }

    @ApiStatus.Internal
    public void projectTasksBeforeRun(@NotNull ProjectTaskContext context) throws ExecutionException {
        if (context == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(13);
        }
        if (this.isInitializationFinished.get()) {
            if (!this.myTaskActivator.doExecuteBuildPhaseTriggers(true, context)) {
                throw new ExecutionException(ExternalSystemBundle.message((String)"dialog.message.before.build.triggering.task.failed", (Object[])new Object[0]));
            }
        } else {
            LOG.debug("projectTasksBeforeRun called before external system initialization finished");
        }
    }

    @ApiStatus.Internal
    public void projectTasksAfterRun(@NotNull ProjectTaskManager.Result result) throws ExecutionException {
        if (result == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(14);
        }
        if (this.isInitializationFinished.get()) {
            if (!this.myTaskActivator.doExecuteBuildPhaseTriggers(false, result.getContext())) {
                throw new ExecutionException(ExternalSystemBundle.message((String)"dialog.message.after.build.triggering.task.failed", (Object[])new Object[0]));
            }
        } else {
            LOG.debug("projectTasksAfterRun called before external system initialization finished");
        }
    }

    @ApiStatus.Internal
    @NotNull
    public ExternalProjectsState getState() {
        for (ExternalProjectsView externalProjectsView : this.myProjectsViews) {
            if (!(externalProjectsView instanceof ExternalProjectsViewImpl)) continue;
            ExternalProjectsViewState externalProjectsViewState = ((ExternalProjectsViewImpl)externalProjectsView).getState();
            ExternalProjectsState.State state = this.myState.getExternalSystemsState().get(externalProjectsView.getSystemId().getId());
            assert (state != null);
            state.setProjectsViewState(externalProjectsViewState);
        }
        ExternalProjectsState externalProjectsState = this.myState;
        if (externalProjectsState == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(15);
        }
        return externalProjectsState;
    }

    @ApiStatus.Internal
    @NotNull
    public ExternalProjectsStateProvider getStateProvider() {
        return new ExternalProjectsStateProvider(){

            @Override
            public List<ExternalProjectsStateProvider.TasksActivation> getAllTasksActivation() {
                SmartList result = new SmartList();
                Map<String, ProjectSystemId> systemIds = ExternalSystemApiUtil.getAllManagers().stream().collect(Collectors.toMap(o -> o.getSystemId().getId(), o -> o.getSystemId()));
                for (Map.Entry<String, ExternalProjectsState.State> systemState : ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().entrySet()) {
                    ProjectSystemId systemId = systemIds.get(systemState.getKey());
                    if (systemId == null) continue;
                    for (Map.Entry<String, TaskActivationState> activationStateEntry : systemState.getValue().getExternalSystemsTaskActivation().entrySet()) {
                        result.add(new ExternalProjectsStateProvider.TasksActivation(systemId, activationStateEntry.getKey(), activationStateEntry.getValue()));
                    }
                }
                return result;
            }

            @Override
            public TaskActivationState getTasksActivation(@NotNull ProjectSystemId systemId, @NotNull String projectPath) {
                if (systemId == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (projectPath == null) {
                    2.$$$reportNull$$$0(1);
                }
                return ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().get(systemId.getId()).getExternalSystemsTaskActivation().get(projectPath);
            }

            @Override
            public Map<String, TaskActivationState> getProjectsTasksActivationMap(@NotNull ProjectSystemId systemId) {
                if (systemId == null) {
                    2.$$$reportNull$$$0(2);
                }
                return ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().get(systemId.getId()).getExternalSystemsTaskActivation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "systemId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectPath";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getTasksActivation";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getProjectsTasksActivationMap";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public boolean isIgnored(@NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        ExternalProjectInfo projectInfo;
        if (systemId == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(16);
        }
        if (projectPath == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(17);
        }
        if ((projectInfo = ExternalSystemUtil.getExternalProjectInfo(this.myProject, systemId, projectPath)) == null) {
            return true;
        }
        return ExternalProjectsDataStorage.getInstance(this.myProject).isIgnored(projectInfo.getExternalProjectPath(), projectPath, ProjectKeys.MODULE);
    }

    public void setIgnored(@NotNull DataNode<?> dataNode, boolean isIgnored) {
        if (dataNode == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(18);
        }
        ExternalProjectsDataStorage.getInstance(this.myProject).setIgnored(dataNode, isIgnored);
        ExternalSystemKeymapExtension.updateActions(this.myProject, ExternalSystemApiUtil.findAllRecursively(dataNode, (Key)ProjectKeys.TASK));
    }

    @ApiStatus.Internal
    public void loadState(@NotNull ExternalProjectsState state) {
        if (state == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(19);
        }
        this.myState = state;
        if (this.myState.storeExternally) {
            this.myState.storeExternally = false;
            ExternalStorageConfigurationManager.getInstance((Project)this.myProject).setEnabled(true);
        }
    }

    public void dispose() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        this.myPostInitializationActivities.clear();
        this.myPostInitializationBGActivities.clear();
        this.myProjectsViews.clear();
        this.myRunManagerListener.detach();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerView";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectsView";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshProject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runWhenInitialized";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runWhenInitializedInBackground";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forgetExternalProjectData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "projectTasksBeforeRun";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "projectTasksAfterRun";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setIgnored";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 15 -> new IllegalStateException(string);
        };
    }

    private static class CompositeRunnable
    implements Runnable {
        private List<Runnable> list = new SmartList();

        private CompositeRunnable() {
        }

        public boolean add(Runnable runnable) {
            return this.list.add(runnable);
        }

        public void clear() {
            this.list = new SmartList();
        }

        @Override
        public void run() {
            for (Runnable runnable : this.list) {
                runnable.run();
            }
        }
    }

    @ApiStatus.Internal
    public static interface ExternalProjectsStateProvider {
        public List<TasksActivation> getAllTasksActivation();

        public TaskActivationState getTasksActivation(@NotNull ProjectSystemId var1, @NotNull String var2);

        public Map<String, TaskActivationState> getProjectsTasksActivationMap(@NotNull ProjectSystemId var1);

        public static class TasksActivation {
            public final ProjectSystemId systemId;
            public final String projectPath;
            public final TaskActivationState state;

            public TasksActivation(ProjectSystemId systemId, String projectPath, TaskActivationState state) {
                this.systemId = systemId;
                this.projectPath = projectPath;
                this.state = state;
            }
        }
    }
}

