/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractRemoteExternalSystemService<S extends ExternalSystemExecutionSettings>
implements RemoteExternalSystemService<S> {
    private final ConcurrentMap<ExternalSystemTaskType, Set<ExternalSystemTaskId>> myTasksInProgress = new ConcurrentHashMap<ExternalSystemTaskType, Set<ExternalSystemTaskId>>();
    private final AtomicReference<S> mySettings = new AtomicReference();
    private final AtomicReference<ExternalSystemTaskNotificationListener> myListener = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(@NotNull ExternalSystemTaskId id, @NotNull Supplier<? extends T> task) {
        Set tasks;
        if (id == null) {
            AbstractRemoteExternalSystemService.$$$reportNull$$$0(0);
        }
        if (task == null) {
            AbstractRemoteExternalSystemService.$$$reportNull$$$0(1);
        }
        if ((tasks = (Set)this.myTasksInProgress.get(id.getType())) == null) {
            this.myTasksInProgress.putIfAbsent(id.getType(), new HashSet());
            tasks = (Set)this.myTasksInProgress.get(id.getType());
        }
        tasks.add(id);
        try {
            T t = task.get();
            return t;
        }
        finally {
            tasks.remove(id);
        }
    }

    @Override
    public void setSettings(@NotNull S settings) {
        if (settings == null) {
            AbstractRemoteExternalSystemService.$$$reportNull$$$0(2);
        }
        this.mySettings.set(settings);
    }

    @Nullable
    public S getSettings() {
        return (S)((ExternalSystemExecutionSettings)this.mySettings.get());
    }

    @Override
    public void setNotificationListener(@NotNull ExternalSystemTaskNotificationListener listener2) {
        if (listener2 == null) {
            AbstractRemoteExternalSystemService.$$$reportNull$$$0(3);
        }
        this.myListener.set(listener2);
    }

    @NotNull
    public ExternalSystemTaskNotificationListener getNotificationListener() {
        ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener = this.myListener.get();
        if (externalSystemTaskNotificationListener == null) {
            AbstractRemoteExternalSystemService.$$$reportNull$$$0(4);
        }
        return externalSystemTaskNotificationListener;
    }

    @Override
    public boolean isTaskInProgress(@NotNull ExternalSystemTaskId id) {
        Set tasks;
        if (id == null) {
            AbstractRemoteExternalSystemService.$$$reportNull$$$0(5);
        }
        return (tasks = (Set)this.myTasksInProgress.get(id.getType())) != null && tasks.contains(id);
    }

    @Override
    @NotNull
    public Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> getTasksInProgress() {
        ConcurrentMap<ExternalSystemTaskType, Set<ExternalSystemTaskId>> concurrentMap = this.myTasksInProgress;
        if (concurrentMap == null) {
            AbstractRemoteExternalSystemService.$$$reportNull$$$0(6);
        }
        return concurrentMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/remote/AbstractRemoteExternalSystemService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/remote/AbstractRemoteExternalSystemService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksInProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setNotificationListener";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTaskInProgress";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

