/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTree;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTreeModel;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathLookupElement;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.TextFieldCompletionProviderDumbAware;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExternalProjectPathField
extends ComponentWithBrowseButton<MyPathAndProjectButtonPanel>
implements TextAccessor {
    @NotNull
    private static final String PROJECT_FILE_TO_START_WITH_KEY = "external.system.task.project.file.to.start";
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSystemId myExternalSystemId;

    public ExternalProjectPathField(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull FileChooserDescriptor descriptor2, @NlsContexts.DialogTitle @NotNull String fileChooserTitle) {
        ActionListener[] listeners;
        if (project == null) {
            ExternalProjectPathField.$$$reportNull$$$0(0);
        }
        if (externalSystemId == null) {
            ExternalProjectPathField.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            ExternalProjectPathField.$$$reportNull$$$0(2);
        }
        if (fileChooserTitle == null) {
            ExternalProjectPathField.$$$reportNull$$$0(3);
        }
        super((JComponent)ExternalProjectPathField.createPanel(project, externalSystemId), (ActionListener)new MyBrowseListener(descriptor2, fileChooserTitle, project));
        for (ActionListener listener2 : listeners = this.getButton().getActionListeners()) {
            if (!(listener2 instanceof MyBrowseListener)) continue;
            ((MyBrowseListener)listener2).setPathField(((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField());
            break;
        }
        this.myProject = project;
        this.myExternalSystemId = externalSystemId;
    }

    @NotNull
    public static MyPathAndProjectButtonPanel createPanel(final @NotNull Project project, final @NotNull ProjectSystemId externalSystemId) {
        if (project == null) {
            ExternalProjectPathField.$$$reportNull$$$0(4);
        }
        if (externalSystemId == null) {
            ExternalProjectPathField.$$$reportNull$$$0(5);
        }
        final EditorTextField textField = ExternalProjectPathField.createTextField(project, externalSystemId);
        final FixedSizeButton selectRegisteredProjectButton = new FixedSizeButton();
        selectRegisteredProjectButton.setIcon(AllIcons.Nodes.Module);
        String tooltipText = ExternalSystemBundle.message((String)"run.configuration.tooltip.choose.registered.project", (Object[])new Object[]{externalSystemId.getReadableName()});
        selectRegisteredProjectButton.setToolTipText(tooltipText);
        selectRegisteredProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ref popupRef = new Ref();
                Tree tree = ExternalProjectPathField.buildRegisteredProjectsTree(project, externalSystemId);
                tree.setBorder(JBUI.Borders.empty((int)8));
                Runnable treeSelectionCallback = () -> {
                    Object e1;
                    Object lastPathComponent;
                    TreePath path = tree.getSelectionPath();
                    if (path != null && (lastPathComponent = path.getLastPathComponent()) instanceof ExternalSystemNode && (e1 = ((ExternalSystemNode)lastPathComponent).getDescriptor().getElement()) instanceof ExternalProjectPojo) {
                        ExternalProjectPojo pojo = (ExternalProjectPojo)e1;
                        textField.setText(pojo.getPath());
                        Editor editor = textField.getEditor();
                        if (editor != null) {
                            ExternalProjectPathField.collapseIfPossible(editor, externalSystemId, project);
                        }
                    }
                    ((JBPopup)popupRef.get()).closeOk(null);
                };
                JBPopup popup = new PopupChooserBuilder((JTree)tree).setTitle(ExternalSystemBundle.message((String)"run.configuration.title.choose.registered.project", (Object[])new Object[]{externalSystemId.getReadableName()})).setResizable(true).setItemChosenCallback(treeSelectionCallback).setAutoselectOnMouseMove(true).setCloseOnEnter(false).createPopup();
                popupRef.set((Object)popup);
                popup.showUnderneathOf((Component)selectRegisteredProjectButton);
            }
        });
        return new MyPathAndProjectButtonPanel(textField, selectRegisteredProjectButton);
    }

    @NotNull
    private static Tree buildRegisteredProjectsTree(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        if (project == null) {
            ExternalProjectPathField.$$$reportNull$$$0(6);
        }
        if (externalSystemId == null) {
            ExternalProjectPathField.$$$reportNull$$$0(7);
        }
        ExternalSystemTasksTreeModel model = new ExternalSystemTasksTreeModel(externalSystemId);
        ExternalSystemTasksTree result = new ExternalSystemTasksTree(model, new HashMap<String, Boolean>(), project, externalSystemId);
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        Map projects = settings.getAvailableProjects();
        ArrayList rootProjects = new ArrayList(projects.keySet());
        ContainerUtil.sort(rootProjects);
        for (ExternalProjectPojo rootProject : rootProjects) {
            model.ensureSubProjectsStructure(rootProject, (Collection)projects.get(rootProject));
        }
        ExternalSystemTasksTree externalSystemTasksTree = result;
        if (externalSystemTasksTree == null) {
            ExternalProjectPathField.$$$reportNull$$$0(8);
        }
        return externalSystemTasksTree;
    }

    @NotNull
    private static EditorTextField createTextField(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        if (project == null) {
            ExternalProjectPathField.$$$reportNull$$$0(9);
        }
        if (externalSystemId == null) {
            ExternalProjectPathField.$$$reportNull$$$0(10);
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        final AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        final ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
        TextFieldCompletionProviderDumbAware provider = new TextFieldCompletionProviderDumbAware(){

            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                if (text == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                for (Map.Entry entry : settings.getAvailableProjects().entrySet()) {
                    String rootProjectPath = ((ExternalProjectPojo)entry.getKey()).getPath();
                    String rootProjectName = uiAware.getProjectRepresentationName(rootProjectPath, null);
                    ExternalProjectPathLookupElement rootProjectElement = new ExternalProjectPathLookupElement(rootProjectName, rootProjectPath);
                    result.addElement((LookupElement)rootProjectElement);
                    for (ExternalProjectPojo subProject : (Collection)entry.getValue()) {
                        String p = subProject.getPath();
                        if (rootProjectPath.equals(p)) continue;
                        String subProjectName = uiAware.getProjectRepresentationName(p, rootProjectPath);
                        ExternalProjectPathLookupElement subProjectElement = new ExternalProjectPathLookupElement(subProjectName, p);
                        result.addElement((LookupElement)subProjectElement);
                    }
                }
                result.stopHere();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$2";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        EditorTextField result = provider.createEditor(project, true, editor -> {
            ExternalProjectPathField.collapseIfPossible(editor, externalSystemId, project);
            editor.getSettings().setShowIntentionBulb(false);
        });
        result.setOneLineMode(true);
        result.setOpaque(true);
        result.setBackground(UIUtil.getTextFieldBackground());
        EditorTextField editorTextField = result;
        if (editorTextField == null) {
            ExternalProjectPathField.$$$reportNull$$$0(11);
        }
        return editorTextField;
    }

    public void setText(String text) {
        ((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField().setText(text);
        Editor editor = ((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField().getEditor();
        if (editor != null) {
            ExternalProjectPathField.collapseIfPossible(editor, this.myExternalSystemId, this.myProject);
        }
    }

    private static void collapseIfPossible(@NotNull Editor editor, @NotNull ProjectSystemId externalSystemId, @NotNull Project project) {
        if (editor == null) {
            ExternalProjectPathField.$$$reportNull$$$0(12);
        }
        if (externalSystemId == null) {
            ExternalProjectPathField.$$$reportNull$$$0(13);
        }
        if (project == null) {
            ExternalProjectPathField.$$$reportNull$$$0(14);
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
        String rawText = editor.getDocument().getText();
        for (Map.Entry entry : settings.getAvailableProjects().entrySet()) {
            if (((ExternalProjectPojo)entry.getKey()).getPath().equals(rawText)) {
                ExternalProjectPathField.collapse(editor, uiAware.getProjectRepresentationName(project, ((ExternalProjectPojo)entry.getKey()).getPath(), null));
                return;
            }
            for (ExternalProjectPojo pojo : (Collection)entry.getValue()) {
                if (!pojo.getPath().equals(rawText)) continue;
                ExternalProjectPathField.collapse(editor, uiAware.getProjectRepresentationName(project, pojo.getPath(), ((ExternalProjectPojo)entry.getKey()).getPath()));
                return;
            }
        }
    }

    public static void collapse(@NotNull Editor editor, @NotNull String placeholder) {
        if (editor == null) {
            ExternalProjectPathField.$$$reportNull$$$0(15);
        }
        if (placeholder == null) {
            ExternalProjectPathField.$$$reportNull$$$0(16);
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        foldingModel.runBatchFoldingOperation(() -> {
            for (FoldRegion region : foldingModel.getAllFoldRegions()) {
                foldingModel.removeFoldRegion(region);
            }
            FoldRegion region = foldingModel.addFoldRegion(0, editor.getDocument().getTextLength(), placeholder);
            if (region != null) {
                region.setExpanded(false);
            }
        });
    }

    public String getText() {
        return ((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField().getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooserTitle";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRegisteredProjectsTree";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildRegisteredProjectsTree";
                break;
            }
            case 8: 
            case 11: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTextField";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collapseIfPossible";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collapse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11 -> new IllegalStateException(string);
        };
    }

    public static class MyPathAndProjectButtonPanel
    extends JPanel {
        @NotNull
        private final EditorTextField myTextField;
        @NotNull
        private final FixedSizeButton myRegisteredProjectsButton;

        public MyPathAndProjectButtonPanel(@NotNull EditorTextField textField, @NotNull FixedSizeButton registeredProjectsButton) {
            if (textField == null) {
                MyPathAndProjectButtonPanel.$$$reportNull$$$0(0);
            }
            if (registeredProjectsButton == null) {
                MyPathAndProjectButtonPanel.$$$reportNull$$$0(1);
            }
            super(new GridBagLayout());
            this.myTextField = textField;
            this.myRegisteredProjectsButton = registeredProjectsButton;
            this.add((Component)this.myTextField, new GridBag().weightx(1.0).fillCellHorizontally());
            this.add((Component)this.myRegisteredProjectsButton, new GridBag().insets(0, 3, 0, 1));
        }

        @NotNull
        public EditorTextField getTextField() {
            EditorTextField editorTextField = this.myTextField;
            if (editorTextField == null) {
                MyPathAndProjectButtonPanel.$$$reportNull$$$0(2);
            }
            return editorTextField;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textField";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registeredProjectsButton";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyPathAndProjectButtonPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyPathAndProjectButtonPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyBrowseListener
    implements ActionListener {
        @NotNull
        private final FileChooserDescriptor myDescriptor;
        @NotNull
        private final Project myProject;
        private EditorTextField myPathField;

        MyBrowseListener(@NotNull FileChooserDescriptor descriptor2, @NlsContexts.DialogTitle @NotNull String fileChooserTitle, @NotNull Project project) {
            if (descriptor2 == null) {
                MyBrowseListener.$$$reportNull$$$0(0);
            }
            if (fileChooserTitle == null) {
                MyBrowseListener.$$$reportNull$$$0(1);
            }
            if (project == null) {
                MyBrowseListener.$$$reportNull$$$0(2);
            }
            descriptor2.setTitle(fileChooserTitle);
            this.myDescriptor = descriptor2;
            this.myProject = project;
        }

        private void setPathField(@NotNull EditorTextField pathField) {
            if (pathField == null) {
                MyBrowseListener.$$$reportNull$$$0(3);
            }
            this.myPathField = pathField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualFile file;
            if (this.myPathField == null) {
                assert (false);
                return;
            }
            PropertiesComponent component = PropertiesComponent.getInstance((Project)this.myProject);
            String pathToStart = this.myPathField.getText();
            if (StringUtil.isEmpty((String)pathToStart)) {
                pathToStart = component.getValue(ExternalProjectPathField.PROJECT_FILE_TO_START_WITH_KEY);
            }
            VirtualFile fileToStart = null;
            if (!StringUtil.isEmpty((String)pathToStart)) {
                fileToStart = LocalFileSystem.getInstance().findFileByPath(pathToStart);
            }
            if ((file = FileChooser.chooseFile((FileChooserDescriptor)this.myDescriptor, (Project)this.myProject, (VirtualFile)fileToStart)) != null) {
                String path = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file);
                this.myPathField.setText(path);
                component.setValue(ExternalProjectPathField.PROJECT_FILE_TO_START_WITH_KEY, path);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileChooserTitle";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathField";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyBrowseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setPathField";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

