/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.AbstractBuildEvent;
import com.intellij.build.events.impl.FailureImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemMessageEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.Failure;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResult;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExternalSystemProgressEventConverter {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.externalSystem.event-processing");

    @Nullable
    public static BuildEvent convertBuildEvent(@NotNull ExternalSystemTaskExecutionEvent event) {
        if (event == null) {
            ExternalSystemProgressEventConverter.$$$reportNull$$$0(0);
        }
        String hint = event.getProgressEvent().getDescriptor().getHint();
        AbstractBuildEvent buildEvent = ExternalSystemProgressEventConverter.convertAbstractBuildEvent(event);
        if (buildEvent != null) {
            buildEvent.setHint(hint);
        }
        return buildEvent;
    }

    @Nullable
    private static AbstractBuildEvent convertAbstractBuildEvent(@NotNull ExternalSystemTaskExecutionEvent event) {
        if (event == null) {
            ExternalSystemProgressEventConverter.$$$reportNull$$$0(1);
        }
        ExternalSystemProgressEvent progressEvent = event.getProgressEvent();
        String eventId = progressEvent.getEventId();
        OperationDescriptor descriptor2 = progressEvent.getDescriptor();
        long eventTime = descriptor2.getEventTime();
        String displayName = descriptor2.getDisplayName();
        Serializable parentEventId = (Serializable)ObjectUtils.chooseNotNull((Object)progressEvent.getParentEventId(), (Object)event.getId());
        if (progressEvent instanceof ExternalSystemStartEvent) {
            return new StartEventImpl((Object)eventId, (Object)parentEventId, eventTime, displayName);
        }
        if (progressEvent instanceof ExternalSystemFinishEvent) {
            ExternalSystemFinishEvent finishEvent = (ExternalSystemFinishEvent)progressEvent;
            OperationResult operationResult = finishEvent.getOperationResult();
            EventResult eventResult = ExternalSystemProgressEventConverter.convertEventResult(operationResult);
            if (eventResult != null) {
                return new FinishEventImpl((Object)eventId, (Object)parentEventId, eventTime, displayName, eventResult);
            }
        } else {
            if (progressEvent instanceof ExternalSystemStatusEvent) {
                ExternalSystemStatusEvent statusEvent = (ExternalSystemStatusEvent)progressEvent;
                long total = statusEvent.getTotal();
                long progress = statusEvent.getProgress();
                String unit = statusEvent.getUnit();
                return new ProgressBuildEventImpl((Object)eventId, (Object)parentEventId, eventTime, displayName, total, progress, unit);
            }
            if (progressEvent instanceof ExternalSystemMessageEvent) {
                ExternalSystemMessageEvent messageEvent = (ExternalSystemMessageEvent)progressEvent;
                String message = (String)ObjectUtils.chooseNotNull((Object)messageEvent.getMessage(), (Object)displayName);
                boolean isStdOut = messageEvent.isStdOut();
                return new OutputBuildEventImpl((Object)eventId, (Object)parentEventId, message, isStdOut);
            }
        }
        LOG.warn("Undefined progress event " + event.getClass().getSimpleName() + " " + String.valueOf(event));
        return null;
    }

    @Nullable
    private static EventResult convertEventResult(@NotNull OperationResult result) {
        if (result == null) {
            ExternalSystemProgressEventConverter.$$$reportNull$$$0(2);
        }
        if (result instanceof FailureResult) {
            List<com.intellij.build.events.Failure> failures = ExternalSystemProgressEventConverter.convertFailureResult((FailureResult)result);
            return new FailureResultImpl(failures);
        }
        if (result instanceof SkippedResult) {
            return new SkippedResultImpl();
        }
        if (result instanceof SuccessResult) {
            SuccessResult successResult = (SuccessResult)result;
            return new SuccessResultImpl(successResult.isUpToDate());
        }
        return null;
    }

    @NotNull
    private static List<com.intellij.build.events.Failure> convertFailureResult(@NotNull FailureResult failure) {
        if (failure == null) {
            ExternalSystemProgressEventConverter.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.map((Collection)failure.getFailures(), it -> ExternalSystemProgressEventConverter.convertFailure(it));
        if (list == null) {
            ExternalSystemProgressEventConverter.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static com.intellij.build.events.Failure convertFailure(@NotNull Failure failure) {
        if (failure == null) {
            ExternalSystemProgressEventConverter.$$$reportNull$$$0(5);
        }
        List causes = ContainerUtil.map((Collection)failure.getCauses(), it -> ExternalSystemProgressEventConverter.convertFailure(it));
        return new FailureImpl(failure.getMessage(), failure.getDescription(), causes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/util/ExternalSystemProgressEventConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemProgressEventConverter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFailureResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertBuildEvent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertAbstractBuildEvent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertEventResult";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertFailureResult";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertFailure";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

