/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.telephony;

import com.intellij.cwm.plugin.common.telephony.MyFormatter;
import com.intellij.openapi.application.PathManager;
import java.nio.file.Path;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.cef.CefSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/cwm/plugin/common/telephony/TelephonyLogger;", "", "className", "", "<init>", "(Ljava/lang/String;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "logDirPath", "Ljava/nio/file/Path;", "Lorg/jetbrains/annotations/NotNull;", "logfileName", "info", "", "message", "warning", "autoDetermination", "level", "Lorg/cef/CefSettings$LogSeverity;", "intellij.cwm.plugin.common"})
public final class TelephonyLogger {
    private final Logger logger;
    @NotNull
    private final Path logDirPath;
    @NotNull
    private final String logfileName;

    public TelephonyLogger(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.logger = Logger.getLogger(className);
        Path path = PathManager.getLogDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getLogDir(...)");
        this.logDirPath = path;
        this.logfileName = "telephony.log";
        Path logfilePath = this.logDirPath.resolve(this.logfileName);
        Handler fileHandler = new FileHandler(String.valueOf(logfilePath));
        fileHandler.setFormatter(new MyFormatter());
        this.logger.setUseParentHandlers(false);
        this.logger.addHandler(fileHandler);
    }

    public final void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.info(message);
    }

    public final void warning(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.warning(message);
    }

    public final void autoDetermination(@NotNull String message, @NotNull CefSettings.LogSeverity level) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (level.compareTo((Enum)CefSettings.LogSeverity.LOGSEVERITY_INFO) > 0) {
            this.logger.warning(message);
        } else {
            this.logger.info(message);
        }
    }
}

