/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.provider.utils;

import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.platform.eel.EelExecApi;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.OwnedBuilder;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFsError;
import com.intellij.platform.eel.fs.EelOpenedFile;
import com.intellij.platform.eel.provider.utils.EelUtilsKt;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.intellij.util.text.StringKt;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.ReadOnlyFileSystemException;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\u001a\u0018\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0007\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007\u001a\f\u0010\u000f\u001a\u00020\n*\u00020\tH\u0007\u001a\f\u0010\u0010\u001a\u00020\t*\u00020\nH\u0007\u001a-\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012\"\b\b\u0001\u0010\u0013*\u00020\u0014*\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016\u001a>\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012\"\b\b\u0001\u0010\u0013*\u00020\u0014\"\u001a\b\u0002\u0010\u0017*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\u00150\u0018*\u0002H\u0017H\u0087@\u00a2\u0006\u0002\u0010\u0019\u001a\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0014H\u0007\"'\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"fetchLoginShellEnvVariablesBlocking", "", "", "Lcom/intellij/platform/eel/EelExecApi;", "toOs", "Lcom/intellij/util/system/OS;", "Lcom/intellij/platform/eel/EelPlatform;", "archMap", "Lcom/intellij/util/containers/BidirectionalMap;", "Lcom/intellij/util/system/CpuArch;", "Lcom/intellij/platform/eel/EelPlatform$Arch;", "getArchMap", "()Lcom/intellij/util/containers/BidirectionalMap;", "archMap$delegate", "Lkotlin/Lazy;", "toEelArch", "toCpuArch", "getOrThrowFileSystemException", "T", "E", "Lcom/intellij/platform/eel/fs/EelFsError;", "Lcom/intellij/platform/eel/EelResult;", "(Lcom/intellij/platform/eel/EelResult;)Ljava/lang/Object;", "O", "Lcom/intellij/platform/eel/OwnedBuilder;", "(Lcom/intellij/platform/eel/OwnedBuilder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "throwFileSystemException", "", "intellij.platform.eel.provider"})
@SourceDebugExtension(value={"SMAP\neelUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 eelUtils.kt\ncom/intellij/platform/eel/provider/utils/EelUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class EelUtilsKt {
    @NotNull
    private static final Lazy archMap$delegate = LazyKt.lazy(EelUtilsKt::archMap_delegate$lambda$0);

    @ApiStatus.Internal
    @NotNull
    public static final Map<String, String> fetchLoginShellEnvVariablesBlocking(@NotNull EelExecApi $this$fetchLoginShellEnvVariablesBlocking) {
        Intrinsics.checkNotNullParameter((Object)$this$fetchLoginShellEnvVariablesBlocking, (String)"<this>");
        return (Map)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends String>>, Object>($this$fetchLoginShellEnvVariablesBlocking, null){
            int label;
            final /* synthetic */ EelExecApi $this_fetchLoginShellEnvVariablesBlocking;
            {
                this.$this_fetchLoginShellEnvVariablesBlocking = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$this_fetchLoginShellEnvVariablesBlocking.fetchLoginShellEnvVariables((Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @ApiStatus.Internal
    @NotNull
    public static final OS toOs(@NotNull EelPlatform $this$toOs) {
        OS oS;
        Intrinsics.checkNotNullParameter((Object)$this$toOs, (String)"<this>");
        EelPlatform eelPlatform = $this$toOs;
        if (eelPlatform instanceof EelPlatform.Windows) {
            oS = OS.Windows;
        } else if (eelPlatform instanceof EelPlatform.Linux) {
            oS = OS.Linux;
        } else if (eelPlatform instanceof EelPlatform.Darwin) {
            oS = OS.macOS;
        } else if (eelPlatform instanceof EelPlatform.FreeBSD) {
            oS = OS.FreeBSD;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return oS;
    }

    private static final BidirectionalMap<CpuArch, EelPlatform.Arch> getArchMap() {
        Lazy lazy = archMap$delegate;
        return (BidirectionalMap)lazy.getValue();
    }

    @ApiStatus.Internal
    @NotNull
    public static final EelPlatform.Arch toEelArch(@NotNull CpuArch $this$toEelArch) {
        Intrinsics.checkNotNullParameter((Object)$this$toEelArch, (String)"<this>");
        EelPlatform.Arch arch = (EelPlatform.Arch)EelUtilsKt.getArchMap().get((Object)$this$toEelArch);
        if (arch == null) {
            arch = (EelPlatform.Arch)EelPlatform.Arch.Unknown.INSTANCE;
        }
        return arch;
    }

    @ApiStatus.Internal
    @NotNull
    public static final CpuArch toCpuArch(@NotNull EelPlatform.Arch $this$toCpuArch) {
        Intrinsics.checkNotNullParameter((Object)$this$toCpuArch, (String)"<this>");
        List list = EelUtilsKt.getArchMap().getKeysByValue((Object)$this$toCpuArch);
        if (list == null || (list = (CpuArch)CollectionsKt.single((List)list)) == null) {
            list = CpuArch.UNKNOWN;
        }
        return list;
    }

    @ApiStatus.Internal
    public static final <T, E extends EelFsError> T getOrThrowFileSystemException(@NotNull EelResult<? extends T, ? extends E> $this$getOrThrowFileSystemException) throws FileSystemException {
        Intrinsics.checkNotNullParameter($this$getOrThrowFileSystemException, (String)"<this>");
        EelResult<? extends T, ? extends E> eelResult = $this$getOrThrowFileSystemException;
        if (!(eelResult instanceof EelResult.Ok)) {
            if (eelResult instanceof EelResult.Error) {
                EelUtilsKt.throwFileSystemException((EelFsError)((EelResult.Error)$this$getOrThrowFileSystemException).getError());
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return (T)((EelResult.Ok)$this$getOrThrowFileSystemException).getValue();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @ApiStatus.Internal
    @Nullable
    public static final <T, E extends EelFsError, O extends OwnedBuilder<EelResult<? extends T, ? extends E>>> Object getOrThrowFileSystemException(@NotNull O $this$getOrThrowFileSystemException, @NotNull Continuation<? super T> $completion) throws FileSystemException {
        if (!($completion instanceof getOrThrowFileSystemException.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EelUtilsKt.getOrThrowFileSystemException(null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable($this$getOrThrowFileSystemException /* !! */ );
                $continuation.label = 1;
                v0 = $this$getOrThrowFileSystemException /* !! */ .eelIt($continuation);
                ** if (v0 != var6_4) goto lbl19
lbl18:
                // 1 sources

                return var6_4;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                $this$getOrThrowFileSystemException /* !! */  = (OwnedBuilder)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    if (!((var3_6 = (v = (EelResult)v0)) instanceof EelResult.Ok)) {
                        if (var3_6 instanceof EelResult.Error) {
                            EelUtilsKt.throwFileSystemException((EelFsError)((EelResult.Error)v).getError());
                            throw new KotlinNothingValueException();
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    return ((EelResult.Ok)v).getValue();
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Throwable t) {
                    v1 = t.getMessage();
                    if (v1 == null) {
                        v1 = "";
                    }
                    throw new IOException(v1, t);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @ApiStatus.Internal
    @NotNull
    public static final Void throwFileSystemException(@NotNull EelFsError $this$throwFileSystemException) throws FileSystemException {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)$this$throwFileSystemException, (String)"<this>");
        EelFsError eelFsError = $this$throwFileSystemException;
        if (eelFsError instanceof EelFsError.DoesNotExist) {
            throwable = new NoSuchFileException($this$throwFileSystemException.getWhere().toString(), null, StringKt.nullize$default((String)$this$throwFileSystemException.getMessage(), (boolean)false, (int)1, null));
        } else if (eelFsError instanceof EelFsError.NotFile) {
            throwable = new FileSystemException($this$throwFileSystemException.getWhere().toString(), null, "Is a directory");
        } else if (eelFsError instanceof EelFsError.PermissionDenied) {
            throwable = new AccessDeniedException($this$throwFileSystemException.getWhere().toString(), null, StringKt.nullize$default((String)$this$throwFileSystemException.getMessage(), (boolean)false, (int)1, null));
        } else if (eelFsError instanceof EelFsError.NotDirectory) {
            throwable = new NotDirectoryException($this$throwFileSystemException.getWhere().toString());
        } else if (eelFsError instanceof EelFsError.AlreadyExists) {
            throwable = new FileAlreadyExistsException($this$throwFileSystemException.getWhere().toString());
        } else if (eelFsError instanceof EelFsError.UnknownFile) {
            throwable = new IOException("File is not opened");
        } else if (eelFsError instanceof EelFsError.DirNotEmpty) {
            throwable = new DirectoryNotEmptyException($this$throwFileSystemException.getWhere().toString());
        } else if (eelFsError instanceof EelFsError.NameTooLong) {
            throwable = new IllegalArgumentException("Name is too long");
        } else if (eelFsError instanceof EelFsError.NotEnoughSpace) {
            throwable = new FileSystemException($this$throwFileSystemException.getWhere().toString(), null, "Not enough space");
        } else if (eelFsError instanceof EelFsError.ReadOnlyFileSystem) {
            throwable = new ReadOnlyFileSystemException();
        } else if (eelFsError instanceof EelOpenedFile.SeekError.InvalidValue) {
            throwable = new IllegalArgumentException($this$throwFileSystemException.getMessage());
        } else if (eelFsError instanceof EelOpenedFile.Reader.ReadError.InvalidValue) {
            throwable = new IllegalArgumentException($this$throwFileSystemException.getMessage());
        } else {
            if (eelFsError instanceof EelOpenedFile.Writer.TruncateError.NegativeOffset || eelFsError instanceof EelOpenedFile.Writer.TruncateError.OffsetTooBig) {
                throw new IllegalArgumentException($this$throwFileSystemException.getMessage());
            }
            if (eelFsError instanceof EelOpenedFile.Writer.WriteError.InvalidValue) {
                throw new IllegalArgumentException($this$throwFileSystemException.getMessage());
            }
            if (eelFsError instanceof EelFileSystemApi.DeleteError.UnresolvedLink) {
                throw new FileSystemException($this$throwFileSystemException.getWhere().toString(), null, $this$throwFileSystemException.getMessage());
            }
            if (eelFsError instanceof EelFileSystemApi.FileReaderError.FileBiggerThanRequested) {
                FileSystemException fileSystemException;
                FileSystemException $this$throwFileSystemException_u24lambda_u240 = fileSystemException = new FileSystemException($this$throwFileSystemException.getWhere().toString(), null, "File is too big");
                boolean bl = false;
                $this$throwFileSystemException_u24lambda_u240.initCause((Throwable)new FileTooBigException("File is too big"));
                throw (Throwable)fileSystemException;
            }
            if (eelFsError instanceof EelFsError.Other) {
                throwable = new FileSystemException($this$throwFileSystemException.getWhere().toString(), null, StringKt.nullize$default((String)$this$throwFileSystemException.getMessage(), (boolean)false, (int)1, null));
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        throw throwable;
    }

    private static final BidirectionalMap archMap_delegate$lambda$0() {
        BidirectionalMap bidirectionalMap;
        BidirectionalMap $this$archMap_delegate_u24lambda_u240_u240 = bidirectionalMap = new BidirectionalMap();
        boolean bl = false;
        $this$archMap_delegate_u24lambda_u240_u240.put((Object)CpuArch.X86, (Object)EelPlatform.Arch.X86.INSTANCE);
        $this$archMap_delegate_u24lambda_u240_u240.put((Object)CpuArch.X86_64, (Object)EelPlatform.Arch.X86_64.INSTANCE);
        $this$archMap_delegate_u24lambda_u240_u240.put((Object)CpuArch.ARM32, (Object)EelPlatform.Arch.ARM_32.INSTANCE);
        $this$archMap_delegate_u24lambda_u240_u240.put((Object)CpuArch.ARM64, (Object)EelPlatform.Arch.ARM_64.INSTANCE);
        $this$archMap_delegate_u24lambda_u240_u240.put((Object)CpuArch.OTHER, (Object)EelPlatform.Arch.Unknown.INSTANCE);
        $this$archMap_delegate_u24lambda_u240_u240.put((Object)CpuArch.UNKNOWN, (Object)EelPlatform.Arch.Unknown.INSTANCE);
        return bidirectionalMap;
    }
}

