/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.indices;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import it.unimi.dsi.fastutil.Hash;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0000\"\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000*$\b\u0000\u0010\u0000\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*0\b\u0000\u0010\u0004\"\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005*\u0018\b\u0000\u0010\t\"\b\u0012\u0004\u0012\u00020\u00060\n2\b\u0012\u0004\u0012\u00020\u00060\n\u00a8\u0006\u000f"}, d2={"EntityId2Vfu", "Lkotlinx/collections/immutable/PersistentMap;", "", "", "Vfu2EntityId", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "Lcom/intellij/platform/workspace/storage/impl/containers/Object2LongWithDefaultMap;", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityIdWithProperty;", "EntityId2JarDir", "Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongMultiMap;", "getHashingStrategy", "Lit/unimi/dsi/fastutil/Hash$Strategy;", "STANDARD_STRATEGY", "CASE_INSENSITIVE_STRATEGY", "intellij.platform.workspace.storage"})
public final class VirtualFileIndexKt {
    @NotNull
    private static final Hash.Strategy<VirtualFileUrl> STANDARD_STRATEGY = (Hash.Strategy)new Hash.Strategy<VirtualFileUrl>(){

        public boolean equals(VirtualFileUrl firstVirtualFile, VirtualFileUrl secondVirtualFile) {
            if (firstVirtualFile == secondVirtualFile) {
                return true;
            }
            if (firstVirtualFile == null || secondVirtualFile == null) {
                return false;
            }
            return Intrinsics.areEqual((Object)firstVirtualFile, (Object)secondVirtualFile);
        }

        public int hashCode(VirtualFileUrl fileUrl) {
            if (fileUrl == null) {
                return 0;
            }
            return fileUrl.hashCode();
        }
    };
    @NotNull
    private static final Hash.Strategy<VirtualFileUrl> CASE_INSENSITIVE_STRATEGY = (Hash.Strategy)new Hash.Strategy<VirtualFileUrl>(){

        public boolean equals(VirtualFileUrl firstVirtualFile, VirtualFileUrl secondVirtualFile) {
            VirtualFileUrl virtualFileUrl = firstVirtualFile;
            VirtualFileUrl virtualFileUrl2 = secondVirtualFile;
            return StringUtilRt.equal((CharSequence)(virtualFileUrl != null ? virtualFileUrl.getUrl() : null), (CharSequence)(virtualFileUrl2 != null ? virtualFileUrl2.getUrl() : null), (boolean)false);
        }

        public int hashCode(VirtualFileUrl fileUrl) {
            if (fileUrl == null) {
                return 0;
            }
            return Strings.stringHashCodeInsensitive((CharSequence)fileUrl.getUrl());
        }
    };

    @NotNull
    public static final Hash.Strategy<VirtualFileUrl> getHashingStrategy() {
        boolean indexSensitivityEnabled = Registry.Companion.is("ide.new.project.model.index.case.sensitivity", false);
        if (!indexSensitivityEnabled) {
            return STANDARD_STRATEGY;
        }
        if (!SystemInfoRt.isFileSystemCaseSensitive) {
            return CASE_INSENSITIVE_STRATEGY;
        }
        return STANDARD_STRATEGY;
    }
}

