/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0004\u0010\u0011\u0012\u0013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/run/actions/MoveGridFloatingPagingAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/database/run/actions/GridAction;", "newPosition", "Lcom/intellij/database/settings/DataGridSettings$PagingDisplayMode;", "<init>", "(Lcom/intellij/database/settings/DataGridSettings$PagingDisplayMode;)V", "getNewPosition", "()Lcom/intellij/database/settings/DataGridSettings$PagingDisplayMode;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "EditorToolbar", "GridLeft", "GridRight", "GridCenter", "intellij.grid.impl"})
public abstract class MoveGridFloatingPagingAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    private final DataGridSettings.PagingDisplayMode newPosition;

    public MoveGridFloatingPagingAction(@NotNull DataGridSettings.PagingDisplayMode newPosition) {
        Intrinsics.checkNotNullParameter((Object)newPosition, (String)"newPosition");
        this.newPosition = newPosition;
    }

    @NotNull
    public final DataGridSettings.PagingDisplayMode getNewPosition() {
        return this.newPosition;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        DataGrid dataGrid = GridUtil.getDataGrid(e.getDataContext());
        if (dataGrid == null) {
            return;
        }
        DataGrid grid = dataGrid;
        DataGridSettings dataGridSettings = GridUtil.getSettings(grid);
        if (dataGridSettings == null) {
            return;
        }
        DataGridSettings settings = dataGridSettings;
        e.getPresentation().setEnabledAndVisible(settings.getPagingDisplayMode() != this.newPosition);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = GridUtil.getDataGrid(e.getDataContext());
        if (dataGrid == null) {
            return;
        }
        DataGrid grid = dataGrid;
        DataGridSettings dataGridSettings = GridUtil.getSettings(grid);
        if (dataGridSettings == null) {
            return;
        }
        DataGridSettings settings = dataGridSettings;
        settings.setPagingDisplayMode(this.newPosition);
        settings.fireChanged();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/run/actions/MoveGridFloatingPagingAction$EditorToolbar;", "Lcom/intellij/database/run/actions/MoveGridFloatingPagingAction;", "<init>", "()V", "intellij.grid.impl"})
    public static final class EditorToolbar
    extends MoveGridFloatingPagingAction {
        public EditorToolbar() {
            super(DataGridSettings.PagingDisplayMode.DATA_EDITOR_TOOLBAR);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/run/actions/MoveGridFloatingPagingAction$GridCenter;", "Lcom/intellij/database/run/actions/MoveGridFloatingPagingAction;", "<init>", "()V", "intellij.grid.impl"})
    public static final class GridCenter
    extends MoveGridFloatingPagingAction {
        public GridCenter() {
            super(DataGridSettings.PagingDisplayMode.GRID_CENTER_FLOATING);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/run/actions/MoveGridFloatingPagingAction$GridLeft;", "Lcom/intellij/database/run/actions/MoveGridFloatingPagingAction;", "<init>", "()V", "intellij.grid.impl"})
    public static final class GridLeft
    extends MoveGridFloatingPagingAction {
        public GridLeft() {
            super(DataGridSettings.PagingDisplayMode.GRID_LEFT_FLOATING);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/run/actions/MoveGridFloatingPagingAction$GridRight;", "Lcom/intellij/database/run/actions/MoveGridFloatingPagingAction;", "<init>", "()V", "intellij.grid.impl"})
    public static final class GridRight
    extends MoveGridFloatingPagingAction {
        public GridRight() {
            super(DataGridSettings.PagingDisplayMode.GRID_RIGHT_FLOATING);
        }
    }
}

