/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.editor.actions.command.mode;

import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookCellCaretTracker;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.Gray;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001aB\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00142\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListenerAdapter;", "Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/Disposable$Default;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "currentEditorMode", "Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorMode;", "isInitializing", "", "onModeChange", "", "mode", "caretAdded", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "caretRemoved", "getCaretAttributes", "Lcom/intellij/openapi/editor/CaretVisualAttributes;", "kotlin.jvm.PlatformType", "isCaretRowShown", "handleCarets", "saveCaretPositions", "restoreSavedCaretPositions", "Companion", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookEditorModeListenerAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookEditorModeListenerAdapter.kt\ncom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListenerAdapter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n23#2:126\n4253#3,12:127\n1915#4,2:139\n1915#4,2:141\n*S KotlinDebug\n*F\n+ 1 NotebookEditorModeListenerAdapter.kt\ncom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListenerAdapter\n*L\n27#1:126\n32#1:127,12\n32#1:139,2\n44#1:141,2\n*E\n"})
public final class NotebookEditorModeListenerAdapter
implements NotebookEditorModeListener,
CaretListener,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @Nullable
    private NotebookEditorMode currentEditorMode;
    private boolean isInitializing;
    @NotNull
    private static final CaretVisualAttributes INVISIBLE_CARET = new CaretVisualAttributes(Gray.TRANSPARENT, CaretVisualAttributes.Weight.NORMAL);
    @NotNull
    private static final Key<List<NotebookCellCaretTracker.CellCaretPosition>> SAVED_CARET_POSITIONS_KEY;

    private NotebookEditorModeListenerAdapter(Editor editor) {
        this.editor = editor;
        this.isInitializing = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onModeChange(@NotNull Editor editor, @NotNull NotebookEditorMode mode) {
        void $this$forEach$iv;
        Iterator $this$filterIsInstanceTo$iv$iv;
        MarkupModelEx $this$thisLogger$iv2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        boolean modeWasChanged = this.currentEditorMode != mode;
        this.currentEditorMode = mode;
        if (editor.isDisposed()) {
            NotebookEditorModeListenerAdapter $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NotebookEditorModeListenerAdapter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot change notebook mode, Editor is disposed already");
            return;
        }
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx $this$onModeChange_u24lambda_u240 = $this$thisLogger$iv2 = (MarkupModelEx)markupModel;
        boolean bl = false;
        RangeHighlighter[] rangeHighlighterArray = $this$onModeChange_u24lambda_u240.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object $this$filterIsInstance$iv = rangeHighlighterArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RangeHighlighterEx)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighterEx it = (RangeHighlighterEx)element$iv;
            boolean bl2 = false;
            LineMarkerRenderer lineMarkerRenderer = it.getLineMarkerRenderer();
            it.setLineMarkerRenderer(null);
            it.setLineMarkerRenderer(lineMarkerRenderer);
        }
        if (modeWasChanged) {
            this.handleCarets(mode);
            editor.getSettings().setCaretRowShown(this.isCaretRowShown(mode));
        }
        List list = editor.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$forEach$iv2 = list;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Caret caret = (Caret)element$iv;
            boolean bl3 = false;
            caret.setVisualAttributes(this.getCaretAttributes(mode));
        }
        JComponent jComponent = editor.getContentComponent();
        jComponent.putClientProperty(ActionUtil.ALLOW_PlAIN_LETTER_SHORTCUTS, switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            default -> throw new NoWhenBranchMatchedException();
        });
        JComponent jComponent2 = editor.getContentComponent();
        jComponent2.enableInputMethods(switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    public void caretAdded(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NotebookEditorMode notebookEditorMode = this.currentEditorMode;
        if (notebookEditorMode == null) {
            return;
        }
        NotebookEditorMode mode = notebookEditorMode;
        event.getCaret().setVisualAttributes(this.getCaretAttributes(mode));
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor).getGutterComponentEx().repaint();
    }

    public void caretRemoved(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor).getGutterComponentEx().repaint();
    }

    private final CaretVisualAttributes getCaretAttributes(NotebookEditorMode mode) {
        return switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> CaretVisualAttributes.getDefault();
            case 2 -> INVISIBLE_CARET;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isCaretRowShown(NotebookEditorMode mode) {
        return switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void handleCarets(NotebookEditorMode mode) {
        if (this.isInitializing) {
            return;
        }
        if (mode == NotebookEditorMode.EDIT) {
            this.editor.getCaretModel().removeSecondaryCarets();
            this.restoreSavedCaretPositions();
        } else {
            this.saveCaretPositions();
            for (Caret caret : this.editor.getCaretModel().getAllCarets()) {
                caret.removeSelection();
            }
        }
    }

    private final void saveCaretPositions() {
        NotebookCellCaretTracker notebookCellCaretTracker = NotebookCellCaretTracker.Companion.getInstance();
        if (notebookCellCaretTracker == null) {
            return;
        }
        NotebookCellCaretTracker caretTracker = notebookCellCaretTracker;
        List<NotebookCellCaretTracker.CellCaretPosition> caretPositions = caretTracker.saveCaretPositions(this.editor);
        if (caretPositions != null) {
            this.editor.putUserData(SAVED_CARET_POSITIONS_KEY, caretPositions);
        }
    }

    private final void restoreSavedCaretPositions() {
        List savedPositions = (List)this.editor.getUserData(SAVED_CARET_POSITIONS_KEY);
        this.editor.putUserData(SAVED_CARET_POSITIONS_KEY, null);
        Collection collection = savedPositions;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        NotebookCellCaretTracker notebookCellCaretTracker = NotebookCellCaretTracker.Companion.getInstance();
        if (notebookCellCaretTracker == null) {
            return;
        }
        NotebookCellCaretTracker caretTracker = notebookCellCaretTracker;
        caretTracker.restoreCaretPositions(this.editor, savedPositions);
    }

    public /* synthetic */ NotebookEditorModeListenerAdapter(Editor editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    static {
        Key key = Key.create((String)"NOTEBOOK_SAVED_CARET_POSITIONS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SAVED_CARET_POSITIONS_KEY = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0006\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \n*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListenerAdapter$Companion;", "", "<init>", "()V", "INVISIBLE_CARET", "Lcom/intellij/openapi/editor/CaretVisualAttributes;", "SAVED_CARET_POSITIONS_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookCellCaretTracker$CellCaretPosition;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "setupForEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.notebooks.ui"})
    public static final class Companion {
        private Companion() {
        }

        public final void setupForEditor(@NotNull Editor editor) {
            MessageBusConnection connection;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            NotebookEditorModeListenerAdapter listener = new NotebookEditorModeListenerAdapter(editor, null);
            editor.getCaretModel().addCaretListener((CaretListener)listener, (Disposable)listener);
            EditorUtil.disposeWithEditor((Editor)editor, (Disposable)((Disposable)listener));
            Project project = editor.getProject();
            MessageBusConnection messageBusConnection = connection = project != null && (project = project.getMessageBus()) != null ? project.connect((Disposable)listener) : null;
            if (messageBusConnection != null) {
                messageBusConnection.subscribe(NotebookEditorModeKt.getNOTEBOOK_EDITOR_MODE(), (Object)listener);
            }
            listener.onModeChange(editor, NotebookEditorModeKt.getCurrentMode(editor));
            listener.isInitializing = false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookEditorMode.values().length];
            try {
                nArray[NotebookEditorMode.EDIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookEditorMode.COMMAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

