/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.examples.server;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.intellij.httpClient.examples.server.GraphQLBody;
import com.intellij.httpClient.examples.server.GraphQLParser;
import com.intellij.httpClient.examples.server.GraphQLQuery;
import com.intellij.httpClient.examples.server.GraphQLRequest;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.webSocket.WebSocketClient;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a(\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000fH\u0002\u001a.\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001aE\u0010\u001c\u001a\u0002H\u001d\"\u0006\b\u0000\u0010\u001d\u0018\u0001*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2!\u0010!\u001a\u001d\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020'0\"H\u0082\b\u00a2\u0006\u0002\u0010(\u001a\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010,\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000*$\b\u0002\u0010\u000e\"\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u000f2\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u000f*$\b\u0002\u0010\u0011\"\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00120\u000f2\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00120\u000f\u00a8\u0006-"}, d2={"WEB_SOCKET_PREFIX", "", "GRAPH_QL_HTTP_PREFIX", "GRAPH_QL_WS_PREFIX", "MALFORMED_JSON_ERROR", "MALFORMED_GRAPHQL_REQUEST_ERROR", "parseQuery", "Lcom/intellij/httpClient/examples/server/GraphQLQuery;", "jsonBody", "Lcom/intellij/httpClient/examples/server/GraphQLRequest;", "send", "", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "message", "OperationFunctions", "", "Lcom/intellij/httpClient/examples/server/GraphQLFunction;", "Json", "", "getValue", "value", "variables", "createComment", "", "fieldBody", "Lcom/intellij/httpClient/examples/server/GraphQLBody;", "text", "userName", "fromJson", "T", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "json", "", "onError", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/core/JacksonException;", "Lkotlin/ParameterName;", "name", "error", "", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/lang/CharSequence;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "contentType", "Lio/netty/handler/codec/http/HttpHeaders;", "type", "SCHEME", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientExamplesServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/HttpClientExamplesServerKt\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,611:1\n116#2:612\n54#2:613\n117#2:614\n61#2,8:615\n71#2:624\n1#3:623\n*S KotlinDebug\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/HttpClientExamplesServerKt\n*L\n431#1:612\n431#1:613\n431#1:614\n431#1:615,8\n431#1:624\n431#1:623\n*E\n"})
public final class HttpClientExamplesServerKt {
    @NotNull
    private static final String WEB_SOCKET_PREFIX = "/http-client/examples/ws";
    @NotNull
    private static final String GRAPH_QL_HTTP_PREFIX = "/http-client/examples/graphql";
    @NotNull
    private static final String GRAPH_QL_WS_PREFIX = "/http-client/examples/graphql-ws";
    @NotNull
    private static final String MALFORMED_JSON_ERROR = "{\"error\": \"malformed JSON\"}";
    @NotNull
    private static final String MALFORMED_GRAPHQL_REQUEST_ERROR = "{\"error\": \"malformed GraphQL request\"}";
    @NotNull
    private static final String SCHEME = "\ntype Query {\n    getUser(userName: String): User\n    getCommentsWith(text: String): [Comment]\n}\n\ntype Mutation {\n    newComment(userName: String, text: String): Comment\n}\n\ntype Subscription {\n    newComments : Comment\n}\n\ntype User {\n    name: String,\n    comments: [Comment]\n}\n\ntype Comment {\n    text: String,\n    by: String\n}\n";

    private static final GraphQLQuery parseQuery(GraphQLRequest jsonBody) {
        String string = StringUtil.collapseWhiteSpace((CharSequence)StringsKt.replace$default((String)jsonBody.getQuery(), (String)"\\n", (String)"", (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collapseWhiteSpace(...)");
        String query = string;
        return new GraphQLParser(query).parseQuery();
    }

    /*
     * WARNING - void declaration
     */
    private static final void send(WebSocketClient $this$send, String message) {
        void $this$send_u24lambda_u240;
        ByteBuf byteBuf;
        ByteBuf byteBuf2 = byteBuf = $this$send.getByteBufAllocator().buffer();
        WebSocketClient webSocketClient = $this$send;
        boolean bl = false;
        $this$send_u24lambda_u240.writeCharSequence((CharSequence)message, Charsets.UTF_8);
        webSocketClient.send(byteBuf);
    }

    private static final String getValue(String value2, Map<String, String> variables2) {
        Map<String, String> map2;
        if (StringsKt.startsWith$default((String)value2, (String)"$", (boolean)false, (int)2, null)) {
            char[] cArray;
            map2 = variables2;
            if (map2 == null || (map2 = (String)map2.get(StringsKt.trimStart((String)value2, (char[])(cArray = new char[]{'$'})))) == null) {
                return null;
            }
        } else if (StringsKt.startsWith$default((String)value2, (String)"\"", (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{'\"'};
            map2 = StringsKt.trim((String)value2, (char[])cArray);
        } else {
            map2 = value2;
        }
        return map2;
    }

    private static final Map<String, Object> createComment(GraphQLBody fieldBody, String text2, String userName) {
        Map commentBody = new LinkedHashMap();
        for (Pair<String, GraphQLBody> pair : fieldBody.getFields()) {
            String commentField = (String)pair.component1();
            GraphQLBody commentFieldBody = (GraphQLBody)pair.component2();
            if (commentFieldBody != null) {
                return null;
            }
            String string = commentField;
            if (Intrinsics.areEqual((Object)string, (Object)"text")) {
                commentBody.put("text", text2);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"by")) {
                commentBody.put("by", userName);
                continue;
            }
            return null;
        }
        return commentBody;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ <T> T fromJson(ObjectMapper $this$fromJson, CharSequence json, Function1 onError) {
        boolean $i$f$fromJson = false;
        try {
            void $this$checkTypeMismatch$iv$iv;
            void $this$readValue$iv;
            ObjectMapper objectMapper = $this$fromJson;
            String content$iv = ((Object)json).toString();
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef22 = false;
            Intrinsics.needClassReification();
            Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(content$iv, new TypeReference<T>(){});
            boolean $i$f$checkTypeMismatch = false;
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!($this$checkTypeMismatch$iv$iv instanceof Object)) {
                String string;
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                String nullability$iv$iv = null instanceof Object ? "?" : "(non-null)";
                StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                StringBuilder stringBuilder2 = stringBuilder.append(Reflection.getOrCreateKotlinClass(Object.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                void v2 = $this$checkTypeMismatch$iv$iv;
                if (v2 != null) {
                    void it$iv$iv;
                    void var10_12 = v2;
                    StringBuilder stringBuilder3 = stringBuilder2;
                    boolean bl = false;
                    stringBuilder2 = stringBuilder3;
                    string = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                } else {
                    string = null;
                }
                String string2 = stringBuilder2.append(string).toString();
                throw new RuntimeJsonMappingException(string2);
            }
            return $this$checkTypeMismatch$iv$iv;
        }
        catch (JacksonException e) {
            onError.invoke((Object)e);
            throw new KotlinNothingValueException();
        }
    }

    private static final HttpHeaders contentType(String type) {
        HttpHeaders httpHeaders = new DefaultHttpHeaders().set("content-type", (Object)type);
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"set(...)");
        return httpHeaders;
    }

    public static final /* synthetic */ void access$send(WebSocketClient $receiver, String message) {
        HttpClientExamplesServerKt.send($receiver, message);
    }

    public static final /* synthetic */ HttpHeaders access$contentType(String type) {
        return HttpClientExamplesServerKt.contentType(type);
    }

    public static final /* synthetic */ GraphQLQuery access$parseQuery(GraphQLRequest jsonBody) {
        return HttpClientExamplesServerKt.parseQuery(jsonBody);
    }

    public static final /* synthetic */ String access$getValue(String value2, Map variables2) {
        return HttpClientExamplesServerKt.getValue(value2, variables2);
    }

    public static final /* synthetic */ Map access$createComment(GraphQLBody fieldBody, String text2, String userName) {
        return HttpClientExamplesServerKt.createComment(fieldBody, text2, userName);
    }
}

