/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.documentation.protocols;

import com.intellij.httpClient.converters.RequestBuilder;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.httpClient.http.request.lexer.HttpClientExtensionLexemesDefaultManager;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.model.Pointer;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000f\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0014\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/httpClient/http/request/documentation/protocols/ProtocolDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "protocolElement", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;)V", "protocolValue", "Lcom/intellij/httpClient/converters/RequestBuilder$HttpProtocol;", "getProtocolValue", "()Lcom/intellij/httpClient/converters/RequestBuilder$HttpProtocol;", "createPointer", "Lcom/intellij/model/Pointer;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "computeDocumentationHint", "", "Lcom/intellij/openapi/util/NlsContexts$HintText;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "invalidPresentation", "getInvalidPresentation", "()Lcom/intellij/platform/backend/presentation/TargetPresentation;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpProtocolDocumentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpProtocolDocumentationProvider.kt\ncom/intellij/httpClient/http/request/documentation/protocols/ProtocolDocumentationTarget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,81:1\n1#2:82\n66#3,2:83\n*S KotlinDebug\n*F\n+ 1 HttpProtocolDocumentationProvider.kt\ncom/intellij/httpClient/http/request/documentation/protocols/ProtocolDocumentationTarget\n*L\n51#1:83,2\n*E\n"})
final class ProtocolDocumentationTarget
implements DocumentationTarget {
    @NotNull
    private final SmartPsiElementPointer<PsiElement> protocolElement;

    public ProtocolDocumentationTarget(@NotNull SmartPsiElementPointer<PsiElement> protocolElement) {
        Intrinsics.checkNotNullParameter(protocolElement, (String)"protocolElement");
        this.protocolElement = protocolElement;
    }

    private final RequestBuilder.HttpProtocol getProtocolValue() {
        RequestBuilder.HttpProtocol httpProtocol;
        PsiElement psiElement = this.protocolElement.dereference();
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            httpProtocol = HttpRequestPsiConverter.getProtocolValue(it);
        } else {
            httpProtocol = null;
        }
        return httpProtocol;
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        Pointer pointer = Pointer.delegatingPointer((Pointer)((Pointer)this.protocolElement), arg_0 -> ProtocolDocumentationTarget.createPointer$lambda$1(ProtocolDocumentationTarget::createPointer$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"delegatingPointer(...)");
        return pointer;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        PsiElement psiElement = this.protocolElement.getElement();
        if (psiElement == null) {
            return this.getInvalidPresentation();
        }
        PsiElement protocol = psiElement;
        RequestBuilder.HttpProtocol httpProtocol = HttpRequestPsiConverter.getProtocolValue(protocol);
        if (httpProtocol == null) {
            return this.getInvalidPresentation();
        }
        RequestBuilder.HttpProtocol protocolValue = httpProtocol;
        Object[] objectArray = new Object[]{protocol.getText()};
        String string = RestClientBundle.message("http.client.protocol.doc.valid.presentation", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(string).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @Nullable
    public String computeDocumentationHint() {
        PsiElement protocol;
        PsiElement psiElement = this.protocolElement.getElement();
        if (psiElement == null) {
            return null;
        }
        PsiElement $this$parentOfType_u24default$iv = protocol = psiElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        HttpRequest httpRequest = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, HttpRequest.class, (boolean)true);
        if (httpRequest == null) {
            return null;
        }
        HttpRequest request = httpRequest;
        if (!HttpClientExtensionLexemesDefaultManager.getMethods().contains(request.getHttpMethod())) {
            return null;
        }
        RequestBuilder.HttpProtocol protocolValue = this.getProtocolValue();
        if (Intrinsics.areEqual((Object)request.getScheme(), (Object)"https")) {
            RequestBuilder.HttpProtocol httpProtocol = protocolValue;
            return switch (httpProtocol == null ? -1 : WhenMappings.$EnumSwitchMapping$0[httpProtocol.ordinal()]) {
                case 1 -> RestClientBundle.message("http.client.https.http1.documentaion", new Object[0]);
                case 2 -> RestClientBundle.message("http.client.https.http2.documentation", new Object[0]);
                case 3 -> RestClientBundle.message("http.client.https.http2.pk.documentation", new Object[0]);
                case -1 -> null;
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        if (Intrinsics.areEqual((Object)request.getScheme(), (Object)"http") || request.getScheme() == null) {
            RequestBuilder.HttpProtocol httpProtocol = protocolValue;
            return switch (httpProtocol == null ? -1 : WhenMappings.$EnumSwitchMapping$0[httpProtocol.ordinal()]) {
                case 1 -> RestClientBundle.message("http.client.http.http1.documentation", new Object[0]);
                case 2 -> RestClientBundle.message("http.client.http.http2.documentation", new Object[0]);
                case 3 -> RestClientBundle.message("http.client.http.http2.pk.documentation", new Object[0]);
                case -1 -> null;
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        return null;
    }

    @Nullable
    public DocumentationResult computeDocumentation() {
        String string = this.computeDocumentationHint();
        if (string == null) {
            return null;
        }
        String hint = string;
        return (DocumentationResult)DocumentationResult.Companion.documentation(hint);
    }

    private final TargetPresentation getInvalidPresentation() {
        String string = RestClientBundle.message("http.client.protocol.doc.invalid.presentation", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(string).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    private static final ProtocolDocumentationTarget createPointer$lambda$0(PsiElement it) {
        Intrinsics.checkNotNull((Object)it);
        return new ProtocolDocumentationTarget((SmartPsiElementPointer<PsiElement>)SmartPointersKt.createSmartPointer((PsiElement)it));
    }

    private static final ProtocolDocumentationTarget createPointer$lambda$1(Function1 $tmp0, Object p0) {
        return (ProtocolDocumentationTarget)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestBuilder.HttpProtocol.values().length];
            try {
                nArray[RequestBuilder.HttpProtocol.HTTP_11.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestBuilder.HttpProtocol.HTTP_2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestBuilder.HttpProtocol.HTTP_2_PRIOR_KNOWLEDGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

