/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.onboarding.comment;

import com.intellij.httpClient.http.request.HttpRequestFileUtils;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocComment;
import com.intellij.httpClient.http.request.onboarding.comment.HttpClientOnboardingCommentsUtilsKt;
import com.intellij.httpClient.http.request.onboarding.comment.HttpClientOnboardingState;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.documentation.InlineDocumentation;
import com.intellij.platform.backend.documentation.InlineDocumentationProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0002J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/intellij/httpClient/http/request/onboarding/comment/HttpClientOnboardingTipsDocumentationProvider;", "Lcom/intellij/platform/backend/documentation/InlineDocumentationProvider;", "<init>", "()V", "enabledForFile", "", "renderedOnboardingTipsEnabled", "", "getRenderedOnboardingTipsEnabled", "()Z", "inlineDocumentationItems", "", "Lcom/intellij/platform/backend/documentation/InlineDocumentation;", "file", "Lcom/intellij/psi/PsiFile;", "findInlineDocumentation", "textRange", "Lcom/intellij/openapi/util/TextRange;", "isEnabledForFile", "isExampleFile", "httpFile", "isRegularUsersFile", "showCommentForFile", "", "showTipCommentInExampleFile", "showStaticOnboardingComment", "fileTextRange", "findFirstSeparator", "Lcom/intellij/psi/PsiElement;", "markFileAsShown", "", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientOnboardingTipsDocumentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientOnboardingTipsDocumentationProvider.kt\ncom/intellij/httpClient/http/request/onboarding/comment/HttpClientOnboardingTipsDocumentationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1642#2,10:125\n1915#2:135\n1916#2:137\n1652#2:138\n1#3:136\n1#3:139\n*S KotlinDebug\n*F\n+ 1 HttpClientOnboardingTipsDocumentationProvider.kt\ncom/intellij/httpClient/http/request/onboarding/comment/HttpClientOnboardingTipsDocumentationProvider\n*L\n77#1:125,10\n77#1:135\n77#1:137\n77#1:138\n77#1:136\n*E\n"})
public final class HttpClientOnboardingTipsDocumentationProvider
implements InlineDocumentationProvider {
    @Nullable
    private String enabledForFile;

    private final boolean getRenderedOnboardingTipsEnabled() {
        return Registry.Companion.is("doc.onboarding.tips.render");
    }

    @NotNull
    public Collection<InlineDocumentation> inlineDocumentationItems(@Nullable PsiFile file) {
        if (file == null || !this.isEnabledForFile(file)) {
            return CollectionsKt.emptyList();
        }
        return HttpClientOnboardingTipsDocumentationProvider.showCommentForFile$default(this, file, null, 2, null);
    }

    @Nullable
    public InlineDocumentation findInlineDocumentation(@NotNull PsiFile file, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        if (!this.isEnabledForFile(file)) {
            return null;
        }
        return (InlineDocumentation)CollectionsKt.firstOrNull(this.showCommentForFile(file, textRange));
    }

    private final boolean isEnabledForFile(PsiFile file) {
        return this.getRenderedOnboardingTipsEnabled() && file instanceof HttpRequestPsiFile;
    }

    private final boolean isExampleFile(PsiFile httpFile) {
        VirtualFile virtualFile = httpFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        return HttpRequestFileUtils.isFileFromCollections(virtualFile2.getPath()) || Intrinsics.areEqual((Object)virtualFile2.getName(), (Object)"whats-new.http");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRegularUsersFile(PsiFile httpFile) {
        if (Intrinsics.areEqual((Object)this.enabledForFile, (Object)httpFile.getName())) return true;
        Project project = httpFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (HttpClientOnboardingState.Companion.getInstance(project).isOnboardingCommentShown()) return false;
        return true;
    }

    private final List<InlineDocumentation> showCommentForFile(PsiFile file, TextRange textRange) {
        return this.isExampleFile(file) ? this.showTipCommentInExampleFile(file, textRange) : (this.isRegularUsersFile(file) ? CollectionsKt.listOfNotNull((Object)this.showStaticOnboardingComment(file, textRange)) : CollectionsKt.emptyList());
    }

    static /* synthetic */ List showCommentForFile$default(HttpClientOnboardingTipsDocumentationProvider httpClientOnboardingTipsDocumentationProvider, PsiFile psiFile, TextRange textRange, int n, Object object) {
        if ((n & 2) != 0) {
            textRange = null;
        }
        return httpClientOnboardingTipsDocumentationProvider.showCommentForFile(psiFile, textRange);
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlineDocumentation> showTipCommentInExampleFile(PsiFile file, TextRange textRange) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        TextRange textRange2 = textRange;
        if (textRange2 == null) {
            object = (PsiElement)file;
        } else {
            PsiElement psiElement = file.findElementAt(textRange2.getStartOffset());
            object = psiElement != null ? psiElement.getParent() : null;
        }
        PsiElement elementInRange = object;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)elementInRange, HttpDocComment.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        Collection httpComments = collection;
        Iterable $this$mapNotNull$iv = httpComments;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            InlineDocumentation it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            HttpDocComment p0 = (HttpDocComment)element$iv$iv;
            boolean bl2 = false;
            if (HttpClientOnboardingCommentsUtilsKt.generateTipInlineDoc(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final InlineDocumentation showStaticOnboardingComment(PsiFile file, TextRange fileTextRange) {
        PsiElement psiElement = this.findFirstSeparator(file, fileTextRange);
        if (psiElement == null) {
            return null;
        }
        PsiElement separator = psiElement;
        this.markFileAsShown(file);
        return HttpClientOnboardingCommentsUtilsKt.generateStaticOnboardingInlineDoc(separator);
    }

    private final PsiElement findFirstSeparator(PsiFile file, TextRange fileTextRange) {
        PsiElement firstElementInRequest;
        PsiElement psiElement;
        PsiElement psiElement2 = file.getFirstChild();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement firstRequest = psiElement2;
        PsiElement psiElement3 = firstRequest.getFirstChild();
        if (psiElement3 == null) {
            return null;
        }
        PsiElement it = psiElement = (firstElementInRequest = psiElement3);
        boolean bl = false;
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)HttpRequestElementTypes.REQUEST_SEPARATOR) && (fileTextRange == null || fileTextRange.contains(it.getTextRange())) ? psiElement : null;
    }

    private final void markFileAsShown(PsiFile file) {
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        HttpClientOnboardingState onboardingState = HttpClientOnboardingState.Companion.getInstance(project);
        if (!onboardingState.isOnboardingCommentShown()) {
            this.enabledForFile = file.getName();
            onboardingState.setOnboardingCommentShown(true);
        }
    }
}

