/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.info;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.http.request.psi.HttpCommonScriptHandler;
import com.intellij.httpClient.http.request.psi.HttpFilePath;
import com.intellij.httpClient.http.request.psi.HttpHandlerScriptDescriptor;
import com.intellij.httpClient.http.request.psi.HttpPreRequestHandler;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpResponseHandler;
import com.intellij.httpClient.http.request.psi.HttpScriptBody;
import com.intellij.httpClient.http.request.run.HttpClientResponseHandler;
import com.intellij.httpClient.http.request.run.HttpRequestExecutionHelperService;
import com.intellij.httpClient.http.request.run.info.HttpRunRequestInfo;
import com.intellij.httpClient.http.request.run.info.ScriptSource;
import com.intellij.httpClient.http.request.run.preScript.HttpClientPreRequestHandler;
import com.intellij.httpClient.http.request.substitutor.HttpRequestVariableSessionSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import java.io.IOException;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a8\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a5\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u000b\u0010\u0014\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002\u001a>\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002\u00a8\u0006\u001f"}, d2={"createPreRequestHandler", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreRequestHandler;", "handler", "Lcom/intellij/httpClient/http/request/psi/HttpPreRequestHandler;", "commonScriptHandler", "Lcom/intellij/httpClient/http/request/psi/HttpCommonScriptHandler;", "createResponseHandler", "Lcom/intellij/httpClient/http/request/run/HttpClientResponseHandler;", "Lcom/intellij/httpClient/http/request/psi/HttpResponseHandler;", "pointerToOriginalElement", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "substitutor", "Lcom/intellij/httpClient/http/request/substitutor/HttpRequestVariableSessionSubstitutor;", "requestMethod", "", "readScript", "Lcom/intellij/httpClient/http/request/run/info/ScriptSource;", "scriptDescriptor", "Lcom/intellij/httpClient/http/request/psi/HttpHandlerScriptDescriptor;", "errorTitle", "Lcom/intellij/openapi/util/NlsContexts$NotificationTitle;", "errorProducer", "Lkotlin/Function1;", "showWarningIfPossible", "", "Ljava/util/function/Function;", "filePath", "Lcom/intellij/httpClient/http/request/psi/HttpFilePath;", "service", "Lcom/intellij/httpClient/http/request/run/HttpRequestExecutionHelperService;", "intellij.httpClient.executor"})
public final class RequestHandlerProviderKt {
    @Nullable
    public static final HttpClientPreRequestHandler createPreRequestHandler(@NotNull HttpPreRequestHandler handler, @Nullable HttpCommonScriptHandler commonScriptHandler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        ScriptSource scriptSource = RequestHandlerProviderKt.readScript(handler, HttpClientExecutorBundle.message("rest.client.cannot.execute.pre.request.handler.failed.title", new Object[0]), (Function1<? super String, String>)((Function1)RequestHandlerProviderKt::createPreRequestHandler$lambda$0));
        if (scriptSource == null) {
            return null;
        }
        ScriptSource scriptSource2 = scriptSource;
        ScriptSource commonScriptSource = RequestHandlerProviderKt.readScript(commonScriptHandler, HttpClientExecutorBundle.message("rest.client.cannot.execute.pre.request.handler.failed.title", new Object[0]), (Function1<? super String, String>)((Function1)RequestHandlerProviderKt::createPreRequestHandler$lambda$1));
        ScriptSource scriptSource3 = commonScriptSource;
        ScriptSource scriptSource4 = commonScriptSource;
        ScriptSource scriptSource5 = commonScriptSource;
        return new HttpClientPreRequestHandler(scriptSource2.getText(), scriptSource2.getFile(), scriptSource2.getLineOffset(), scriptSource3 != null ? scriptSource3.getText() : null, (VirtualFile)(scriptSource4 != null ? scriptSource4.getFile() : null), scriptSource5 != null ? scriptSource5.getLineOffset() : 0);
    }

    @Nullable
    public static final HttpClientResponseHandler createResponseHandler(@NotNull HttpResponseHandler handler, @NotNull SmartPsiElementPointer<HttpRequest> pointerToOriginalElement, @NotNull HttpRequestVariableSessionSubstitutor substitutor2, @NotNull String requestMethod, @Nullable HttpCommonScriptHandler commonScriptHandler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(pointerToOriginalElement, (String)"pointerToOriginalElement");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        ScriptSource scriptSource = RequestHandlerProviderKt.readScript(handler, HttpClientExecutorBundle.message("rest.client.cannot.execute.response.handler.failed.title", new Object[0]), (Function1<? super String, String>)((Function1)RequestHandlerProviderKt::createResponseHandler$lambda$0));
        if (scriptSource == null) {
            return null;
        }
        ScriptSource scriptSource2 = scriptSource;
        ScriptSource commonScriptSource = RequestHandlerProviderKt.readScript(commonScriptHandler, HttpClientExecutorBundle.message("rest.client.cannot.execute.response.handler.failed.title", new Object[0]), (Function1<? super String, String>)((Function1)RequestHandlerProviderKt::createResponseHandler$lambda$1));
        ScriptSource scriptSource3 = commonScriptSource;
        ScriptSource scriptSource4 = commonScriptSource;
        ScriptSource scriptSource5 = commonScriptSource;
        return new HttpClientResponseHandler(pointerToOriginalElement, substitutor2, requestMethod, scriptSource2.getText(), scriptSource2.getFile(), scriptSource2.getLineOffset(), scriptSource3 != null ? scriptSource3.getText() : null, (VirtualFile)(scriptSource4 != null ? scriptSource4.getFile() : null), scriptSource5 != null ? scriptSource5.getLineOffset() : 0);
    }

    private static final ScriptSource readScript(HttpHandlerScriptDescriptor scriptDescriptor, String errorTitle, Function1<? super String, String> errorProducer) {
        ScriptSource scriptSource;
        PsiFile file;
        HttpRequestExecutionHelperService service;
        if (scriptDescriptor == null) {
            return null;
        }
        HttpScriptBody scriptBody = scriptDescriptor.getScriptBody();
        if (scriptBody != null) {
            String text2 = scriptBody.getText();
            Intrinsics.checkNotNull((Object)text2);
            if (((CharSequence)text2).length() > 0) {
                Document document;
                PsiFile containingFile = scriptBody.getContainingFile();
                if (containingFile.getVirtualFile() == null) {
                    Logger.getInstance(HttpRunRequestInfo.class).error("Virtual file is null.");
                    return null;
                }
                VirtualFile sourceFile = scriptBody.getContainingFile().getVirtualFile();
                Document document2 = document = containingFile.getViewProvider().getDocument();
                int lineOffset = document2 != null ? document2.getLineNumber(scriptBody.getTextOffset()) : 0;
                Intrinsics.checkNotNull((Object)sourceFile);
                return new ScriptSource(text2, sourceFile, lineOffset);
            }
        }
        HttpFilePath httpFilePath = scriptDescriptor.getFilePath();
        if (httpFilePath == null) {
            return null;
        }
        HttpFilePath filePath = httpFilePath;
        HttpRequestExecutionHelperService httpRequestExecutionHelperService = service = HttpRequestExecutionHelperService.getInstance();
        Object object = file = httpRequestExecutionHelperService != null ? httpRequestExecutionHelperService.resolveFilePath(filePath) : null;
        if (file == null) {
            RequestHandlerProviderKt.showWarningIfPossible(scriptDescriptor, errorTitle, arg_0 -> RequestHandlerProviderKt.readScript$lambda$0(errorProducer, arg_0), filePath, service);
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        try {
            String string = VfsUtilCore.loadText((VirtualFile)virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
            String text3 = string;
            Intrinsics.checkNotNull((Object)virtualFile);
            scriptSource = new ScriptSource(text3, virtualFile, 0);
        }
        catch (IOException e) {
            RequestHandlerProviderKt.showWarningIfPossible(scriptDescriptor, errorTitle, arg_0 -> RequestHandlerProviderKt.readScript$lambda$1(errorProducer, arg_0), filePath, service);
            scriptSource = null;
        }
        return scriptSource;
    }

    private static final void showWarningIfPossible(HttpHandlerScriptDescriptor scriptDescriptor, String errorTitle, Function<String, String> errorProducer, HttpFilePath filePath, HttpRequestExecutionHelperService service) {
        block0: {
            Project project = scriptDescriptor.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            String string = filePath.getPresentablePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentablePath(...)");
            String path = string;
            HttpRequestExecutionHelperService httpRequestExecutionHelperService = service;
            if (httpRequestExecutionHelperService == null) break block0;
            httpRequestExecutionHelperService.showWarning(project2, errorTitle, errorProducer.apply(path));
        }
    }

    private static final String createPreRequestHandler$lambda$0(String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object[] objectArray = new Object[]{path};
        return HttpClientExecutorBundle.message("rest.client.request.cannot.find.pre.request.handler", objectArray);
    }

    private static final String createPreRequestHandler$lambda$1(String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object[] objectArray = new Object[]{path};
        return HttpClientExecutorBundle.message("rest.client.cannot.execute.pre.request.handler.failed.title", objectArray);
    }

    private static final String createResponseHandler$lambda$0(String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object[] objectArray = new Object[]{path};
        return HttpClientExecutorBundle.message("rest.client.request.cannot.find.response.handler", objectArray);
    }

    private static final String createResponseHandler$lambda$1(String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object[] objectArray = new Object[]{path};
        return HttpClientExecutorBundle.message("rest.client.request.cannot.find.response.handler", objectArray);
    }

    private static final String readScript$lambda$0(Function1 $tmp0, String p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (String)$tmp0.invoke((Object)p0);
    }

    private static final String readScript$lambda$1(Function1 $tmp0, String p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (String)$tmp0.invoke((Object)p0);
    }
}

