/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.injection.http.request;

import com.intellij.httpClient.executor.graphql.request.GraphQLPresentationKt;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestMessage;
import com.intellij.httpClient.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.httpClient.injection.http.request.HttpClientCustomBodyInjector;
import com.intellij.httpClient.injection.http.request.HttpRequestBodyInjector;
import com.intellij.httpClient.injection.http.request.InjectionsKt;
import com.intellij.httpClient.injection.http.request.Place;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/injection/http/request/GraphQLVariableInjector;", "Lcom/intellij/httpClient/injection/http/request/HttpClientCustomBodyInjector;", "<init>", "()V", "isApplicable", "", "request", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "provideInjection", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "message", "Lcom/intellij/httpClient/http/request/psi/HttpRequestMessagesGroup;", "injectVariablesJson", "messageBody", "Lcom/intellij/httpClient/http/request/psi/HttpMessageBody;", "injectVariablesJsonAfterGraphQl", "intellij.restClient"})
public final class GraphQLVariableInjector
implements HttpClientCustomBodyInjector {
    @Override
    public boolean isApplicable(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return Intrinsics.areEqual((Object)request.getHttpMethod(), (Object)"GRAPHQL");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void provideInjection(@NotNull MultiHostRegistrar registrar, @NotNull HttpRequestMessagesGroup message) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message.getRequestMessageList().size() > 1) {
            List<HttpRequestMessage> list2 = message.getRequestMessageList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getRequestMessageList(...)");
            if (CollectionsKt.last(list2) instanceof HttpMessageBody) {
                List<HttpRequestMessage> list3 = message.getRequestMessageList();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"getRequestMessageList(...)");
                Object object = CollectionsKt.last(list3);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.httpClient.http.request.psi.HttpMessageBody");
                this.injectVariablesJson((HttpMessageBody)object, registrar);
                return;
            }
        }
        if (message.getRequestMessageList().size() != 1) return;
        if (!(message.getRequestMessageList().get(0) instanceof HttpMessageBody)) return;
        HttpRequestMessage httpRequestMessage = message.getRequestMessageList().get(0);
        Intrinsics.checkNotNull((Object)httpRequestMessage, (String)"null cannot be cast to non-null type com.intellij.httpClient.http.request.psi.HttpMessageBody");
        this.injectVariablesJsonAfterGraphQl((HttpMessageBody)httpRequestMessage, registrar);
    }

    private final void injectVariablesJson(HttpMessageBody messageBody, MultiHostRegistrar registrar) {
        String text2 = messageBody.getText();
        Intrinsics.checkNotNull((Object)text2);
        if (StringsKt.isBlank((CharSequence)text2)) {
            return;
        }
        List<Place> injectionPlaces = HttpRequestBodyInjector.injectBody(messageBody, text2, null, 0);
        JsonLanguage jsonLanguage = JsonLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)jsonLanguage, (String)"INSTANCE");
        Language language = (Language)jsonLanguage;
        Intrinsics.checkNotNull(injectionPlaces);
        InjectionsKt.inject(registrar, language, injectionPlaces);
    }

    private final void injectVariablesJsonAfterGraphQl(HttpMessageBody messageBody, MultiHostRegistrar registrar) {
        String text2 = messageBody.getText();
        Intrinsics.checkNotNull((Object)text2);
        Integer jsonStart = GraphQLPresentationKt.findJsonPartInGraphQLText(text2);
        if (jsonStart != null) {
            String string = text2.substring(jsonStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            List<Place> injectionPlaces = HttpRequestBodyInjector.injectBody(messageBody, string, null, jsonStart);
            JsonLanguage jsonLanguage = JsonLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)jsonLanguage, (String)"INSTANCE");
            Language language = (Language)jsonLanguage;
            Intrinsics.checkNotNull(injectionPlaces);
            InjectionsKt.inject(registrar, language, injectionPlaces);
        }
    }
}

