/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ExecBuilder;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.ProcessBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RunViaSudoInfo;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.config.AuthMethods;
import com.intellij.ssh.config.RemoteCredentialsSshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ssh.interaction.PlatformSshPasswordProvider;
import com.intellij.ssh.process.CommandLineUtil;
import com.intellij.ssh.ui.SshPasswordPrompt;
import com.intellij.util.EventDispatcher;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a:\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a.\u0010\u0011\u001a\u00020\u0012*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0002\u001a\u0014\u0010\u0017\u001a\u00020\f*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0002\u001a\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a4\u0010\u001b\u001a\u00020\b*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002\"\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"connectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "Lcom/intellij/remote/RemoteCredentials;", "project", "Lcom/intellij/openapi/project/Project;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "allowDialogs", "", "passwordPrompt", "Lcom/intellij/ssh/ui/SshPasswordPrompt;", "JETBRAINS_REMOTE_RUN", "", "processBuilder", "Lcom/intellij/ssh/ProcessBuilder;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "J", "Lcom/intellij/ssh/ExecBuilder;", "changeDir", "runViaSudoInfo", "Lcom/intellij/ssh/RunViaSudoInfo;", "allocatePty", "J", "Ljava/io/File;", "isWindowsPath", "J", "checkConnection", "timeout", "Ljava/time/Duration;", "sshPasswordPrompt", "J", "Lcom/intellij/ssh/config/SshConnectionConfig;", "source", "intellij.platform.ssh"})
@JvmName(name="RemoteCredentialsUtil")
@SourceDebugExtension(value={"SMAP\nremoteCredentialsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 remoteCredentialsUtil.kt\ncom/intellij/ssh/RemoteCredentialsUtil\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,238:1\n34#2:239\n*S KotlinDebug\n*F\n+ 1 remoteCredentialsUtil.kt\ncom/intellij/ssh/RemoteCredentialsUtil\n*L\n206#1:239\n*E\n"})
public final class RemoteCredentialsUtil {
    @NotNull
    private static final String JETBRAINS_REMOTE_RUN = "JETBRAINS_REMOTE_RUN";

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials $this$connectionBuilder, @Nullable Project project, @Nullable ProgressIndicator progressIndicator2, boolean allowDialogs, @Nullable SshPasswordPrompt passwordPrompt) {
        Intrinsics.checkNotNullParameter((Object)$this$connectionBuilder, (String)"<this>");
        String string = $this$connectionBuilder.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        return new ConnectionBuilder(string).withSshPasswordProvider(new PlatformSshPasswordProvider($this$connectionBuilder, allowDialogs, passwordPrompt)).withProgressIndicator(progressIndicator2).withSshConnectionConfig((Function1<? super SshConnectionConfig, SshConnectionConfig>)((Function1)new Function1<SshConnectionConfig, SshConnectionConfig>((Object)$this$connectionBuilder){

            public final SshConnectionConfig invoke(SshConnectionConfig p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RemoteCredentialsSshConnectionConfig.changeSshConnectionConfig((RemoteCredentials)this.receiver, p0);
            }
        })).withParsingOpenSSHConfig($this$connectionBuilder.shouldUseOpenSshConfig());
    }

    public static /* synthetic */ ConnectionBuilder connectionBuilder$default(RemoteCredentials remoteCredentials, Project project, ProgressIndicator progressIndicator2, boolean bl, SshPasswordPrompt sshPasswordPrompt, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        if ((n & 2) != 0) {
            progressIndicator2 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            sshPasswordPrompt = null;
        }
        return RemoteCredentialsUtil.connectionBuilder(remoteCredentials, project, progressIndicator2, bl, sshPasswordPrompt);
    }

    @NotNull
    public static final ProcessBuilder processBuilder(@NotNull ConnectionBuilder $this$processBuilder, @NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)$this$processBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return new ProcessBuilder($this$processBuilder, commandLine);
    }

    private static final ExecBuilder J(ConnectionBuilder connectionBuilder2, GeneralCommandLine generalCommandLine, boolean bl, RunViaSudoInfo runViaSudoInfo, boolean bl2) {
        Map map = generalCommandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
        Object object = map;
        String string = JETBRAINS_REMOTE_RUN;
        String string2 = "1";
        object.put(string, string2);
        object = RemoteCredentialsUtil.J(generalCommandLine);
        boolean bl3 = RemoteFile.isWindowsPath((String)generalCommandLine.getExePath());
        if (!bl3) {
            object = CommandLineUtil.addEnvCommand(generalCommandLine, (String)object);
        }
        File file = generalCommandLine.getInputFile();
        String string3 = string2 = file != null ? RemoteCredentialsUtil.J(file, bl3) : null;
        if (string2 != null) {
            object = (String)object + " < " + com.intellij.execution.CommandLineUtil.posixQuote((String)string2);
        }
        if (!bl3 && runViaSudoInfo != null) {
            object = RunViaSudoInfo.patchCommand$default(runViaSudoInfo, (String)object, null, 2, null);
        }
        if (bl && generalCommandLine.getWorkDirectory() != null) {
            File file2 = generalCommandLine.getWorkDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getWorkDirectory(...)");
            String string4 = RemoteCredentialsUtil.J(file2, bl3);
            object = "cd " + com.intellij.execution.CommandLineUtil.posixQuote((String)string4) + "; exec " + (String)object;
        }
        return (ExecBuilder)connectionBuilder2.execBuilder((String)object).withAllocatePty(bl2);
    }

    private static final String J(File file, boolean bl) {
        String string = RemoteFile.createRemoteFile((String)file.getPath(), (boolean)bl).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private static final String J(GeneralCommandLine generalCommandLine) {
        Boolean bl = (Boolean)generalCommandLine.getUserData(Ssh.getDO_NOT_ESCAPE_CMD_ARGS());
        if (bl != null && bl.booleanValue()) {
            String string = generalCommandLine.getCommandLineString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
            return string;
        }
        List list = generalCommandLine.getCommandLineList(null);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCommandLineList(...)");
        return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, (Function1)getCommandLineString.1.INSTANCE, (int)30, null);
    }

    @ApiStatus.Experimental
    public static final boolean checkConnection(@NotNull RemoteCredentials $this$checkConnection, @NotNull Duration timeout, @Nullable ProgressIndicator progressIndicator2, @Nullable SshPasswordPrompt sshPasswordPrompt, boolean allowDialogs) throws TimeoutException, ProcessCanceledException, RuntimeException {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$checkConnection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        long l = System.currentTimeMillis() + timeout.toMillis();
        ErrorMessageAndField errorMessageAndField = SshCredentialsVerifier.validate(SshCredentialsVerifier.ValidationMode.WITHOUT_SLOW_KEY_CHECKS, $this$checkConnection, timeout.toMillis(), SshBackendLibrary.Companion.get());
        if (errorMessageAndField != null) {
            throw new RuntimeException(errorMessageAndField.errorMessage());
        }
        long l2 = l - System.currentTimeMillis();
        if (l2 <= 0L) {
            throw new TimeoutException("Timeout occurred during credentials check");
        }
        EventDispatcher eventDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        EventDispatcher eventDispatcher2 = eventDispatcher;
        Object[] objectArray2 = RemoteCredentialsUtil.connectionBuilder$default($this$checkConnection, null, progressIndicator2, allowDialogs, sshPasswordPrompt, 1, null).withDisconnectTrigger((EventDispatcher<ForceDisconnectListener>)eventDispatcher2).withConnectionTimeout(l2, TimeUnit.MILLISECONDS);
        boolean bl = !allowDialogs;
        boolean bl2 = false;
        if (bl) {
            Object[] objectArray3 = objectArray2;
            boolean bl3 = false;
            objectArray = objectArray3.withSshConnectionConfig((Function1<? super SshConnectionConfig, SshConnectionConfig>)((Function1)checkConnection.connectionBuilder.1.1.INSTANCE));
        } else {
            objectArray = objectArray2;
        }
        Object[] objectArray4 = objectArray;
        ProgressIndicator progressIndicator3 = progressIndicator2;
        if (progressIndicator3 != null) {
            objectArray2 = new Object[]{objectArray4.getUserHostPort()};
            progressIndicator3.setText(IdeCoreBundle.message((String)"progress.message.connecting.to", (Object[])objectArray2));
        }
        objectArray2 = CompletableFuture.supplyAsync(() -> RemoteCredentialsUtil.J((ConnectionBuilder)objectArray4));
        try {
            Object object = ProgressIndicatorUtils.awaitWithCheckCanceled((Future)((Future)objectArray2), (ProgressIndicator)progressIndicator2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"awaitWithCheckCanceled(...)");
            return (Boolean)object;
        }
        catch (ProcessCanceledException processCanceledException) {
            ((ForceDisconnectListener)eventDispatcher2.getMulticaster()).forceDisconnect();
            throw processCanceledException;
        }
    }

    public static /* synthetic */ boolean checkConnection$default(RemoteCredentials remoteCredentials, Duration duration, ProgressIndicator progressIndicator2, SshPasswordPrompt sshPasswordPrompt, boolean bl, int n, Object object) throws TimeoutException, ProcessCanceledException, RuntimeException {
        if ((n & 4) != 0) {
            sshPasswordPrompt = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return RemoteCredentialsUtil.checkConnection(remoteCredentials, duration, progressIndicator2, sshPasswordPrompt, bl);
    }

    private static final SshConnectionConfig J(SshConnectionConfig sshConnectionConfig) {
        List list = null;
        String string = null;
        List list2 = null;
        boolean bl = false;
        Duration duration = null;
        boolean bl2 = false;
        List list3 = null;
        AuthMethods authMethods = null;
        SshConnectionConfig sshConnectionConfig2 = sshConnectionConfig;
        boolean bl3 = false;
        SshHostKeyVerifier sshHostKeyVerifier = sshConnectionConfig.getHostKeyVerifier() instanceof OpenSshLikeHostKeyVerifier ? (SshHostKeyVerifier)new OpenSshLikeHostKeyVerifier(((OpenSshLikeHostKeyVerifier)sshConnectionConfig.getHostKeyVerifier()).getKnownHostsFiles(), ((OpenSshLikeHostKeyVerifier)sshConnectionConfig.getHostKeyVerifier()).getStrictHostKeyChecking(), ((OpenSshLikeHostKeyVerifier)sshConnectionConfig.getHostKeyVerifier()).getHashKnownHosts(), false) : sshConnectionConfig.getHostKeyVerifier();
        return SshConnectionConfig.copy$default(sshConnectionConfig2, authMethods, list3, bl2, duration, bl, list2, string, list, sshHostKeyVerifier, null, null, null, null, null, 0, null, null, null, null, 524031, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials $this$connectionBuilder, @Nullable Project project, @Nullable ProgressIndicator progressIndicator2, boolean allowDialogs) {
        Intrinsics.checkNotNullParameter((Object)$this$connectionBuilder, (String)"<this>");
        return RemoteCredentialsUtil.connectionBuilder$default($this$connectionBuilder, project, progressIndicator2, allowDialogs, null, 8, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials $this$connectionBuilder, @Nullable Project project, @Nullable ProgressIndicator progressIndicator2) {
        Intrinsics.checkNotNullParameter((Object)$this$connectionBuilder, (String)"<this>");
        return RemoteCredentialsUtil.connectionBuilder$default($this$connectionBuilder, project, progressIndicator2, false, null, 12, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials $this$connectionBuilder, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$connectionBuilder, (String)"<this>");
        return RemoteCredentialsUtil.connectionBuilder$default($this$connectionBuilder, project, null, false, null, 14, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials $this$connectionBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$connectionBuilder, (String)"<this>");
        return RemoteCredentialsUtil.connectionBuilder$default($this$connectionBuilder, null, null, false, null, 15, null);
    }

    private static final Boolean J(ConnectionBuilder connectionBuilder2) {
        return connectionBuilder2.checkCanAuthenticate(true);
    }

    public static final /* synthetic */ ExecBuilder access$execBuilder(ConnectionBuilder $receiver, GeneralCommandLine commandLine, boolean changeDir, RunViaSudoInfo runViaSudoInfo, boolean allocatePty) {
        return RemoteCredentialsUtil.J($receiver, commandLine, changeDir, runViaSudoInfo, allocatePty);
    }

    public static final /* synthetic */ SshConnectionConfig access$declineHostKeyVerifierDialogs(SshConnectionConfig source) {
        return RemoteCredentialsUtil.J(source);
    }
}

