/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshConfigConfigurable;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ssh.ui.unified.SshConfigsMasterComponent;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SshConfigComboBox
extends ComboboxWithBrowseButton
implements SshConfigManager.Listener {
    private static final Logger LOG = Logger.getInstance(SshConfigComboBox.class);
    @Nullable
    private Project myProject;
    @NotNull
    private final SshConfigVisibility myDefaultVisibility;
    private Runnable myChangesListener;
    private SshConfigManager.ConfigsData myData;

    public SshConfigComboBox(@Nullable Project project, @NotNull Disposable parent, @NotNull SshConfigVisibility defaultVisibility) {
        if (parent == null) {
            SshConfigComboBox.J(0);
        }
        if (defaultVisibility == null) {
            SshConfigComboBox.J(1);
        }
        LOG.assertTrue(project != null && !project.isDefault() || defaultVisibility == SshConfigVisibility.App, (Object)"Form without project can't create project-level ssh configurations");
        this.myDefaultVisibility = defaultVisibility;
        this.myProject = project;
        Disposer.register((Disposable)parent, (Disposable)this);
        this.J().setPrototypeDisplayValue(new NothingSelectedDataWrapper(true));
        this.J().setRenderer((ListCellRenderer<DataWrapper>)new ColoredListCellRenderer<DataWrapper>(){

            protected void customizeCellRenderer(@NotNull JList<? extends DataWrapper> list, DataWrapper item, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.J(0);
                }
                this.clear();
                if (item == null) {
                    return;
                }
                SshUiData sshUiData = item.getData();
                if (sshUiData != null) {
                    SshConfigsMasterComponent.renderData(sshUiData, (SimpleColoredComponent)this);
                } else {
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    if (!item.isConfigured()) {
                        simpleTextAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
                    }
                    if (item instanceof NothingSelectedDataWrapper) {
                        simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    }
                    this.append(item.getPresentableName(), simpleTextAttributes);
                }
            }

            private static /* synthetic */ void J(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ssh/ui/unified/SshConfigComboBox$1", "customizeCellRenderer"));
            }
        });
        this.J().setModel((ComboBoxModel<DataWrapper>)new MutableCollectionComboBoxModel());
        this.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1 && e.getStateChange() != 2) {
                    return;
                }
                SshConfigComboBox.this.J();
            }
        });
        this.myData = SshConfigManager.getInstance(this.myProject).getLastSavedAndCurrentData();
        MessageBus messageBus = project == null || project.isDefault() ? ApplicationManager.getApplication().getMessageBus() : project.getMessageBus();
        messageBus.connect(parent).subscribe(SshConfigManager.SSH_CONFIGS, (Object)this);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SshConfigComboBox.this.edit(false);
            }
        });
    }

    public void edit(final boolean clone) {
        final DataWrapper dataWrapper = this.J();
        final SshUiData sshUiData = dataWrapper == null ? null : dataWrapper.getData();
        final SshConfigConfigurable.ComboBoxConfigurable comboBoxConfigurable = new SshConfigConfigurable.ComboBoxConfigurable(this.myProject, sshUiData, this.myData, this.myDefaultVisibility);
        String string = ShowSettingsUtilImpl.createDimensionKey((Configurable)comboBoxConfigurable);
        DialogWrapper dialogWrapper = SettingsDialogFactory.getInstance().create(this.myProject, string, (Configurable)comboBoxConfigurable, true, false);
        UiNotifyConnector.Once.installOn((Component)dialogWrapper.getContentPane(), (Activatable)new Activatable(){

            public void showNotify() {
                SshUiData sshUiData2;
                SshConfigManager.ConfigsData configsData = SshConfigComboBox.this.myData;
                SshUiData sshUiData3 = sshUiData;
                if (dataWrapper != null && !dataWrapper.isConfigured()) {
                    sshUiData3 = sshUiData2 = SshUiData.createData(dataWrapper.getName(), dataWrapper.getId(), dataWrapper.getVisibility());
                    configsData = configsData.createMerged(new SshConfigManager.ConfigsData(Collections.emptyList(), Collections.singletonList(sshUiData2)));
                }
                comboBoxConfigurable.resetFromData(configsData);
                if (clone && sshUiData3 != null) {
                    sshUiData2 = sshUiData3.clone();
                    SshConfig sshConfig = sshUiData2.getConfig();
                    sshConfig.setId(UUID.randomUUID().toString());
                    Set set = ContainerUtil.map2Set(configsData.getCurrentData(), sshUiData -> sshUiData.getName());
                    String string = UniqueNameGenerator.generateUniqueName((String)sshConfig.getName(), (Collection)set);
                    sshConfig.setCustomName(string);
                    comboBoxConfigurable.add(sshUiData2);
                } else {
                    comboBoxConfigurable.select(sshUiData3);
                }
            }
        });
        boolean bl = dialogWrapper.showAndGet();
        if (!bl) {
            return;
        }
        SshUiData sshUiData2 = comboBoxConfigurable.getLastSelectedData();
        if (sshUiData2 == null) {
            this.reload();
        } else {
            this.reload(sshUiData2.getConfig().createPresentableId(), sshUiData2.getConfig().getVisibility());
        }
    }

    private void J() {
        if (this.myChangesListener != null) {
            this.myChangesListener.run();
        }
    }

    public void setDataListener(@NotNull Runnable listener) {
        if (listener == null) {
            SshConfigComboBox.J(2);
        }
        LOG.assertTrue(this.myChangesListener == null, (Object)"Only one listener is supported so far");
        this.myChangesListener = listener;
    }

    @NotNull
    private JComboBox<DataWrapper> J() {
        JComboBox jComboBox = (JComboBox)this.getChildComponent();
        if (jComboBox == null) {
            SshConfigComboBox.J(3);
        }
        return jComboBox;
    }

    @Nullable
    public PresentableId getSelectedPresentableId() {
        DataWrapper dataWrapper = this.J();
        if (dataWrapper == null) {
            return null;
        }
        if (dataWrapper.getData() == null) {
            return PresentableId.createId(null, (String)dataWrapper.getName());
        }
        return dataWrapper.getData().getConfig().createPresentableId();
    }

    @Nullable
    public @Nullable Pair<@Nullable SshUiData, @NotNull String> getSelectedUiDataAndName() {
        DataWrapper dataWrapper = this.J();
        return dataWrapper == null ? null : new Pair((Object)dataWrapper.getData(), (Object)dataWrapper.getName());
    }

    @Nullable
    public @Nullable Pair<@Nullable SshUiData, PresentableId> getSelectedUiDataAndPresentableId() {
        DataWrapper dataWrapper = this.J();
        return dataWrapper == null ? null : new Pair((Object)dataWrapper.getData(), (Object)PresentableId.createId((String)dataWrapper.getId(), (String)dataWrapper.getName()));
    }

    @Nullable
    public SshConfig getSelectedSshConfig() {
        DataWrapper dataWrapper = this.J();
        if (dataWrapper == null) {
            return null;
        }
        SshUiData sshUiData = dataWrapper.getData();
        if (sshUiData == null) {
            return null;
        }
        return sshUiData.getConfig().clone();
    }

    @Nullable
    private DataWrapper J() {
        Object object = this.J().getSelectedItem();
        return object instanceof DataWrapper && !(object instanceof NothingSelectedDataWrapper) ? (DataWrapper)object : null;
    }

    public void select(@Nullable SshConfig sshConfigToSelect) {
        DataWrapper dataWrapper = null;
        MutableCollectionComboBoxModel<DataWrapper> mutableCollectionComboBoxModel = this.J();
        List list = mutableCollectionComboBoxModel.getItems();
        if (sshConfigToSelect == null) {
            for (DataWrapper dataWrapper2 : list) {
                if (!(dataWrapper2 instanceof NothingSelectedDataWrapper)) continue;
                dataWrapper = dataWrapper2;
                break;
            }
            if (dataWrapper == null) {
                dataWrapper = new NothingSelectedDataWrapper(list.isEmpty());
                mutableCollectionComboBoxModel.add((Object)dataWrapper);
            }
        } else {
            for (DataWrapper dataWrapper3 : list) {
                if (!sshConfigToSelect.getId().equals(dataWrapper3.getId())) continue;
                dataWrapper = dataWrapper3;
                break;
            }
            if (dataWrapper == null) {
                dataWrapper = SshConfigComboBox.J(sshConfigToSelect);
                mutableCollectionComboBoxModel.add((Object)dataWrapper);
            }
        }
        this.getComboBox().setSelectedItem(dataWrapper);
    }

    public void reload() {
        this.J(this.myData.getCurrentData(), null, null, SshConfigVisibility.Project);
    }

    public void reload(@Nullable PresentableId configToSelect, SshConfigVisibility configVisibility) {
        List<SshUiData> list = this.myData.getCurrentData();
        SshUiData sshUiData = SshConfigManager.findData(configToSelect, list);
        this.J(list, sshUiData, configToSelect, configVisibility);
    }

    private void J(@NotNull List<SshUiData> list, @Nullable SshUiData sshUiData, @Nullable PresentableId presentableId, SshConfigVisibility sshConfigVisibility) {
        if (list == null) {
            SshConfigComboBox.J(4);
        }
        ArrayList<DataWrapper> arrayList = new ArrayList<DataWrapper>(list.size());
        DataWrapper dataWrapper = null;
        for (SshUiData sshUiData2 : list) {
            DataWrapper dataWrapper2 = SshConfigComboBox.J(sshUiData2);
            arrayList.add(dataWrapper2);
            if (sshUiData2 != sshUiData) continue;
            dataWrapper = dataWrapper2;
        }
        if (dataWrapper == null) {
            if (presentableId != null && presentableId.getName() != null) {
                dataWrapper = SshConfigComboBox.J(presentableId.getName(), presentableId.getId(), sshConfigVisibility);
                arrayList.add(dataWrapper);
            } else {
                dataWrapper = new NothingSelectedDataWrapper(arrayList.isEmpty());
            }
        }
        Iterator<SshUiData> iterator = this.J();
        iterator.update(arrayList);
        iterator.setSelectedItem(dataWrapper);
        if (arrayList.size() > 1 || arrayList.size() == 1 && !(arrayList.get(0) instanceof NothingSelectedDataWrapper)) {
            this.J().setPrototypeDisplayValue(null);
        }
        this.J();
    }

    private MutableCollectionComboBoxModel<DataWrapper> J() {
        return (MutableCollectionComboBoxModel)this.J().getModel();
    }

    public boolean isSelected(@Nullable String nameToSelect) {
        DataWrapper dataWrapper = this.J();
        if (nameToSelect == null) {
            return dataWrapper == null;
        }
        if (dataWrapper == null) {
            return false;
        }
        return StringUtil.equals((CharSequence)nameToSelect, (CharSequence)dataWrapper.getName());
    }

    public void dispose() {
        super.dispose();
        this.myChangesListener = null;
        this.myProject = null;
    }

    @Override
    public void sshConfigsChanged() {
        SshUiData sshUiData;
        this.myData = SshConfigManager.getInstance(this.myProject).getLastSavedAndCurrentData();
        List<SshUiData> list = this.myData.getCurrentData();
        DataWrapper dataWrapper = this.J();
        SshUiData sshUiData2 = null;
        if (dataWrapper != null) {
            sshUiData = dataWrapper.getData();
            if (sshUiData != null) {
                sshUiData2 = SshUiData.findById(list, sshUiData.getConfig().getId());
            }
            if (sshUiData2 == null) {
                sshUiData2 = SshUiData.findByName(list, dataWrapper.getName());
            }
        }
        sshUiData = null;
        SshConfigVisibility sshConfigVisibility = SshConfigVisibility.Project;
        if (dataWrapper != null && sshUiData2 == null) {
            sshUiData = PresentableId.createId((String)dataWrapper.getId(), (String)dataWrapper.getName());
            sshConfigVisibility = dataWrapper.getVisibility();
        }
        this.J(list, sshUiData2, (PresentableId)sshUiData, sshConfigVisibility);
    }

    private static DataWrapper J(@NotNull SshUiData sshUiData) {
        if (sshUiData == null) {
            SshConfigComboBox.J(5);
        }
        return new DataWrapperImpl(sshUiData);
    }

    private static DataWrapper J(@NotNull String string, @Nullable String string2, @NotNull SshConfigVisibility sshConfigVisibility) {
        if (string == null) {
            SshConfigComboBox.J(6);
        }
        if (sshConfigVisibility == null) {
            SshConfigComboBox.J(7);
        }
        return new PartialDataWrapper(string, string2, sshConfigVisibility);
    }

    private static DataWrapper J(@NotNull SshConfig sshConfig) {
        if (sshConfig == null) {
            SshConfigComboBox.J(8);
        }
        return new PartialDataWrapper(sshConfig.getName(), sshConfig.getId(), sshConfig.isProjectLevel() ? SshConfigVisibility.Project : SshConfigVisibility.App);
    }

    @NotNull
    public List<String> getElements() {
        ArrayList<String> arrayList = new ArrayList<String>();
        JComboBox<DataWrapper> jComboBox = this.J();
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            DataWrapper dataWrapper = jComboBox.getItemAt(i);
            arrayList.add(dataWrapper.getName());
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            SshConfigComboBox.J(9);
        }
        return arrayList2;
    }

    private static /* synthetic */ void J(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultVisibility";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigComboBox";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigComboBox";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMyComboBox";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDataListener";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "changeData";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9 -> new IllegalStateException(string);
        };
    }

    private static final class NothingSelectedDataWrapper
    implements DataWrapper {
        private final boolean isEmpty;

        private NothingSelectedDataWrapper(boolean empty) {
            this.isEmpty = empty;
        }

        @Override
        public boolean isConfigured() {
            return true;
        }

        @Override
        @NotNull
        @NonNls
        public String getName() {
            String string = this.isEmpty ? SshBundle.message("ssh.combo.create.configuration", new Object[0]) : SshBundle.message("ssh.combo.select.configuration", new Object[0]);
            if (string == null) {
                NothingSelectedDataWrapper.J(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getPresentableName() {
            String string = this.isEmpty ? SshBundle.message("ssh.combo.create.configuration", new Object[0]) : SshBundle.message("ssh.combo.select.configuration", new Object[0]);
            if (string == null) {
                NothingSelectedDataWrapper.J(1);
            }
            return string;
        }

        @Override
        @Nullable
        public SshUiData getData() {
            return null;
        }

        @Override
        @Nullable
        public String getId() {
            return null;
        }

        @Override
        @NotNull
        public SshConfigVisibility getVisibility() {
            SshConfigVisibility sshConfigVisibility = SshConfigVisibility.Project;
            if (sshConfigVisibility == null) {
                NothingSelectedDataWrapper.J(2);
            }
            return sshConfigVisibility;
        }

        @Override
        @NotNull
        public DataWrapper clone() {
            DataWrapper dataWrapper;
            try {
                dataWrapper = (DataWrapper)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
            if (dataWrapper == null) {
                NothingSelectedDataWrapper.J(3);
            }
            return dataWrapper;
        }

        private static /* synthetic */ void J(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ssh/ui/unified/SshConfigComboBox$NothingSelectedDataWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVisibility";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clone";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static interface DataWrapper
    extends Cloneable {
        public boolean isConfigured();

        @NonNls
        @NotNull
        public String getName();

        @Nls
        @NotNull
        public String getPresentableName();

        @Nullable
        public String getId();

        @NotNull
        public SshConfigVisibility getVisibility();

        @Nullable
        public SshUiData getData();

        @NotNull
        public DataWrapper clone();
    }

    private static final class DataWrapperImpl
    implements DataWrapper {
        @NotNull
        private SshUiData myData;

        private DataWrapperImpl(@NotNull SshUiData data) {
            if (data == null) {
                DataWrapperImpl.J(0);
            }
            this.myData = data;
        }

        @Override
        public boolean isConfigured() {
            return true;
        }

        @Override
        @NotNull
        @NonNls
        public String getName() {
            String string = this.myData.getName();
            if (string == null) {
                DataWrapperImpl.J(1);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getPresentableName() {
            String string = this.myData.getConfig().getPresentableFullName();
            if (string == null) {
                DataWrapperImpl.J(2);
            }
            return string;
        }

        @Override
        @NotNull
        public SshUiData getData() {
            SshUiData sshUiData = this.myData;
            if (sshUiData == null) {
                DataWrapperImpl.J(3);
            }
            return sshUiData;
        }

        @Override
        @NotNull
        public String getId() {
            String string = this.myData.getConfig().getId();
            if (string == null) {
                DataWrapperImpl.J(4);
            }
            return string;
        }

        @Override
        @NotNull
        public SshConfigVisibility getVisibility() {
            SshConfigVisibility sshConfigVisibility = this.myData.getConfig().isProjectLevel() ? SshConfigVisibility.Project : SshConfigVisibility.App;
            if (sshConfigVisibility == null) {
                DataWrapperImpl.J(5);
            }
            return sshConfigVisibility;
        }

        @Override
        @NotNull
        public DataWrapper clone() {
            DataWrapperImpl dataWrapperImpl;
            try {
                DataWrapperImpl dataWrapperImpl2 = (DataWrapperImpl)super.clone();
                dataWrapperImpl2.myData = dataWrapperImpl2.myData.clone();
                dataWrapperImpl = dataWrapperImpl2;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
            if (dataWrapperImpl == null) {
                DataWrapperImpl.J(6);
            }
            return dataWrapperImpl;
        }

        private static /* synthetic */ void J(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigComboBox$DataWrapperImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigComboBox$DataWrapperImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVisibility";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clone";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static final class PartialDataWrapper
    implements DataWrapper {
        @NotNull
        @NlsSafe
        private final String myName;
        @Nullable
        private final String myId;
        private final SshConfigVisibility myVisibility;

        private PartialDataWrapper(@NotNull String name, @Nullable String id, @NotNull SshConfigVisibility visibility) {
            if (name == null) {
                PartialDataWrapper.J(0);
            }
            if (visibility == null) {
                PartialDataWrapper.J(1);
            }
            this.myName = name;
            this.myId = id;
            this.myVisibility = visibility;
        }

        @Override
        public boolean isConfigured() {
            return false;
        }

        @Override
        @NotNull
        @NonNls
        public String getName() {
            String string = this.myName;
            if (string == null) {
                PartialDataWrapper.J(2);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getPresentableName() {
            String string = this.myName;
            if (string == null) {
                PartialDataWrapper.J(3);
            }
            return string;
        }

        @Override
        @Nullable
        public SshUiData getData() {
            return null;
        }

        @Override
        @Nullable
        public String getId() {
            return this.myId;
        }

        @Override
        @NotNull
        public SshConfigVisibility getVisibility() {
            SshConfigVisibility sshConfigVisibility = this.myVisibility;
            if (sshConfigVisibility == null) {
                PartialDataWrapper.J(4);
            }
            return sshConfigVisibility;
        }

        @Override
        @NotNull
        public DataWrapper clone() {
            DataWrapper dataWrapper;
            try {
                dataWrapper = (DataWrapper)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
            if (dataWrapper == null) {
                PartialDataWrapper.J(5);
            }
            return dataWrapper;
        }

        private static /* synthetic */ void J(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibility";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigComboBox$PartialDataWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigComboBox$PartialDataWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVisibility";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clone";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

