/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import java.util.Map;

public final class MapSerializerUtil {
    public static final String TEST_STARTED = "testStarted";
    public static final String TEST_FINISHED = "testFinished";
    public static final String TEST_FAILED = "testFailed";
    public static final String TEST_IGNORED = "testIgnored";
    public static final String TEST_STD_OUT = "testStdOut";
    public static final String TEST_SUITE_STARTED = "testSuiteStarted";
    public static final String TEST_SUITE_FINISHED = "testSuiteFinished";
    public static final String SUITE_TREE_STARTED = "suiteTreeStarted";
    public static final String SUITE_TREE_ENDED = "suiteTreeEnded";
    public static final String SUITE_TREE_NODE = "suiteTreeNode";
    public static final String ROOT_NAME = "rootName";
    public static final EscapeInfoProvider STD_ESCAPER = new EscapeInfoProvider(){

        @Override
        public char escape(char c) {
            switch (c) {
                case '\n': {
                    return 'n';
                }
                case '\r': {
                    return 'r';
                }
                case '\b': {
                    return 'b';
                }
                case '\u0085': {
                    return 'x';
                }
                case '\u2028': {
                    return 'l';
                }
                case '\u2029': {
                    return 'p';
                }
                case '|': {
                    return '|';
                }
                case '\'': {
                    return '\'';
                }
                case '[': {
                    return '[';
                }
                case ']': {
                    return ']';
                }
            }
            return '\u0000';
        }

        @Override
        public char escapeCharacter() {
            return '|';
        }
    };

    public static String escapeStr(String str, EscapeInfoProvider p) {
        if (str == null) {
            return null;
        }
        int finalCount = MapSerializerUtil.calcFinalEscapedStringCount(str, p);
        if (str.length() == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            char escaped = p.escape(c);
            if (escaped != '\u0000') {
                resultChars[resultPos++] = p.escapeCharacter();
                resultChars[resultPos++] = escaped;
                continue;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect escaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalEscapedStringCount(String name, EscapeInfoProvider p) {
        int result = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (p.escape(c) != '\u0000') {
                result += 2;
                continue;
            }
            ++result;
        }
        return result;
    }

    public static String asString(String messageName, Map<String, String> attributes) {
        StringBuilder text = new StringBuilder("##teamcity[" + messageName);
        for (String attrName : attributes.keySet()) {
            text.append(" ").append((Object)attrName).append("='").append(MapSerializerUtil.escapeStr(attributes.get(attrName), STD_ESCAPER)).append("'");
        }
        text.append("]");
        return text.toString();
    }

    public static interface EscapeInfoProvider {
        public char escape(char var1);

        public char escapeCharacter();
    }
}

