/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.hints.HintReferenceBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReference;
import com.intellij.spring.boot.application.config.SpringBootReplacementTokenResolver;
import com.intellij.spring.spi.SpringSpiClassesListJamConverter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBootConfigFileAnnotatorBase
implements Annotator {
    private final boolean DEBUG_MODE = ApplicationManager.getApplication().isUnitTestMode();

    @Nullable
    protected abstract TextAttributesKey getPlaceholderTextAttributesKey();

    @Nullable
    protected TextAttributesKey getReplacementTokenTextAttributesKey() {
        return DefaultLanguageHighlighterColors.METADATA;
    }

    protected void annotateValue(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SpringBootConfigFileAnnotatorBase.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringBootConfigFileAnnotatorBase.$$$reportNull$$$0(1);
        }
        int elementOffset = element.getNode().getStartOffset();
        Object[] references = element.getReferences();
        boolean highlightOnlyPlaceholders = ContainerUtil.findInstance((Object[])references, SpringBootPlaceholderReference.class) != null;
        HashSet<Integer> annotatedOffsets = new HashSet<Integer>();
        for (Object reference : references) {
            TextRange highlightTextRange;
            TextAttributesKey key = null;
            if (highlightOnlyPlaceholders) {
                if (reference instanceof SpringBootPlaceholderReference) {
                    key = this.getPlaceholderTextAttributesKey();
                }
            } else if (reference instanceof JavaClassReference || reference instanceof SpringSpiClassesListJamConverter.SpringSpiClassReference || reference instanceof PsiPackageReference) {
                if (reference.resolve() != null) {
                    key = DefaultLanguageHighlighterColors.CLASS_REFERENCE;
                }
            } else if (reference instanceof SpringBootReplacementTokenResolver.ReplacementTokenReference) {
                key = this.getReplacementTokenTextAttributesKey();
            } else if (reference instanceof HintReferenceBase) {
                key = ((HintReferenceBase)reference).getTextAttributesKey();
            }
            if (key == null || !annotatedOffsets.add((highlightTextRange = reference.getRangeInElement().shiftRight(elementOffset)).getStartOffset())) continue;
            this.doAnnotate(holder, highlightTextRange, key);
        }
    }

    protected void annotateKey(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SpringBootConfigFileAnnotatorBase.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            SpringBootConfigFileAnnotatorBase.$$$reportNull$$$0(3);
        }
        int elementStartOffset = element.getNode().getStartOffset();
        block5: for (PsiReference psiReference : element.getReferences()) {
            if (!(psiReference instanceof ConfigKeyPathReference)) continue;
            ConfigKeyPathReference configKeyPathReference = (ConfigKeyPathReference)psiReference;
            TextRange referenceRange = configKeyPathReference.getRangeInElement().shiftRight(elementStartOffset);
            switch (configKeyPathReference.getPathType()) {
                case ENUM: {
                    this.doAnnotate(holder, referenceRange, DefaultLanguageHighlighterColors.CONSTANT);
                    continue block5;
                }
                case BEAN_PROPERTY: {
                    this.doAnnotate(holder, referenceRange, DefaultLanguageHighlighterColors.INSTANCE_METHOD);
                    PsiElement resolve = configKeyPathReference.resolve();
                    if (!(resolve instanceof BeanPropertyElement) || !((BeanPropertyElement)resolve).getMethod().isDeprecated()) continue block5;
                    this.doAnnotate(holder, referenceRange, CodeInsightColors.DEPRECATED_ATTRIBUTES);
                    continue block5;
                }
                case ARBITRARY_ENTRY_KEY: {
                    this.doAnnotateEnforced(holder, referenceRange, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES, "REGULAR_ITALIC_ATTRIBUTES");
                }
            }
        }
    }

    protected void doAnnotate(AnnotationHolder holder, TextRange range, TextAttributesKey key) {
        if (range.isEmpty()) {
            return;
        }
        (this.DEBUG_MODE ? holder.newAnnotation(HighlightSeverity.INFORMATION, key.getExternalName()) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION)).range(range).textAttributes(key).create();
    }

    protected void doAnnotateEnforced(AnnotationHolder holder, TextRange range, SimpleTextAttributes key, String debugMessage) {
        if (range.isEmpty()) {
            return;
        }
        String message = this.DEBUG_MODE ? debugMessage : null;
        (message != null ? holder.newAnnotation(HighlightSeverity.INFORMATION, message) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION)).range(range).enforcedTextAttributes(key.toTextAttributes()).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/application/config/SpringBootConfigFileAnnotatorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

