/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5.report;

import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.io.File;
import java.util.Optional;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.CompositeTestSource;
import org.junit.platform.engine.support.descriptor.FilePosition;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestIdentifier;

public final class LocationInfo {
    static final LocationInfo EMPTY = new LocationInfo(null, null, null);
    private final String locationHint;
    private final String metainfo;

    public LocationInfo(TestSource opt, TestSource parent, TestIdentifier node) {
        this.locationHint = LocationInfo.getLocationHintValue(opt, parent);
        this.metainfo = this.locationHint.isEmpty() ? null : LocationInfo.getMetaInfoValue(node);
    }

    public String locationHint() {
        return this.locationHint;
    }

    public String metainfo() {
        return this.metainfo;
    }

    public static LocationInfo compute(TestIdentifier node, TestIdentifier parent) {
        TestSource parentSource = parent != null ? (TestSource)parent.getSource().orElse(null) : null;
        Optional sourceOpt = node.getSource();
        if (!sourceOpt.isPresent()) {
            return EMPTY;
        }
        return new LocationInfo((TestSource)sourceOpt.get(), parentSource, node);
    }

    private static String getMetaInfoValue(TestIdentifier root) {
        if (root == null || !root.getSource().isPresent()) {
            return null;
        }
        TestSource source = (TestSource)root.getSource().get();
        if (source instanceof MethodSource) {
            return ((MethodSource)source).getMethodParameterTypes();
        }
        if (source instanceof ClassSource) {
            Optional position = ((ClassSource)source).getPosition();
            if (!position.isPresent()) {
                return null;
            }
            FilePosition pos = (FilePosition)position.get();
            return pos.getLine() - 1 + ":" + (pos.getColumn().orElse(1) - 1);
        }
        return null;
    }

    private static String getLocationHintValue(TestSource testSource, TestSource parentSource) {
        if (testSource instanceof CompositeTestSource) {
            CompositeTestSource composite = (CompositeTestSource)testSource;
            for (TestSource s : composite.getSources()) {
                String v = LocationInfo.getLocationHintValue(s, parentSource);
                if (v.isEmpty()) continue;
                return v;
            }
            return "";
        }
        if (testSource instanceof FileSource) {
            FileSource fileSource = (FileSource)testSource;
            File file = fileSource.getFile();
            String line = fileSource.getPosition().map(position -> ":" + position.getLine()).orElse("");
            return "file://" + file.getAbsolutePath() + line;
        }
        if (testSource instanceof MethodSource) {
            MethodSource methodSource = (MethodSource)testSource;
            return LocationInfo.javaLocation(methodSource.getClassName(), methodSource.getMethodName(), true);
        }
        if (testSource instanceof ClassSource) {
            String className = ((ClassSource)testSource).getClassName();
            return LocationInfo.javaLocation(className, null, false);
        }
        if (parentSource != null) {
            return LocationInfo.getLocationHintValue(parentSource, null);
        }
        return "";
    }

    private static String javaLocation(String className, String maybeMethodName, boolean isTest) {
        String type = isTest ? "test" : "suite";
        String methodName = maybeMethodName == null ? "" : "/" + maybeMethodName;
        return "java:" + type + "://" + MapSerializerUtil.escapeStr((String)(className + methodName), (MapSerializerUtil.EscapeInfoProvider)MapSerializerUtil.STD_ESCAPER);
    }
}

