/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.connection.backend.statistics;

import com.intellij.cwm.connection.backend.join.RdServerJoinLinkManager;
import com.intellij.cwm.connection.backend.statistics.CwmStatisticsGuestTransportListener;
import com.intellij.cwm.plugin.join.JoinLinkData;
import com.intellij.cwm.plugin.permissions.CwmSharedPermissionManager;
import com.intellij.cwm.plugin.permissions.CwmSharedPermissionManagerKt;
import com.intellij.cwm.plugin.statistics.CwmStatisticsPortForwardingListener;
import com.intellij.cwm.plugin.telephony.BackendTelephonyManager;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.split.connection.SessionEndedReason;
import com.intellij.platform.split.connection.protocol.transport.WireTransportListener;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.GlobalPortListener;
import com.jetbrains.rd.platform.codeWithMe.statistics.CodeWithMeLifecycleUsagesCollector;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rdserver.permissions.PermissionModel;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u001d\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0017J\u0006\u0010\u001c\u001a\u00020\u0010J\u0006\u0010\u001d\u001a\u00020\u0010J\u0006\u0010\u001e\u001a\u00020\u0010J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u0006\u0010\"\u001a\u00020 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/cwm/connection/backend/statistics/CwmSessionStatisticsManager;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "setDisposable", "(Lcom/intellij/openapi/Disposable;)V", "sessionStartTime", "Ljava/time/Instant;", "sessionCreated", "", "joinLinkData", "Lcom/intellij/cwm/plugin/join/JoinLinkData;", "sessionCreated$intellij_cwm_connection_backend", "sessionEnded", "reason", "Lcom/intellij/platform/split/connection/SessionEndedReason;", "sessionEnded$intellij_cwm_connection_backend", "maximumGuests", "Ljava/util/concurrent/atomic/AtomicInteger;", "currentGuests", "disconnects", "guestConnected", "guestDisconnected", "clear", "getCurrentGuestsCount", "", "getMaximumGuestsCount", "getDisconnectsCount", "intellij.cwm.connection.backend"})
@SourceDebugExtension(value={"SMAP\nCwmSessionStatisticsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CwmSessionStatisticsManager.kt\ncom/intellij/cwm/connection/backend/statistics/CwmSessionStatisticsManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class CwmSessionStatisticsManager
extends LifetimedService {
    @NotNull
    private final Project project;
    @NotNull
    private Disposable disposable;
    @Nullable
    private Instant sessionStartTime;
    @NotNull
    private AtomicInteger maximumGuests;
    @NotNull
    private AtomicInteger currentGuests;
    @NotNull
    private AtomicInteger disconnects;

    public CwmSessionStatisticsManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Disposable disposable = Disposer.newDisposable((Disposable)((Disposable)this));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.maximumGuests = new AtomicInteger(0);
        this.currentGuests = new AtomicInteger(0);
        this.disconnects = new AtomicInteger(0);
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    public final void setDisposable(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"<set-?>");
        this.disposable = disposable;
    }

    public final void sessionCreated$intellij_cwm_connection_backend(@NotNull JoinLinkData joinLinkData) {
        RdServerJoinLinkManager.JoinLinkDataImpl joinLinkDataImpl;
        Intrinsics.checkNotNullParameter((Object)joinLinkData, (String)"joinLinkData");
        Disposable disposable = Disposer.newDisposable((Disposable)((Disposable)this));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        CwmSharedPermissionManager sharedPermissionManager = CwmSharedPermissionManager.Companion.getInstance(this.project);
        PermissionModel permissions = sharedPermissionManager.getProjectPermissionModel(this.project);
        boolean telephonyEnabledOnSessionStart = joinLinkData.getTelephonyUrl() != null && (Boolean)BackendTelephonyManager.Companion.getInstance(this.project).isTelephonyEnabled().getValue() != false;
        if (!(this.sessionStartTime == null)) {
            boolean bl = false;
            String string = "Session start time is not null upon session creation";
            throw new IllegalStateException(string.toString());
        }
        this.sessionStartTime = Instant.now();
        CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.onCwmSessionCreated(joinLinkData.getSessionId(), telephonyEnabledOnSessionStart, CwmSharedPermissionManagerKt.toStatisticsData((PermissionModel)permissions), AppMode.isRemoteDevHost(), (joinLinkDataImpl = joinLinkData instanceof RdServerJoinLinkManager.JoinLinkDataImpl ? (RdServerJoinLinkManager.JoinLinkDataImpl)joinLinkData : null) != null && (joinLinkDataImpl = joinLinkDataImpl.getLobbyServerSession()) != null && (joinLinkDataImpl = joinLinkDataImpl.getSessionResponse()) != null && (joinLinkDataImpl = joinLinkDataImpl.getWsRelay()) != null ? joinLinkDataImpl.getAcceptChannelEndpointPrefix() : null);
        ApplicationKt.getApplication().getMessageBus().connect(this.disposable).subscribe(WireTransportListener.TOPIC, (Object)new CwmStatisticsGuestTransportListener(this.project));
        ApplicationKt.getApplication().getMessageBus().connect(this.disposable).subscribe(GlobalPortListener.Companion.getTOPIC(), (Object)new CwmStatisticsPortForwardingListener(this.project));
    }

    public final void sessionEnded$intellij_cwm_connection_backend(@NotNull SessionEndedReason reason, @NotNull JoinLinkData joinLinkData) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter((Object)joinLinkData, (String)"joinLinkData");
        String sessionId = joinLinkData.getSessionId();
        int sessionMaxParticipantsCount = this.getMaximumGuestsCount();
        int sessionDisconnectsCount = this.getDisconnectsCount();
        if (!(this.sessionStartTime != null)) {
            boolean bl = false;
            String string = "Session start time is null upon session end";
            throw new IllegalStateException(string.toString());
        }
        CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.onCwmSessionFinished(sessionId, sessionMaxParticipantsCount, (int)Math.abs(ChronoUnit.MINUTES.between(this.sessionStartTime, Instant.now())), sessionDisconnectsCount, reason);
        this.sessionStartTime = null;
        Disposer.dispose((Disposable)this.disposable);
        this.clear();
    }

    public final void guestConnected() {
        int currentMaximumGuests;
        int currentGuestsOnConnection = this.currentGuests.incrementAndGet();
        while (currentGuestsOnConnection > (currentMaximumGuests = this.maximumGuests.get())) {
            if (!this.maximumGuests.compareAndSet(currentMaximumGuests, currentGuestsOnConnection)) continue;
            return;
        }
    }

    public final void guestDisconnected() {
        this.disconnects.incrementAndGet();
        this.currentGuests.decrementAndGet();
    }

    public final void clear() {
        this.maximumGuests.set(0);
        this.currentGuests.set(0);
        this.disconnects.set(0);
    }

    public final int getCurrentGuestsCount() {
        return this.currentGuests.get();
    }

    public final int getMaximumGuestsCount() {
        return this.maximumGuests.get();
    }

    public final int getDisconnectsCount() {
        return this.disconnects.get();
    }
}

