/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u0006\u0010\u000f\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R$\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/ui/SingleTextSelectionHandler;", "Ljavax/swing/event/CaretListener;", "<init>", "()V", "myComponents", "Ljava/util/ArrayList;", "Ljavax/swing/text/JTextComponent;", "Lkotlin/collections/ArrayList;", "getMyComponents", "()Ljava/util/ArrayList;", "myIgnoreEvents", "", "add", "", "component", "start", "remove", "caretUpdate", "e", "Ljavax/swing/event/CaretEvent;", "intellij.platform.util.ui"})
public class SingleTextSelectionHandler
implements CaretListener {
    @NotNull
    private final ArrayList<JTextComponent> myComponents = new ArrayList();
    private boolean myIgnoreEvents;

    @NotNull
    protected final ArrayList<JTextComponent> getMyComponents() {
        return this.myComponents;
    }

    public final void add(@NotNull JTextComponent component, boolean start) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.myComponents.add(component);
        if (start) {
            component.addCaretListener(this);
        }
    }

    public final void remove(@NotNull JTextComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.myComponents.remove(component);
        component.removeCaretListener(this);
    }

    public final void start() {
        if (this.myComponents.size() > 1) {
            Iterator<JTextComponent> iterator = this.myComponents.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<JTextComponent> iterator2 = iterator;
            while (iterator2.hasNext()) {
                JTextComponent component;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                component.addCaretListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.myIgnoreEvents) {
            this.myIgnoreEvents = true;
            try {
                Object source = e.getSource();
                Iterator<JTextComponent> iterator = this.myComponents.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<JTextComponent> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    JTextComponent component;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                    if (component == source || component.getSelectionStart() == component.getSelectionEnd()) continue;
                    component.select(0, 0);
                }
            }
            finally {
                this.myIgnoreEvents = false;
            }
        }
    }
}

