/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.jam.converters.SpringBeanReferenceJamConverter;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

public abstract class SpringBeanPointerResolveInspection
extends SpringUastInspectionBase {
    protected static boolean isPlainJavaFileInSpringModule(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SpringBeanPointerResolveInspection.$$$reportNull$$$0(0);
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)psiElement.getContainingFile())) {
            return false;
        }
        return SpringCommonUtils.isSpringConfigured(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement));
    }

    public static void checkBeanPointerResolve(ProblemsHolder holder, JamStringAttributeElement<SpringBeanPointer<?>> element) {
        Set<String> beanTypes = Collections.emptySet();
        JamConverter converter = element.getConverter();
        if (converter instanceof SpringBeanReferenceJamConverter) {
            beanTypes = ((SpringBeanReferenceJamConverter)converter).getBaseClasses();
        }
        SpringBeanPointerResolveInspection.checkBeanPointerResolve(holder, element, beanTypes);
    }

    public static void checkBeanPointerResolve(ProblemsHolder holder, JamStringAttributeElement<SpringBeanPointer<?>> element, Collection<String> beanTypes) {
        PsiAnnotationMemberValue memberValue;
        String beanName = element.getStringValue();
        if (beanName != null && (memberValue = element.getPsiElement()) != null) {
            PsiElement problemPsiElement;
            PsiClass psiClass;
            SpringBeanPointer value = (SpringBeanPointer)element.getValue();
            if (value == null) {
                PsiElement problemPsiElement2 = SpringBeanPointerResolveInspection.getProblemPsiElement((PsiElement)memberValue);
                if (problemPsiElement2 != null) {
                    holder.registerProblem(problemPsiElement2, SpringApiBundle.message("model.bean.error.message", beanName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            } else if (!beanTypes.isEmpty() && (psiClass = value.getBeanClass()) != null && !SpringBeanPointerResolveInspection.isInheritor(psiClass, beanTypes) && (problemPsiElement = SpringBeanPointerResolveInspection.getProblemPsiElement((PsiElement)memberValue)) != null) {
                holder.registerProblem(problemPsiElement, SpringBeanPointerResolveInspection.getMessage(beanTypes), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
    }

    @NotNull
    @Nls
    private static String getMessage(@NotNull Collection<String> beanTypes) {
        if (beanTypes == null) {
            SpringBeanPointerResolveInspection.$$$reportNull$$$0(1);
        }
        if (beanTypes.size() == 1) {
            String string = SpringApiBundle.message("bean.must.be.of.type", beanTypes.iterator().next());
            if (string == null) {
                SpringBeanPointerResolveInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = SpringApiBundle.message("bean.must.be.one.of.these.types", StringUtil.join(beanTypes, (String)","));
        if (string == null) {
            SpringBeanPointerResolveInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static boolean isInheritor(@NotNull PsiClass psiClass, Collection<String> beanTypes) {
        if (psiClass == null) {
            SpringBeanPointerResolveInspection.$$$reportNull$$$0(4);
        }
        for (String beanType : beanTypes) {
            if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)beanType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getProblemPsiElement(PsiElement element) {
        UElement uElement = UastContextKt.toUElement((PsiElement)element, UInjectionHost.class);
        if (uElement == null) {
            return null;
        }
        return uElement.getSourcePsi();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanTypes";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringBeanPointerResolveInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringBeanPointerResolveInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPlainJavaFileInSpringModule";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

