/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.templates;

import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/spring/templates/BaseSpringClassTemplateContextType;", "Lcom/intellij/codeInsight/template/TemplateContextType;", "id", "", "language", "availableAsInnerClass", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getLanguage", "()Ljava/lang/String;", "getAvailableAsInnerClass", "()Z", "isInContext", "templateActionContext", "Lcom/intellij/codeInsight/template/TemplateActionContext;", "intellij.spring"})
public abstract class BaseSpringClassTemplateContextType
extends TemplateContextType {
    @NotNull
    private final String language;
    private final boolean availableAsInnerClass;

    public BaseSpringClassTemplateContextType(@NlsContexts.Label @NotNull String id, @NotNull String language, boolean availableAsInnerClass) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        super(id);
        this.language = language;
        this.availableAsInnerClass = availableAsInnerClass;
    }

    public /* synthetic */ BaseSpringClassTemplateContextType(String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(string, string2, bl);
    }

    @NotNull
    public final String getLanguage() {
        return this.language;
    }

    public final boolean getAvailableAsInnerClass() {
        return this.availableAsInnerClass;
    }

    public boolean isInContext(@NotNull TemplateActionContext templateActionContext) {
        Class[] classArray;
        Intrinsics.checkNotNullParameter((Object)templateActionContext, (String)"templateActionContext");
        PsiFile psiFile = templateActionContext.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile psiFile2 = psiFile;
        if (!Intrinsics.areEqual((Object)psiFile2.getLanguage().getID(), (Object)this.language)) {
            return false;
        }
        Project project = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
        if (!SpringCommonUtils.isSpringConfigured(module)) {
            return false;
        }
        PsiElement psiElementAtCaret = psiFile2.findElementAt(templateActionContext.getStartOffset() - 1);
        if (psiElementAtCaret instanceof PsiComment) {
            return false;
        }
        PsiElement prevElement = FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)psiElementAtCaret);
        if (prevElement instanceof PsiKeyword) {
            return false;
        }
        PsiElement psiElement = psiElementAtCaret;
        UElement uParentAtCaret = UastContextKt.getUastParentOfTypes((PsiElement)(psiElement != null ? psiElement.getParent() : null), (Class[])(classArray = new Class[]{UMethod.class, UClass.class}), (boolean)false);
        if (uParentAtCaret instanceof UMethod) {
            return false;
        }
        UClass uParentClass = uParentAtCaret instanceof UClass ? (UClass)uParentAtCaret : null;
        return !this.availableAsInnerClass && uParentClass == null || this.availableAsInnerClass;
    }
}

