/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend;

import com.intellij.ide.startup.importSettings.fus.TransferSettingsCollector;
import com.intellij.ide.startup.importSettings.models.BaseIdeVersion;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsProvider;
import com.intellij.ide.startup.importSettings.transfer.backend.TransferSettingsDataProviderKt;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ,\u0010\u000f\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\n0\n \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\n0\n\u0018\u00010\u00030\u0010H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/TransferSettingsDataProviderSession;", "", "providers", "", "Lcom/intellij/ide/startup/importSettings/providers/TransferSettingsProvider;", "skipIds", "", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "baseIdeVersions", "Lcom/intellij/ide/startup/importSettings/models/BaseIdeVersion;", "getBaseIdeVersions", "()Ljava/util/List;", "baseIdeVersions$delegate", "Lkotlin/Lazy;", "createBaseIdeVersions", "", "kotlin.jvm.PlatformType", "intellij.ide.startup.importSettings"})
final class TransferSettingsDataProviderSession {
    @NotNull
    private final List<TransferSettingsProvider> providers;
    @Nullable
    private final List<String> skipIds;
    @NotNull
    private final Lazy baseIdeVersions$delegate;

    public TransferSettingsDataProviderSession(@NotNull List<? extends TransferSettingsProvider> providers, @Nullable List<String> skipIds) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        this.providers = providers;
        this.skipIds = skipIds;
        this.baseIdeVersions$delegate = LazyKt.lazy(() -> TransferSettingsDataProviderSession.baseIdeVersions_delegate$lambda$0(this));
    }

    @NotNull
    public final List<BaseIdeVersion> getBaseIdeVersions() {
        Lazy lazy = this.baseIdeVersions$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (List)object;
    }

    private final List<BaseIdeVersion> createBaseIdeVersions() {
        return this.providers.parallelStream().flatMap(arg_0 -> TransferSettingsDataProviderSession.createBaseIdeVersions$lambda$1(arg_0 -> TransferSettingsDataProviderSession.createBaseIdeVersions$lambda$0(this, arg_0), arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static final List baseIdeVersions_delegate$lambda$0(TransferSettingsDataProviderSession this$0) {
        return this$0.createBaseIdeVersions();
    }

    private static final Stream createBaseIdeVersions$lambda$0(TransferSettingsDataProviderSession this$0, TransferSettingsProvider provider) {
        Stream stream;
        if (!provider.isAvailable()) {
            TransferSettingsDataProviderKt.access$getLogger$p().info("Provider " + provider.getName() + " is not available");
            return null;
        }
        try {
            long startTime = DurationKt.toDuration((long)System.nanoTime(), (DurationUnit)DurationUnit.NANOSECONDS);
            List list = this$0.skipIds;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Stream stream2 = provider.getIdeVersions(list).stream();
            Intrinsics.checkNotNullExpressionValue(stream2, (String)"stream(...)");
            Stream result2 = stream2;
            long endTime = DurationKt.toDuration((long)System.nanoTime(), (DurationUnit)DurationUnit.NANOSECONDS);
            TransferSettingsCollector.INSTANCE.logPerformanceMeasured-Wn2Vu4Y(TransferSettingsCollector.PerformanceMetricType.Total, provider.getTransferableIdeId(), null, Duration.minus-LRDsOJo((long)endTime, (long)startTime));
            stream = result2;
        }
        catch (Throwable t) {
            TransferSettingsDataProviderKt.access$getLogger$p().warn("Failed to get base ide versions", t);
            return null;
        }
        return stream;
    }

    private static final Stream createBaseIdeVersions$lambda$1(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }
}

